/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.properties.solution;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.context.IToolContext;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.dao.ORMUtil;
import com.kingdee.bos.tool.properties.solution.Messages;
import com.kingdee.bos.tool.utils.CheckUtils;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.IProgressService;

public class SolutionBaseInfoPropertyPage
extends PropertyPage {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.properties.solution.SolutionBaseInfoPropertyPage");
    private String pkPrefix;
    private String alias;
    private String description;
    private String name;
    private String version;
    private Label nameLab;
    private Text aliasTxt;
    private Text descTxt;
    private Text pkPerfixTxt;
    private Text versionTxt;
    private IProject project;

    protected Control createContents(Composite parent) {
        this.initBaseInfos();
        Composite container = new Composite(parent, 0);
        container.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 20;
        container.setLayout((Layout)layout);
        new Label(container, 16448).setText(Messages.SolutionBaseInfoPropertyPage_BaoQianZhuiP);
        this.pkPerfixTxt = new Text(container, 2052);
        this.pkPerfixTxt.setLayoutData((Object)new GridData(768));
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)gridData);
        new Label(container, 0).setText(Messages.SolutionBaseInfoPropertyPage_MingCheng);
        this.nameLab = new Label(container, 0);
        this.nameLab.setLayoutData((Object)new GridData(768));
        new Label(container, 0).setText(Messages.SolutionBaseInfoPropertyPage_BanBen);
        this.versionTxt = new Text(container, 2052);
        this.versionTxt.setLayoutData((Object)new GridData(256));
        new Label(container, 0).setText(Messages.SolutionBaseInfoPropertyPage_BieMing);
        this.aliasTxt = new Text(container, 2052);
        this.aliasTxt.setLayoutData((Object)new GridData(256));
        new Label(container, 0).setText(Messages.SolutionBaseInfoPropertyPage_MiaoShu);
        this.descTxt = new Text(container, 2882);
        gridData = new GridData(256);
        gridData.widthHint = 300;
        gridData.heightHint = 120;
        gridData.verticalSpan = 5;
        this.descTxt.setLayoutData((Object)gridData);
        this.initializeDialogUnits((Control)container);
        this.initControlContent();
        TextModifyListener textModifyListener = new TextModifyListener();
        this.pkPerfixTxt.addModifyListener((ModifyListener)textModifyListener);
        this.aliasTxt.addModifyListener((ModifyListener)textModifyListener);
        this.descTxt.addModifyListener((ModifyListener)textModifyListener);
        this.versionTxt.addModifyListener((ModifyListener)textModifyListener);
        return container;
    }

    public boolean performOk() {
        if (this.project == null) {
            return false;
        }
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.runInUI((IRunnableContext)progressService, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.setCanceled(false);
                    monitor.beginTask(Messages.SolutionBaseInfoPropertyPage_BaoCunJieJueFangAnDeJiBenXinXi, 100);
                    monitor.setTaskName(Messages.SolutionBaseInfoPropertyPage_ZhengZaiBaoCunJieJueFangAnDeJiBenXinXiQingShaoDeng);
                    monitor.subTask(Messages.SolutionBaseInfoPropertyPage_ZhengZaiBaoCun);
                    monitor.worked(10);
                    try {
                        SolutionInfo solution = ORMUtil.getSolution(SolutionBaseInfoPropertyPage.this.project);
                        monitor.worked(50);
                        if (solution == null) {
                            throw new IDEException(Messages.SolutionBaseInfoPropertyPage_BaoCunJiBenXinXiShiDuQuSOLUTIONChuCuo);
                        }
                        solution.setAlias(SolutionBaseInfoPropertyPage.this.alias);
                        solution.setPerfix(SolutionBaseInfoPropertyPage.this.pkPrefix);
                        solution.setDescription(SolutionBaseInfoPropertyPage.this.description);
                        solution.setVersion(SolutionBaseInfoPropertyPage.this.version);
                        IToolContext ctx = ToolContextManager.getContext(SolutionBaseInfoPropertyPage.this.project);
                        IFolder folder = SolutionBaseInfoPropertyPage.this.project.getFolder(ctx.getSrcName());
                        IFile file = ORMUtil.getFile(folder, (IObjectValue)solution);
                        ORMUtil.store((IObjectValue)solution, file, null);
                    }
                    catch (Exception e) {
                        SolutionBaseInfoPropertyPage.this.setErrorMessage(Messages.SolutionBaseInfoPropertyPage_BaoCunJieJueFangAnDeJiBenXinXiChuCuoQingYuGuanLiYuanLianXi);
                        logger.error((Object)"error", (Throwable)e);
                        throw new InvocationTargetException(e);
                    }
                }
            }, null);
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(Messages.SolutionBaseInfoPropertyPage_BaoCunJieJueFangAnDeJiBenXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            this.setErrorMessage(Messages.SolutionBaseInfoPropertyPage_BaoCunJieJueFangAnDeJiBenXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            this.setErrorMessage(Messages.SolutionBaseInfoPropertyPage_BaoCunJieJueFangAnDeJiBenXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
            return false;
        }
        return super.performOk();
    }

    private void initControlContent() {
        this.pkPerfixTxt.setText(this.pkPrefix == null ? "" : this.pkPrefix);
        this.nameLab.setText(this.name == null ? "" : this.name);
        this.aliasTxt.setText(this.alias == null ? "" : this.alias);
        this.descTxt.setText(this.description == null ? "" : this.description);
        this.versionTxt.setText(this.version == null ? "" : this.version);
    }

    private void initBaseInfos() {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.runInUI((IRunnableContext)progressService, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.setCanceled(false);
                    monitor.beginTask(Messages.SolutionBaseInfoPropertyPage_ZhuangZaiJieJueFangAnDeJiBenXinXi, 100);
                    monitor.setTaskName(Messages.SolutionBaseInfoPropertyPage_ZhengZaiZhuangZaiJieJueFangAnDeJiBenXinXiQingShaoDeng);
                    monitor.subTask(Messages.SolutionBaseInfoPropertyPage_ZhengZaiDuQuGongChengXiangMu);
                    IAdaptable adapter = SolutionBaseInfoPropertyPage.this.getElement();
                    monitor.worked(10);
                    if (adapter != null) {
                        SolutionBaseInfoPropertyPage.this.project = (IProject)adapter.getAdapter(IResource.class);
                        if (SolutionBaseInfoPropertyPage.this.project != null) {
                            try {
                                monitor.subTask(Messages.SolutionBaseInfoPropertyPage_ZhengZaiDuQuJieJueFangAnXinXi);
                                SolutionInfo solution = ORMUtil.getSolution(SolutionBaseInfoPropertyPage.this.project);
                                monitor.worked(50);
                                if (solution != null) {
                                    monitor.subTask(Messages.SolutionBaseInfoPropertyPage_ZhengZaiDuQuJiBenXinXi);
                                    SolutionBaseInfoPropertyPage.this.name = solution.getName();
                                    SolutionBaseInfoPropertyPage.this.alias = solution.getAlias();
                                    SolutionBaseInfoPropertyPage.this.pkPrefix = solution.getPerfix();
                                    SolutionBaseInfoPropertyPage.this.description = solution.getDescription();
                                    SolutionBaseInfoPropertyPage.this.version = solution.getVersion();
                                    monitor.subTask(Messages.SolutionBaseInfoPropertyPage_ZhengZaiGouJianJiBenXinXiBianJiJieMian);
                                }
                            }
                            catch (Exception e) {
                                SolutionBaseInfoPropertyPage.this.setErrorMessage(Messages.SolutionBaseInfoPropertyPage_ZaiZhuangJieJueFangAnDeJiBenXinXiChuCuoQingYuGuanLiYuanLianXi);
                                logger.error((Object)"error", (Throwable)e);
                            }
                        }
                    }
                }
            }, null);
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(Messages.SolutionBaseInfoPropertyPage_ZaiZhuangJieJueFangAnDeDuoYuYanXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.setErrorMessage(Messages.SolutionBaseInfoPropertyPage_ZaiZhuangJieJueFangAnDeDuoYuYanXinXiChuCuoQingYuGuanLiYuanLianXi);
            logger.error((Object)"error", (Throwable)e);
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (e.getSource().equals(SolutionBaseInfoPropertyPage.this.aliasTxt)) {
                SolutionBaseInfoPropertyPage.this.alias = SolutionBaseInfoPropertyPage.this.aliasTxt.getText();
            } else if (e.getSource().equals(SolutionBaseInfoPropertyPage.this.descTxt)) {
                SolutionBaseInfoPropertyPage.this.description = SolutionBaseInfoPropertyPage.this.descTxt.getText();
            } else if (e.getSource().equals(SolutionBaseInfoPropertyPage.this.pkPerfixTxt)) {
                if (!CheckUtils.isValidPackageName(SolutionBaseInfoPropertyPage.this.pkPerfixTxt.getText())) {
                    SolutionBaseInfoPropertyPage.this.setErrorMessage(Messages.SolutionBaseInfoPropertyPage_BaoQianZhuiBuHeFaTaYingGaiShiYiGeHeFaDeJAVABaoMingCheng);
                    return;
                }
                SolutionBaseInfoPropertyPage.this.setErrorMessage(null);
                SolutionBaseInfoPropertyPage.this.pkPrefix = SolutionBaseInfoPropertyPage.this.pkPerfixTxt.getText();
            } else if (e.getSource().equals(SolutionBaseInfoPropertyPage.this.versionTxt)) {
                SolutionBaseInfoPropertyPage.this.version = SolutionBaseInfoPropertyPage.this.versionTxt.getText();
            }
        }
    }
}

