/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.solution;

import com.kingdee.bos.metadata.management.DataSourceInfo;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.metadata.management.JdbcDriverType;
import com.kingdee.bos.tool.context.IToolContext;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.solution.Messages;
import com.kingdee.bos.tool.solution.StudioConfiguration;
import com.kingdee.bos.tool.solution.StudioConfigurationItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;

public class StudioConfigurationOptions {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.solution.StudioConfigurationOptions");
    private static IProject currentProject;

    public static Collection loadDeployOptions(IProject project) {
        currentProject = project;
        ArrayList<DeployOptionInfo> list = new ArrayList<DeployOptionInfo>();
        StudioConfiguration config = StudioConfiguration.getInstance();
        StudioConfigurationItem item2 = config.getConfigItem(StudioConfigurationOptions.getCurrentProjectName());
        if (item2 == null) {
            String root = project.getLocation().toOSString();
            item2 = new StudioConfigurationItem(project.getName());
            config.addConfigItem(item2);
            StudioConfigurationItem dItem = new StudioConfigurationItem("DeployOptions");
            item2.addChild(dItem);
            StudioConfigurationItem child = new StudioConfigurationItem("BIM_DEFAULT");
            dItem.addChild(child);
            child.setProperty("IsDefaultOption", "true");
            child.setProperty("JavaOutputDir", StudioConfigurationOptions.ensurePath(root, "src"));
            child.setProperty("J2eeOutputDir", StudioConfigurationOptions.ensurePath(root, "deploy"));
            child.setProperty("MetadataRespository", StudioConfigurationOptions.ensurePath(root, "deployed_metas"));
            child.setProperty("IsOverwriteConfig", "false");
            child.setProperty("DeployLevel", "3");
            child.setProperty("TargetAppServer", "1");
            child.setProperty("JdbcDriverType", "oracle.jdbc.driver.OracleDriver");
            child.setProperty("Host", "");
            child.setProperty("Port", "1433");
            child.setProperty("DBName", "");
            child.setProperty("User", "");
            child.setProperty("Password", "");
            child.setProperty("webuiappname", "myweb.war");
            child.setProperty("webuimappingname", "myweb");
            child.setProperty("webuirootpath", StudioConfigurationOptions.ensurePath(root, "web/webRoot"));
            child.setProperty("webuisrcpath", StudioConfigurationOptions.ensurePath(root, "web/websrc"));
            config.store();
        }
        if ((item2 = item2.getChild("DeployOptions")) != null) {
            List items = item2.getAllChildren();
            for (StudioConfigurationItem item2 : items) {
                String overwriteConfig;
                DeployOptionInfo info = new DeployOptionInfo();
                info.setName(item2.getName());
                info.setAlias(item2.getProperty("Alias") == null ? "" : item2.getProperty("Alias"));
                info.setDefault(new Boolean(item2.getProperty("IsDefaultOption")).booleanValue());
                info.setJavaOutputDir(item2.getProperty("JavaOutputDir"));
                info.setJ2eeOutputDir(item2.getProperty("J2eeOutputDir"));
                info.setMetaDataRepository(item2.getProperty("MetadataRespository"));
                info.setDeployRPC(true);
                info.setWebUiAppName(item2.getProperty("webuiappname"));
                info.setWebUiMappingName(item2.getProperty("webuimappingname"));
                info.setWebUiRootPath(item2.getProperty("webuirootpath"));
                info.setWebUiSrcPath(item2.getProperty("webuisrcpath"));
                info.setMBeanDeploy(new Boolean(item2.getProperty("isMBeanDeploy")).booleanValue());
                String strAppSrv = item2.getProperty("TargetAppServer");
                if (strAppSrv != null) {
                    try {
                        info.setTargetAppServer(new Integer(strAppSrv).intValue());
                    }
                    catch (NumberFormatException e) {
                        logger.debug((Object)Messages.StudioConfigurationOptions_BuHeFaDeFaBuYingYongFuWuQiFaBuYingYongFuWuQiJiangShiYongQueShengZhi, (Throwable)e);
                    }
                }
                if ((overwriteConfig = item2.getProperty("IsOverwriteConfig")) != null && overwriteConfig.equalsIgnoreCase("true")) {
                    info.setOverrideDeployFile(true);
                } else {
                    info.setOverrideDeployFile(false);
                }
                String strLevel = item2.getProperty("DeployLevel");
                if (strLevel != null) {
                    try {
                        int level = new Integer(strLevel);
                        info.setDeployLevel(level);
                    }
                    catch (NumberFormatException e) {
                        logger.debug((Object)Messages.StudioConfigurationOptions_BuHeFaDeFaBuJiBieFaBuJiBieJiangShiYongQueShengZhi, (Throwable)e);
                    }
                }
                DataSourceInfo ds = new DataSourceInfo();
                ds.setDriverType(JdbcDriverType.getEnum((String)item2.getProperty("JdbcDriverType")));
                ds.setHost(item2.getProperty("Host"));
                ds.setPort(new Integer(item2.getProperty("Port")).intValue());
                ds.setDbName(item2.getProperty("DBName"));
                ds.setUser(item2.getProperty("User"));
                ds.setPassword(item2.getProperty("Password"));
                info.setTargetDBMS(ds);
                list.add(info);
            }
        }
        return list;
    }

    private static String ensurePath(String projectDir, String dir) {
        File file;
        Path path = new Path(dir);
        if (!path.isAbsolute()) {
            dir = projectDir + File.separator + dir;
        }
        if (!(file = new File(dir)).exists()) {
            file.mkdirs();
        }
        return dir;
    }

    public static void removeDeployOption(DeployOptionInfo info) {
        StudioConfiguration config = StudioConfiguration.getInstance();
        StudioConfigurationItem item = config.getConfigItem(StudioConfigurationOptions.getCurrentProjectName());
        if (item == null) {
            return;
        }
        if ((item = item.getChild("DeployOptions")) != null && info.getName() != null) {
            item.removeChild(info.getName());
            config.store();
        }
    }

    public static void storeDeployOptions(Collection c) {
        StudioConfiguration config = StudioConfiguration.getInstance();
        StudioConfigurationItem pItem = config.getConfigItem(StudioConfigurationOptions.getCurrentProjectName());
        StudioConfigurationItem item = null;
        if (pItem == null) {
            pItem = new StudioConfigurationItem(StudioConfigurationOptions.getCurrentProjectName());
            config.addConfigItem(pItem);
        } else {
            item = pItem.getChild("DeployOptions");
        }
        if (item == null) {
            item = new StudioConfigurationItem("DeployOptions");
            pItem.addChild(item);
        }
        item.removeAllChildren();
        for (DeployOptionInfo info : c) {
            StudioConfigurationItem child = new StudioConfigurationItem(info.getName());
            item.addChild(child);
            child.setProperty("Alias", String.valueOf(info.getAlias()));
            child.setProperty("IsDefaultOption", String.valueOf(info.isDefault()));
            child.setProperty("JavaOutputDir", info.getJavaOutputDir());
            child.setProperty("J2eeOutputDir", info.getJ2eeOutputDir());
            child.setProperty("MetadataRespository", info.getMetaDataRepository());
            child.setProperty("IsOverwriteConfig", String.valueOf(info.isOverrideDeployFile()));
            child.setProperty("DeployLevel", String.valueOf(info.getDeployLevel()));
            child.setProperty("TargetAppServer", String.valueOf(info.getTargetAppServer()));
            child.setProperty("JdbcDriverType", info.getTargetDBMS().getDriverType().getName());
            child.setProperty("Host", info.getTargetDBMS().getHost());
            child.setProperty("Port", String.valueOf(info.getTargetDBMS().getPort()));
            child.setProperty("DBName", info.getTargetDBMS().getDbName());
            child.setProperty("User", info.getTargetDBMS().getUser());
            child.setProperty("Password", info.getTargetDBMS().getPassword());
            child.setProperty("webuiappname", String.valueOf(info.getWebUiAppName()));
            child.setProperty("webuimappingname", String.valueOf(info.getWebUiMappingName()));
            child.setProperty("webuirootpath", String.valueOf(info.getWebUiRootPath()));
            child.setProperty("webuisrcpath", String.valueOf(info.getWebUiSrcPath()));
            child.setProperty("isMBeanDeploy", String.valueOf(info.isMBeanDeploy()));
        }
        config.store();
    }

    public static DeployOptionInfo getDefaultDeployOptionInfo(IProject project) {
        Collection c = StudioConfigurationOptions.loadDeployOptions(project);
        for (DeployOptionInfo info : c) {
            if (!info.isDefault()) continue;
            return info;
        }
        return null;
    }

    public static void addSolution(String name) {
        StudioConfiguration config = StudioConfiguration.getInstance();
        StudioConfigurationItem item = config.getConfigItem(StudioConfigurationOptions.getCurrentProjectName());
        if (item == null) {
            item = new StudioConfigurationItem(name);
            config.addConfigItem(item);
        }
    }

    public static void removeSolution(String name) {
        StudioConfiguration config = StudioConfiguration.getInstance();
        config.removeConfigItem(name);
    }

    private static String getCurrentProjectName() {
        IToolContext ctx = ToolContextManager.getContext(currentProject);
        return ctx.getProjectName();
    }
}

