/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.update.nature;

import com.kingdee.bos.tool.update.nature.Messages;
import com.kingdee.bos.tool.update.nature.SolutionContentProvider;
import com.kingdee.bos.tool.update.nature.SolutionLabelProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class SolutionUpdateWizardPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.wizard.update.SolutionUpdateWizardPage");
    private CheckboxTableViewer viewer;

    public SolutionUpdateWizardPage() {
        super("SolutionUpdateWizardPage");
        this.setTitle(Messages.SolutionUpdateWizardPage_ShengJiJieJueFangAn);
        this.setDescription(Messages.SolutionUpdateWizardPage_QingXuanZeXuYaoShengJiDeJieJueFangAn);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 10;
        container.setLayout((Layout)layout);
        Table table = new Table(container, 2338);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        this.viewer.setLabelProvider((IBaseLabelProvider)new SolutionLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new SolutionContentProvider());
        this.viewer.addCheckStateListener((ICheckStateListener)new CheckStateListener());
        List list = this.getAllSolutions();
        if (list.size() == 0) {
            this.setMessage(Messages.SolutionUpdateWizardPage_ZaiGongZuoQuMeiYouXuYaoShengJiDeJieJueFangAn);
            this.setPageComplete(false);
        }
        this.viewer.setInput((Object)list);
        this.setControl((Control)container);
    }

    private List getAllSolutions() {
        ArrayList<IProject> list = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!this.isSolution(projects[i]) || this.hasSolutionNatureId(projects[i])) continue;
            list.add(projects[i]);
        }
        return list;
    }

    private boolean isSolution(IProject project) {
        return project.getFile(".solution.xml").exists();
    }

    private boolean hasSolutionNatureId(IProject project) {
        IProjectDescription desc = null;
        try {
            desc = project.getDescription();
        }
        catch (CoreException e) {
            logger.debug((Object)"", (Throwable)e);
        }
        if (null == desc) {
            return false;
        }
        return desc.hasNature("com.kingdee.bos.tool.toolcommon.SolutionNature");
    }

    public void addSolutionNature(IProgressMonitor monitor) {
        Object[] projects = this.viewer.getCheckedElements();
        for (int i = 0; i < projects.length; ++i) {
            IProject project = (IProject)projects[i];
            try {
                IProjectDescription desc = project.getDescription();
                String[] oldNatureIds = desc.getNatureIds();
                String[] newNatureIds = new String[oldNatureIds.length + 1];
                System.arraycopy(oldNatureIds, 0, newNatureIds, 0, oldNatureIds.length);
                newNatureIds[oldNatureIds.length] = "com.kingdee.bos.tool.toolcommon.SolutionNature";
                desc.setNatureIds(newNatureIds);
                project.setDescription(desc, monitor);
                continue;
            }
            catch (CoreException e1) {
                logger.error((Object)(Messages.SolutionUpdateWizardPage_ShengJiJieJueFangAn + project.getName() + Messages.SolutionUpdateWizardPage_ShiBai), (Throwable)e1);
            }
        }
    }

    private class CheckStateListener
    implements ICheckStateListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (SolutionUpdateWizardPage.this.viewer.getCheckedElements().length > 0) {
                SolutionUpdateWizardPage.this.setErrorMessage(null);
                SolutionUpdateWizardPage.this.setPageComplete(true);
            } else {
                SolutionUpdateWizardPage.this.setErrorMessage(Messages.SolutionUpdateWizardPage_QingXuanZeXuYaoDeShengJiDeJieJueFangAn);
                SolutionUpdateWizardPage.this.setPageComplete(false);
            }
        }
    }
}

