/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.utils;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener3;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;

public class PerspectiveChangeListener
implements IPerspectiveListener3,
Preferences.IPropertyChangeListener {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.utils.PerspectiveChangeListener");
    private static String BIMPerspectiveId = "com.kingdee.bos.studio.perspective.StudioPerspective";
    private static String StudioPerspectiveeId = "com.kingdee.bos.bim.perspective.BIMPerspective";
    private IWorkspace workspace;
    private boolean autobuilding = true;
    private boolean needRestore = false;
    private Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();

    public PerspectiveChangeListener(IWorkspace workspace) {
        this.workspace = workspace;
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        IWorkspaceDescription description = this.workspace.getDescription();
        this.autobuilding = description.isAutoBuilding();
        if ((BIMPerspectiveId.equals(perspective.getId()) || StudioPerspectiveeId.equals(perspective.getId())) && this.autobuilding) {
            this.setAutoBuilding(false);
            this.needRestore = true;
            this.preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        }
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.preferences.removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        if (this.needRestore) {
            this.setAutoBuilding(this.autobuilding);
            this.needRestore = false;
        }
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (this.needRestore) {
            this.setAutoBuilding(this.autobuilding);
            this.needRestore = false;
        }
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        this.needRestore = false;
    }

    private void setAutoBuilding(boolean autobuilding) {
        IWorkspaceDescription description = this.workspace.getDescription();
        description.setAutoBuilding(autobuilding);
        try {
            this.workspace.setDescription(description);
        }
        catch (CoreException e) {
            logger.error((Object)"set auto building error", (Throwable)e);
        }
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }
}

