/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.widgets;

import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.tool.dao.ORMUtil;
import com.kingdee.bos.tool.utils.EditorHelper;
import com.kingdee.bos.tool.widgets.HrefTextResourceManager;
import com.kingdee.bos.tool.widgets.Messages;
import com.kingdee.util.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class HrefText
extends StyledText {
    private static RGB DEFAULT_NORMAL_COLOR = new RGB(0, 0, 0);
    private static RGB DEFAULT_HOVER_COLOR = new RGB(0, 0, 255);
    private static boolean DEFAULT_BOTTOM_LINE = true;
    private static RGB normalColorRgb = DEFAULT_NORMAL_COLOR;
    private static RGB hoverColorRgb = DEFAULT_HOVER_COLOR;
    private static boolean underLine = DEFAULT_BOTTOM_LINE;
    private Font normalFont;
    private String href;
    private boolean controlPushed = false;
    private HrefTextResourceManager.HrefTextResource resource;
    private StyleRange styleRange = new StyleRange();

    public HrefText(Composite parent, int style) {
        super(parent, style);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                HrefText.this.controlMouseUp(e);
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                HrefText.this.controlMouseHover(e);
            }

            public void mouseExit(MouseEvent e) {
                HrefText.this.controlMouseExit(e);
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                HrefText.this.controlKeyPressed(e);
            }

            public void keyReleased(KeyEvent e) {
                HrefText.this.controlKeyReleased(e);
            }
        });
        this.resource = HrefTextResourceManager.getInstance().applyResource(this);
    }

    public static boolean isUnderLine() {
        return underLine;
    }

    public static RGB getHoverColorRgb() {
        return hoverColorRgb;
    }

    public static RGB getNormalColorRgb() {
        return normalColorRgb;
    }

    public static void setUnderLine(boolean b) {
        underLine = b;
    }

    public static void setHoverColorRgb(RGB rgb) {
        hoverColorRgb = rgb;
    }

    public static void setNormalColorRgb(RGB rgb) {
        normalColorRgb = rgb;
    }

    public void setHref(String href) {
        this.href = href;
        if (href == null) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText("hold CTRL and click");
        }
        this.setNormalStatus();
    }

    public void setHref(String text, String href) {
        this.setText(text);
        this.setHref(href);
    }

    public void controlMouseHover(MouseEvent e) {
        if (this.controlPushed && this.href != null && !StringUtils.isEmpty((String)this.getText())) {
            this.setHoverStatus();
        }
    }

    public void controlMouseExit(MouseEvent e) {
        if (this.href != null) {
            this.setNormalStatus();
        }
    }

    public void controlMouseUp(MouseEvent e) {
        if (this.controlPushed && this.href != null && !StringUtils.isEmpty((String)this.getText())) {
            IFile file = ORMUtil.getFile(this.href);
            IMDFile mFile = MDResourceUtil.toMDFile(file);
            if (!mFile.exists()) {
                MessageDialog m = new MessageDialog(this.getShell(), "", null, Messages.HrefText_LianJieMuBiaoWenJianBuCunZai, 1, new String[]{Messages.HrefText_QueDing}, 0);
                m.create();
                m.open();
            } else {
                EditorHelper.openFile(mFile);
            }
            this.controlPushed = false;
        }
    }

    public void controlKeyPressed(KeyEvent e) {
        if (e.keyCode == 262144) {
            this.controlPushed = true;
        }
    }

    public void controlKeyReleased(KeyEvent e) {
        if (e.keyCode == 262144) {
            this.controlPushed = false;
            if (this.href != null) {
                this.setNormalStatus();
            }
        }
    }

    private void setHoverStatus() {
        this.styleRange.start = 0;
        this.styleRange.length = this.getText().length();
        this.styleRange.foreground = this.resource.hoverColor;
        this.setStyleRange(this.styleRange);
        if (underLine) {
            this.setFont(this.resource.hoverFont);
        }
        this.setCursor(this.resource.hoverCursor);
    }

    private void setNormalStatus() {
        this.styleRange.start = 0;
        this.styleRange.length = this.getText().length();
        this.styleRange.foreground = this.resource.normalColor;
        this.setStyleRange(this.styleRange);
        if (underLine) {
            this.setFont(this.normalFont);
        }
        this.setCursor(null);
    }
}

