/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webframework.dynamic.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.webframework.dynamic.CtrlConfigCollection;
import com.kingdee.bos.webframework.dynamic.CtrlConfigFactory;
import com.kingdee.bos.webframework.dynamic.CtrlConfigInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class DynamicWebUtils {
    private static Logger logger = Logger.getLogger(DynamicWebUtils.class);
    private static boolean isTemporaryLicense = false;
    private static final String TEMPORARY_LINCENSE_L1 = "Temporary License";
    private static final String TEMPORARY_LINCENSE_L2 = "\u4e34\u65f6\u8bb8\u53ef";
    private static final String TEMPORARY_LINCENSE_L3 = "\u81e8\u6642\u8a31\u53ef";

    public static String getWatermarkContent(Context ctx) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("ctrlType", (Object)"configPage", CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        try {
            CtrlConfigCollection ctrlConfigCollection = CtrlConfigFactory.getLocalInstance(ctx).getCtrlConfigCollection(entityViewInfo);
            for (int i = 0; i < ctrlConfigCollection.size(); ++i) {
                CtrlConfigInfo ctrlConfigInfo = ctrlConfigCollection.get(i);
                if (!"configPage".equals(ctrlConfigInfo.getCtrlType())) continue;
                DynamicWebUtils.processSpecialConfig(ctrlConfigInfo, ctx);
                String watermarkJsonStr = JSON.parseObject((String)ctrlConfigInfo.getOptionData()).getJSONObject("watermark").getString("ctrlOptVal");
                return DynamicWebUtils.getRealText(JSON.parseObject((String)watermarkJsonStr), ctx);
            }
            if (ctrlConfigCollection.isEmpty()) {
                return DynamicWebUtils.getDefaultText(ctx);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static void processSpecialConfig(CtrlConfigInfo ctrlConfigInfo, Context ctx) {
        if ("configPage".equals(ctrlConfigInfo.getCtrlType())) {
            String optionData = ctrlConfigInfo.getOptionData();
            JSONObject optionDataJson = JSON.parseObject((String)optionData);
            JSONObject watermark = optionDataJson.getJSONObject("watermark");
            if (optionDataJson != null) {
                String ctrlOptVal = watermark.getString("ctrlOptVal");
                String newCtrlOptVal = DynamicWebUtils.generateWatermarkRealText(ctrlOptVal, ctx);
                watermark.put("ctrlOptVal", (Object)newCtrlOptVal);
                optionDataJson.put("watermark", (Object)watermark);
                ctrlConfigInfo.setOptionData(JSON.toJSONString((Object)optionDataJson));
            }
        }
    }

    public static String generateWatermarkRealText(String watermarkJsonStr, Context ctx) {
        if (StringUtil.isEmptyString((String)watermarkJsonStr)) {
            return "";
        }
        JSONObject watermarkJson = JSON.parseObject((String)watermarkJsonStr);
        watermarkJson.put("realText", (Object)DynamicWebUtils.getRealText(watermarkJson, ctx));
        return JSON.toJSONString((Object)watermarkJson);
    }

    private static String getRealText(JSONObject watermarkJson, Context ctx) {
        String content;
        String realText = DynamicWebUtils.getDefaultText(ctx);
        String display = watermarkJson.getString("display");
        String language = ctx.getLocale().getLanguage();
        if ("no".equals(display)) {
            return realText;
        }
        if (isTemporaryLicense) {
            realText = "l1".equals(language) ? "[" + realText + "]" : "\u3010" + realText + "\u3011";
        }
        if (!"custom".equals(content = watermarkJson.getString("content"))) {
            String callId = ctx.getCaller() == null ? "" : ctx.getCaller().toString();
            String cellTailNumber = "";
            String fullName = "";
            try {
                UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(callId));
                fullName = userInfo.getName(ctx.getLocale());
                String cell = userInfo.getCell();
                cellTailNumber = StringUtils.isEmpty((String)cell) ? "" : (cell.length() < 4 ? cell : cell.substring(cell.length() - 4));
            }
            catch (Exception e) {
                logger.error((Object)"\u83b7\u53d6\u7528\u6237\u521d\u59cb\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            }
            if ("name".equals(content)) {
                realText = realText + fullName;
            } else if ("nameAndTel".equals(content)) {
                realText = realText + fullName + cellTailNumber;
            }
        } else {
            realText = realText + watermarkJson.getString("text");
        }
        return realText;
    }

    private static String getDefaultText(Context ctx) {
        String realText = "";
        String language = ctx.getLocale().getLanguage();
        if (isTemporaryLicense) {
            realText = TEMPORARY_LINCENSE_L2;
            if ("l1".equals(language)) {
                realText = TEMPORARY_LINCENSE_L1;
            } else if ("l3".equals(language)) {
                realText = TEMPORARY_LINCENSE_L3;
            }
        }
        return realText;
    }

    static {
        try {
            isTemporaryLicense = LicenseSrvFactory.getInstance().isShowWaterMark();
        }
        catch (LicenseException e) {
            logger.error((Object)"\u83b7\u53d6License\u7248\u672c\u5931\u8d25", (Throwable)e);
        }
    }
}

