/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.axis;

import com.kingdee.bos.Context;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axis.deployment.wsdd.WSDDOperation;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;

public class WSDDServiceBuilder {
    public static final String AIS_NAME = "aisName";
    public static final String SOLUTION_NAME = "eas";
    public static final String PROC_DEF_ID = "procDefId";
    public static final String NAMESPACE = "namespace";
    private final Context context;
    private String procDefId;
    private String namspace;

    public WSDDServiceBuilder(Context context) {
        this.context = context;
    }

    public void setProcDefId(String procDefId) {
        this.procDefId = procDefId;
    }

    public void setNamspace(String namspace) {
        this.namspace = namspace;
    }

    public WSDDService build(Definition definition) throws Exception {
        WSDDService wsddService = new WSDDService();
        PortType portType = (PortType)definition.getPortTypes().values().iterator().next();
        List operations = portType.getOperations();
        ServiceDesc serviceDesc = wsddService.getServiceDesc();
        String serviceName = this.generateServiceName(definition);
        serviceDesc.setName(serviceName);
        QName qname = new QName(serviceName);
        wsddService.setQName(qname);
        int size = operations.size();
        for (int i = 0; i < size; ++i) {
            Operation operation = (Operation)operations.get(i);
            WSDDOperation wsddOoperation = this.buildWSDDOperation(operation);
            wsddService.addOperation(wsddOoperation);
        }
        QName providerQName = new QName("http://xml.apache.org/axis/wsdd/providers/java", "PROCESS");
        wsddService.setProviderQName(providerQName);
        wsddService.setParameter(AIS_NAME, this.context.getAIS());
        wsddService.setParameter(SOLUTION_NAME, this.context.getSolution());
        wsddService.setParameter(PROC_DEF_ID, this.procDefId);
        wsddService.setParameter(NAMESPACE, this.namspace);
        return wsddService;
    }

    private String generateServiceName(Definition definition) {
        String serviceName = definition.getQName().getLocalPart();
        return serviceName;
    }

    private WSDDOperation buildWSDDOperation(Operation operation) throws SecurityException, NoSuchMethodException {
        OperationDesc wsddOperationDesc = new OperationDesc();
        Input input = operation.getInput();
        Message message = input.getMessage();
        for (Part part : message.getParts().values()) {
            ParameterDesc parameterDesc = new ParameterDesc(new QName(part.getName()), 1, part.getTypeName());
            wsddOperationDesc.setName(operation.getName());
            wsddOperationDesc.addParameter(parameterDesc);
            wsddOperationDesc.setSoapAction(operation.getName());
        }
        WSDDOperation wsddOoperation = new WSDDOperation(wsddOperationDesc);
        return wsddOoperation;
    }
}

