/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cleaner;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.returns.Delay;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class ProcessContextCleaner
implements IJobHandler {
    private static final Logger log = Logger.getLogger(ProcessContextCleaner.class);
    private static final long serialVersionUID = -3703204961780642917L;

    public static void enqueue(Context ctx) {
        Job job = new Job(ctx, "ProcessContextCleaner", (IJobHandler)new ProcessContextCleaner(), null, false, true);
        JobManager.instance().add(job);
        log.info((Object)("ProcessContextCleaner of " + ctx.getAIS() + " started."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Job job) throws Exception {
        Context ctx = job.getContext();
        Connection cn = null;
        Statement ps = null;
        ResultSet rs = null;
        int updateNum = 0;
        try {
            String sql = "delete from t_wfr_procinstdatahst where ftime < ?";
            Calendar c = Calendar.getInstance();
            c.add(1, -2);
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(sql);
            ps.setTimestamp(1, new Timestamp(c.getTimeInMillis()));
            ps.executeUpdate();
            log.info((Object)("ProcessContextCleaner delete t_wfr_procinstdatahst of " + ctx.getAIS()));
            sql = "delete from t_wfr_procinstdata where fprocinstid in (select top 300 b.fprocinstid from t_wfr_procinst a,t_wfr_procinstdata b where a.fprocinstid=b.fprocinstid and a.FSTATE in ('closed.completed','closed.aborted','closed.aborted') and b.ftime<? order by ftime)";
            ps = cn.prepareStatement(sql);
            ps.setTimestamp(1, new Timestamp(c.getTimeInMillis()));
            updateNum = ps.executeUpdate();
            log.info((Object)("ProcessContextCleaner delete t_wfr_procinstdata of " + ctx.getAIS()));
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable sql) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable sql) {}
            }
            if (cn != null) {
                try {
                    cn.close();
                }
                catch (Throwable sql) {}
            }
        }
        if (updateNum > 0) {
            return new Delay(3600);
        }
        return new Delay(259200);
    }
}

