/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.OtherSys;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.async.CallMode;
import com.kingdee.bos.workflow.enactment.async.RpaUtil;
import com.kingdee.bos.workflow.enactment.async.YsqUtil;
import com.kingdee.bos.workflow.metas.IOtherSysTask;
import com.kingdee.bos.workflow.metas.OtherSysTaskFactory;
import com.kingdee.bos.workflow.metas.OtherSysTaskInfo;
import com.kingdee.bos.workflow.metas.OtherSysTaskState;
import com.kingdee.bos.workflow.metas.ProcessInstEventEnum;
import com.kingdee.bos.workflow.util.EnactmentUtils;
import com.kingdee.bos.workflow.util.WorkflowUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.log4j.Logger;

public class AsyncTaskHandler
implements IJobHandler {
    private static Logger logger = Logger.getLogger(AsyncTaskHandler.class);
    private static final long serialVersionUID = 1L;
    private String taskId;
    private WfActivity actInst;
    private String procInstId;
    private String apiId;
    private String callMode;
    private String address;
    private String script;
    private Map parameterMap;
    private boolean isReturn;
    private OtherSys otherSysInfo;

    public AsyncTaskHandler(WfActivity actInst, String procInstId, String apiId, String callMode, String address, String script, Map parameterMap, boolean isReturn, OtherSys otherSysInfo) {
        this.actInst = actInst;
        this.procInstId = procInstId;
        this.apiId = apiId;
        this.callMode = callMode;
        this.address = address;
        this.script = script;
        this.parameterMap = parameterMap;
        this.isReturn = isReturn;
        this.otherSysInfo = otherSysInfo;
    }

    public Object execute(Job job) throws Exception {
        IObjectPK pk = null;
        try {
            this.parameterMap.put("isReturn", this.isReturn);
            pk = this.addNewInvoke(job, OtherSysTaskState.RUNNING, null);
            this.taskId = pk.toString();
            Context ctx = EnactmentUtils.getApplicationContext(this.actInst);
            if ("rpa".equalsIgnoreCase(this.callMode) || this.callMode.indexOf("rpa") >= 0) {
                RpaUtil.addCallBackParams(this.taskId, this.parameterMap);
                CallMode.RPA.call(this.parameterMap.get("apiBaseUrl").toString(), this.parameterMap, this.actInst, ctx);
            } else if ("http".equalsIgnoreCase(this.callMode) || this.callMode.indexOf("http") >= 0) {
                CallMode.HTTP.call(this.address, this.parameterMap, this.actInst, ctx);
            } else if ("openapi".equalsIgnoreCase(this.callMode) || this.callMode.indexOf("openapi") >= 0) {
                CallMode.OPENAPI.call(this.address, this.parameterMap, this.actInst, ctx);
            } else if ("script".equalsIgnoreCase(this.callMode) || this.callMode.indexOf("script") >= 0) {
                RpaUtil.addCallBackParams(this.taskId, this.parameterMap);
                RpaUtil.addCallBackParamsToCtx(this.taskId, this.parameterMap, ctx);
                CallMode.KSCRIPT.call(this.script, this.parameterMap, this.actInst, ctx);
            } else if ("webservice".equalsIgnoreCase(this.callMode) || this.callMode.indexOf("webservice") >= 0) {
                CallMode.WEBSERVICE.call(this.address, this.parameterMap, this.actInst, ctx);
            } else if ("ysq".equalsIgnoreCase(this.callMode) && !"ysqDynamic".equals(this.otherSysInfo.getRobotId())) {
                YsqUtil.getYsqBodyParams(this.otherSysInfo, this.taskId, this.parameterMap, ctx);
                CallMode.YSQ.call(this.address, this.parameterMap, this.actInst, ctx);
            } else if ("ysqDynamic".equals(this.otherSysInfo.getRobotId())) {
                YsqUtil.getYsqdynamicBodyParams(this.otherSysInfo, this.taskId, this.parameterMap, ctx);
                CallMode.YSQDYNAMIC.call(this.address, this.parameterMap, this.actInst, ctx);
            } else {
                this.updateInvoke(null, job, OtherSysTaskState.ERR_STOP, "\u4e0d\u5b58\u5728\u7684\u8c03\u7528\u6a21\u5f0f\uff01");
                throw new Exception("\u4e0d\u5b58\u5728\u7684\u8c03\u7528\u6a21\u5f0f\uff01");
            }
            this.updateInvoke(pk, job, OtherSysTaskState.RUNNING, null);
        }
        catch (Exception e) {
            this.updateInvoke(pk, job, OtherSysTaskState.ERR_STOP, this.dump(e));
            throw e;
        }
        return null;
    }

    protected void saveLog(Throwable error, Context ctx, String procInstId) {
        try {
            WfEngine engine = WfEngine.getEngine(ctx);
            WfException ex = new WfException("WFE_invokeToolError ", engine.getLocale().getLanguage(), error);
            WorkflowUtils.logProcessException(procInstId, engine, ex, ProcessInstEventEnum.ASYNCTASK);
        }
        catch (Throwable e) {
            logger.error((Object)("Error of procInstId:" + procInstId), error);
        }
    }

    private IObjectPK addNewInvoke(Job job, OtherSysTaskState state, String errorInfo) throws BOSException {
        IObjectPK pk = null;
        try {
            IOtherSysTask task = OtherSysTaskFactory.getLocalInstance((Context)job.getContext());
            OtherSysTaskInfo model = new OtherSysTaskInfo();
            model.setApiId(BOSUuid.read((String)this.apiId));
            model.setActinstId(this.actInst.getId());
            model.setProcinstId(this.procInstId);
            model.setTaskState(state);
            model.setLaststatetime(new Timestamp(System.currentTimeMillis()));
            model.setReqVal(this.parameterMap.toString());
            model.setStartTime(new Timestamp(System.currentTimeMillis()));
            model.setIsValid("Y");
            if (errorInfo != null) {
                model.setErrorInfo(errorInfo);
            }
            pk = task.addnew(model);
        }
        catch (Exception e) {
            logger.error((Object)"AsyncTaskHandler addNewInvoke error", (Throwable)e);
        }
        return pk;
    }

    private void updateInvoke(IObjectPK pk, Job job, OtherSysTaskState state, String errorInfo) throws BOSException {
        IOtherSysTask task = OtherSysTaskFactory.getLocalInstance((Context)job.getContext());
        OtherSysTaskInfo model = task.getValue(pk);
        model.setTaskState(state);
        model.setLaststatetime(new Timestamp(System.currentTimeMillis()));
        if (errorInfo != null) {
            model.setErrorInfo(errorInfo);
        }
        task.update(pk, model);
    }

    private String dump(Exception e) {
        if (e == null || "".equals(e)) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        e.printStackTrace(pw);
        pw.flush();
        return baos.toString();
    }

    public String toString() {
        return "{actInstId:" + this.actInst.getId() + " , procInstId:" + this.procInstId + " , apiId:" + this.apiId + "}";
    }
}

