/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ScriptDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConditionParticipantHelper {
    private static final Logger logger = Logger.getLogger(ConditionParticipantHelper.class);
    private Context ctx;

    public ConditionParticipantHelper(Context ctx) {
        this.ctx = ctx;
    }

    private WfEngine getWfEngine() throws WfException {
        WfEngine engine = WfEngine.getEngine(this.ctx);
        engine.setLocale(this.ctx.getLocale());
        engine.setContext(this.ctx);
        return engine;
    }

    public Map getConditionParticipantId(String procInstId, List actdefids) throws WfException {
        HashMap rtn = new HashMap();
        if (StringUtils.isEmpty((String)procInstId) || actdefids == null || actdefids.size() == 0) {
            return rtn;
        }
        WfProcess procInst = this.getWfEngine().getProcessInst(procInstId);
        ProcessDef procDef = procInst.getDefinition();
        Interpreter interpreter = new Interpreter();
        Map datamap = procInst.getProcContextDataCopy();
        datamap.putAll(ScriptUtil.getInnerVariables(procDef));
        int len = actdefids.size();
        for (int i = 0; i < len; ++i) {
            ActivityDef actDef;
            String actdefid = (String)actdefids.get(i);
            if (StringUtils.isEmpty((String)actdefid) || !((actDef = procDef.getActivityDef(actdefid)) instanceof ManpowerActivityDef)) continue;
            ArrayList<String> tmpList = new ArrayList<String>();
            ManpowerActivityDef manActDef = (ManpowerActivityDef)actDef;
            ParticipantCollection participants = manActDef.getParticipants();
            for (ParticipantDef participant : participants) {
                ScriptDef scriptdef;
                String refScriptId = participant.getScriptRef();
                boolean bRt = true;
                if (!StringUtils.isEmpty((String)refScriptId) && (scriptdef = procDef.getScripts().get(refScriptId)) != null && scriptdef.getScriptContent() != null) {
                    String _scriptcontent = null;
                    try {
                        _scriptcontent = scriptdef.getScriptContent();
                        Object result = interpreter.evalExpr(_scriptcontent, datamap);
                        bRt = result instanceof Boolean ? (Boolean)result : false;
                    }
                    catch (Throwable e) {
                        logger.error((Object)("\u6761\u4ef6\u53c2\u4e0e\u4eba\u811a\u672c\u89e3\u6790 \u65f6 \u51fa\u73b0\u9519\u8bef  \u811a\u672c\uff1a" + _scriptcontent), e);
                        bRt = true;
                    }
                }
                if (!bRt) continue;
                tmpList.add(participant.getID());
            }
            rtn.put(actdefid, tmpList);
        }
        return rtn;
    }

    public List getConditionParticipantId(String procInstId, String actdefid) throws WfException {
        ArrayList<String> rtn = new ArrayList<String>();
        if (StringUtils.isEmpty((String)procInstId) || StringUtils.isEmpty((String)actdefid)) {
            return rtn;
        }
        WfProcess procInst = this.getWfEngine().getProcessInst(procInstId);
        ProcessDef procDef = procInst.getDefinition();
        Interpreter interpreter = new Interpreter();
        Map datamap = procInst.getProcContextDataCopy();
        datamap.putAll(ScriptUtil.getInnerVariables(procDef));
        ActivityDef actDef = procDef.getActivityDef(actdefid);
        if (actDef instanceof ManpowerActivityDef) {
            ManpowerActivityDef manActDef = (ManpowerActivityDef)actDef;
            ParticipantCollection participants = manActDef.getParticipants();
            for (ParticipantDef participant : participants) {
                ScriptDef scriptdef;
                String refScriptId = participant.getScriptRef();
                boolean bRt = true;
                if (!StringUtils.isEmpty((String)refScriptId) && (scriptdef = procDef.getScripts().get(refScriptId)) != null && scriptdef.getScriptContent() != null) {
                    String _scriptcontent = null;
                    try {
                        _scriptcontent = scriptdef.getScriptContent();
                        Object result = interpreter.evalExpr(_scriptcontent, datamap);
                        bRt = result instanceof Boolean ? (Boolean)result : false;
                    }
                    catch (Throwable e) {
                        logger.error((Object)("\u6761\u4ef6\u53c2\u4e0e\u4eba\u811a\u672c\u89e3\u6790 \u65f6 \u51fa\u73b0\u9519\u8bef  \u811a\u672c\uff1a" + _scriptcontent), e);
                        bRt = true;
                    }
                }
                if (!bRt) continue;
                rtn.add(participant.getID());
            }
        }
        return rtn;
    }
}

