/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.monitor.DynamicOperationInfo;
import com.kingdee.bos.workflow.monitor.DynamicOperationServiceFactory;
import com.kingdee.bos.workflow.monitor.IDynamicOperationService;
import com.kingdee.bos.workflow.store.WorkItemStorer;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProcessDataRepair {
    private static final Logger logger = Logger.getLogger(ProcessDataRepair.class);
    private Context ctx;

    public ProcessDataRepair(Context ctx) {
        this.ctx = ctx;
    }

    public void dataRepair(String procInstId, int type) throws BOSException {
        try {
            if (type == 0) {
                this.forcedAabortProcinstData(procInstId);
            } else {
                this.repairActivityData(procInstId);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u6570\u636e\u4fee\u590d\u51fa\u9519", (Throwable)e);
            throw e;
        }
    }

    private void forcedAabortProcinstData(String procInstId) throws BOSException {
        String sqlProc = "update t_wfr_procinst set fstate = 'closed.aborted' where fprocinstid = ? and fstate!='closed.completed' ";
        int[] types = new int[]{12};
        Object[] params = new Object[]{procInstId};
        SQL.executeUpdate((Context)this.ctx, (String)sqlProc, (int[])types, (Object[])params);
        String updateActivity = "update t_wfr_actinst set fstate = 'closed.aborted' where fprocinstid = ? and (fstate='open.running' or fstate='open.not_running.not_started')";
        types = new int[]{12};
        params = new Object[]{procInstId};
        SQL.executeUpdate((Context)this.ctx, (String)updateActivity, (int[])types, (Object[])params);
        String updateAssign = "update t_wfr_assign set fstate = 4 where fprocinstid = ?";
        types = new int[]{12};
        params = new Object[]{procInstId};
        SQL.executeUpdate((Context)this.ctx, (String)updateAssign, (int[])types, (Object[])params);
        String sqlAssigns = "select fassignid  from t_wfr_assign where fprocinstid = ? ";
        ArrayList resultAssign = SQL.executeQuery((Context)this.ctx, (String)sqlAssigns, (int[])types, (Object[])params);
        if (resultAssign.size() > 0) {
            HashSet<String> dumpAssignmentIDs = new HashSet<String>();
            for (int index = 0; index < resultAssign.size(); ++index) {
                dumpAssignmentIDs.add(((Map)resultAssign.get(index)).get("fassignid").toString());
            }
            WfEngine engine = WfEngine.getEngine(this.ctx);
            WorkItemStorer storer = engine.getStoreManager().getWorkItemStorer();
            storer.dumpTx(dumpAssignmentIDs);
        }
        this.saveDynamicOperationInfo("forcedAabort", procInstId, null, null, null, null, null, "\u5f3a\u5236\u4fee\u6539\u6d41\u7a0b\u5b9e\u4f8b\u72b6\u6001\u4e3a\u7ec8\u6b62");
    }

    private void repairActivityData(String procInstId) throws BOSException {
        String deleRuntime = "delete from t_wfr_runtime where fprocinstid = ? ";
        int[] types = new int[]{12};
        Object[] params = new Object[]{procInstId};
        SQL.executeUpdate((Context)this.ctx, (String)deleRuntime, (int[])types, (Object[])params);
        WfEngine engine = WfEngine.getEngine(this.ctx);
        Set<String> updateInstSet = this.getOpenActivityIds(procInstId, engine);
        ActivityInstInfo startInfo = this.getStartActivityInfo(procInstId, engine);
        if (startInfo != null) {
            String openActivity = "update T_WFR_ACTINST set fstate='closed.completed',FTOACTINSTLIST =?,FPOSTACTINSTLIST =? where factinstid=? ";
            for (String actinstId : updateInstSet) {
                types = new int[]{12, 12, 12};
                params = new Object[]{startInfo.getActInstId(), startInfo.getActInstId(), actinstId};
                SQL.executeUpdate((Context)this.ctx, (String)openActivity, (int[])types, (Object[])params);
            }
            String sqlStart = "update T_WFR_ACTINST set fstate='open.not_running.not_started' where factinstid=?";
            types = new int[]{12};
            params = new Object[]{startInfo.getActInstId()};
            SQL.executeUpdate((Context)this.ctx, (String)sqlStart, (int[])types, (Object[])params);
        }
        this.saveDynamicOperationInfo("jumpRepair", procInstId, null, null, null, null, null, "\u6d41\u7a0b\u8df3\u8f6c\u524d\u4fee\u590d\u6570\u636e");
        engine.getCacheManager().cleanUp();
    }

    private ActivityInstInfo getStartActivityInfo(String procInstId, WfEngine engine) throws WfException {
        WfProcess wfProcess = engine.getProcessInst(procInstId);
        ActivityCollection startUpactivities = wfProcess.getDefinition().getStartupActivities();
        ActivityInstInfo startInfo = null;
        for (int index = 0; index < startUpactivities.size(); ++index) {
            ActivityInstInfo[] startActicitys = engine.getActInstMetaByDefId(startUpactivities.get(index).getID(), procInstId, false);
            if (startActicitys.length <= 0) continue;
            startInfo = startActicitys[0];
        }
        return startInfo;
    }

    private Set<String> getOpenActivityIds(String procInstId, WfEngine engine) throws WfException {
        ActivityInstInfo[] openInsts;
        HashSet<String> updateInstSet = new HashSet<String>();
        ActivityInstInfo[] activityInsts = engine.getActInstMetaArrayByProcInstId(procInstId);
        if (activityInsts.length > 0) {
            ActivityInstInfo lastActInfo = activityInsts[activityInsts.length - 1];
            updateInstSet.add(lastActInfo.getActInstId());
        }
        if ((openInsts = engine.getActInstMetaArrayByProcInstIdAndActInstState(procInstId, "open")).length > 0) {
            for (int index = 0; index < openInsts.length; ++index) {
                updateInstSet.add(openInsts[index].getActInstId());
            }
        }
        return updateInstSet;
    }

    private void saveDynamicOperationInfo(String operType, String procInstId, String actInstId, String actName, String billId, String targetActDefId, String targetActDefName, String opinion) throws BOSException {
        IDynamicOperationService serivce = DynamicOperationServiceFactory.getLocalInstance((Context)this.ctx);
        DynamicOperationInfo info = new DynamicOperationInfo();
        info.setType(operType);
        info.setBillId(billId);
        info.setProcInstId(procInstId);
        info.setActInstId(actInstId);
        info.setActName(actName);
        info.setTargetActId(targetActDefId);
        info.setTargetActName(targetActDefName);
        info.setComment(opinion, new Locale("l1"));
        info.setComment(opinion, new Locale("l2"));
        info.setComment(opinion, new Locale("l3"));
        info.setCreatorId(this.ctx.getCaller().toString());
        String userName = ContextUtil.getCurrentUserInfo((Context)this.ctx).getName(this.ctx.getLocale());
        info.setCreatorName(userName);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        serivce.addNewDynamicOperationInfo(info);
    }
}

