/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.TransBoxInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityEvent;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.AutomationMode;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.ConditionDef;
import com.kingdee.bos.workflow.define.ConditionType;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.define.EventPolicyCollection;
import com.kingdee.bos.workflow.define.EventPolicyDef;
import com.kingdee.bos.workflow.define.ExecutionMode;
import com.kingdee.bos.workflow.define.ExpressionCollection;
import com.kingdee.bos.workflow.define.ExpressionDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.JoinType;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessEvent;
import com.kingdee.bos.workflow.define.ProcessHeaderDef;
import com.kingdee.bos.workflow.define.ProcessType;
import com.kingdee.bos.workflow.define.ResponsibleCollection;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.SplitType;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.TaskServiceReceiveActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.IWfProcess;
import com.kingdee.bos.workflow.enactment.ParticipantHelper;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.ProcessContextNotExistException;
import com.kingdee.bos.workflow.enactment.RuntimeSystemVariable;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfExecutionObject;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.enactment.message.WfMessageSender;
import com.kingdee.bos.workflow.enactment.queue.impl.WfTransQueueEntry;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.bos.workflow.engine.core.thread.FlowAbort;
import com.kingdee.bos.workflow.engine.core.thread.FlowInitiator;
import com.kingdee.bos.workflow.engine.core.thread.FlowResume;
import com.kingdee.bos.workflow.engine.core.thread.FlowSuspend;
import com.kingdee.bos.workflow.event.WfEvent;
import com.kingdee.bos.workflow.event.WfEventType;
import com.kingdee.bos.workflow.exception.AlreadyRunningException;
import com.kingdee.bos.workflow.exception.AlreadySuspendedException;
import com.kingdee.bos.workflow.exception.CannotResumeException;
import com.kingdee.bos.workflow.exception.CannotStartException;
import com.kingdee.bos.workflow.exception.CannotStopException;
import com.kingdee.bos.workflow.exception.CannotSuspendException;
import com.kingdee.bos.workflow.exception.DisableRollbackException;
import com.kingdee.bos.workflow.exception.InvalidStateException;
import com.kingdee.bos.workflow.exception.NotRunningException;
import com.kingdee.bos.workflow.exception.NotSuspendedException;
import com.kingdee.bos.workflow.exception.PostManpowerActivityHasClosedException;
import com.kingdee.bos.workflow.exception.WfExpiredException;
import com.kingdee.bos.workflow.metas.ActInstInfo;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.ProcInstBizObjCollection;
import com.kingdee.bos.workflow.metas.ProcInstDataInfo;
import com.kingdee.bos.workflow.metas.ProcessInstEventEnum;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.participant.ParticipantUtils;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.store.ActivityStorer;
import com.kingdee.bos.workflow.store.DataFieldStorer;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.transaction.ProcessLock;
import com.kingdee.bos.workflow.transaction.SnapshotRecorder;
import com.kingdee.bos.workflow.util.CommonEventUtils;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.bos.workflow.util.ProcessParamUtils;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.bos.workflow.util.WfMsgToOtherSys;
import com.kingdee.bos.workflow.util.WorkflowUtils;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import com.kingdee.cbos.process.vm.runtime.Profile;
import com.kingdee.exception.ExceptionUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

public class WfProcess
extends WfExecutionObject
implements IWfProcess {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.WfProcess");
    private ProcessLock innerLock;
    private List activityIds;
    private ProcessInstInfo meta;
    private ProcessContext context;
    private WfProcessMgr processMgr;
    private Set ansySubflowSet;
    private Map bizObjOrgMap;
    private HashSet billIds = null;

    public WfProcess() {
        this.innerLock = ProcessLock.LOCK_NOT;
    }

    public WfProcess(ProcessInstInfo meta, WfProcessMgr mgr) throws WfException {
        super(mgr.getWfEngine(), meta.getProcInstId());
        this.meta = meta;
        this.processMgr = mgr;
        this.innerLock = ProcessLock.LOCK_NOT;
        log.debug((Object)("PROCESS-INST::" + this.toString() + "@" + meta.getProcInstId()));
    }

    @Override
    public String getId() {
        return this.meta.getProcInstId();
    }

    public String name() throws WfException {
        return this.manager().name();
    }

    public ProcessDef getDefinition() {
        return this.manager().getProcessDef();
    }

    public WfActivity innerCreateActivityInst(String actInstId, ActivityDef actDef, String[] fromActInstList, String parentActInstId) throws WfException {
        if (!this.state().startsWith("open")) {
            throw new WfException("Fatal Error.");
        }
        ActInstInfo actInstInfo = ActivityStorer.buildNewActInstInfo(this.getWfEngine().context(), this, actDef, fromActInstList, fromActInstList, false, 0, null, null, parentActInstId);
        actInstInfo.setActInstID(BOSUuid.read((String)actInstId));
        SnapshotRecorder recorder = SnapshotRecorder.create();
        recorder.snapshoot((AbstractObjectValue)actInstInfo);
        recorder.recordSnapshots();
        WfActivity wfActivity = new WfActivity(this.getWfEngine(), new ActivityInstInfo(actInstInfo));
        this.getWfEngine().eventService().raiseActivityEvent(ActivityEvent.OnActivityCreated, wfActivity, null);
        this.getWfEngine().getCacheManager().addActivityInst(wfActivity);
        this.activityIds(true).add(actInstInfo.getActInstID());
        return wfActivity;
    }

    public boolean evalCondition(ExpressionCollection expressionCollection) throws WfException {
        if (expressionCollection == null || expressionCollection.size() == 0) {
            return true;
        }
        ExpressionDef express = expressionCollection.get(0);
        if (express == null || express.toString().trim().length() == 0) {
            return true;
        }
        return ScriptUtil.evalCondition(express.toString(), this.getProcessContext(), this.getDefinition());
    }

    public void innerStartAndCommitFirstActivity(String eventId, String startActDefId, Map boMap, String userId, Context ctx, Person person, Object[] parameters, Map extendProperties) throws WfException {
        ProcessDef processDef = this.getDefinition();
        ManpowerActivityDef startupActivityDef = this.checkAndGetFirstActivity(startActDefId, processDef);
        this.prepare4startup(boMap, ctx, extendProperties, (ActivityDef)startupActivityDef);
        this.startRuntime(processDef, (ActivityDef)startupActivityDef, true);
    }

    private void startRuntime(ProcessDef processDef, ActivityDef startupActivityDef, boolean omitFirstAct) throws WfException {
        this.innerStart();
        Flow flow = this.getWfEngine().getFlow(processDef.getHashValue());
        FlowContext runtime = flow.newInstance();
        runtime.setProfile(Profile.PERFORMANCE);
        Util.setFirstActivity(runtime, startupActivityDef, omitFirstAct);
        this.getProcessContext().setFlowContext(runtime);
        FlowInitiator.enqueue(this.getContext(), this.getId());
    }

    public void innerStart() throws WfException {
        this.setState(WfState.RUNNING);
        if (this.getWfEngine().getState() == 1) {
            this.createEvent(WfEventType.PROCESS_STARTED);
        }
    }

    private void prepare4startup(Map boMap, Context ctx, Map extendProperties, ActivityDef startupActivityDef) throws WfException, CannotStopException, NotRunningException {
        ManpowerActivityDef manpowerActDef = (ManpowerActivityDef)startupActivityDef;
        ApplicationDef appDef = manpowerActDef.getRelatedApplication();
        ActualParameterCollection actualParamCol = manpowerActDef.getActualParameters();
        HashMap<String, FormalParameterDef> paramDefMap = new HashMap<String, FormalParameterDef>();
        Map paramValueMap = new HashMap();
        FormalParameterCollection formalParms = appDef.getFormalParameters();
        FormalParameterDef bizObjParamDef = null;
        for (int i = 0; i < formalParms.size(); ++i) {
            FormalParameterDef paramDef = formalParms.get(i);
            if (!paramDef.getMode().equals((Object)FormalParameterMode.OUT) && !paramDef.getMode().equals((Object)FormalParameterMode.INOUT) || paramDef.getBoId() == null || paramDef.getBoId().equals("")) continue;
            if (!paramDef.getDataType().equals(BasicType.BIZOBJ)) {
                paramDefMap.put(paramDef.getID(), paramDef);
                continue;
            }
            bizObjParamDef = paramDef;
            paramDefMap.put(paramDef.getID(), paramDef);
        }
        try {
            paramValueMap = ScriptUtil.evalPropertyExpr(paramDefMap, boMap, ctx, this.getProcessContext());
        }
        catch (Exception t) {
            log.error((Object)t);
            throw new WfException((Throwable)t);
        }
        for (FormalParameterDef paramDef : paramDefMap.values()) {
            ActualParameterDef actualParam;
            DataFieldDef dataField;
            if (paramDef.getDataType().equals(BasicType.BIZOBJ) || paramDef.getIndex() >= actualParamCol.size() || (dataField = (actualParam = (ActualParameterDef)actualParamCol.getObject(paramDef.getIndex())).getDataField()) == null) continue;
            String dataName = dataField.getName();
            Object paramValue = paramValueMap.get(paramDef.getID());
            this.getProcessContext().setDataFieldValue(dataName, paramValue);
        }
        if (bizObjParamDef != null) {
            for (Object obj : boMap.keySet()) {
                if (obj == null) continue;
                String bizId = obj.toString();
                String objectType = null;
                try {
                    objectType = BOSUuid.getBOSObjectType((String)bizId, (boolean)true).toString();
                }
                catch (Exception paramValue) {
                    // empty catch block
                }
                if (objectType == null || !objectType.equals(bizObjParamDef.getBoId())) continue;
                ActualParameterDef actualParam = actualParamCol.get(bizObjParamDef.getIndex());
                if (!StringUtils.isEmpty((String)actualParam.getExpr())) {
                    String name = actualParam.getDataField().getName();
                    this.getProcessContext().putDataFieldValue(name, null);
                    this.getProcessContext().putDataFieldValue("$" + name + " .bizId$", bizId);
                    break;
                }
                this.getProcessContext().putDataFieldValue(bizObjParamDef.getName(), null);
                this.getProcessContext().putDataFieldValue("$" + bizObjParamDef.getName() + " .bizId$", bizId);
                break;
            }
        }
        if (paramValueMap.containsKey(RuntimeSystemVariable.ORGMAP.getValue())) {
            this.getProcessContext().putDataFieldValue(RuntimeSystemVariable.ORGMAP.getValue(), paramValueMap.get(RuntimeSystemVariable.ORGMAP.getValue()));
        }
        ProcessContext ctx1 = this.getProcessContext();
        if (extendProperties != null) {
            Locale loacle;
            Map performers = (Map)extendProperties.get("DesignateNextActivityPerformerWhenSubmit");
            if (performers != null) {
                ctx1.putDataFieldValues(performers);
            }
            if ((loacle = (Locale)extendProperties.get("lastRealLocale")) != null) {
                ctx1.putDataFieldValue("lastRealLocale", loacle);
            }
        }
        Object orgMap = this.getProcessContext().getDataFieldValue(RuntimeSystemVariable.ORGMAP.getValue());
        HashMap boIdOrgIdMap = new HashMap(boMap.size());
        for (Object boId : boMap.keySet()) {
            if (orgMap != null) {
                boIdOrgIdMap.put(boId, ((Map)orgMap).get(boId));
                continue;
            }
            String s = null;
            Object obj = ctx1.getDataFieldValue("$BIZ_ORG_ID$");
            if (obj != null) {
                s = obj.toString();
            }
            boIdOrgIdMap.put(boId, s);
        }
        this.holdBizObj(boIdOrgIdMap);
    }

    private ManpowerActivityDef checkAndGetFirstActivity(String startActDefId, ProcessDef processDef) throws WfException {
        this.checkExpire();
        ActivityDef startupActivityDef = processDef.getActivityDef(startActDefId);
        if (!(startupActivityDef instanceof ManpowerActivityDef)) {
            throw new WfExpiredException("WFE_PROCESS_start_actType", null, null).addArg(startupActivityDef.getID());
        }
        if (!this.state().equals(WfState.NOT_STARTED.getValue())) {
            throw new CannotStartException("WFE_PROCESS_start_state", null, null).addArg(this.getId()).addArg(this.meta.getCode());
        }
        return (ManpowerActivityDef)startupActivityDef;
    }

    public void innerComplete() throws WfException {
        this.setCompleteTime();
        this.setState(WfState.COMPLETED);
        this.createEvent(WfEventType.PROCESS_COMPLETED);
        this.abortUncompleteActivities();
        this.dispose();
    }

    private void dispose() throws WfException {
        this.removeProcessBizObj();
        this.deleteProcessRecord();
        this.deleteBackgroundJob();
    }

    public void innerAbort() throws WfException {
        this.setState(WfState.ABORTED);
        this.dispose();
    }

    public void innerTerminate() throws WfException {
        this.setState(WfState.TERMINATED);
        this.dispose();
    }

    public void innerSuspend() throws WfException {
        this.setState(WfState.SUSPENDED);
        this.createEvent(WfEventType.PROCESS_SUSPENDED);
    }

    public void innerResume() throws WfException {
        this.setState(WfState.RUNNING);
        this.getWfEngine().eventService().raiseProcessEvent(ProcessEvent.OnProcessResumed, this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getBizObjOrgMap() throws WfException {
        if (this.bizObjOrgMap == null) {
            WfProcess wfProcess = this;
            synchronized (wfProcess) {
                if (this.bizObjOrgMap == null) {
                    ProcInstBizObjCollection procInstBizObjs = this.getWfEngine().getStoreManager().getProcessStorer().getProcInstBizObjInfoByProcInstId(this.getId());
                    HashMap<String, String> bizObjOrgMap = new HashMap<String, String>();
                    if (procInstBizObjs != null) {
                        for (int i = 0; i < procInstBizObjs.size(); ++i) {
                            if (procInstBizObjs.get(i).getBizObjID() != null) {
                                bizObjOrgMap.put(procInstBizObjs.get(i).getBizObjID().toString(), procInstBizObjs.get(i).getOrgId());
                                continue;
                            }
                            log.debug((Object)("BoId is null." + procInstBizObjs.get(i).getProcInstID()));
                        }
                    }
                    this.bizObjOrgMap = bizObjOrgMap;
                }
            }
        }
        return this.bizObjOrgMap;
    }

    public String getOrgIdByHoldedBizObjId(String boId) throws WfException {
        if (boId == null || boId.trim().length() == 0) {
            return "";
        }
        if (this.getBizObjOrgMap().containsKey(boId) && this.getBizObjOrgMap().get(boId) != null) {
            return this.getBizObjOrgMap().get(boId).toString();
        }
        return "";
    }

    public String getOrgIdByVariable(String varName) throws WfException {
        String orgId = null;
        Object o = this.getProcessContext().getDataFieldValue(varName);
        if (o != null) {
            String s = o.toString();
            try {
                BOSUuid.read((String)s);
                orgId = s;
            }
            catch (Throwable e) {
                log.warn((Object)("variable " + varName + " is not a validate orgid"), e);
            }
        }
        return orgId;
    }

    public Enum getOrgTypeByVariable(String varName) throws WfException {
        String orgTypeClassName = "com.kingdee.eas.basedata.org.OrgType";
        Object o = this.getProcessContext().getDataFieldValue(varName);
        Class<?> OrgTypeClass = null;
        try {
            OrgTypeClass = Class.forName(orgTypeClassName);
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"cannot found OrgType Class", (Throwable)e);
            throw new WfException("WFE_PROCESS_orgType_notFound", null, (Throwable)e);
        }
        if (o != null) {
            if (o instanceof Enum) {
                List orgTypeList = EnumUtils.getEnumList((String)orgTypeClassName);
                orgTypeList.contains(o);
                return (Enum)o;
            }
            if (o instanceof Integer) {
                return EnumUtils.getEnum(OrgTypeClass, (int)((Integer)o));
            }
        }
        log.warn((Object)("variable " + varName + " value is " + o + ",is not a validate orgtype"));
        return null;
    }

    public Map getProcContextDataCopy() throws WfException {
        return this.getProcessContext().getDataCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessContext getProcessContext() throws WfException {
        if (this.context == null) {
            WfProcess wfProcess = this;
            synchronized (wfProcess) {
                if (this.context == null) {
                    this.innerLoadProcessContext();
                }
            }
        }
        return this.context;
    }

    private void innerLoadProcessContext() throws WfException {
        DataFieldStorer storer = this.getWfEngine().getStoreManager().getDataFieldStorer();
        ProcInstDataInfo procInstDataInfo = storer.getProcInstDataInfo(BOSUuid.read((String)this.getId()));
        if (procInstDataInfo == null) {
            throw new WfException((Throwable)new ProcessContextNotExistException());
        }
        this.context = new ProcessContext(this.manager().getWfEngine(), this, procInstDataInfo);
    }

    public void setProcessContext(ProcessContext processContext) {
        this.context = processContext;
    }

    public void storeProcessContext(Map procCtx) throws WfException {
        this.getProcessContext().setDataFieldValues(procCtx);
        this.getProcessContext().storeToDb();
    }

    public void setDataField(String name, Object value) throws WfException {
        this.getProcessContext().setDataFieldValue(name, value);
    }

    public String[] getPassedTransDefArray() throws WfException {
        ArrayList<String> transDefIdList = new ArrayList<String>();
        List actInstList = this.activities();
        for (int i = 0; i < actInstList.size(); ++i) {
            WfActivity actInst = (WfActivity)actInstList.get(i);
            String[] fromActInstIdArray = actInst.getMeta().getFromActInstList();
            if (fromActInstIdArray == null) continue;
            String actDefId = actInst.getDefinition().getID();
            ProcessDef procDef = this.getDefinition();
            for (int j = 0; j < fromActInstIdArray.length; ++j) {
                WfActivity fromActInst;
                String fromActInstId = fromActInstIdArray[j];
                if (fromActInstId == null || fromActInstId.length() == 0 || (fromActInst = this.getActInstByInstId(fromActInstId)) == null) continue;
                assert (fromActInst.getDefinition() != null);
                String fromActDefId = fromActInst.getDefinition().getID();
                TransitionCollection transCol = procDef.getTransitionsByActivity(fromActDefId, actDefId);
                for (int k = 0; k < transCol.size(); ++k) {
                    String transDefId = transCol.get(k).getID();
                    if (transDefIdList.contains(transDefId)) continue;
                    transDefIdList.add(transDefId);
                }
            }
        }
        String[] rtnValue = new String[transDefIdList.size()];
        transDefIdList.toArray(rtnValue);
        return rtnValue;
    }

    public synchronized List activityIds(boolean isActivitiesLoaded) throws WfException {
        if (this.activityIds == null) {
            this.activityIds = new ArrayList();
            if (isActivitiesLoaded) {
                ActivityInstInfo[] actInstMetaArray = this.getWfEngine().getActInstMetaArrayByProcInstId(this.getId());
                for (int i = 0; i < actInstMetaArray.length; ++i) {
                    this.activityIds.add(actInstMetaArray[i].getActInstId());
                }
            }
        }
        return this.activityIds;
    }

    public synchronized List activities() throws WfException {
        ArrayList<WfActivity> activities = new ArrayList<WfActivity>();
        List activityIds = this.activityIds(true);
        Iterator it = activityIds.iterator();
        while (it.hasNext()) {
            WfActivity actInst = this.getWfEngine().getActivityInst(it.next().toString());
            activities.add(actInst);
        }
        return activities;
    }

    public WfProcessMgr manager() {
        return this.processMgr;
    }

    public void receiveResults(WfActivity activity, Map results) throws WfException {
        if (results != null) {
            this.getProcessContext().setDataFieldValues(results);
            this.getProcessContext().storeToDb();
        }
    }

    public synchronized void start(String startActDefId) throws WfException, CannotStartException, AlreadyRunningException {
        this.start(startActDefId, null);
    }

    private void checkExpire() throws WfException {
        ProcessDef procDef = this.getDefinition();
        Date validFrom = procDef.getProcessHeader().getValidFrom();
        Date validTo = procDef.getProcessHeader().getValidTo();
        long currentTime = System.currentTimeMillis();
        if (validFrom != null && validFrom.getTime() > currentTime) {
            WfException ex = new WfExpiredException("WFE_SER_validFrom", null, null).addArg(procDef.getNameResource().getPossibleValue(null)).addArg(procDef.getCode()).addArg(DateTimeUtils.format((Date)validFrom));
            ExceptionUtil.process((Throwable)ex, null);
            throw ex;
        }
        if (validTo != null && currentTime > validTo.getTime()) {
            WfException ex = new WfExpiredException("WFE_SER_validTo", null, null).addArg(procDef.getNameResource().getPossibleValue(null)).addArg(procDef.getCode()).addArg(validTo.getTime() + "");
            ExceptionUtil.process((Throwable)ex, null);
            throw ex;
        }
    }

    public synchronized void start(String startActDefId, String startActPerfoermId) throws WfException, CannotStartException, AlreadyRunningException {
        this.checkExpire();
        if (!this.state().equals("open.not_running.not_started")) {
            throw new CannotStartException("WFE_PROCESS_start_state").addArg(this.getId());
        }
        ProcessDef procDef = this.getDefinition();
        ActivityDef firstActDef = procDef.getActivityDef(startActDefId);
        if (startActPerfoermId != null && !(firstActDef instanceof ManpowerActivityDef)) {
            throw new CannotStartException("\u5f00\u59cb\u6d3b\u52a8(" + startActDefId + ")\u4e0d\u662f\u4eba\u5de5\u6d3b\u52a8\uff0c\u4e0d\u80fd\u6307\u5b9a\u53c2\u4e0e\u4eba\uff01");
        }
        this.setPerformers(startActPerfoermId, firstActDef);
        this.startRuntime(procDef, firstActDef, false);
    }

    private void setPerformers(String startActPerfoermId, ActivityDef firstActDef) throws WfException {
        if (startActPerfoermId == null || startActPerfoermId.length() == 0) {
            return;
        }
        String key = ParticipantUtils.createDesignatePerformerKey((ActivityDef)firstActDef);
        ArrayList<String> persons = new ArrayList<String>(1);
        persons.add(startActPerfoermId);
        this.getProcessContext().putDataFieldValue(key, persons);
    }

    private void createEvent(WfEventType eventType) throws WfException {
        EventPolicyCollection eventPolicyCol = this.getDefinition().getProcessHeader().getEventPolicies();
        boolean needSend = ProcessParamUtils.isSatisfyThisParam((Context)this.getContext(), (String)this.getProcessMeta().getProcDefId(), (String)"notifySubmitterWhenSuspend");
        log.info((Object)("ProcessParamUtils.isSatisfyThisParam result : " + needSend + "  , params : " + this.getProcessMeta().getProcDefId() + " notifySubmitterWhenSuspend"));
        if (eventPolicyCol.isEmpty() && !needSend) {
            return;
        }
        String bid = null;
        String sourceids = this.getSourceIds(bid);
        WfMessageSender sender = this.getWfEngine().getMessageSender();
        if (needSend && WfEventType.PROCESS_SUSPENDED.equals((Object)eventType)) {
            this.defaultSendMsg(eventType, sourceids, sender);
        }
        int size = eventPolicyCol.size();
        for (int i = 0; i < size; ++i) {
            ParticipantCollection participantCol;
            List personList;
            EventPolicyDef eventPolicy = eventPolicyCol.get(i);
            String defEventType = eventPolicy.getEventType();
            if (!defEventType.equals(eventType.getAlias()) || (personList = ParticipantHelper.getPersonsByParticipants(this, participantCol = eventPolicy.getParticipants())).size() <= 0) continue;
            StringBuffer buff = new StringBuffer();
            int size1 = personList.size();
            for (int j = 0; j < size1; ++j) {
                if (j != 0) {
                    buff.append(";");
                }
                Person temPerson = (Person)personList.get(j);
                buff.append(temPerson.getUserId());
            }
            WfEvent event = this.makeWfEvent(eventType, buff.toString(), sourceids);
            if (eventType.getAlias().equals(WfEventType.PROCESS_SUSPENDED.toString())) {
                if (eventPolicy.isHasSuspendEmail()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("suspendEmail", "true");
                    event.setParameters(map);
                } else {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("suspendEmail", "false");
                    event.setParameters(map);
                }
            }
            sender.sendEvent(event);
        }
    }

    private void defaultSendMsg(WfEventType eventType, String sourceids, WfMessageSender sender) throws WfException {
        String receiverList = this.getData().getInitiatorId();
        ProcessHeaderDef processHeader = this.getDefinition().getProcessHeader();
        if (processHeader != null) {
            ResponsibleCollection adminPerson = processHeader.getResponsibles();
            String adminPersons = "";
            for (int i = 0; i < adminPerson.size(); ++i) {
                adminPersons = i == 0 ? "'" + adminPerson.get(i).getID() + "'" : adminPersons + " , '" + adminPerson.get(i).getID() + "'";
            }
            if (adminPersons.length() > 0) {
                String sql = "select FID from T_PM_USER where FPERSONID in (" + adminPersons + ")";
                try {
                    ArrayList arrayList = SQL.executeQuery((Context)this.getContext(), (String)sql);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        receiverList = receiverList + ";" + ((Map)arrayList.get(i)).get("fid");
                    }
                }
                catch (BOSException e) {
                    log.info((Object)"T_PM_USER\u53d6\u503c\u62a5\u9519", (Throwable)e);
                }
            }
        }
        WfEvent event = this.makeWfEvent(eventType, receiverList, sourceids);
        String[] values = ProcessParamUtils.getParamValues((Context)this.getContext(), (String)this.getProcessMeta().getProcDefId(), (String)"notifySubmitterWhenSuspend");
        if (eventType.getAlias().equals(WfEventType.PROCESS_SUSPENDED.toString())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("suspendEmail", "true");
            map.put("suspendSms", "true");
            if (values != null) {
                map.put("suspendValue", values[0]);
            }
            event.setParameters(map);
        }
        sender.sendEvent(event);
    }

    private String getSourceIds(String bid) {
        String sourceids = "|" + this.getId();
        try {
            String[] bids = this.getBizObjIds();
            if (bids != null && bids.length > 0) {
                bid = bids[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bid != null) {
            sourceids = sourceids + "|" + bid;
        }
        return sourceids;
    }

    private WfEvent makeWfEvent(WfEventType eventType, String receiverList, String sourceIds) {
        WfEvent event = new WfEvent(this.getWfEngine());
        event.setReceiverList(receiverList);
        log.info((Object)("message receiverList : " + receiverList));
        event.setProcessDefId(this.getDefinition().getID());
        event.setProcessId(this.getId());
        event.setProcessDefVersion(this.manager().getData().getInnerVersion());
        event.setProcessName(this.getDefinition().getNameResource());
        event.setEventType(eventType);
        event.setSourceIds(sourceIds);
        if (this.getDefinition() != null) {
            event.setWfType(this.getDefinition().getType());
        }
        return event;
    }

    public synchronized void startAndCommitFirstActivity(Map boMap, String userId, Context ctx, Person person) throws WfException, CannotStartException, AlreadyRunningException {
        ProcessDef processDef = this.getDefinition();
        StartActivityDef startPointDef = processDef.getStartActivity();
        ActivityCollection postActDefList = startPointDef.getPostActivities();
        if (postActDefList.size() == 1) {
            ActivityDef activityDef = postActDefList.get(0);
            this.startAndCommitFirstActivity(null, activityDef.getID(), boMap, userId, ctx, person, null, null);
            return;
        }
        throw new WfException("processdef Name:" + processDef.getName() + " ID:" + processDef.getID() + " has more than one statrt activity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startAndCommitFirstActivity(String eventId, String startActDefId, Map boMap, String userId, Context ctx, Person person, Object[] parameters, Map extendProperties) throws WfException, CannotStartException, AlreadyRunningException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "startAndCommitFirstActivity", null);
        }
        try {
            this.checkExpire();
            ProcessDef processDef = this.getDefinition();
            ActivityDef startupActivityDef = processDef.getActivityDef(startActDefId);
            if (!(startupActivityDef instanceof ManpowerActivityDef)) {
                WfException ex = new WfExpiredException("WFE_PROCESS_start_actType", null, null).addArg(startupActivityDef.getID());
                throw ex;
            }
            if (!this.state().equals(WfState.NOT_STARTED.getValue())) {
                throw new CannotStartException("WFE_PROCESS_start_state", null, null).addArg(this.getId()).addArg(this.meta.getCode());
            }
            this.prepare4startup(boMap, ctx, extendProperties, startupActivityDef);
            this.getProcessContext().storeToDb();
            this.startRuntime(processDef, startupActivityDef, true);
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    public synchronized void startAndCompleteFirstActivity(Map invokeContext) throws WfException {
        this.checkExpire();
        ProcessDef processDef = this.getDefinition();
        ActivityDef startupActivityDef = processDef.getStartupActivities().get(0);
        if (!this.state().equals(WfState.NOT_STARTED.getValue())) {
            throw new CannotStartException("WFE_PROCESS_start_state", null, null).addArg(this.getId()).addArg(this.meta.getCode());
        }
        this.getProcessContext().putDataFieldValues(invokeContext);
        this.getProcessContext().storeToDb();
        this.startRuntime(processDef, startupActivityDef, true);
    }

    public synchronized String redo(WfActivity redoActInst) throws WfException {
        if (redoActInst.state().startsWith(WfState.OPEN.getValue())) {
            redoActInst.abortInternal();
        }
        ActivityDef actDef = redoActInst.getDefinition();
        String[] fromActInstList = new String[]{redoActInst.getId()};
        String newActInstId = this.createActivityInst(actDef, fromActInstList, redoActInst.getMeta().getPreActInstList(), true);
        WfActivity newActInst = this.getWfEngine().getActivityInst(newActInstId);
        String[] toActInfoInfo = new String[]{newActInstId};
        String[] postActListInfo = null;
        SnapshotRecorder recorder = SnapshotRecorder.create();
        recorder.snapshoot((AbstractObjectValue)redoActInst.getMeta().getActInstInfo());
        redoActInst.getMeta().setToActInstList(toActInfoInfo);
        redoActInst.getMeta().setPostActInstList(postActListInfo);
        recorder.snapshoot((AbstractObjectValue)redoActInst.getMeta().getActInstInfo());
        recorder.recordSnapshots();
        newActInst.init();
        if (actDef.getActivityHeader().getStartMode().equals((Object)AutomationMode.AUTOMATIC) && !(actDef instanceof ManpowerActivityDef)) {
            newActInst.activate();
        }
        this.updatePreActInstData(redoActInst, newActInst);
        return newActInstId;
    }

    public boolean canTransBack(WfActivity rollbackActInst) {
        if (!rollbackActInst.state().equals("closed.completed")) {
            return false;
        }
        ActivityCollection postActDefs = null;
        try {
            postActDefs = rollbackActInst.getDefinition().getPostActivities();
        }
        catch (WfException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        boolean flag = this.checkCanRollBack(rollbackActInst);
        if (!flag) {
            return false;
        }
        if (postActDefs != null) {
            int n = postActDefs.size();
            for (int i = 0; i < n; ++i) {
            }
        }
        if (rollbackActInst.getDefinition() instanceof EndActivityDef) {
            return true;
        }
        return true;
    }

    private boolean checkCanRollBack(WfActivity rollbackActInst) {
        boolean flag = true;
        String[] instArray = rollbackActInst.getInstanceInfo().getPostActInstList();
        WfActivity actInst = null;
        ActivityDef actDef = null;
        for (int i = 0; i < instArray.length; ++i) {
            if (StringUtils.isEmpty((String)instArray[i])) continue;
            try {
                actInst = this.getWfEngine().getActivityInst(instArray[i]);
                actDef = actInst.getDefinition();
                if (actInst.state().equals("closed.completed")) {
                    flag = actDef instanceof RouterActivityDef ? this.checkCanRollBack(actInst) : false;
                }
            }
            catch (WfException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            if (!flag) break;
        }
        return flag;
    }

    boolean canPostInstTransBack(WfActivity postActInst) {
        if (ActivityType.MANPOWER.equals((Object)postActInst.getDefinition().getType())) {
            String[] toActInstList;
            WfActivity actInst = postActInst;
            if (postActInst.getMeta().getPostActInstList() == null && postActInst.getMeta().getToActInstList() != null && (toActInstList = postActInst.getMeta().getToActInstList()) != null) {
                try {
                    actInst = this.getWfEngine().getActivityInst(toActInstList[0]);
                }
                catch (WfException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                if (actInst == null) {
                    actInst = postActInst;
                }
            }
            return actInst.state().equals("open.not_running.not_started") || actInst.state().equals("open.running.rollbacked");
        }
        return true;
    }

    private String transBackClosedProcess(WfActivity rollbackActInst) throws WfException {
        WfActivity parentActInst;
        boolean hasEndAct;
        if (!this.state().startsWith(WfState.CLOSED.getValue())) {
            throw new WfException("Process not closed!");
        }
        boolean isHistory = this.meta.isHistory();
        if (isHistory) {
            ProcessStorer ps = this.getWfEngine().getStoreManager().getProcessStorer();
            String processInstID = this.meta.getProcInstId();
            try {
                if (processInstID != null && processInstID.length() != 0) {
                    ps.getBackWfData(processInstID);
                }
            }
            catch (SQLException e) {
                throw new WfException("", (Throwable)e);
            }
            catch (DataAccessException e) {
                throw new WfException("", (Throwable)e);
            }
        }
        EndActivityDef endActDef = this.getDefinition().getEndActivity();
        if (!rollbackActInst.getDefinition().getPostActivities().containsKey((Object)endActDef.getID()) && !(hasEndAct = this.canTransBackClosedProc(rollbackActInst.getMeta().getToActInstList()))) {
            throw new WfException("WFE_PROCESS_transBack_hasPost", null, null).addArg(this.getId()).addArg(rollbackActInst.getId());
        }
        WfActivity endActInst = this.getActInstByDefId(endActDef.getID());
        if (this.meta.getParentActInstId() != null && this.meta.getParentActInstId().length() > 0 && (parentActInst = this.getWfEngine().getActivityInst(this.meta.getParentActInstId())) != null) {
            parentActInst.container().setState(WfState.ROLLBACKED);
        }
        this.setState(WfState.ROLLBACKED);
        endActInst.rollback();
        return this.transBack(rollbackActInst);
    }

    private boolean canTransBackClosedProc(String[] toActs) throws WfException {
        EndActivityDef endActDef = this.getDefinition().getEndActivity();
        int i = 0;
        int n = toActs.length;
        if (i < n && toActs[i] != null) {
            WfActivity act = this.getActInstByInstId(toActs[i]);
            if (ActivityType.MANPOWER.equals((Object)act.getDefinition().getType()) || ActivityType.SUBFLOW.equals((Object)act.getDefinition().getType())) {
                String msg = "can not trans back ,post manpower activity has closed.";
                throw new PostManpowerActivityHasClosedException(msg);
            }
            if (endActDef.getID().equals(act.getMeta().getActDefId())) {
                return true;
            }
            return this.canTransBackClosedProc(act.getMeta().getToActInstList());
        }
        return true;
    }

    public synchronized String transBack(WfActivity rollbackActInst) throws WfException {
        if (!this.canTransBack(rollbackActInst)) {
            throw new DisableRollbackException("can not trans back.");
        }
        if (!rollbackActInst.state().equals("closed.completed")) {
            return rollbackActInst.redo();
        }
        if (this.state().startsWith(WfState.CLOSED.getValue())) {
            return this.transBackClosedProcess(rollbackActInst);
        }
        List list = this.activityIds(true);
        synchronized (list) {
            ActivityDef rollbackActDef = rollbackActInst.getDefinition();
            if (rollbackActDef.getActivityHeader().getSplitType().equals((Object)SplitType.XOR) || rollbackActDef.outDegree() == 1) {
                return this.transBackXorSplit(rollbackActInst);
            }
            if (rollbackActDef.getActivityHeader().getSplitType() == SplitType.AND) {
                return this.transBackAndSplit(rollbackActInst);
            }
            if (rollbackActDef.getActivityHeader().getSplitType() == SplitType.OR) {
                return this.transBackOrSplit(rollbackActInst);
            }
            throw new WfException("FATAL ERROR. rollbackAct splitType error" + rollbackActDef.getActivityHeader().getSplitType().getName());
        }
    }

    private String transBackOrSplit(WfActivity rollbackActInst) throws WfException {
        String[] toActInstList = rollbackActInst.getMeta().getToActInstList();
        if (toActInstList.length <= 1) {
            throw new WfException("FATAL ERROR");
        }
        boolean flag = true;
        for (int i = 0; i < toActInstList.length; ++i) {
            WfActivity toActInst = this.getWfEngine().getActivityInst(toActInstList[i]);
            if (toActInst == null) {
                throw new WfException("FATAL ERROR");
            }
            if (toActInst.state().equals("open.not_running.not_started")) continue;
            flag = false;
            break;
        }
        if (!flag) {
            throw new WfException("toactivity has started,can not rollback.");
        }
        String[] newFromActInstList = null;
        for (int i = 0; i < toActInstList.length; ++i) {
            WfActivity toActInst = this.getWfEngine().getActivityInst(toActInstList[i]);
            newFromActInstList = i == 0 ? new String[]{toActInst.getId()} : StringUtils.stringArrayAppend(newFromActInstList, (String)toActInst.getId());
            ActivityDef toActDef = toActInst.getDefinition();
            if (!toActDef.getActivityHeader().getJoinType().equals((Object)JoinType.XOR) && toActDef.inDegree() != 1) {
                throw new WfException("TODO");
            }
            toActInst.rollback();
        }
        String[] newPreActInstList = rollbackActInst.getMeta().getPreActInstList();
        String newActInstId = this.createActivityInst(rollbackActInst.getDefinition(), newFromActInstList, newPreActInstList, false);
        WfActivity newActInst = this.getWfEngine().getActivityInst(newActInstId);
        if (this.canTransBackCascade(newActInst)) {
            return this.transBackCascade(newActInst);
        }
        newActInst.init();
        return newActInstId;
    }

    private String transBackAndSplit(WfActivity rollbackActInst) throws WfException {
        String[] toActInstList = rollbackActInst.getMeta().getToActInstList();
        if (toActInstList.length <= 1) {
            throw new WfException("FATAL ERROR");
        }
        boolean flag = true;
        for (int i = 0; i < toActInstList.length; ++i) {
            WfActivity toActInst = this.getWfEngine().getActivityInst(toActInstList[i]);
            if (toActInst == null) {
                throw new WfException("FATAL ERROR");
            }
            if (toActInst.state().equals("open.not_running.not_started")) continue;
            flag = false;
            break;
        }
        if (!flag) {
            throw new WfException("can not rollback.");
        }
        String[] newFromActInstList = null;
        for (int i = 0; i < toActInstList.length; ++i) {
            WfActivity toActInst = this.getWfEngine().getActivityInst(toActInstList[i]);
            newFromActInstList = i == 0 ? new String[]{toActInst.getId()} : StringUtils.stringArrayAppend(newFromActInstList, (String)toActInst.getId());
            ActivityDef toActDef = toActInst.getDefinition();
            if (!toActDef.getActivityHeader().getJoinType().equals((Object)JoinType.XOR) && toActDef.inDegree() != 1) {
                throw new WfException("TODO");
            }
            toActInst.rollback();
        }
        String[] newPreActInstList = rollbackActInst.getMeta().getPreActInstList();
        String newActInstId = this.createActivityInst(rollbackActInst.getDefinition(), newFromActInstList, newPreActInstList, false);
        WfActivity newActInst = this.getWfEngine().getActivityInst(newActInstId);
        if (this.canTransBackCascade(newActInst)) {
            return this.transBackCascade(newActInst);
        }
        newActInst.init();
        return newActInstId;
    }

    private String transBackXorSplit(WfActivity rollbackActInst) throws WfException {
        String[] toActInstList = rollbackActInst.getMeta().getToActInstList();
        if (toActInstList != null && toActInstList.length != 0 && toActInstList[0] != null) {
            HashSet<String> set = new HashSet<String>();
            for (String id : toActInstList) {
                if (set.contains(id)) continue;
                set.add(id);
            }
            toActInstList = new String[set.size()];
            set.toArray(toActInstList);
        }
        ActivityDef rollbackActDef = rollbackActInst.getDefinition();
        ActivityCollection postActDefList = rollbackActDef.getPostActivities();
        if (toActInstList == null) {
            ProcessStorer procStorer = this.getWfEngine().getStoreManager().getProcessStorer();
            ArrayList<TransBoxInfo> transBoxList = new ArrayList<TransBoxInfo>();
            for (int i = 0; i < postActDefList.size(); ++i) {
                TransBoxInfo transBox;
                ActivityDef postActDef = postActDefList.get(i);
                try {
                    transBox = procStorer.getTransBox(this.getId(), postActDef.getID());
                }
                catch (SQLException ex) {
                    throw new WfException("can not get transBox from db.", (Throwable)ex);
                }
                catch (DataAccessException e) {
                    throw new WfException("DataAccessException", (Throwable)e);
                }
                if (transBox == null) continue;
                transBoxList.add(transBox);
            }
            if (transBoxList.size() != 1) {
                log.debug((Object)"error occur when transback,because transBox size is not 1");
                if (this.canTransBackCascade(rollbackActInst)) {
                    return this.transBackCascade(rollbackActInst);
                }
                return rollbackActInst.redo();
            }
            TransBoxInfo transBox = (TransBoxInfo)transBoxList.get(0);
            if (transBox.getTransCount() > 0) {
                try {
                    procStorer.deleteTransBox(this.getId(), transBox.getToActDefId().toString());
                }
                catch (SQLException ex) {
                    throw new WfException("can not delete transBox from db.", (Throwable)ex);
                }
                catch (DataAccessException e) {
                    throw new WfException("DataAccessException", (Throwable)e);
                }
                if (this.canTransBackCascade(rollbackActInst)) {
                    return this.transBackCascade(rollbackActInst);
                }
                return rollbackActInst.redo();
            }
        }
        if (toActInstList != null && toActInstList.length != 1) {
            throw new WfException("FATAL ERROR");
        }
        WfActivity postActInst = this.getWfEngine().getActivityInst(toActInstList[0]);
        if (postActInst == null) {
            throw new WfException("FATAL ERROR");
        }
        ActivityDef postActDef = postActInst.getDefinition();
        if (postActDef == null) {
            throw new WfException("FATAL ERROR");
        }
        return this.transBackInternal(rollbackActInst, postActInst);
    }

    private boolean canTransBackCascade(WfActivity rollbackActInst) {
        ActivityDef actDef = rollbackActInst.getDefinition();
        if (!actDef.getActivityHeader().isRollback()) {
            return false;
        }
        if (ActivityType.TOOL.equals((Object)actDef.getType())) {
            return true;
        }
        return ActivityType.BLOCK.equals((Object)actDef.getType()) && !(actDef instanceof StartActivityDef);
    }

    private String transBackInternal(WfActivity rollbackActInst, WfActivity postActInst) throws WfException {
        ActivityDef rollbackActDef = rollbackActInst.getDefinition();
        ActivityDef postActDef = postActInst.getDefinition();
        String postActInstId = postActInst.getId();
        String postActDefId = postActDef.getID();
        if (postActDef.getActivityHeader().getJoinType() == JoinType.XOR || postActDef.inDegree() == 1) {
            this.tranBackRecursion(postActInst);
            postActInst.rollback();
            if (!ActivityType.MANPOWER.equals((Object)rollbackActDef.getType())) {
                return postActInst.getId();
            }
            String[] newFromActInstList = new String[]{postActInst.getId()};
            String[] newPreActInstList = rollbackActInst.getMeta().getPreActInstList();
            String newActInstId = this.createActivityInst(rollbackActInst.getDefinition(), newFromActInstList, newPreActInstList, false);
            WfActivity newActInst = this.getWfEngine().getActivityInst(newActInstId);
            this.updateRollbackActInstLinkInfo(rollbackActInst, newActInstId);
            this.updatePreActInstData(rollbackActInst, newActInst);
            String innerPreviousActivityInstId = rollbackActInst.getMeta().getActInstId();
            newActInst.init(innerPreviousActivityInstId);
            return newActInstId;
        }
        if (postActDef.getActivityHeader().getJoinType() == JoinType.AND) {
            if (!this.canPostInstTransBack(postActInst)) {
                throw new WfException("can not rollback.");
            }
            this.tranBackRecursion(postActInst);
            postActInst.rollback();
            if (!ActivityType.MANPOWER.equals((Object)rollbackActDef.getType())) {
                return postActInst.getId();
            }
            ActivityInstInfo postActInstMeta = postActInst.getMeta();
            String[] postFromActInstList = postActInstMeta.getFromActInstList();
            if (postFromActInstList == null || postFromActInstList.length <= 1) {
                throw new WfException("Fatal Error.");
            }
            String[] transRecord = null;
            for (int i = 0; i < postFromActInstList.length; ++i) {
                if (postFromActInstList[i].equals(rollbackActInst.getId())) continue;
                transRecord = transRecord == null ? new String[]{postFromActInstList[i]} : StringUtils.stringArrayAppend(transRecord, (String)postFromActInstList[i]);
            }
            TransBoxInfo transBox = new TransBoxInfo();
            transBox.setProcInstId(this.getId());
            transBox.setToActDefId(postActDefId);
            transBox.setTransRecord(transRecord);
            transBox.setTransCount(transRecord.length - 1);
            ProcessStorer procStorer = this.getWfEngine().getStoreManager().getProcessStorer();
            try {
                procStorer.createTransBox(transBox.getMeta());
            }
            catch (SQLException ex) {
                throw new WfException("SQLException", (Throwable)ex);
            }
            catch (DataAccessException e) {
                throw new WfException("DataAccessException", (Throwable)e);
            }
            String[] newFromActInstList = new String[]{postActInstId};
            String[] newPreActInstList = rollbackActInst.getMeta().getPreActInstList();
            String newActInstId = this.createActivityInst(rollbackActDef, newFromActInstList, newPreActInstList, false);
            WfActivity newActInst = this.getWfEngine().getActivityInst(newActInstId);
            this.updateRollbackActInstLinkInfo(rollbackActInst, newActInstId);
            this.updatePreActInstData(rollbackActInst, newActInst);
            newActInst.init();
            return newActInstId;
        }
        if (postActDef.getActivityHeader().getJoinType() == JoinType.OR) {
            String[] newFromActInstList;
            if (!postActInst.state().equals("open.not_running.not_started")) {
                throw new WfException("can not rollback.");
            }
            this.tranBackRecursion(postActInst);
            postActInst.rollback();
            if (!ActivityType.MANPOWER.equals((Object)rollbackActDef.getType())) {
                return postActInst.getId();
            }
            ActivityInstInfo postActInstMeta = postActInst.getMeta();
            String[] postFromActInstList = postActInstMeta.getFromActInstList();
            if (postFromActInstList == null || postFromActInstList.length <= 1) {
                throw new WfException("Fatal Error.");
            }
            String[] transRecord = null;
            for (int i = 0; i < postFromActInstList.length; ++i) {
                if (postFromActInstList[i].equals(rollbackActInst.getId())) continue;
                transRecord = transRecord == null ? new String[]{postFromActInstList[i]} : StringUtils.stringArrayAppend(transRecord, (String)postFromActInstList[i]);
            }
            TransBoxInfo transBox = new TransBoxInfo();
            transBox.setProcInstId(this.getId());
            transBox.setToActDefId(postActDefId);
            transBox.setTransRecord(transRecord);
            transBox.setTransCount(transRecord.length - 1);
            ProcessStorer procStorer = this.getWfEngine().getStoreManager().getProcessStorer();
            try {
                procStorer.createTransBox(transBox.getMeta());
            }
            catch (SQLException ex) {
                throw new WfException("SQLException", (Throwable)ex);
            }
            catch (DataAccessException e) {
                throw new WfException("DataAccessException", (Throwable)e);
            }
            String[] newPreActInstList = newFromActInstList = new String[]{postActInstId};
            String newActInstId = this.createActivityInst(rollbackActDef, newFromActInstList, newPreActInstList, false);
            WfActivity newActInst = this.getWfEngine().getActivityInst(newActInstId);
            this.updateRollbackActInstLinkInfo(rollbackActInst, newActInstId);
            newActInst.init();
            return newActInstId;
        }
        throw new WfException("FATAL ERROR");
    }

    private void tranBackRecursion(WfActivity postActInst) throws WfException {
        String[] postActToActList = postActInst.getMeta().getToActInstList();
        postActToActList = postActInst.getWfEngine().getActivityInst(postActInst.getId()).getMeta().getToActInstList();
        if (postActToActList != null && postActToActList.length > 0) {
            int n = postActToActList.length;
            for (int i = 0; i < n; ++i) {
                WfActivity postActToActInst = this.getWfEngine().getActivityInst(postActToActList[i]);
                if (postActToActInst != null && !ActivityType.MANPOWER.equals((Object)postActToActInst.getDefinition().getType()) && !(postActToActInst.getDefinition() instanceof EndActivityDef)) {
                    this.transBackInternal(postActInst, postActToActInst);
                }
                if (postActToActInst == null || !ActivityType.MANPOWER.equals((Object)postActToActInst.getDefinition().getType())) continue;
                postActToActInst.rollback();
            }
        }
    }

    private void updatePreActInstData(WfActivity oldActInst, WfActivity newActInst) throws WfException {
        String[] preActs = oldActInst.getMeta().getPreActInstList();
        String oldActInstID = oldActInst.getId();
        String newActInstID = newActInst.getId();
        for (String preActInstID : preActs) {
            String[] postActs;
            ActivityInstInfo actInstInfo = this.getWfEngine().getActivityInst(preActInstID).getMeta();
            if (actInstInfo == null) continue;
            SnapshotRecorder recorder = SnapshotRecorder.create();
            recorder.snapshoot((AbstractObjectValue)actInstInfo.getActInstInfo());
            String[] toActs = actInstInfo.getToActInstList();
            if (toActs != null) {
                int m = toActs.length;
                for (int j = 0; j < m; ++j) {
                    if (!toActs[j].equals(oldActInstID)) continue;
                    toActs[j] = newActInstID;
                }
            }
            if ((postActs = actInstInfo.getPostActInstList()) != null) {
                int m = postActs.length;
                for (int j = 0; j < m; ++j) {
                    if (!postActs[j].equals(oldActInstID)) continue;
                    postActs[j] = newActInstID;
                }
            }
            actInstInfo.setToActInstList(toActs);
            actInstInfo.setPostActInstList(postActs);
            recorder.snapshoot((AbstractObjectValue)actInstInfo.getActInstInfo());
            recorder.recordSnapshots();
        }
    }

    private void updateRollbackActInstLinkInfo(WfActivity rollbackActInst, String newActInstId) throws WfException {
        String[] postActListInfo = new String[]{newActInstId};
        SnapshotRecorder recorder = SnapshotRecorder.create();
        recorder.snapshoot((AbstractObjectValue)rollbackActInst.getMeta().getActInstInfo());
        rollbackActInst.getMeta().setPostActInstList(postActListInfo);
        recorder.snapshoot((AbstractObjectValue)rollbackActInst.getMeta().getActInstInfo());
        recorder.recordSnapshots();
        String[] preActInstList = rollbackActInst.getMeta().getPreActInstList();
        if (preActInstList != null) {
            int n = preActInstList.length;
            for (int i = 0; i < n; ++i) {
                WfActivity preActInst = this.getWfEngine().getActivityInst(preActInstList[i]);
                if (preActInst == null) continue;
                String[] postActInstList = preActInst.getMeta().getPostActInstList();
                if (postActInstList != null) {
                    boolean hasId = false;
                    int m = postActInstList.length;
                    for (int j = 0; j < m; ++j) {
                        if (!rollbackActInst.getId().equals(postActInstList[j])) continue;
                        postActInstList[j] = newActInstId;
                        hasId = true;
                        break;
                    }
                    if (!hasId) {
                        postActInstList = StringUtils.stringArrayAppend((String[])postActInstList, (String)newActInstId);
                    }
                }
                SnapshotRecorder recorder2 = SnapshotRecorder.create();
                recorder2.snapshoot((AbstractObjectValue)preActInst.getMeta().getActInstInfo());
                preActInst.getMeta().setToActInstList(preActInst.getMeta().getToActInstList());
                preActInst.getMeta().setPostActInstList(postActListInfo);
                recorder2.snapshoot((AbstractObjectValue)preActInst.getMeta().getActInstInfo());
                recorder2.recordSnapshots();
            }
        }
    }

    String transBackCascade(WfActivity rollbackActInst) throws WfException {
        ActivityInstInfo rollbackActMeta = rollbackActInst.getMeta();
        String tbActInstId = null;
        String[] preActInstList = rollbackActMeta.getPreActInstList();
        for (int i = 0; i < preActInstList.length; ++i) {
            WfActivity preAct = this.getActInstByInstId(preActInstList[i]);
            tbActInstId = this.transBack(preAct);
        }
        return tbActInstId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transNext(String eventId, WfActivity fromActInst) throws WfException {
        block46: {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().enter(this.getClass().getName(), "transNext", null);
            }
            try {
                this.getProcessContext().putDataFieldValue("$ThisIsCanSuspend$", "");
                ActivityDef fromActDef = fromActInst.getDefinition();
                ActivityCollection postActDefList = fromActDef.getPostActivities();
                SplitType splitType = fromActDef.getActivityHeader().getSplitType();
                if (splitType.equals((Object)SplitType.AND) && fromActDef instanceof RouterActivityDef && ((RouterActivityDef)fromActDef).isMutexSplit()) {
                    String gouprName = Uuid.create().toString();
                    int len = postActDefList.size();
                    int errorNum = 0;
                    WfException oldex = null;
                    Object flag = null;
                    for (int i = 0; i < len; ++i) {
                        try {
                            if (errorNum == len - 1) {
                                this.getProcessContext().putDataFieldValue("$ThisIsCanSuspend$", postActDefList.get(i).getID());
                            }
                            this.trans(eventId, fromActInst, postActDefList.get(i), gouprName);
                            continue;
                        }
                        catch (WfException ex) {
                            ++errorNum;
                            oldex = ex;
                            continue;
                        }
                        finally {
                            flag = this.getProcessContext().getDataFieldValue("$ThisIsCanSuspend$");
                        }
                    }
                    if (errorNum == len && !"".equals(flag)) {
                        if (oldex != null) {
                            throw oldex;
                        }
                        throw new WfException("trans error!");
                    }
                    this.getProcessContext().putDataFieldValue("$ThisIsCanSuspend$", "");
                    break block46;
                }
                if (splitType.equals((Object)SplitType.AND)) {
                    int len = postActDefList.size();
                    int errorNum = 0;
                    WfException oldex = null;
                    Object flag = null;
                    for (int i = 0; i < len; ++i) {
                        try {
                            if (errorNum == len - 1) {
                                this.getProcessContext().putDataFieldValue("$ThisIsCanSuspend$", postActDefList.get(i).getID());
                            }
                            this.trans(eventId, fromActInst, postActDefList.get(i));
                        }
                        catch (WfException ex) {
                            ++errorNum;
                            oldex = ex;
                        }
                        finally {
                            flag = this.getProcessContext().getDataFieldValue("$ThisIsCanSuspend$");
                        }
                        if (errorNum == len && !"".equals(flag)) {
                            if (oldex != null) {
                                throw oldex;
                            }
                            throw new WfException("trans error!");
                        }
                        this.getProcessContext().putDataFieldValue("$ThisIsCanSuspend$", "");
                    }
                    break block46;
                }
                if (splitType.equals((Object)SplitType.XOR)) {
                    ActivityDef act;
                    List transRef = fromActDef.getActivityHeader().getTransitionRefs();
                    if (transRef.size() == 0) {
                        transRef = fromActDef.getOutgoingTransitions().toList();
                    }
                    if ((act = this.evalXorSplitTransition(transRef)) != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("begine trans." + fromActInst.getId()));
                        }
                        boolean isError = false;
                        Exception oldex = null;
                        Object flag = null;
                        this.getProcessContext().putDataFieldValue("$ThisIsCanSuspend$", act.getID());
                        try {
                            this.trans(eventId, fromActInst, act);
                        }
                        catch (Exception ex) {
                            isError = true;
                            oldex = ex;
                        }
                        flag = this.getProcessContext().getDataFieldValue("$ThisIsCanSuspend$");
                        if (isError && !"".equals(flag)) {
                            if (oldex != null) {
                                if (oldex instanceof WfException) {
                                    throw (WfException)((Object)oldex);
                                }
                                throw new WfException("trans error!", (Throwable)oldex);
                            }
                            throw new WfException("trans error!");
                        }
                        this.getProcessContext().putDataFieldValue("$ThisIsCanSuspend$", "");
                        break block46;
                    }
                    WfException ex = new WfException("WFE_PROCESS_transNext_noTrans", null, null).addArg(fromActInst.getMeta().getActInstInfo().getActDefName());
                    WorkflowUtils.logProcessException(fromActInst.getProcInstId(), fromActInst.getWfEngine(), ex);
                    this.processError(ex.getMessage(), fromActInst);
                    break block46;
                }
                ActivityCollection activities = this.evalOrSplitTransition(fromActDef.getOutgoingTransitions().toList());
                if (activities != null && activities.size() > 0) {
                    String gouprName = null;
                    if (fromActDef instanceof RouterActivityDef && ((RouterActivityDef)fromActDef).isMutexSplit()) {
                        gouprName = Uuid.create().toString();
                    }
                    int len = activities.size();
                    int errorNum = 0;
                    WfException oldex = null;
                    Object flag = null;
                    for (int i = 0; i < len; ++i) {
                        try {
                            if (errorNum == len - 1) {
                                this.getProcessContext().putDataFieldValue("$ThisIsCanSuspend$", activities.get(i).getID());
                            }
                            this.trans(eventId, fromActInst, activities.get(i), gouprName);
                            continue;
                        }
                        catch (WfException ex) {
                            ++errorNum;
                            oldex = ex;
                            continue;
                        }
                        finally {
                            flag = this.getProcessContext().getDataFieldValue("$ThisIsCanSuspend$");
                        }
                    }
                    if (errorNum == len && !"".equals(flag)) {
                        if (oldex != null) {
                            throw oldex;
                        }
                        throw new WfException("trans error!");
                    }
                    this.getProcessContext().putDataFieldValue("$ThisIsCanSuspend$", "");
                } else {
                    WfException ex = new WfException("WFE_PROCESS_transNext_noTrans", null, null).addArg(fromActInst.getDefinition().getName());
                    WorkflowUtils.logProcessException(fromActInst.getProcInstId(), fromActInst.getWfEngine(), ex);
                    this.processError(ex.getMessage(), fromActInst);
                }
            }
            finally {
                if (ProfileConfig.getInstance().logWfEngine) {
                    ThreadProfileContext.getInstance().exit();
                }
            }
        }
    }

    public void trans(String eventId, WfActivity fromActInst, ActivityDef toActDef) throws WfException {
        this.trans(eventId, fromActInst, toActDef, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trans(String eventId, WfActivity fromActInst, ActivityDef toActDef, String toActInstGroup) throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "trans", null);
        }
        try {
            ActivityDef fromActDef = fromActInst.getDefinition();
            if (fromActDef instanceof ManpowerActivityDef || fromActDef instanceof StartActivityDef || fromActDef instanceof TaskServiceReceiveActivityDef) {
                WfTransQueueEntry entry = new WfTransQueueEntry();
                entry.fromActInstId = fromActInst.getId();
                entry.toActDefId = toActDef.getID();
                entry.toActInstGroup = toActInstGroup;
                entry.procInstId = fromActInst.container().getId();
                entry.priority = this.isBackgroud() ? WfPriority.LOWER : WfPriority.getEnum((int)toActDef.getActivityHeader().getpriority());
                throw new UnsupportedOperationException("\u8bf7\u6539\u7528\u6d41\u7a0b\u865a\u62df\u673a\u8c03\u5ea6\u673a\u5236\uff01");
            }
            this.transInternal(fromActInst, toActDef, toActInstGroup);
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private boolean isBackgroud() {
        return ProcessType.BACKGROUNDJOB.equals((Object)this.getDefinition().getType());
    }

    public void transWithoutVerify(WfActivity fromActInst, ActivityDef toActDef) throws WfException {
        if (fromActInst == null) {
            throw new IllegalArgumentException("fromActInst is null");
        }
        if (toActDef == null) {
            throw new IllegalArgumentException("toActDef is null");
        }
        if (!this.state().startsWith(WfState.RUNNING.getValue())) {
            throw new WfException("Fatal Error.WfProcess not running. WfProcess id :" + this.getId());
        }
        String[] transPath = new String[]{fromActInst.getId()};
        String toActInstId = this.createActivityInst(toActDef, transPath, transPath, false, null, null, null);
        WfActivity toActInst = this.getWfEngine().getActivityInst(toActInstId);
        this.setFromActInstPostInfo(transPath, toActInst);
        toActInst.init(fromActInst.getId());
        if (toActDef.getActivityHeader().getStartMode().equals((Object)AutomationMode.AUTOMATIC) && !(toActDef instanceof ManpowerActivityDef)) {
            toActInst.activate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String transInternal(WfActivity fromActInst, ActivityDef toActDef, String groupName) throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "transInternal", null);
        }
        try {
            RouterActivityDef toRouterActDef;
            if (fromActInst == null) {
                throw new IllegalArgumentException("fromActInst is null");
            }
            if (toActDef == null) {
                throw new IllegalArgumentException("toActDef is null");
            }
            if (!this.state().startsWith(WfState.RUNNING.getValue())) {
                throw new WfException("Fatal Error.WfProcess not running. WfProcess id :" + this.getId() + " State: " + this.state());
            }
            long time = System.currentTimeMillis();
            ActivityDef fromActDef = fromActInst.getDefinition();
            boolean flag = false;
            for (TransitionDef transDef : fromActDef.getOutgoingTransitions()) {
                if (!transDef.getTo().getID().equals(toActDef.getID())) continue;
                flag = true;
                break;
            }
            if (!flag) {
                throw new WfException("can not trans.toActDefId:" + toActDef.getID() + " fromActDef:" + fromActDef.getID() + " fromActInst:" + fromActInst.getId());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("transInternal getOutgoingTrans cost: " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
            ProcessStorer procStorer = this.getWfEngine().getStoreManager().getProcessStorer();
            String[] transPath = null;
            JoinType joinType = toActDef.getActivityHeader().getJoinType();
            if (joinType.equals((Object)JoinType.AND) && toActDef.inDegree() > 1) {
                RouterActivityDef toRouterActDef2;
                TransBoxInfo transBox;
                try {
                    transBox = procStorer.getTransBox(this.getId(), toActDef.getID());
                }
                catch (SQLException ex) {
                    throw new WfException("can not get trans box.", (Throwable)ex);
                }
                catch (DataAccessException e) {
                    throw new WfException("DataAccessException", (Throwable)e);
                }
                if (transBox == null) {
                    String[] transRecordItem = new String[]{fromActInst.getId()};
                    transBox = new TransBoxInfo();
                    transBox.setProcInstId(this.getId());
                    transBox.setToActDefId(toActDef.getID());
                    transBox.setTransCount(1);
                    transBox.setTransRecord(transRecordItem);
                    try {
                        procStorer.createTransBox(transBox.getMeta());
                    }
                    catch (SQLException ex) {
                        throw new WfException("can not create trans box.", (Throwable)ex);
                    }
                    catch (DataAccessException e) {
                        throw new WfException("DataAccessException", (Throwable)e);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("transInternal createTransBox cost: " + (System.currentTimeMillis() - time)));
                        time = System.currentTimeMillis();
                    }
                    String e = null;
                    return e;
                }
                if (toActDef.inDegree() != transBox.getTransCount() + 1) {
                    String[] transRecord = StringUtils.stringArrayAppend((String[])transBox.getTransRecord(), (String)fromActInst.getId());
                    transBox.setTransCount(transBox.getTransCount() + 1);
                    transBox.setTransRecord(transRecord);
                    try {
                        procStorer.setTransBox(transBox);
                    }
                    catch (SQLException ex) {
                        throw new WfException("can not set trans box.", (Throwable)ex);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("transInternal setTransBox cost: " + (System.currentTimeMillis() - time)));
                        time = System.currentTimeMillis();
                    }
                    String string = null;
                    return string;
                }
                transPath = StringUtils.stringArrayAppend((String[])transBox.getTransRecord(), (String)fromActInst.getId());
                try {
                    procStorer.deleteTransBox(this.getId(), toActDef.getID());
                }
                catch (SQLException ex) {
                    throw new WfException("can not clear trans box.", (Throwable)ex);
                }
                catch (DataAccessException e) {
                    throw new WfException("DataAccessException", (Throwable)e);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("transInternal deleteTransBox cost: " + (System.currentTimeMillis() - time)));
                    time = System.currentTimeMillis();
                }
                if (toActDef instanceof RouterActivityDef && ((RouterActivityDef)toActDef).isSync() && (toRouterActDef2 = (RouterActivityDef)toActDef).getSyncCondition() != null && toRouterActDef2.getSyncCondition().getXpressionList() != null && !this.evalCondition(toRouterActDef2.getSyncCondition().getXpressionList())) {
                    String string = null;
                    return string;
                }
            } else if (joinType.equals((Object)JoinType.OR)) {
                if (toActDef instanceof RouterActivityDef && ((RouterActivityDef)toActDef).isSync()) {
                    toRouterActDef = (RouterActivityDef)toActDef;
                    if (toRouterActDef.getSyncCondition() != null && toRouterActDef.getSyncCondition().getXpressionList() != null && !this.evalCondition(toRouterActDef.getSyncCondition().getXpressionList())) {
                        String toRouterActDef2 = null;
                        return toRouterActDef2;
                    }
                } else {
                    ActivityCollection preActs = toActDef.getPreviousActivities();
                    if (preActs == null) {
                        throw new WfException("No preActivity!");
                    }
                    for (int i = 0; i < preActs.size(); ++i) {
                        if (!this.isActivityInstFlowed(preActs.get(i))) continue;
                        String string = null;
                        return string;
                    }
                }
                transPath = new String[]{fromActInst.getId()};
            } else {
                if (toActDef instanceof RouterActivityDef && ((RouterActivityDef)toActDef).isSync() && (toRouterActDef = (RouterActivityDef)toActDef).getSyncCondition() != null && toRouterActDef.getSyncCondition().getXpressionList() != null && !this.evalCondition(toRouterActDef.getSyncCondition().getXpressionList())) {
                    String i = null;
                    return i;
                }
                transPath = StringUtils.stringArrayAppend(transPath, (String)fromActInst.getId());
            }
            String toActInstId = this.createActivityInst(toActDef, transPath, transPath, false, groupName, null, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("transInternal xor createAct cost: " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
            WfActivity toActInst = this.getWfEngine().getActivityInst(toActInstId);
            this.setFromActInstPostInfo(transPath, toActInst);
            if (log.isDebugEnabled()) {
                log.debug((Object)("transInternal xor setFromActPostInfo cost: " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
            toActInst.init(fromActInst.getId());
            if (toActInst.state().startsWith("open.not_running.blocked") || toActInst.state().startsWith("open.not_running.suspended")) {
                throw new WfException("Activity init error!");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("transInternal xor toAct.init cost: " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
            if (toActDef.getActivityHeader().getStartMode().equals((Object)AutomationMode.AUTOMATIC) && !(toActDef instanceof ManpowerActivityDef)) {
                toActInst.activate();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("transInternal xor act.activate cost: " + (System.currentTimeMillis() - time) + " actId:" + toActInst.getId()));
                time = System.currentTimeMillis();
            }
            String string = toActInstId;
            return string;
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    WfActivity[] getActInstArrayByDef(ActivityDef actDef) throws WfException {
        ArrayList<WfActivity> actInstList = new ArrayList<WfActivity>();
        for (WfActivity actInst : this.activities()) {
            ActivityDef actInstDef = actInst.getDefinition();
            if (!actDef.getID().equals(actInstDef.getID())) continue;
            actInstList.add(actInst);
        }
        WfActivity[] actInstArray = new WfActivity[actInstList.size()];
        actInstList.toArray(actInstArray);
        return actInstArray;
    }

    public boolean isActivityInstFlowed(ActivityDef actDef) {
        WfActivity[] actInsts = null;
        try {
            actInsts = this.getActInstArrayByDef(actDef);
        }
        catch (WfException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        if (actInsts != null) {
            for (int i = 0; i < actInsts.length; ++i) {
                if (!actInsts[i].state().startsWith("close")) continue;
                return true;
            }
        }
        return false;
    }

    public WfActivity getActInstByDefId(String actDefId) throws WfException {
        WfActivity rtnValue = null;
        for (WfActivity actInst : this.activities()) {
            ActivityDef actInstDef = actInst.getDefinition();
            if (!actDefId.equals(actInstDef.getID())) continue;
            if (rtnValue == null) {
                rtnValue = actInst;
                continue;
            }
            if (!rtnValue.getMeta().getCreatedTime().before(actInst.getMeta().getCreatedTime())) continue;
            rtnValue = actInst;
        }
        return rtnValue;
    }

    WfActivity[] getActInstsOrderByCreateTime(String actDefId) throws WfException {
        List list = this.activities();
        ArrayList<WfActivity> matchedActivities = new ArrayList<WfActivity>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            WfActivity wfActivity = (WfActivity)list.get(i);
            ActivityDef actInstDef = wfActivity.getDefinition();
            if (!actDefId.equals(actInstDef.getID())) continue;
            matchedActivities.add(wfActivity);
        }
        Collections.sort(matchedActivities, new Comparator(){

            public int compare(Object o1, Object o2) {
                WfActivity activity1 = (WfActivity)o1;
                WfActivity activity2 = (WfActivity)o2;
                boolean flag = activity1.getMeta().getCreatedTime().before(activity2.getMeta().getCreatedTime());
                return flag ? 1 : 0;
            }
        });
        return matchedActivities.toArray(new WfActivity[matchedActivities.size()]);
    }

    WfActivity getActInstByInstId(String actInstId) throws WfException {
        WfActivity actInst = null;
        for (WfActivity act : this.activities()) {
            if (!act.getId().equals(actInstId)) continue;
            return act;
        }
        return actInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFromActInstPostInfo(String[] fromActList, WfActivity toActInst) throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "setFromActInstPostInfo", null);
        }
        try {
            String postItemInfo = toActInst.getId();
            if (fromActList.length < 1) {
                throw new WfException("ERROR");
            }
            for (int i = 0; i < fromActList.length; ++i) {
                String[] newToInfo;
                String[] newPostInfo;
                ActivityInstInfo fromActInstMeta = this.getWfEngine().getActivityInst(fromActList[0]).getMeta();
                if (fromActInstMeta == null) {
                    throw new WfException("activity instance null");
                }
                String fromActInstId = fromActList[0];
                String[] originalPostInfo = fromActInstMeta.getPostActInstList();
                String[] originalToInfo = fromActInstMeta.getToActInstList();
                if (originalPostInfo == null || originalPostInfo.length == 0) {
                    newPostInfo = new String[]{postItemInfo};
                    newToInfo = new String[]{postItemInfo};
                } else {
                    newPostInfo = StringUtils.stringArrayAppend((String[])originalPostInfo, (String)postItemInfo);
                    newToInfo = StringUtils.stringArrayAppend((String[])originalToInfo, (String)postItemInfo);
                }
                WfActivity fromActInst = this.getWfEngine().getActivityInst(fromActInstId);
                SnapshotRecorder recorder = SnapshotRecorder.create();
                recorder.snapshoot((AbstractObjectValue)fromActInst.getMeta().getActInstInfo());
                fromActInst.getMeta().setToActInstList(newToInfo);
                fromActInst.getMeta().setPostActInstList(newPostInfo);
                recorder.snapshoot((AbstractObjectValue)fromActInst.getMeta().getActInstInfo());
                recorder.recordSnapshots();
                while (fromActInstMeta.isRedo()) {
                    String[] redoActInstItemArray = fromActInstMeta.getFromActInstList();
                    if (redoActInstItemArray.length != 1) {
                        throw new WfException("FATAL ERROR");
                    }
                    fromActInst = this.getWfEngine().getActivityInst(redoActInstItemArray[0]);
                    if (fromActInst == null) {
                        throw new WfException("FATAL ERROR");
                    }
                    fromActInstId = fromActInst.getId();
                    newToInfo = fromActInstMeta.getToActInstList();
                    SnapshotRecorder recorder2 = SnapshotRecorder.create();
                    recorder2.snapshoot((AbstractObjectValue)fromActInst.getMeta().getActInstInfo());
                    fromActInst.getMeta().setToActInstList(newToInfo);
                    fromActInst.getMeta().setPostActInstList(newPostInfo);
                    recorder2.snapshoot((AbstractObjectValue)fromActInst.getMeta().getActInstInfo());
                    recorder2.recordSnapshots();
                    fromActInstMeta = this.getWfEngine().getActivityInst(fromActInstId).getMeta();
                }
            }
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    public synchronized boolean start() throws WfException, CannotStartException, AlreadyRunningException {
        String eventId = BOSUuid.create((String)"WFBIZEVT").toString();
        return this.startFromEvent(eventId);
    }

    public synchronized boolean startFromEvent(String eventId) throws WfException, CannotStartException, AlreadyRunningException {
        this.checkExpire();
        if (!this.state().equals("open.not_running.not_started")) {
            throw new CannotStartException("already started.");
        }
        ProcessDef procDef = this.getDefinition();
        StartActivityDef startPointDef = procDef.getStartActivity();
        ActivityCollection postActDefList = startPointDef.getPostActivities();
        if (postActDefList.size() > 1) {
            return false;
        }
        ActivityDef firstActDef = postActDefList.get(0);
        this.startRuntime(procDef, firstActDef, false);
        return true;
    }

    public synchronized void resumeInternal() throws WfException, CannotResumeException, NotSuspendedException {
        if (this.getActivitiesInState(WfState.OPEN).size() == 0) {
            if (this.getProcessContext().getDataFieldValue("suspendActInstID") != null) {
                String actInstId = (String)this.getProcessContext().getDataFieldValue("suspendActInstID");
                WfActivity activity = this.getWfEngine().getActivityInst(actInstId);
                try {
                    this.setState(WfState.RUNNING);
                    String eventId = BOSUuid.create((String)"WFBIZEVT").toString();
                    this.transNext(eventId, activity);
                }
                catch (Exception e) {
                    this.setState(WfState.SUSPENDED);
                    if (e instanceof WfException) {
                        throw (WfException)((Object)e);
                    }
                    throw new WfException((Throwable)e);
                }
            } else {
                List closedActInsts = this.getActivitiesInState(WfState.CLOSED);
                WfActivity lastestActInst = null;
                WfActivity currentActInst2 = null;
                if (closedActInsts != null) {
                    for (WfActivity currentActInst2 : closedActInsts) {
                        if (lastestActInst != null && lastestActInst.getMeta().getCompleteTime() != null && (currentActInst2.getMeta().getCompleteTime() == null || !currentActInst2.getMeta().getCompleteTime().after(lastestActInst.getMeta().getCompleteTime()))) continue;
                        lastestActInst = currentActInst2;
                    }
                }
                if (lastestActInst != null) {
                    try {
                        this.setState(WfState.RUNNING);
                        String eventId = BOSUuid.create((String)"WFBIZEVT").toString();
                        this.transNext(eventId, lastestActInst);
                    }
                    catch (Exception e) {
                        this.setState(WfState.SUSPENDED);
                        if (e instanceof WfException) {
                            throw (WfException)((Object)e);
                        }
                        throw new WfException((Throwable)e);
                    }
                } else {
                    throw new CannotResumeException();
                }
            }
        }
        for (WfActivity activity : this.getActivitiesInState(WfState.BLOCKED)) {
            activity.resumeInternal();
        }
        for (WfActivity activity : this.getActivitiesInState(WfState.SUSPENDED)) {
            activity.resumeInternal();
        }
        this.setState(WfState.RUNNING);
    }

    public synchronized void resume() throws WfException, CannotResumeException, NotSuspendedException {
        if (this.getProcessContext().isPvmMode()) {
            Context ctx = this.getContext();
            FlowResume.enqueue(ctx, this.getId(), null);
            return;
        }
        if (!this.state().equals("open.not_running.suspended")) {
            throw new NotSuspendedException();
        }
        this.resumeInternal();
        this.getWfEngine().eventService().raiseProcessEvent(ProcessEvent.OnProcessResumed, this, null);
        ProcessInstInfo procInstMeta = this.getData();
        if (procInstMeta.getParentActInstId() != null) {
            String parentActInstId = procInstMeta.getParentActInstId();
            WfActivity parentActInst = this.getWfEngine().getActivityInst(parentActInstId);
            if (parentActInst == null) {
                throw new WfException("Fatal Error.");
            }
            SubflowActivityDef subflowDef = (SubflowActivityDef)parentActInst.getDefinition();
            if (subflowDef.getSynchrMode().equals((Object)ExecutionMode.SYNCHR)) {
                if (!parentActInst.state().equals("open.not_running.suspended")) {
                    throw new WfException("Fatal Error.");
                }
                parentActInst.resume();
            }
        }
    }

    public synchronized void suspend(String message) throws WfException, CannotSuspendException, NotRunningException, AlreadySuspendedException {
        if (this.getProcessContext().isPvmMode()) {
            FlowSuspend.enqueue(this.getContext(), this.getId(), null);
            return;
        }
        if (this.state().startsWith(WfState.SUSPENDED.getValue())) {
            throw new AlreadySuspendedException();
        }
        if (!this.state().equals("open.running")) {
            throw new NotRunningException();
        }
        for (WfActivity activity : this.getActivitiesInState(WfState.NOT_STARTED)) {
            activity.suspendInternal();
        }
        for (WfActivity activity : this.getActivitiesInState(WfState.RUNNING)) {
            activity.suspendInternal();
        }
        this.setState(WfState.SUSPENDED);
        try {
            WfLogger wfLogger = this.getWfEngine().getWfLogger();
            wfLogger.addWfProcessInstLog(LogTypeEnum.WARN, ProcessInstEventEnum.SUSPEND, this.getId(), message);
        }
        catch (Throwable e) {
            log.warn((Object)"addProcInstLog", e);
        }
        ProcessInstInfo procInstMeta = this.getData();
        if (procInstMeta.getParentActInstId() != null) {
            String parentActInstId = procInstMeta.getParentActInstId();
            WfActivity parentActInst = this.getWfEngine().getActivityInst(parentActInstId);
            if (parentActInst == null) {
                throw new WfException("Fatal Error.");
            }
            SubflowActivityDef subflowDef = (SubflowActivityDef)parentActInst.getDefinition();
            if (subflowDef.getSynchrMode().equals((Object)ExecutionMode.SYNCHR)) {
                if (!parentActInst.state().equals("open.running")) {
                    throw new WfException("Fatal Error.");
                }
                parentActInst.suspend("subprocess instance suspended.");
            }
        }
        this.createEvent(WfEventType.PROCESS_SUSPENDED);
    }

    synchronized void setState(WfState state) throws WfException {
        if (WfState.COMPLETED.equals((Object)state)) {
            this.getWfEngine().increaseCompleteProcessInstCount();
        }
        LowTimer lowTimer = new LowTimer();
        SnapshotRecorder recorder = SnapshotRecorder.create();
        recorder.snapshoot((AbstractObjectValue)this.meta.getMeta());
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        this.meta.getMeta().setLastStateTime(ts);
        this.meta.getMeta().setState(state);
        recorder.snapshoot((AbstractObjectValue)this.meta.getMeta());
        recorder.recordSnapshots();
        this.raiseEvent(state);
        if (log.isDebugEnabled()) {
            log.debug((Object)("WfProcess.setState() cost:" + lowTimer.msValue()));
        }
        try {
            String[] billIds = this.getBizObjIds();
            if (billIds != null && billIds.length > 0) {
                String billId = this.getBizObjIds()[0];
                if (billId == null) {
                    throw new Exception("wfProcess\u7b2c\u4e09\u65b9\u6d88\u606f\u63a8\u9001\u83b7\u53d6\u5355\u636eid\u5931\u8d25");
                }
                WfMsgToOtherSys.pushProcInst4OtherSys(this.getContext(), this.meta, billId, this.getOrgIdByHoldedBizObjId(billId), state);
            } else {
                log.error((Object)"wfProcess\u7b2c\u4e09\u65b9\u6d88\u606f\u63a8\u9001\u83b7\u53d6\u5355\u636eid\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error((Object)("WfProcess\u4e2d\u6d41\u7a0b\u5b9e\u4f8b\u72b6\u6001\u6539\u53d8\u65f6  \u7b2c\u4e09\u65b9\u6d88\u606f\u63a8\u9001\u5931\u8d25  \u5177\u4f53\u9519\u8bef:\u6d41\u7a0b\u5b9e\u4f8bid " + this.meta.getProcInstId()), (Throwable)e);
        }
    }

    public synchronized boolean isClosed() {
        return this.state().startsWith(WfState.CLOSED.getValue());
    }

    public synchronized void terminate() throws WfException, CannotStopException, NotRunningException {
        if (this.getProcessContext().isPvmMode()) {
            FlowAbort.enqueue(this.getContext(), this.getId(), null);
            return;
        }
        if (this.isClosed()) {
            throw new NotRunningException("connot abort process , because already closed!");
        }
        this.abortUncompleteActivities();
        this.setState(WfState.TERMINATED);
        ProcessInstInfo procInstMeta = this.getData();
        if (procInstMeta.getParentActInstId() != null) {
            String parentActInstId = procInstMeta.getParentActInstId();
            WfActivity parentActInst = this.getWfEngine().getActivityInst(parentActInstId);
            if (parentActInst == null) {
                throw new WfException("Fatal Error.");
            }
            SubflowActivityDef subflowDef = (SubflowActivityDef)parentActInst.getDefinition();
            if (subflowDef.getSynchrMode().equals((Object)ExecutionMode.SYNCHR)) {
                if (!parentActInst.state().equals("open.running")) {
                    throw new WfException("Fatal Error.");
                }
                parentActInst.terminateInternal();
            }
        }
        try {
            ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
            storer.removeProcessBizObj(this.getId());
        }
        catch (SQLException e) {
            log.warn((Object)"can not remove bizObjList", (Throwable)e);
            throw new WfException("can not remove bizObjList", (Throwable)e);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    void terminateInternal() throws WfException {
        try {
            WfLogger wfLogger = this.getWfEngine().getWfLogger();
            wfLogger.addWfProcessInstLog(LogTypeEnum.ERROR, ProcessInstEventEnum.SUSPEND, this.getId(), "Process terminate.ProcInstId:" + this.getId());
        }
        catch (Throwable e) {
            log.warn((Object)"addProcInstLog", e);
        }
        this.setState(WfState.TERMINATED);
        List actInsts = this.activities();
        for (int i = 0; i < actInsts.size(); ++i) {
            WfActivity activity = (WfActivity)actInsts.get(i);
            activity.terminateInternal();
        }
        try {
            ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
            storer.removeProcessBizObj(this.getId());
        }
        catch (SQLException e) {
            log.warn((Object)"can not remove bizObjList", (Throwable)e);
            throw new WfException("can not remove bizObjList", (Throwable)e);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    public synchronized void abort(String message) throws WfException, CannotStopException, NotRunningException {
        if (this.getProcessContext().isPvmMode()) {
            FlowContext runtime = this.getProcessContext().loadFlowContext();
            Util.setAborted(runtime);
            this.getProcessContext().setFlowContext(runtime);
            FlowAbort.enqueue(this.getContext(), this.getId(), null);
            return;
        }
        if (!StringUtils.isEmpty((String)message)) {
            try {
                WfLogger wfLogger = this.getWfEngine().getWfLogger();
                wfLogger.addWfProcessInstLog(LogTypeEnum.WARN, ProcessInstEventEnum.ABORT, this.getId(), message);
            }
            catch (Throwable e) {
                log.warn((Object)"addProcInstLog", e);
            }
        }
        if (this.state().startsWith(WfState.CLOSED.getValue())) {
            throw new NotRunningException("connot abort process , because already closed!");
        }
        this.abortUncompleteActivities();
        this.setState(WfState.ABORTED);
        ProcessInstInfo procInstMeta = this.getData();
        if (procInstMeta.getParentActInstId() != null) {
            String parentActInstId = procInstMeta.getParentActInstId();
            WfActivity parentActInst = this.getWfEngine().getActivityInst(parentActInstId);
            if (parentActInst == null) {
                throw new WfException("Fatal Error.");
            }
            SubflowActivityDef subflowDef = (SubflowActivityDef)parentActInst.getDefinition();
            if (subflowDef.getSynchrMode().equals((Object)ExecutionMode.SYNCHR)) {
                parentActInst.abortInternal();
            }
        }
        ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
        try {
            storer.removeProcessBizObj(this.getId());
        }
        catch (SQLException e) {
            log.error((Object)"can not remove bizObjList", (Throwable)e);
            throw new WfException("can not remove bizObjList", (Throwable)e);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    public List getActivitiesInState(WfState state) throws WfException, InvalidStateException {
        return this.getActivitiesInState(state.getValue());
    }

    public List getActivitiesInState(String state) throws WfException, InvalidStateException {
        Iterator iterator = this.activities().iterator();
        ArrayList<WfActivity> arrayList = new ArrayList<WfActivity>();
        while (iterator.hasNext()) {
            WfActivity actInt = (WfActivity)iterator.next();
            if (!actInt.state().startsWith(state)) continue;
            arrayList.add(actInt);
        }
        return arrayList;
    }

    public String state() {
        return this.meta.getState();
    }

    public ProcessInstInfo getProcessMeta() {
        return this.meta;
    }

    public void setProcessMeta(ProcessInstInfo meta) {
        this.meta = meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void holdBizObj(Map boIdOrgIdMap) throws WfException {
        LowTimer lowTimer = new LowTimer();
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "holdBizObj", null);
        }
        try {
            HashMap<String, String> holdBOOrgMap = new HashMap<String, String>();
            if (boIdOrgIdMap == null || boIdOrgIdMap.size() == 0) {
                return;
            }
            for (Map.Entry entry : boIdOrgIdMap.entrySet()) {
                String boID = entry.getKey().toString();
                boolean ignore = false;
                try {
                    String bosType = BOSUuid.read((String)boID).getType().toString();
                    ignore = bosType.equals("63D30103") || bosType.equals("C7CEA331");
                }
                catch (Throwable bosType) {
                    // empty catch block
                }
                if (!ignore) {
                    this.addToBizObjIds(boID);
                }
                String orgID = "";
                if (entry.getValue() != null) {
                    String string = orgID = this.isBOSUuid(entry.getValue()) ? entry.getValue().toString() : "";
                }
                if (this.getBizObjOrgMap().containsKey(boID)) continue;
                this.getBizObjOrgMap().put(boID, orgID);
                holdBOOrgMap.put(boID, orgID);
            }
            if (holdBOOrgMap.size() > 0) {
                this.holdBizObjIntalnternal(this.getId(), holdBOOrgMap);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("WfProcess.holdBizObj() cost:" + lowTimer.msValue()));
            }
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private boolean isBOSUuid(Object object) {
        assert (object != null);
        if (object instanceof BOSUuid) {
            return true;
        }
        return BOSUuid.isValid((String)object.toString(), (boolean)false);
    }

    private void holdBizObjIntalnternal(String procInstId, Map bizObjIds) throws WfException {
        try {
            this.getWfEngine().getStoreManager().getProcessStorer().addProcessBizObj(procInstId, bizObjIds);
        }
        catch (SQLException e) {
            log.warn((Object)"can not hold bizObj", (Throwable)e);
            throw new WfException("can not hold bizObj", (Throwable)e);
        }
        catch (DataAccessException e) {
            log.warn((Object)"can not hold bizObj", (Throwable)e);
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    void removeProcessBizObj(String subflowActinstID) throws DataAccessException, SQLException {
        if (this.ansySubflowSet == null) {
            this.ansySubflowSet = new HashSet();
        }
        if (this.ansySubflowSet.contains(subflowActinstID)) {
            this.ansySubflowSet.remove(subflowActinstID);
            if (this.ansySubflowSet.size() == 0) {
                this.getWfEngine().getStoreManager().getProcessStorer().removeProcessBizObj(this.getId());
            }
        }
    }

    void removeProcessBizObj() throws WfException {
        ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
        try {
            boolean hasAnsySubflow = false;
            List actInsts = this.activities();
            int n = actInsts.size();
            for (int i = 0; i < n; ++i) {
                WfActivity activity = (WfActivity)actInsts.get(i);
                ActivityDef actDef = activity.getDefinition();
                if (!(actDef instanceof SubflowActivityDef) || !((SubflowActivityDef)actDef).getExecution().equals((Object)ExecutionMode.ASYNCHR) || activity.getSubProcessInstance() == null) continue;
                hasAnsySubflow = true;
                if (this.ansySubflowSet == null) {
                    this.ansySubflowSet = new HashSet();
                } else {
                    this.ansySubflowSet.clear();
                }
                this.ansySubflowSet.add(activity.getId());
            }
            if (!hasAnsySubflow) {
                storer.removeProcessBizObj(this.getId());
            }
        }
        catch (SQLException e) {
            log.warn((Object)"can not remove bizObjList", (Throwable)e);
            throw new WfException("can not remove bizObjList", (Throwable)e);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    void deleteProcessRecord() throws WfException {
        ProcessStorer storer = this.getWfEngine().getStoreManager().getProcessStorer();
        try {
            String[] ids = this.getBizObjIds();
            storer.addDeleteProcessRecord(this.getId(), ids);
        }
        catch (Exception e) {
            log.warn((Object)"WfProcess deleteProcessRecord error! ", (Throwable)e);
        }
    }

    void complete(String eventId) throws WfException {
        ProcessInstInfo procInstMeta;
        long time = System.currentTimeMillis();
        this.setState(WfState.COMPLETED);
        if (log.isDebugEnabled()) {
            log.debug((Object)("WfProcess.complete setState cost: " + (System.currentTimeMillis() - time)));
            time = System.currentTimeMillis();
        }
        this.removeProcessBizObj();
        this.deleteProcessRecord();
        if (log.isDebugEnabled()) {
            log.debug((Object)("WfProcess.complete removeProcessBizObj cost: " + (System.currentTimeMillis() - time)));
            time = System.currentTimeMillis();
        }
        if ((procInstMeta = this.getData()).getParentActInstId() != null) {
            String parentActInstId = procInstMeta.getParentActInstId();
            WfActivity parentActInst = this.getWfEngine().getActivityInst(parentActInstId);
            if (parentActInst == null) {
                throw new WfException("Fatal Error.");
            }
            SubflowActivityDef subflowDef = (SubflowActivityDef)parentActInst.getDefinition();
            this.outputSubflowData(parentActInst, subflowDef);
            if (subflowDef.getSynchrMode().equals((Object)ExecutionMode.SYNCHR)) {
                if (!parentActInst.state().equals("open.running")) {
                    throw new WfException("Fatal Error.");
                }
                parentActInst.completeInternal(eventId);
            } else if (subflowDef.getSynchrMode().equals((Object)ExecutionMode.ASYNCHR)) {
                try {
                    this.getWfEngine().getProcessInst(parentActInst.getMeta().getProcInstId()).removeProcessBizObj(parentActInst.getId());
                }
                catch (SQLException e) {
                    log.warn((Object)("remove holded bizObj error. procInstId : " + this.getId()), (Throwable)e);
                    throw new WfException("remove holded bizObj error. procInstId : " + this.getId(), (Throwable)e);
                }
                catch (DataAccessException e) {
                    throw new WfException("DataAccessException", (Throwable)e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("WfProcess.complete parent cost: " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
        }
        this.abortUncompleteActivities();
        if (log.isDebugEnabled()) {
            log.debug((Object)("WfProcess.complete abortInternal cost: " + (System.currentTimeMillis() - time)));
            time = System.currentTimeMillis();
        }
        this.createEvent(WfEventType.PROCESS_COMPLETED);
        this.setCompleteTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("WfProcess.complete setProcInstCompleteTime cost: " + (System.currentTimeMillis() - time)));
            time = System.currentTimeMillis();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("WfProcess.complete clearTempInstData cost: " + (System.currentTimeMillis() - time)));
            time = System.currentTimeMillis();
        }
        this.deleteBackgroundJob();
        if (log.isDebugEnabled()) {
            log.debug((Object)("WfProcess.complete deleteProcessInst cost: " + (System.currentTimeMillis() - time)));
            time = System.currentTimeMillis();
        }
    }

    private void setCompleteTime() {
        SnapshotRecorder recorder = SnapshotRecorder.create();
        recorder.snapshoot((AbstractObjectValue)this.meta.getMeta());
        Timestamp completeTime = new Timestamp(System.currentTimeMillis());
        this.meta.setCompleteTime(completeTime);
        recorder.snapshoot((AbstractObjectValue)this.meta.getMeta());
        recorder.recordSnapshots();
    }

    int setTimestamp() {
        Random rand;
        SnapshotRecorder recorder = SnapshotRecorder.create();
        recorder.snapshoot((AbstractObjectValue)this.meta.getMeta());
        try {
            rand = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            rand = new Random();
        }
        int timestamp = rand.nextInt();
        this.meta.setLimit(timestamp);
        recorder.snapshoot((AbstractObjectValue)this.meta.getMeta());
        recorder.recordSnapshots();
        return timestamp;
    }

    private void deleteBackgroundJob() throws WfException {
        ProcessType processType = this.getDefinition().getType();
        if (processType.equals((Object)ProcessType.BACKGROUNDJOB) && EngineConfig.getInstance().deleteJobProcessWhenClosed()) {
            WfEngine engine = this.getWfEngine();
            try {
                engine.getStoreManager().getProcessStorer().deleteProcessInst(this.getId());
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
        }
    }

    public synchronized String createActivityInst(String actDefId, String[] fromActInstList, String[] preActInstList, boolean isRedo) throws WfException {
        ProcessDef procDef = this.getDefinition();
        ActivityDef actDef = procDef.getActivityDef(actDefId);
        return this.createActivityInst(actDef, fromActInstList, preActInstList, isRedo, null, null, null);
    }

    private synchronized String createActivityInst(ActivityDef actDef, String[] fromActInstList, String[] preActInstList, boolean isRedo) throws WfException {
        return this.createActivityInst(actDef, fromActInstList, preActInstList, isRedo, null, null, null);
    }

    private synchronized String createActivityInst(ActivityDef actDef, String[] fromActInstList, String[] preActInstList, boolean isRedo, String perfoermListString) throws WfException {
        return this.createActivityInst(actDef, fromActInstList, preActInstList, isRedo, null, perfoermListString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createActivityInst(ActivityDef actDef, String[] fromActInstList, String[] preActInstList, boolean isRedo, String groupName, String performerList, String parentActInstId) throws WfException {
        LowTimer lowTimer = new LowTimer();
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "createActivityInst", null);
        }
        try {
            if (!this.state().startsWith(WfState.RUNNING.getValue())) {
                throw new WfException("Fatal Error.");
            }
            ActInstInfo actInstInfo = ActivityStorer.buildNewActInstInfo(this.getWfEngine().context(), this, actDef, fromActInstList, preActInstList, isRedo, 0, groupName, performerList, parentActInstId);
            SnapshotRecorder recorder = SnapshotRecorder.create();
            recorder.snapshoot((AbstractObjectValue)actInstInfo);
            recorder.recordSnapshots();
            WfActivity wfActivity = new WfActivity(this.getWfEngine(), new ActivityInstInfo(actInstInfo));
            this.getWfEngine().eventService().raiseActivityEvent(ActivityEvent.OnActivityCreated, wfActivity, null);
            this.getWfEngine().getCacheManager().addActivityInst(wfActivity);
            boolean isActivitiesLoaded = !(actDef instanceof StartActivityDef);
            this.activityIds(isActivitiesLoaded).add(actInstInfo.getActInstID());
            if (log.isDebugEnabled()) {
                log.debug((Object)("WfProcess.createActivityInst() cost:" + lowTimer.msValue()));
            }
            String string = actInstInfo.getActInstID().toString();
            return string;
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    public ProcessInstInfo getData() {
        return this.meta;
    }

    public int getActivityCount() throws WfException {
        return this.activityIds(true).size();
    }

    public boolean hasMyException(ExpressionCollection expressionCollection, String actDefId) throws WfException {
        if (expressionCollection == null || expressionCollection.size() == 0) {
            return false;
        }
        ExpressionDef express = expressionCollection.get(0);
        if (express == null) {
            return false;
        }
        String expressStr = express.toString().trim();
        if (expressStr.length() == 0) {
            return false;
        }
        String key = actDefId + "_exceptionName";
        String exceptionName = (String)this.getProcessContext().getDataFieldValue(key);
        if (exceptionName == null || exceptionName.trim().length() == 0) {
            return false;
        }
        if (expressStr.indexOf(".") > 0) {
            LinkedList<String> l = new LinkedList<String>();
            l.add(exceptionName.toUpperCase());
            try {
                Class<?> clazz = Class.forName(exceptionName);
                do {
                    clazz = clazz.getSuperclass();
                    l.add(clazz.getName().toUpperCase());
                } while (!clazz.equals(Object.class) && !clazz.equals(Exception.class));
            }
            catch (Exception clazz) {
                // empty catch block
            }
            return l.contains(expressStr.toUpperCase());
        }
        LinkedList<String> l = new LinkedList<String>();
        String name = exceptionName.substring(exceptionName.lastIndexOf(".") + 1, exceptionName.length());
        l.add(name.toUpperCase());
        try {
            Class<?> clazz = Class.forName(exceptionName);
            do {
                String exName;
                name = (exName = (clazz = clazz.getSuperclass()).getName()).indexOf(".") > 0 ? exName.substring(exName.lastIndexOf(".") + 1, exName.length()) : exName;
                l.add(name.toUpperCase());
            } while (!clazz.equals(Object.class) && !clazz.equals(Exception.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l.contains(expressStr.toUpperCase());
    }

    public boolean hasDefaultException(String actDefId) throws WfException {
        String key = actDefId + "_exceptionName";
        String exceptionName = (String)this.getProcessContext().getDataFieldValue(key);
        return exceptionName != null && exceptionName.trim().length() > 0;
    }

    private ActivityCollection evalOrSplitTransition(List transRef) throws WfException {
        ConditionDef condition;
        TransitionDef item;
        int i;
        String actDefId = null;
        if (transRef.size() == 0) {
            log.error((Object)("eval OrSplit transition list is null.procId:" + this.getId()));
            try {
                WfLogger wfLogger = this.getWfEngine().getWfLogger();
                wfLogger.addWfProcessInstLog(LogTypeEnum.ERROR, ProcessInstEventEnum.NOPOSTACTIVITY, this.getId(), "eval OrSplit transition list is null.procId:" + this.getId());
            }
            catch (Throwable ex) {
                log.warn((Object)ex.getMessage(), ex);
            }
        } else {
            actDefId = ((TransitionDef)transRef.get(0)).getFrom().getID();
        }
        ActivityCollection activities = new ActivityCollection(null);
        for (i = 0; i < transRef.size(); ++i) {
            item = (TransitionDef)transRef.get(i);
            condition = item.getCondition();
            if (!condition.getConditionType().equals((Object)ConditionType.CONDITION) || !this.evalCondition(condition.getXpressionList())) continue;
            ActivityDef actDef = item.getTo();
            if (actDef == null) {
                log.error((Object)("or getTo error.transId:" + item.getID()));
                this.suspend("or getTo error.transId:" + item.getID());
            }
            activities.add(actDef);
        }
        for (i = 0; i < transRef.size(); ++i) {
            item = (TransitionDef)transRef.get(i);
            condition = item.getCondition();
            if (!condition.getConditionType().equals((Object)ConditionType.EXCEPTION) || !this.hasMyException(condition.getXpressionList(), actDefId)) continue;
            activities.add(item.getTo());
        }
        for (i = 0; i < transRef.size(); ++i) {
            item = (TransitionDef)transRef.get(i);
            condition = item.getCondition();
            if (!condition.getConditionType().equals((Object)ConditionType.DEFAULTEXCEPTION) || !this.hasDefaultException(actDefId)) continue;
            activities.add(item.getTo());
        }
        if (activities.size() == 0) {
            for (i = 0; i < transRef.size(); ++i) {
                item = (TransitionDef)transRef.get(i);
                condition = item.getCondition();
                if (!condition.getConditionType().equals((Object)ConditionType.OTHERWISE)) continue;
                activities.add(item.getTo());
            }
        }
        return activities;
    }

    private ActivityDef evalXorSplitTransition(List transRef) throws WfException {
        ConditionDef condition;
        TransitionDef item;
        int i;
        String actDefId = null;
        if (transRef.size() == 0) {
            log.error((Object)("eval XorSplit transition list is null.procId:" + this.getId()));
            try {
                WfLogger wfLogger = this.getWfEngine().getWfLogger();
                wfLogger.addWfProcessInstLog(LogTypeEnum.ERROR, ProcessInstEventEnum.NOPOSTACTIVITY, this.getId(), "eval XorSplit transition list is null.procId:" + this.getId());
            }
            catch (Throwable ex) {
                log.warn((Object)ex.getMessage(), ex);
            }
        } else {
            actDefId = ((TransitionDef)transRef.get(0)).getFrom().getID();
        }
        if (transRef.size() == 1) {
            ActivityDef actDef = ((TransitionDef)transRef.get(0)).getTo();
            if (actDef == null) {
                log.error((Object)("getTo error.transId:" + ((TransitionDef)transRef.get(0)).getID()));
                try {
                    WfLogger wfLogger = this.getWfEngine().getWfLogger();
                    wfLogger.addWfProcessInstLog(LogTypeEnum.ERROR, ProcessInstEventEnum.SUSPEND, this.getId(), "getTo error.transId:" + ((TransitionDef)transRef.get(0)).getID());
                }
                catch (Throwable ex) {
                    log.warn((Object)ex.getMessage(), ex);
                }
            }
            return actDef;
        }
        for (i = 0; i < transRef.size(); ++i) {
            item = (TransitionDef)transRef.get(i);
            condition = item.getCondition();
            if (!condition.getConditionType().equals((Object)ConditionType.DEFAULTEXCEPTION) || !this.hasDefaultException(actDefId)) continue;
            return item.getTo();
        }
        for (i = 0; i < transRef.size(); ++i) {
            item = (TransitionDef)transRef.get(i);
            condition = item.getCondition();
            if (condition == null || !ConditionType.EXCEPTION.equals((Object)condition.getConditionType()) || !this.hasMyException(condition.getXpressionList(), actDefId)) continue;
            return item.getTo();
        }
        for (i = 0; i < transRef.size(); ++i) {
            item = (TransitionDef)transRef.get(i);
            condition = item.getCondition();
            if (!condition.getConditionType().equals((Object)ConditionType.CONDITION) || !this.evalCondition(condition.getXpressionList())) continue;
            return item.getTo();
        }
        for (i = 0; i < transRef.size(); ++i) {
            item = (TransitionDef)transRef.get(i);
            condition = item.getCondition();
            if (!condition.getConditionType().equals((Object)ConditionType.OTHERWISE)) continue;
            return item.getTo();
        }
        return null;
    }

    private void processError(String errorInfo, WfActivity fromActInst) throws WfException {
        this.getProcessContext().putDataFieldValue("suspendActInstID", fromActInst.getId());
        this.getProcessContext().storeToDb();
        this.suspend("processError, " + errorInfo + ". fromActInstId '" + fromActInst.getId() + "', fromActDefId '" + fromActInst.getDefinition().getID() + "', procDefId '" + fromActInst.container().getDefinition().getID() + "'");
    }

    public void outputSubflowData(WfActivity parentActInst, SubflowActivityDef subflowDef) throws WfException {
        if (parentActInst == null) {
            return;
        }
        this.getProcessContext().adjustBizObject(true, true);
        FormalParameterCollection formalParameters = this.getDefinition().getFormalParameters();
        ActualParameterCollection actualParameters = subflowDef.getActualParameters();
        Map data = this.context.getDataCopy();
        WfProcess parentProcess = parentActInst.container();
        ProcessContext parentProcessContext = parentProcess.getProcessContext();
        for (ActualParameterDef item : actualParameters) {
            if (item.getIndex() >= formalParameters.size()) continue;
            FormalParameterDef formalParameter = null;
            if (StringUtils.isEmpty((String)item.getFormalDefId())) {
                formalParameter = formalParameters.get(item.getIndex());
            } else {
                formalParameter = formalParameters.get(item.getFormalDefId());
                String orginName = formalParameter.getName();
                if (FormalParameterMode.IN.equals((Object)formalParameter.getMode())) {
                    for (int i = 0; i < formalParameters.size(); ++i) {
                        FormalParameterDef formalParameterTemp = formalParameters.get(i);
                        if (!FormalParameterMode.OUT.equals((Object)formalParameterTemp.getMode()) || !orginName.equals(formalParameterTemp.getName())) continue;
                        formalParameter = formalParameterTemp;
                        break;
                    }
                }
            }
            if (formalParameter.getMode().equals((Object)FormalParameterMode.IN) || item == null || item.getDataField() == null) continue;
            parentProcessContext.setDataFieldValue(item.getDataField().getName(), this.getProcessContext().getDataFieldValue(formalParameter.getName()));
        }
        Map nextParticipantPersonData = this.getNextParticipantPersonData(data, parentProcess.getDefinition());
        parentProcessContext.putDataFieldValues(nextParticipantPersonData);
        parentProcessContext.storeToDb();
    }

    private Map getNextParticipantPersonData(Map contextData, ProcessDef parentProcess) {
        HashMap retVal = new HashMap();
        ActivityCollection manpowerActivityDefs = parentProcess.getActivitys(ActivityType.MANPOWER);
        Set contextDataEntrySet = contextData.entrySet();
        for (Map.Entry entry : contextDataEntrySet) {
            Object objKey = entry.getKey();
            if (!(objKey instanceof String)) continue;
            String key = (String)objKey;
            if (!"DesignateNextActivityPerformerWhenSubmit".equals(objKey) && (!key.startsWith("DP_") || !manpowerActivityDefs.containsKey((Object)key.substring("DP_".length())) && !manpowerActivityDefs.containsKey((Object)key.substring(key.indexOf("@") + 1)))) continue;
            retVal.put(key, entry.getValue());
        }
        return retVal;
    }

    public ProcessLock getLock() {
        return this.innerLock;
    }

    public boolean canSuspend() throws WfException, SQLException {
        boolean toolActState = true;
        for (WfActivity actInt : this.getActivitiesInState("open.running")) {
            if (!(actInt.getDefinition() instanceof ToolActivityDef) && !(actInt.getDefinition() instanceof RouterActivityDef)) continue;
            toolActState = false;
            break;
        }
        return this.state().equalsIgnoreCase("open.running") && toolActState;
    }

    private void abortUncompleteActivities() throws WfException {
        List activities = this.getActivitiesInState(WfState.OPEN);
        for (WfActivity activity : activities) {
            activity.abortInternal();
        }
    }

    public synchronized boolean startFromCommonEvent(ICommonEvent event, Person person) throws WfException {
        this.checkExpire();
        if (!this.state().equals("open.not_running.not_started")) {
            throw new CannotStartException("WFE_PROCESS_start_state").addArg(this.getId());
        }
        ProcessDef procDef = this.getDefinition();
        ActivityDef startEventActDef = CommonEventUtils.getActDefByEventActivated(procDef, event);
        CommonEventUtils.outputEventContentToContext(startEventActDef, event, this.getProcessContext());
        this.startRuntime(procDef, startEventActDef, true);
        return true;
    }

    public void initAndActivateEventActivity(WfActivity fromActInst, EventActivityDef toActDef) throws WfException {
        String[] transPath = new String[]{fromActInst.getId()};
        String toActInstId = this.createActivityInst((ActivityDef)toActDef, transPath, transPath, false, null, null, null);
        WfActivity toActInst = this.getWfEngine().getActivityInst(toActInstId);
        toActInst.init(fromActInst.getId());
        toActInst.activate();
    }

    public List getActivities() throws WfException {
        return this.activities();
    }

    public Context getContext() {
        return this.getWfEngine().context();
    }

    public Object getDataField(String name) throws WfException {
        return this.getProcessContext().getDataFieldValue(name);
    }

    public ProcessInstInfo getInstanceInfo() {
        return this.getProcessMeta();
    }

    public String getName() {
        return this.getProcessMeta().getProcDefName(new Locale("l2"));
    }

    private void raiseEvent(WfState state) {
        if (WfState.COMPLETED.equals((Object)state)) {
            this.getWfEngine().eventService().raiseProcessEvent(ProcessEvent.OnProcessComplete, this, null);
        } else if (WfState.SUSPENDED.equals((Object)state)) {
            this.getWfEngine().eventService().raiseProcessEvent(ProcessEvent.OnProcessSuspened, this, null);
        } else if (WfState.TERMINATED.equals((Object)state)) {
            this.getWfEngine().eventService().raiseProcessEvent(ProcessEvent.OnProcessTerminated, this, null);
        } else if (WfState.ABORTED.equals((Object)state)) {
            this.getWfEngine().eventService().raiseProcessEvent(ProcessEvent.OnProcessAborted, this, null);
        }
    }

    private synchronized void addToBizObjIds(String boid) {
        if (this.billIds == null) {
            return;
        }
        if (this.billIds.contains(boid)) {
            return;
        }
        this.billIds.add(boid);
    }

    public synchronized String[] getBizObjIds() throws BOSException {
        if (this.billIds == null) {
            Object o;
            int i;
            this.billIds = new HashSet();
            int[] types = new int[]{12};
            Object[] values = new Object[]{this.getProcessMeta().getProcInstId()};
            String sql = "select distinct frefid from T_WFR_ProcInstRef where fprocInstId= ? and ftype=1 ";
            ArrayList list = SQL.executeQuery((Context)this.getContext(), (String)sql, (int[])types, (Object[])values);
            for (i = 0; i < list.size(); ++i) {
                o = ((Map)list.get(i)).get("frefid");
                if (o == null) continue;
                this.billIds.add(o.toString());
            }
            if (list.size() == 0) {
                sql = "select distinct frefid from T_WFR_ProcInstRefHst where fprocInstId= ? and ftype=1";
                list = SQL.executeQuery((Context)this.getContext(), (String)sql, (int[])types, (Object[])values);
                for (i = 0; i < list.size(); ++i) {
                    o = ((Map)list.get(i)).get("frefid");
                    if (o == null) continue;
                    this.billIds.add(o.toString());
                }
            }
            if (list.size() == 0) {
                sql = "select distinct fbizobjid from t_wfr_assigndetail where fprocInstId= ? ";
                list = SQL.executeQuery((Context)this.getContext(), (String)sql, (int[])types, (Object[])values);
                for (i = 0; i < list.size(); ++i) {
                    o = ((Map)list.get(i)).get("fbizobjid");
                    if (o == null) continue;
                    this.billIds.add(o.toString());
                }
            }
            if (list.size() == 0) {
                sql = "select distinct fbizobjid from t_wfr_assignhst where fprocInstId= ? ";
                list = SQL.executeQuery((Context)this.getContext(), (String)sql, (int[])types, (Object[])values);
                for (i = 0; i < list.size(); ++i) {
                    o = ((Map)list.get(i)).get("fbizobjid");
                    if (o == null) continue;
                    this.billIds.add(o.toString());
                }
            }
        }
        return this.billIds.toArray(new String[this.billIds.size()]);
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeObject((Object)this.getWfEngine().getEngineKey());
        marshaller.writeObject((Object)this.getWfEngine().getInitContext());
        marshaller.writeObject((Object)this.activityIds);
        marshaller.writeObject((Object)this.ansySubflowSet);
        marshaller.writeObject((Object)this.billIds);
        marshaller.writeObject((Object)this.bizObjOrgMap);
        ProcessContext procCtx = null;
        try {
            procCtx = this.getProcessContext();
        }
        catch (WfException e) {
            procCtx = null;
        }
        if (procCtx != null) {
            marshaller.writeObject((Object)procCtx.getProcInstDataInfo());
        } else {
            marshaller.writeObject((Object)procCtx);
        }
        marshaller.writeObject((Object)this.meta);
        this.processMgr.marshal(marshaller);
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        String engineKey = (String)unmarshaller.readObject();
        Context engineContext = (Context)unmarshaller.readObject();
        WfEngine engine = null;
        try {
            engine = WfEngine.getEngine(engineKey, engineContext);
        }
        catch (Exception ex) {
            throw new RuntimeException("Get WfEngine[" + engineKey + "] error! context: " + engineContext);
        }
        this.setWfEngine(engine);
        this.activityIds = (List)unmarshaller.readObject();
        this.ansySubflowSet = (Set)unmarshaller.readObject();
        this.billIds = (HashSet)unmarshaller.readObject();
        this.bizObjOrgMap = (Map)unmarshaller.readObject();
        ProcInstDataInfo procInstDataInfo = (ProcInstDataInfo)unmarshaller.readObject();
        if (procInstDataInfo != null) {
            try {
                this.context = new ProcessContext(engine, this, procInstDataInfo);
            }
            catch (WfException e) {
                throw new RuntimeException("Get ProcessContext error! ");
            }
        } else {
            this.context = null;
        }
        this.meta = (ProcessInstInfo)unmarshaller.readObject();
        this.processMgr = new WfProcessMgr();
        this.processMgr.unmarshal(unmarshaller);
        this.getInnerHashCode(true);
    }

    public List getPersonsByProcessExecutor(String processExecutorType) throws WfException {
        return ParticipantHelper.getPersonsByProcessExecutor(this, processExecutorType);
    }

    public String getInnerHashCode(boolean isRefresh) {
        String hashcode = super.getInnerHashCode();
        if (isRefresh || StringUtils.isEmpty((String)hashcode)) {
            int hc = 0;
            if (this.activityIds != null) {
                hc += this.activityIds.hashCode();
            }
            if (this.ansySubflowSet != null) {
                hc += this.ansySubflowSet.hashCode();
            }
            if (this.billIds != null) {
                hc += this.billIds.hashCode();
            }
            if (this.bizObjOrgMap != null) {
                hc += this.bizObjOrgMap.hashCode();
            }
            if (this.meta != null) {
                hc += this.meta.getInnerHashCode();
            }
            if (this.context != null) {
                hc += this.context.getInnerHashCode();
            }
            hashcode = hc == 0 ? null : String.valueOf(hc);
            this.setInnerHashCode(hashcode);
        }
        return hashcode;
    }
}

