/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.util.md5;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.axis.ProcessWSDDProvider;
import com.kingdee.bos.workflow.axis.WSDDServiceBuilder;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ImportDef;
import com.kingdee.bos.workflow.define.ImportDefCollection;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.TaskServiceReceiveActivityDef;
import com.kingdee.bos.workflow.define.WSOperationDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.ImportTypeEnum;
import com.kingdee.bos.workflow.metas.ProcImportObjCollection;
import com.kingdee.bos.workflow.metas.ProcImportObjInfo;
import com.kingdee.bos.workflow.store.ProcImportObjStorer;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.util.XMLHelper;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDProvider;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.server.AxisServer;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.transform.JDOMSource;
import org.xml.sax.InputSource;

public class WfProcessServiceMgr {
    private static final Logger logger = Logger.getLogger(WfProcessServiceMgr.class);
    private final WfEngine engine;
    private static AxisServer axisServer;

    public WfProcessServiceMgr(WfEngine engine) throws WfException {
        this.engine = engine;
    }

    public static void initServices(AxisServer server) throws WfException {
        axisServer = server;
        QName providerQName = new QName("http://xml.apache.org/axis/wsdd/providers/java", "PROCESS");
        WSDDProvider.registerProvider((QName)providerQName, (WSDDProvider)new ProcessWSDDProvider());
        Set set = WfEngine.getEngineKeySet();
        for (String key : set) {
            WfEngine wfEngine = WfEngine.getEngine(key);
            wfEngine.getProcessServiceMgr().publishAllServices();
        }
    }

    private void publishAllServices() throws WfException {
        ProcImportObjStorer storer = this.engine.getStoreManager().getProcImportObjStorer();
        ProcImportObjCollection collection = storer.getProcImportObjInfos(ImportTypeEnum.WSDL);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            ProcImportObjInfo importObjInfo = collection.get(i);
            String procDefId = importObjInfo.getProcDefId().toString();
            ProcessDefInfo processDefInfo = this.engine.getDefinitionMgr().getProcessDefInfo(procDefId);
            if (!processDefInfo.isEnable()) continue;
            this.deployProcessService(importObjInfo);
        }
    }

    private WSDDDeployment getWSDDDeployment() {
        WSDDEngineConfiguration engineConfiguration = (WSDDEngineConfiguration)axisServer.getConfig();
        return engineConfiguration.getDeployment();
    }

    public WSDDService getWSDDService(QName qname) {
        return this.getWSDDDeployment().getWSDDService(qname);
    }

    private void deployService(WSDDService service) {
        this.getWSDDDeployment().deployService(service);
    }

    private void undeployService(QName qname) {
        this.getWSDDDeployment().undeployService(qname);
    }

    public void publishService(ProcessDef processDef) throws WfException {
        try {
            String procDefId = processDef.getID();
            ProcImportObjStorer storer = this.engine.getStoreManager().getProcImportObjStorer();
            ImportDefCollection collection = processDef.getImports();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                ImportDef importDef = collection.getImportDef(i);
                if (!importDef.isProcessWSDL()) continue;
                ProcImportObjInfo procImportObjInfo = storer.getProcImportObjInfo(procDefId, importDef.getNamespace());
                WSDDService service = this.deployProcessService(procImportObjInfo);
                this.updateProcessDef(processDef, service);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new WfException((Throwable)e);
        }
    }

    private WSDDService deployProcessService(ProcImportObjInfo procImportObjInfo) throws WfException {
        try {
            Document document = XMLHelper.toDocument((String)procImportObjInfo.getContent());
            InputSource inputSource = new JDOMSource(document).getInputSource();
            Definition definition = WSDLFactory.newInstance().newWSDLReader().readWSDL(null, inputSource);
            WSDDServiceBuilder builder = new WSDDServiceBuilder(this.engine.context());
            builder.setProcDefId(procImportObjInfo.getProcDefId().toString());
            builder.setNamspace(procImportObjInfo.getNamespace());
            WSDDService service = builder.build(definition);
            WSDDService deployedService = this.getWSDDService(service.getQName());
            if (deployedService != null) {
                this.undeployService(service.getQName());
            }
            this.deployService(service);
            return service;
        }
        catch (WSDLException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    private void updateProcessDef(ProcessDef processDef, WSDDService service) throws WfException {
        ActivityCollection activities = processDef.getActivitys();
        int size = activities.size();
        for (int i = 0; i < size; ++i) {
            ActivityDef activityDef = activities.get(i);
            if (!(activityDef instanceof TaskServiceReceiveActivityDef)) continue;
            TaskServiceReceiveActivityDef receiveActivityDef = (TaskServiceReceiveActivityDef)activityDef;
            ApplicationDef applicationDef = receiveActivityDef.getRelatedApplication();
            WSOperationDef operationDef = applicationDef.getWSOperationDef();
            operationDef.setServiceName(service.getServiceDesc().getName());
        }
        String oldHashValue = processDef.getHashValue();
        String xml = processDef.toXml();
        md5 md = new md5(xml);
        md.processString();
        String hashValue = md.getStringDigest();
        processDef.setHashValue(hashValue);
        ProcessStorer processStorer = this.engine.getStoreManager().getProcessStorer();
        processStorer.storeDef(processDef, oldHashValue);
    }
}

