/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.app;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ApplicationType;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.util.ScriptUtil;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class AbstractApplicationManager {
    protected static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.app.AbstractApplicationManager");
    public static final String APPLICATION_EXCEPTION_MESSAGE = "_exceptionMessage";
    public static final String APPLICATION_EXCEPTION_NAME = "_exceptionName";
    protected final WfActivity activityInst;

    public AbstractApplicationManager(WfActivity activityInst) {
        this.activityInst = activityInst;
    }

    protected ProcessContext getProcessContext() throws WfException {
        return this.activityInst.container().getProcessContext();
    }

    public abstract void invokeApplication(ApplicationDef var1, ActualParameterCollection var2) throws WfException;

    protected void writeOutputToContext(Object returnObject, ActualParameterCollection actualParameters, FormalParameterCollection formalParms, ApplicationType type) throws WfException {
        Object paramValue;
        ProcessContext processContext = this.getProcessContext();
        HashMap<String, FormalParameterDef> paramDefMap = new HashMap<String, FormalParameterDef>();
        HashMap<String, Object> paramValueMap = new HashMap<String, Object>();
        for (int i = 0; i < formalParms.size(); ++i) {
            FormalParameterDef paramDef = formalParms.get(i);
            if (!paramDef.getMode().equals((Object)FormalParameterMode.OUT) && !paramDef.getMode().equals((Object)FormalParameterMode.INOUT)) continue;
            String boId = paramDef.getBoId();
            paramDefMap.put(paramDef.getID(), paramDef);
            String propertyname = paramDef.getPropertyName();
            paramValue = null;
            if (returnObject instanceof IObjectValue && type.equals((Object)ApplicationType.TOOL)) {
                if (((IObjectValue)returnObject).getBOSType().toString().equals(boId)) {
                    paramValue = ScriptUtil.evalObjectProperty(propertyname, returnObject, processContext.getWfEngine().context());
                }
            } else {
                paramValue = returnObject;
            }
            paramValueMap.put(paramDef.getID(), paramValue);
        }
        for (FormalParameterDef paramDef : paramDefMap.values()) {
            if (paramDef.getIndex() >= actualParameters.size()) continue;
            ActualParameterDef actualParam = actualParameters.get(paramDef.getIndex());
            String dataName = actualParam.getDataField().getName();
            paramValue = paramValueMap.get(paramDef.getID());
            processContext.setDataFieldValue(dataName, paramValue);
        }
        processContext.storeToDb();
    }
}

