/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.async;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.ExternalType;
import com.kingdee.bos.workflow.define.FunctionScriptType;
import com.kingdee.bos.workflow.define.OtherSys;
import com.kingdee.bos.workflow.define.ScriptFunctionParameter;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.transaction.WfTxHelper;
import com.kingdee.bos.workflow.transaction.WfTxInvocationDesc;
import com.kingdee.bos.workflow.util.MethodDesc;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class OtherSysUtil {
    private static Logger logger = Logger.getLogger(OtherSysUtil.class);

    public static String post(String url, Map params, Map<String, String> headers, int connectTimeout, int readTimeout, String charset) throws Exception {
        return OtherSysUtil.invokeUrl(url, params, headers, connectTimeout, readTimeout, charset, HttpMethod.POST);
    }

    private static String invokeUrl(String url, Map params, Map<String, String> headers, int connectTimeout, int readTimeout, String encoding, HttpMethod method) throws Exception {
        StringBuilder paramsStr = null;
        if (params != null) {
            paramsStr = new StringBuilder();
            Set entries = params.entrySet();
            for (Map.Entry entry : entries) {
                String value = entry.getValue() != null ? String.valueOf(entry.getValue()) : "";
                paramsStr.append(entry.getKey() + "=" + value + "&");
            }
            if (method != HttpMethod.POST) {
                url = url + "?" + paramsStr.toString();
            }
        }
        URL uUrl = null;
        HttpURLConnection conn = null;
        BufferedWriter out = null;
        BufferedReader in = null;
        try {
            uUrl = new URL(url);
            conn = (HttpURLConnection)uUrl.openConnection();
            conn.setRequestProperty("content-type", "application/json");
            conn.setRequestMethod(method.toString());
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            if (headers != null && headers.size() > 0) {
                Set<String> headerSet = headers.keySet();
                for (String key : headerSet) {
                    conn.setRequestProperty(key, headers.get(key));
                }
            }
            if (paramsStr != null && method == HttpMethod.POST) {
                out = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), encoding));
                out.write(paramsStr.toString());
                out.flush();
            }
            StringBuilder result = new StringBuilder();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), encoding));
            if (in != null) {
                String line = "";
                while ((line = in.readLine()) != null) {
                    result.append(line);
                }
            }
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            throw new Exception("httpUrl : " + url + "\u5916\u90e8\u670d\u52a1http\u8c03\u7528\u5f02\u5e38, ex : " + e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static OtherSys parse(String content) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes("UTF-8"));
        Document doc = builder.build((InputStream)bais);
        Element rootEl = doc.getRootElement();
        List otherSysInvokers = rootEl.getChildren("otherSysInvoker");
        Element otherSysInvoker = (Element)otherSysInvokers.get(0);
        OtherSys os = OtherSysUtil.xml2OtherSys(otherSysInvoker);
        return os;
    }

    public static OtherSys xml2OtherSys(Element otherSysInvoker) {
        Element param;
        List params2;
        List params;
        String editable;
        OtherSys os = new OtherSys();
        os.setName(otherSysInvoker.getAttributeValue("name"));
        os.setCallMode(otherSysInvoker.getChildText("callMode"));
        os.setAddress(otherSysInvoker.getChildText("address"));
        String desc = otherSysInvoker.getChildText("description");
        os.setDescription(desc == null ? "" : desc);
        String script = otherSysInvoker.getChildText("script");
        os.setScript(script == null ? "" : script.trim());
        os.setApiBaseUrl(otherSysInvoker.getChildText("apibaseurl"));
        os.setAppId(otherSysInvoker.getChildText("appid"));
        os.setAppSecret(otherSysInvoker.getChildText("appsecret"));
        os.setOrgId(otherSysInvoker.getChildText("orgid_value"));
        os.setRobotId(otherSysInvoker.getChildText("robotid_value"));
        os.setMac(otherSysInvoker.getChildText("mac_value"));
        os.setMac_title(otherSysInvoker.getChildText("mac_title"));
        os.setUserId(otherSysInvoker.getChildText("userid"));
        FunctionScriptType sType = FunctionScriptType.getType((String)otherSysInvoker.getChildText("type"));
        if (sType != null) {
            os.setScriptType(sType);
        }
        if ((editable = otherSysInvoker.getChildText("editable")) == null || !editable.equalsIgnoreCase("false")) {
            os.setEditable(true);
        } else {
            os.setEditable(false);
        }
        Element returnEl = otherSysInvoker.getChild("return");
        if (returnEl != null) {
            String type = returnEl.getChildText("type");
            os.setReturnType(OtherSysUtil.parseType(type));
            os.setReturnDesc(returnEl.getChildText("description"));
            os.setArray(Boolean.valueOf(returnEl.getChildText("array")).booleanValue());
        }
        if ((params = otherSysInvoker.getChildren("parameter")).size() == 0 && (params2 = otherSysInvoker.getChildren("parameters")).size() > 0) {
            param = (Element)params2.get(0);
            params = param.getChildren("parameter");
        }
        if (params != null) {
            for (int j = 0; j < params.size(); ++j) {
                param = (Element)params.get(j);
                ScriptFunctionParameter sfParam = new ScriptFunctionParameter();
                sfParam.setName(param.getChildText("name"));
                sfParam.setDescription(param.getChildText("description"));
                sfParam.setType(OtherSysUtil.parseType(param.getChildText("type")));
                sfParam.setArray(Boolean.valueOf(param.getChildText("array")).booleanValue());
                os.getParameters().add(sfParam);
            }
        }
        return os;
    }

    private static DataType parseType(String type) {
        BasicType dataType = null;
        try {
            dataType = BasicType.parse((String)type);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dataType == null) {
            try {
                dataType = ExternalType.parse((String)type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dataType;
    }

    public static Object invokeScriptRequiresNew(Context ctx, String script, WfActivity activity, Map parameters) throws WfException {
        Class<ScriptUtil> classCaller = ScriptUtil.class;
        Object obj = null;
        String methodName = "executeScript";
        Class[] parameterTypes = new Class[]{String.class, WfActivity.class, Map.class};
        Object[] args = new Object[]{script, activity, parameters};
        MethodDesc methodDesc = new MethodDesc(classCaller, methodName, parameterTypes);
        WfTxInvocationDesc invocationDesc = new WfTxInvocationDesc(methodDesc, obj, args);
        return WfTxHelper.invokeRequiresNew(ctx, invocationDesc);
    }

    public static boolean needRollbackToolActivity(WfActivity activity) {
        if (activity != null && activity.getDefinition() instanceof ToolActivityDef) {
            return ((ToolActivityDef)activity.getDefinition()).isDefaultRollback();
        }
        return false;
    }

    public static Object invokeScriptReturnValueRequiresNew(Context ctx, String script, WfActivity activity, Map parameters) throws WfException {
        Class<ScriptUtil> classCaller = ScriptUtil.class;
        Object obj = null;
        String methodName = "executeScript";
        Class[] parameterTypes = new Class[]{String.class, WfActivity.class, Map.class};
        Object[] args = new Object[]{script, activity, parameters};
        MethodDesc methodDesc = new MethodDesc(classCaller, methodName, parameterTypes);
        WfTxInvocationDesc invocationDesc = new WfTxInvocationDesc(methodDesc, obj, args);
        return WfTxHelper.invokeRequiresNew(ctx, invocationDesc);
    }

    public static Object callWebService(String content, Map wsdlParams) throws Exception {
        Service s = new Service();
        Call call = (Call)s.createCall();
        call.setOperation("\u64cd\u4f5c\u63cf\u8ff0");
        call.setTargetEndpointAddress(content);
        Object result = call.invoke(new Object[]{wsdlParams});
        return result;
    }

    public static String jsonRequest(String httpUrl, String jsonStr) {
        return OtherSysUtil.request(httpUrl, null, jsonStr, false, true);
    }

    private static String request(String httpUrl, Map<String, String> header, String httpArg, boolean isGet, boolean isContentTypeJSON) {
        String result = null;
        StringBuffer sbf = new StringBuffer();
        HttpURLConnection connection = null;
        FilterOutputStream out = null;
        BufferedReader reader = null;
        InputStream is = null;
        try {
            URL url = new URL(httpUrl);
            connection = (HttpURLConnection)url.openConnection();
            if (isGet) {
                connection.setRequestMethod("GET");
            } else {
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                if (isContentTypeJSON) {
                    connection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
                }
                out = new DataOutputStream(connection.getOutputStream());
                ((DataOutputStream)out).writeBytes(httpArg);
                ((DataOutputStream)out).flush();
            }
            if (header != null && header.size() > 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            connection.connect();
            is = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String strRead = null;
            while ((strRead = reader.readLine()) != null) {
                sbf.append(strRead);
                sbf.append("\r\n");
            }
            result = sbf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("HTTP\u8fde\u63a5\u5931\u8d25", e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (is != null) {
                    is.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }

    public static JSONObject mapToJson(Map map) throws JSONException {
        JSONObject json = new JSONObject();
        for (Map.Entry entry : map.entrySet()) {
            json.put((String)entry.getKey(), entry.getValue());
        }
        return json;
    }

    public static String getOtherSysContentByApiId(String apiId, Context ctx) {
        try {
            String sql = "SELECT FCONTENT FROM T_WFR_OTHERSYSINVOKER WHERE FID = ? ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{apiId});
            if (rs != null && rs.next()) {
                return rs.getString(1);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return "";
    }

    public static String getOtherSysReturnValByActintId(String actId, Context ctx) {
        try {
            String sql = "SELECT FRETURNVAL FROM T_WFR_OTHERSYSTASK WHERE FACTINSTID = ? ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{actId});
            if (rs != null && rs.next()) {
                return rs.getString(1);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return "";
    }

    private static enum HttpMethod {
        POST,
        DELETE,
        GET,
        PUT,
        HEAD;

    }
}

