/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.cache;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.workflow.enactment.cache.IIdentifiableObject;
import com.kingdee.bos.workflow.enactment.cache.IdentifiableMethodDesc;
import com.kingdee.bos.workflow.util.InvocationDesc;

public class IdentifiableInvocationDesc
extends InvocationDesc
implements IIdentifiableObject {
    private static final String SEPARATOR = "_";

    public IdentifiableInvocationDesc(IdentifiableMethodDesc methodDesc, IIdentifiableObject obj, Object[] params) {
        super(methodDesc, obj, params);
    }

    public IdentifiableInvocationDesc(IdentifiableMethodDesc methodDesc, Object[] params) {
        this(methodDesc, null, params);
    }

    @Override
    public String getIdentifier() {
        StringBuffer identifier = new StringBuffer();
        IdentifiableMethodDesc identifiableMethodDesc = (IdentifiableMethodDesc)this.methodDesc;
        IIdentifiableObject identifiableObject = (IIdentifiableObject)this.obj;
        identifier.append(identifiableMethodDesc.getIdentifier());
        identifier.append(SEPARATOR);
        if (this.obj != null) {
            identifier.append("Object[").append(this.obj.getClass().getName()).append("]:").append(identifiableObject.getIdentifier());
        } else {
            identifier.append("Class[").append(this.methodDesc.getMethodClass().getName()).append(']');
        }
        identifier.append(SEPARATOR);
        if (this.params != null) {
            identifier.append("Param{");
            int size = this.params.length;
            for (int i = 0; i < size; ++i) {
                identifier.append(this.getParamIdentifier(this.params[i]));
                if (i == size - 1) continue;
                identifier.append(',');
            }
            identifier.append('}');
        }
        return identifier.toString();
    }

    protected String getParamIdentifier(Object param) {
        if (param == null) {
            return "NULL";
        }
        if (param instanceof String) {
            return (String)param;
        }
        if (param instanceof Context) {
            return "Context";
        }
        if (param instanceof Boolean || param instanceof Character || param instanceof Byte || param instanceof Short || param instanceof Integer || param instanceof Long || param instanceof Float || param instanceof Double) {
            return String.valueOf(param);
        }
        if (param instanceof IObjectPK) {
            return param.toString();
        }
        if (param instanceof Object[]) {
            StringBuffer buffer = new StringBuffer();
            Object[] objects = (Object[])param;
            int size = objects.length;
            for (int i = 0; i < size; ++i) {
                buffer.append(this.getParamIdentifier(objects[i]));
            }
            return buffer.toString();
        }
        throw new IllegalArgumentException("the param' type: [" + param.getClass().getName() + "] not supported.");
    }

    public IIdentifiableObject getIdentifiableObject() {
        return (IIdentifiableObject)this.obj;
    }

    public IdentifiableMethodDesc getIdentifiableMethodDesc() {
        return (IdentifiableMethodDesc)this.methodDesc;
    }

    public String toString() {
        return this.getIdentifier();
    }
}

