/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.cache;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.WebBillManpowerActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ProcBostypeLoader {
    private static Logger log = Logger.getLogger(ProcBostypeLoader.class);
    private Context ctx;

    public ProcBostypeLoader(Context ctx) {
        this.ctx = ctx;
    }

    private ActivityDef findManpowerAct(ActivityCollection activities) {
        for (int i = 0; i < activities.size(); ++i) {
            ActivityDef activityDef = activities.get(i);
            if (activityDef instanceof ApproveActivityDef || activityDef instanceof ToolActivityDef) continue;
            return activityDef;
        }
        return null;
    }

    public BOSObjectType[] getRelatedEntityTypes(String procdefID) throws WfException {
        ArrayList<BOSObjectType> retVal = new ArrayList<BOSObjectType>();
        WfEngine wfEngine = WfEngine.getEngine(this.ctx);
        ProcessDef processDef = wfEngine.getProcessMgr(procdefID).getProcessDef();
        ActivityCollection activities = processDef.getStartupActivities();
        if (activities != null && activities.size() >= 0) {
            ExtendedAttributeCollection ex;
            ExtendedAttributeDef ead;
            ActivityDef activityDef = this.findManpowerAct(activities);
            if (activityDef instanceof ManpowerActivityDef) {
                FunctionDef functionDef;
                ManpowerActivityDef manpowerActivityDef = (ManpowerActivityDef)activityDef;
                ApplicationDef applicationDef = manpowerActivityDef.getRelatedApplication();
                if (applicationDef != null && (functionDef = applicationDef.getFunction()) != null) {
                    String bizPack = functionDef.getPackageName();
                    String bizFunc = functionDef.getName();
                    String bizOpetaion = functionDef.getOperation();
                    if (!(StringUtils.isEmpty((String)bizPack) || StringUtils.isEmpty((String)bizFunc) || StringUtils.isEmpty((String)bizOpetaion))) {
                        FunctionObjectInfo funcInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getFunction((IMetaDataPK)MetaDataPK.create((String)bizPack, (String)bizFunc));
                        OperationCollection operations = funcInfo.getOperation();
                        if (operations == null) {
                            log.error((Object)("The operation was not found in the function[" + bizPack + "." + bizFunc + "]!"));
                        } else {
                            int n = operations.size();
                            for (int j = 0; j < n; ++j) {
                                if (!operations.get(j).getName().equals(bizOpetaion)) continue;
                                retVal.add(operations.get(j).getEntityObjectRef().getType());
                            }
                        }
                    }
                }
            } else if (activityDef instanceof WebBillManpowerActivityDef && (ead = (ex = activityDef.getActivityHeader().getExtendedAttributes()).get("WebBillType")) != null) {
                BOSObjectType type;
                MetaDataPK pk;
                String entityName = ead.getValue();
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
                EntityObjectInfo billObject = loader.getEntity((IMetaDataPK)(pk = MetaDataPK.create((String)entityName)));
                if (billObject != null && (type = billObject.getType()) != null) {
                    retVal.add(type);
                }
            }
        }
        if (retVal.size() == 0) {
            try {
                IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                String sql = "select FPROCESSID from t_wfd_processdef where FCHILDPROCESS =? ";
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{"%" + procdefID + "%"});
                if (rs.next()) {
                    return svc.getRelatedEntityTypes(rs.getString(1));
                }
                sql = " SELECT  a.OWNER AS FPROCESSID FROM  t_bwf_lcjd  a left join  t_bwf_lcdy b  on a.owner= b.id   where b.is_published = 'Y'  and a.BIZ_OPERATION=? ";
                rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{procdefID});
                if (rs.next()) {
                    return svc.getRelatedEntityTypes(rs.getString(1));
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return retVal.toArray(new BOSObjectType[retVal.size()]);
    }
}

