/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.cache;

import com.kingdee.bos.Context;
import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.jcache.CacheLoader;
import com.kingdee.bos.jcache.ObjectRef;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import org.apache.log4j.Logger;

public class ProcessDefinitionCacheLoader
implements com.kingdee.bos.cache.CacheLoader,
CacheLoader {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.cache.ProcessDefinitionCacheLoader");
    private WfEngine engine;

    public ProcessDefinitionCacheLoader(WfEngine engine) {
        this.engine = engine;
    }

    public void cleanUp() {
    }

    public Object load(Object argument) throws CacheException {
        try {
            return this.loadProcessDef((String)argument);
        }
        catch (WfException ex) {
            String msg = "can not load process definition from cache. process definition's Id is : '" + argument + "' at " + this.engine.context().getAIS();
            log.warn((Object)msg, (Throwable)ex);
            throw new CacheException(msg, (Throwable)ex);
        }
    }

    private ProcessDef loadProcessDef(String procDefHash) throws WfException {
        LowTimer lowTimer = new LowTimer();
        ProcessStorer storer = this.engine.getStoreManager().getProcessStorer();
        ProcessDef procDef = KpdlParser.parseKpdl((String)storer.getKpdlByHash(procDefHash));
        procDef.setIsReadOnly(true);
        procDef.clearupOriginalString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProcessDefinitionCacheLoader load [" + procDefHash + "] cost: " + lowTimer.msValue()));
        }
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)this.engine.context(), (String)"select top 1  FBILLBOSTYPE  from t_wfr_procdef where FMD5HASH =?", (Object[])new Object[]{procDef.getHashValue()});
            if (rowset.next()) {
                procDef.setBillBostype(rowset.getString(1));
            }
        }
        catch (Exception e) {
            throw new WfException((Throwable)e);
        }
        return procDef;
    }

    public Object load(ObjectRef ref) throws Exception {
        return this.load(ref.name());
    }

    public void unload(ObjectRef ref, Object value) {
        log.info((Object)("cache item " + ref + " unload value " + value));
    }
}

