/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.policy;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.FunctionHelper;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.IPolicy;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AutoApprovePolicy
implements IPolicy {
    private WfActivity ativity;
    private ActivityDef ativityDef;

    public AutoApprovePolicy(WfActivity ativity) {
        this.ativity = ativity;
        this.ativityDef = ativity.getDefinition();
    }

    private boolean canAutoApprove() {
        return false;
    }

    private Object getBillBaseInfo() throws WfException {
        IObjectValue object = FunctionHelper.createObjectValueByBoId(this.getBoid(), this.ativity.getWfEngine().context());
        return object;
    }

    private Object getAuditorInfo() throws Exception {
        BOSUuid userID = BOSUuid.read((String)this.ativity.getWfEngine().context().getCaller().toString());
        WfActivity approveActivity = this.findApproveActivity(this.ativity);
        if (approveActivity != null) {
            WfAssignment[] assignments = approveActivity.getAssignmentsInState(WfAssignmentState.COMPLETED);
            WfAssignment lastAssignment = null;
            for (WfAssignment assignment : assignments) {
                if (lastAssignment != null && !lastAssignment.getMeta().getEndTime().before(assignment.getMeta().getEndTime())) continue;
                lastAssignment = assignment;
            }
            userID = lastAssignment.getMeta().getAssignInfo().getPersonUserID();
        }
        IObjectValue auditorInfo = this.createUserInfo(userID);
        return auditorInfo;
    }

    private IObjectValue createUserInfo(BOSUuid userID) throws Exception {
        Class<?> clazz = Class.forName("com.kingdee.eas.base.permission.UserInfo");
        IObjectValue objectValue = (IObjectValue)clazz.newInstance();
        objectValue.put(objectValue.getPKField(), (Object)userID);
        return objectValue;
    }

    private WfActivity findApproveActivity(WfActivity activity) throws WfException {
        if (activity.getDefinition() instanceof ApproveActivityDef) {
            if (activity.getAssignmentsInState(WfAssignmentState.COMPLETED).length > 0) {
                return activity;
            }
            activity = activity.getWfEngine().getActivityInst(activity.getMeta().getFromActInstList()[0]);
            return this.findApproveActivity(activity);
        }
        return null;
    }

    private String getBoid() throws WfException {
        ApproveActivityDef approveDef = (ApproveActivityDef)this.ativityDef;
        String parameterName = approveDef.getActivityHeader().getExtendedAttributes().get("ApprovedBoIdDataField").getValue();
        return this.ativity.container().getProcessContext().getDataFieldValue(parameterName).toString();
    }

    @Override
    public void excute() throws WfException {
        if (this.canAutoApprove()) {
            Method setAuditorMethod;
            Method passAuditMethod;
            Class[] coreBillBaseInfoParameterTypes;
            Class[] coreBillBaseParameterTypes;
            Class<?> coreBillBaseInfoClass;
            Class<?> coreBillBaseClass;
            String coreBillBaseClassName = "com.kingdee.eas.framework.CoreBillBase";
            String coreBillBaseInfoClassName = "com.kingdee.eas.framework.AbstractCoreBillBaseInfo";
            try {
                coreBillBaseClass = Class.forName(coreBillBaseClassName);
                coreBillBaseInfoClass = Class.forName(coreBillBaseInfoClassName);
            }
            catch (ClassNotFoundException e1) {
                throw new WfException((Throwable)e1, true);
            }
            try {
                coreBillBaseParameterTypes = new Class[]{IObjectPK.class, Class.forName("com.kingdee.eas.framework.CoreBillBaseInfo")};
                coreBillBaseInfoParameterTypes = new Class[]{Class.forName("com.kingdee.eas.base.permission.UserInfo")};
            }
            catch (ClassNotFoundException e3) {
                throw new WfException((Throwable)e3, true);
            }
            try {
                passAuditMethod = coreBillBaseClass.getMethod("passAudit", coreBillBaseParameterTypes);
                setAuditorMethod = coreBillBaseInfoClass.getMethod("setAuditor", coreBillBaseInfoParameterTypes);
            }
            catch (SecurityException e2) {
                throw new WfException((Throwable)e2, true);
            }
            catch (NoSuchMethodException e2) {
                throw new WfException((Throwable)e2, true);
            }
            Object[] passAuditMethodArgs = new Object[]{new ObjectUuidPK(this.getBoid()), this.getBillBaseInfo()};
            boolean isEnable = WfEventListenerStateManager.getInstance().isEnable();
            try {
                Object[] setAuditorMethodArgs = new Object[]{this.getAuditorInfo()};
                Object auditObject = this.getBillObject(new ObjectUuidPK(this.getBoid()));
                if (isEnable) {
                    WfEventListenerStateManager.getInstance().disableEventListener();
                }
                setAuditorMethod.invoke(passAuditMethodArgs[1], setAuditorMethodArgs);
                passAuditMethod.invoke(auditObject, passAuditMethodArgs);
            }
            catch (Exception e) {
                throw new WfException((Throwable)e, true);
            }
            finally {
                if (isEnable) {
                    WfEventListenerStateManager.getInstance().enableEventListener();
                }
            }
        }
    }

    private Object getBillObject(ObjectUuidPK pk) throws WfException {
        Object result = null;
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ativity.getWfEngine().context()).getEntity(pk.getObjectType());
        String baseClassName = entity.getBusinessImplName();
        Object[] args = new Object[]{this.ativity.getWfEngine().context()};
        Class[] formalArgs = new Class[]{Context.class};
        try {
            result = Class.forName(baseClassName).getConstructor(formalArgs).newInstance(args);
        }
        catch (InstantiationException e) {
            throw new WfException((Throwable)e, true);
        }
        catch (IllegalAccessException e) {
            throw new WfException((Throwable)e, true);
        }
        catch (ClassNotFoundException e) {
            throw new WfException((Throwable)e, true);
        }
        catch (IllegalArgumentException e) {
            throw new WfException((Throwable)e, true);
        }
        catch (SecurityException e) {
            throw new WfException((Throwable)e, true);
        }
        catch (InvocationTargetException e) {
            throw new WfException((Throwable)e, true);
        }
        catch (NoSuchMethodException e) {
            throw new WfException((Throwable)e, true);
        }
        return result;
    }
}

