/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.trace;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.WfLogConfig;
import com.kingdee.bos.workflow.cust.app.startsheme.WFStartLogInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.cache.EffectRegion;
import com.kingdee.bos.workflow.enactment.cache.IdentifiableInvocationDesc;
import com.kingdee.bos.workflow.enactment.cache.IdentifiableMethodDesc;
import com.kingdee.bos.workflow.enactment.queue.impl.WfTransQueueEntry;
import com.kingdee.bos.workflow.enactment.trace.WfLogUtils;
import com.kingdee.bos.workflow.enactment.trace.WfLoggerWriter;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.ProcDefInfo;
import com.kingdee.bos.workflow.metas.ProcessDefOperationEnum;
import com.kingdee.bos.workflow.metas.ProcessInstEventEnum;
import com.kingdee.bos.workflow.metas.QueueEnum;
import com.kingdee.bos.workflow.metas.QueueOperationEnum;
import com.kingdee.bos.workflow.metas.WFREngineLogInfo;
import com.kingdee.bos.workflow.metas.WFRProcessDefLogInfo;
import com.kingdee.bos.workflow.metas.WFRProcessInstLogInfo;
import com.kingdee.bos.workflow.metas.WFRQueueLogInfo;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.store.ActivityStorer;
import com.kingdee.bos.workflow.store.AnalysisDataInfo;
import com.kingdee.bos.workflow.store.LogStorer;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.store.StoreManager;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.bos.workflow.util.ResourceUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.objbuddy.BuddyObjectFactory;
import com.kingdee.util.objbuddy.IBuddyObject;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WfLogger {
    private static Logger logger = Logger.getLogger(WfLogger.class);
    private LogStorer logStorer;
    private ProcessStorer processStorer;
    private ActivityStorer activityStorer;
    private Context context;
    private WfLogConfig logConfig = EngineConfig.getInstance().getLogConfig();
    private String serverKey;
    protected WfLoggerWriter logQueue;
    private final String name;
    private final IBuddyObject buddy;
    private final WfEngine wfEngine;

    public WfLogger(StoreManager storeManager) {
        this.wfEngine = storeManager.getWfEngine();
        this.name = this.wfEngine.getEngineKey() + "_WfLogger";
        this.processStorer = storeManager.getProcessStorer();
        this.activityStorer = storeManager.getActivityStorer();
        this.logStorer = storeManager.getLogStorer();
        this.context = storeManager.getWfEngine().context();
        this.serverKey = Configuration.serviceInstanceIdGenerator().getInstanceId();
        this.logQueue = new WfLoggerWriter(this.logStorer);
        this.buddy = BuddyObjectFactory.getInstance((Object)this);
        try {
            this.buddy.initialize();
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }

    String getName() {
        return this.name;
    }

    WfLogConfig getLogConfig() {
        return this.logConfig;
    }

    public synchronized void stop() {
        this.buddy.operationPerformed("stop");
    }

    public synchronized void destroy() {
        this.stop();
        this.buddy.terminate();
    }

    public synchronized void start() {
        this.buddy.operationPerformed("start");
    }

    public void clearWfLog() throws WfException {
        this.logStorer.clearWfLog();
    }

    public void addWfEngineLog(LogTypeEnum logType, WfEngineEventEnum event, String description, String longDescription) {
        this.addWfEngineLog(logType, event, description, longDescription, null);
    }

    public LogTypeEnum getLogLevel() {
        return this.logConfig.logLevel;
    }

    public void addWfEngineLog(LogTypeEnum logType, WfEngineEventEnum event, String description, String longDescription, Throwable t) {
        try {
            description = StringUtils.cnulls((String)description, (String)" ");
            longDescription = StringUtils.cnulls((String)longDescription, (String)" ");
            if (logType == null) {
                throw new IllegalArgumentException();
            }
            if (event == null) {
                throw new IllegalArgumentException();
            }
            if (!this.logConfig.enableEngineLog) {
                return;
            }
            if (this.checkLogLevel(logType)) {
                return;
            }
            String account = this.context.getAIS();
            WFREngineLogInfo info = new WFREngineLogInfo();
            info.setAccount(account);
            info.setLogType(logType);
            info.setEvent(event);
            String stack = " ";
            if (t != null) {
                stack = StringUtils.stackToString((Throwable)t);
                info.setExtendedDescription(stack);
            }
            info.setServer(this.serverKey);
            Timestamp time = new Timestamp(System.currentTimeMillis());
            info.setTime(time);
            Locale[] locales = this.getStorer().getLocales();
            for (int i = 0; i <= locales.length - 1; ++i) {
                Locale locale = locales[i];
                if (description.length() > 400) {
                    description = description.substring(0, 399);
                }
                info.setDescription(description, locale);
                info.setLongDescription(longDescription, locale);
            }
            this.logQueue.put(info);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }

    public void addWfEngineLog(LogTypeEnum logType, WfEngineEventEnum event, String processDefId, boolean enabled) {
        this.addWfEngineLog(logType, event, processDefId, enabled, null);
    }

    public void addWfEngineLog(LogTypeEnum logType, WfEngineEventEnum event, String processDefId, boolean enabled, Throwable t) {
        try {
            if (logType == null) {
                throw new IllegalArgumentException();
            }
            if (event == null) {
                throw new IllegalArgumentException();
            }
            if (!this.logConfig.enableEngineLog) {
                return;
            }
            if (this.checkLogLevel(logType)) {
                return;
            }
            String account = this.context.getAIS();
            String solution = this.context.getSolution();
            EffectRegion methodEffectRegion = EffectRegion.create(new ProcDefInfo().getBOSType());
            IdentifiableMethodDesc methodDesc = new IdentifiableMethodDesc(ProcessStorer.class, "getProcessDefInfoLastVersion", new Class[]{String.class}, methodEffectRegion);
            IdentifiableInvocationDesc invocationDesc = new IdentifiableInvocationDesc(methodDesc, this.processStorer, new Object[]{processDefId});
            ProcessDefInfo processDef = (ProcessDefInfo)this.wfEngine.getCacheManager().getInvocationResult(invocationDesc);
            WFREngineLogInfo info = new WFREngineLogInfo();
            info.setAccount(account);
            info.setLogType(logType);
            info.setEvent(event);
            if (t != null) {
                info.setExtendedDescription(StringUtils.stackToString((Throwable)t));
            }
            info.setServer(this.serverKey);
            Timestamp time = new Timestamp(System.currentTimeMillis());
            info.setTime(time);
            Locale[] locales = this.getStorer().getLocales();
            for (int i = 0; i <= locales.length - 1; ++i) {
                Locale locale = locales[i];
                StringBuffer buffer = new StringBuffer();
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "PROCESSDEFINITION", locale));
                buffer.append("\"" + processDef.getProcDefName(locale) + "\"");
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "AT", locale));
                if (enabled) {
                    buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "ENABLED", locale));
                } else {
                    buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "DISABLED", locale));
                }
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "STATE", locale));
                buffer.append('.');
                String description = buffer.toString();
                if (description.length() > 400) {
                    description = description.substring(0, 399);
                }
                info.setDescription(description, locale);
                buffer = new StringBuffer();
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "ACCOUNT", locale)).append('=');
                buffer.append(account);
                buffer.append(';');
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "SOLUTION", locale)).append('=');
                buffer.append(solution);
                buffer.append('.');
                info.setLongDescription(buffer.toString(), locale);
            }
            this.logQueue.put(info);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }

    public void addWfQueueLog(WFRQueueLogInfo info) {
        try {
            if (info == null) {
                throw new IllegalArgumentException();
            }
            if (info.getLogType().getValue() < this.logConfig.logLevel.getValue()) {
                return;
            }
            this.logQueue.put(info);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }

    public void addWfTransQueueLog(LogTypeEnum logType, QueueOperationEnum operation, WfTransQueueEntry entry) {
        this.addWfTransQueueLog(logType, operation, entry, null);
    }

    public void addWfTransQueueLog(LogTypeEnum logType, QueueOperationEnum operation, WfTransQueueEntry entry, Throwable e) {
        try {
            if (logType == null) {
                throw new IllegalArgumentException();
            }
            if (operation == null) {
                throw new IllegalArgumentException();
            }
            if (entry == null) {
                throw new IllegalArgumentException();
            }
            if (!this.logConfig.enableQueueLog) {
                return;
            }
            if (this.checkLogLevel(logType)) {
                return;
            }
            String message = "";
            if (e != null) {
                StringBuffer buffer = new StringBuffer();
                StackTraceElement[] stackTrace = e.getStackTrace();
                for (int i = 0; i < stackTrace.length; ++i) {
                    buffer.append(stackTrace[i].toString() + "\n");
                }
                message = buffer.toString();
            }
            ProcessInstInfo processInst = this.processStorer.getProcessInstance(entry.procInstId);
            ActivityInstInfo fromActInst = this.activityStorer.getInstance(entry.fromActInstId);
            WFRQueueLogInfo info = new WFRQueueLogInfo();
            info.setQueueType(QueueEnum.WFTRANSQUEUE);
            info.setOperation(operation);
            info.setLogType(logType);
            info.setExtendedDescription(null);
            info.setServer(this.serverKey);
            Timestamp time = new Timestamp(System.currentTimeMillis());
            info.setTime(time);
            Locale[] locales = this.getStorer().getLocales();
            for (int i = 0; i <= locales.length - 1; ++i) {
                Locale locale = locales[i];
                info.setDescription("", locale);
                StringBuffer buffer = new StringBuffer();
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "TRANSENTRY", locale) + "ID=");
                buffer.append(entry.Id);
                buffer.append(';');
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "PROCESSINST", locale) + "ID=");
                buffer.append(entry.procInstId);
                buffer.append(';');
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "PROCESSDEFINITION", locale) + "ID=");
                buffer.append(processInst.getProcDefId());
                buffer.append(';');
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "SOURCE", locale) + ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "PROCESSINST", locale) + "ID=");
                buffer.append(entry.fromActInstId);
                buffer.append(';');
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "SOURCE", locale) + ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "ACTIVITYDEF", locale) + "ID=");
                buffer.append(fromActInst.getActDefId());
                buffer.append(';');
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "AIM", locale) + ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "ACTIVITYDEF", locale) + "ID=");
                buffer.append(entry.toActDefId);
                buffer.append('.');
                info.setLongDescription(buffer.toString(), locale);
            }
            info.setExtendedDescription(message);
            this.addWfQueueLog(info);
        }
        catch (Throwable ex) {
            logger.error((Object)ex.getMessage(), ex);
        }
    }

    public void addWfBizEventQueueLog() {
    }

    public void addWfProcessInstCreateQueueLog() {
    }

    public void addWfProcessDefLog(String userId, LogTypeEnum logType, String processDefID, ProcessDefOperationEnum operation) {
        try {
            if (logType == null) {
                throw new IllegalArgumentException();
            }
            if (operation == null) {
                throw new IllegalArgumentException();
            }
            if (!this.logConfig.enableProcessDefLog) {
                return;
            }
            if (this.checkLogLevel(logType)) {
                return;
            }
            ProcessDefInfo processDef = this.processStorer.getProcessDefInfoLastVersion(processDefID);
            WFRProcessDefLogInfo info = new WFRProcessDefLogInfo();
            info.setProcessDefID(BOSUuid.read((String)processDefID));
            info.setUser(BOSUuid.read((String)userId));
            info.setOperation(operation);
            info.setLogType(logType);
            info.setExtendedDescription(null);
            info.setServer(this.serverKey);
            Timestamp time = new Timestamp(System.currentTimeMillis());
            info.setTime(time);
            Locale[] locales = this.getStorer().getLocales();
            for (int i = 0; i <= locales.length - 1; ++i) {
                Locale locale = locales[i];
                StringBuffer buffer = new StringBuffer();
                buffer.append("\"" + processDef.getProcDefName(locale) + "\"");
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "BY", locale));
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", operation.getName(), locale));
                buffer.append('.');
                info.setDescription(buffer.toString(), locale);
                buffer = new StringBuffer();
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "PROCESSDEFINITION", locale) + "ID=");
                buffer.append(processDefID);
                buffer.append('.');
                info.setLongDescription(buffer.toString(), locale);
                String userName = WfLogUtils.getUserName(this.context, userId, locale);
                info.setUserName(userName, locale);
            }
            this.logQueue.put(info);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }

    public void addWfProcessInstWarn(LogTypeEnum logType, ProcessInstEventEnum event, String processInstID, String extendedDescription) {
        try {
            if (logType == null) {
                throw new IllegalArgumentException();
            }
            if (event == null) {
                throw new IllegalArgumentException();
            }
            if (!this.logConfig.enableProcessInstLog) {
                return;
            }
            if (this.checkLogLevel(logType)) {
                return;
            }
            WfEngine engine = WfEngine.getEngine(this.context);
            WfProcess process = engine.getProcessInst(processInstID);
            if (process == null) {
                return;
            }
            ProcessInstInfo processInstInfo = process.getData();
            WFRProcessInstLogInfo info = new WFRProcessInstLogInfo();
            info.setProcessDefID(BOSUuid.read((String)processInstInfo.getProcDefId()));
            info.setProcessVersion(processInstInfo.getProcDefInnerVersion());
            info.setProcessInstID(BOSUuid.read((String)processInstID));
            info.setLogType(logType);
            info.setEvent(event);
            info.setExtendedDescription(extendedDescription);
            info.setServer(this.serverKey);
            Timestamp time = new Timestamp(System.currentTimeMillis());
            info.setTime(time);
            Locale[] locales = this.getStorer().getLocales();
            for (int i = 0; i <= locales.length - 1; ++i) {
                Locale locale = locales[i];
                info.setExceptionName("\u8b66\u544a", locale);
                info.setDescription("\u5de5\u4f5c\u6d41\u5f15\u64ce\u6267\u884c\u65f6\u53d1\u51fa\u8b66\u544a\u4fe1\u606f\uff0c\u4f46\u4e0d\u5f71\u54cd\u6d41\u7a0b\u6267\u884c", locale);
                info.setLongDescription("", locale);
            }
            this.logQueue.put(info);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }

    public void addWfProcessInstLog(LogTypeEnum logType, ProcessInstEventEnum event, String processInstID, String extendedDescription) {
        this.addWfProcessInstLog(logType, event, processInstID, extendedDescription, "\u5185\u90e8\u5f02\u5e38", "\u5de5\u4f5c\u6d41\u5f15\u64ce\u6267\u884c\u65f6\u51fa\u73b0\u5f02\u5e38", "\u8bf7\u67e5\u770b\u5f02\u5e38\u5806\u6808\u5206\u6790\u5b9a\u4f4d\u95ee\u9898");
    }

    public void addWfProcessInstLog(LogTypeEnum logType, ProcessInstEventEnum event, String processInstID, String extendedDescription, String exceptionName, String description, String longdescription) {
        try {
            if (logType == null) {
                throw new IllegalArgumentException();
            }
            if (event == null) {
                throw new IllegalArgumentException();
            }
            if (!this.logConfig.enableProcessInstLog) {
                return;
            }
            if (this.checkLogLevel(logType)) {
                return;
            }
            WfEngine engine = WfEngine.getEngine(this.context);
            WfProcess process = engine.getProcessInst(processInstID);
            if (process == null) {
                return;
            }
            ProcessInstInfo processInstInfo = process.getData();
            WFRProcessInstLogInfo info = new WFRProcessInstLogInfo();
            info.setProcessDefID(BOSUuid.read((String)processInstInfo.getProcDefId()));
            info.setProcessVersion(processInstInfo.getProcDefInnerVersion());
            info.setProcessInstID(BOSUuid.read((String)processInstID));
            info.setLogType(logType);
            info.setEvent(event);
            info.setExtendedDescription(extendedDescription);
            info.setServer(this.serverKey);
            Timestamp time = new Timestamp(System.currentTimeMillis());
            info.setTime(time);
            Locale[] locales = this.getStorer().getLocales();
            for (int i = 0; i <= locales.length - 1; ++i) {
                Locale locale = locales[i];
                info.setExceptionName(exceptionName, locale);
                info.setDescription(description, locale);
                info.setLongDescription(longdescription, locale);
            }
            this.logQueue.put(info);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }

    public void logProcInstException(String procInstId, String exceptionName, String reason, String response, String stackMsg) {
        this.logProcInstException(procInstId, exceptionName, reason, response, stackMsg, ProcessInstEventEnum.COMMON);
    }

    public void logProcInstException(String procInstId, String exceptionName, String reason, String response, String stackMsg, ProcessInstEventEnum event) {
        try {
            LogTypeEnum logType = LogTypeEnum.ERROR;
            if (!this.logConfig.enableProcessInstLog || this.checkLogLevel(logType)) {
                return;
            }
            WfEngine engine = WfEngine.getEngine(this.context);
            WfProcess process = engine.getProcessInst(procInstId);
            ProcessInstInfo processInstInfo = process.getData();
            WFRProcessInstLogInfo info = new WFRProcessInstLogInfo();
            if (event == null) {
                event = ProcessInstEventEnum.COMMON;
            }
            info.setProcessDefID(BOSUuid.read((String)processInstInfo.getProcDefId()));
            info.setProcessVersion(processInstInfo.getProcDefInnerVersion());
            info.setProcessInstID(BOSUuid.read((String)procInstId));
            info.setLogType(logType);
            info.setEvent(event);
            info.setExtendedDescription(stackMsg);
            info.setServer(this.serverKey);
            Timestamp time = new Timestamp(System.currentTimeMillis());
            info.setTime(time);
            Locale[] locales = this.getStorer().getLocales();
            for (int i = 0; i <= locales.length - 1; ++i) {
                Locale locale = locales[i];
                info.setExceptionName(exceptionName, locale);
                info.setDescription(reason, locale);
                info.setLongDescription(response, locale);
            }
            this.logQueue.put(info);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }

    public void addCacheTransqueueEntryLog(LogTypeEnum logType, WfTransQueueEntry transEntry) {
        try {
            if (logType == null) {
                return;
            }
            if (transEntry == null) {
                return;
            }
            if (!this.logConfig.enableProcessInstLog) {
                return;
            }
            if (this.checkLogLevel(logType)) {
                return;
            }
            WfEngine engine = WfEngine.getEngine(this.context);
            String processId = transEntry.procInstId;
            WfProcess process = engine.getProcessInst(processId);
            ProcessInstInfo processInstInfo = this.processStorer.getProcessInstance(processId);
            ProcessDef processDef = process.getDefinition();
            WfActivity fromActivity = engine.getActivityInst(transEntry.fromActInstId);
            ActivityDef fromActivityDef = fromActivity.getDefinition();
            ActivityDef toActivityDef = processDef.getActivityDef(transEntry.toActDefId);
            WFRProcessInstLogInfo info = new WFRProcessInstLogInfo();
            info.setProcessDefID(BOSUuid.read((String)processInstInfo.getProcDefId()));
            info.setProcessVersion(processInstInfo.getProcDefInnerVersion());
            info.setProcessInstID(BOSUuid.read((String)processId));
            info.setLogType(logType);
            info.setEvent(ProcessInstEventEnum.TRANSACTIONINFO);
            info.setExtendedDescription("");
            info.setServer(this.serverKey);
            Timestamp time = new Timestamp(System.currentTimeMillis());
            info.setTime(time);
            Locale[] locales = this.getStorer().getLocales();
            for (int i = 0; i <= locales.length - 1; ++i) {
                Locale locale = locales[i];
                StringBuffer buffer = new StringBuffer();
                String recordTransactionActivity = ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "CACHETRANSQUEUEENTRY", locale);
                buffer.append(recordTransactionActivity);
                info.setDescription(buffer.toString(), locale);
                buffer = new StringBuffer();
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "PROCESSDEFINITION", locale));
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "NAME", locale));
                buffer.append('=');
                buffer.append('\"');
                buffer.append(processDef.getName(locale));
                buffer.append('\"');
                buffer.append(';');
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "SOURCE", locale));
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "ACTIVITYDEF", locale));
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "NAME", locale));
                buffer.append('=');
                buffer.append('\"');
                buffer.append(fromActivityDef.getName(locale));
                buffer.append('\"');
                buffer.append(';');
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "AIM", locale));
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "ACTIVITYDEF", locale));
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "NAME", locale));
                buffer.append('=');
                buffer.append('\"');
                buffer.append(toActivityDef.getName(locale));
                buffer.append('\"');
                buffer.append('.');
                String message = buffer.toString();
                info.setLongDescription(message, locale);
            }
            this.logQueue.put(info);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }

    public void addCacheTransactionActivityLog(LogTypeEnum logType, WfTransQueueEntry transEntry) {
        try {
            if (logType == null) {
                return;
            }
            if (transEntry == null) {
                return;
            }
            if (!this.logConfig.enableProcessInstLog) {
                return;
            }
            if (this.checkLogLevel(logType)) {
                return;
            }
            WfEngine engine = WfEngine.getEngine(this.context);
            String processId = transEntry.procInstId;
            WfProcess process = engine.getProcessInst(processId);
            ProcessInstInfo processInstInfo = this.processStorer.getProcessInstance(processId);
            ProcessDef processDef = process.getDefinition();
            ActivityDef toActivityDef = processDef.getActivityDef(transEntry.toActDefId);
            WFRProcessInstLogInfo info = new WFRProcessInstLogInfo();
            info.setProcessDefID(BOSUuid.read((String)processInstInfo.getProcDefId()));
            info.setProcessVersion(processInstInfo.getProcDefInnerVersion());
            info.setProcessInstID(BOSUuid.read((String)processId));
            info.setLogType(LogTypeEnum.INFO);
            info.setEvent(ProcessInstEventEnum.TRANSACTIONINFO);
            info.setExtendedDescription("");
            info.setServer(this.serverKey);
            Timestamp time = new Timestamp(System.currentTimeMillis());
            info.setTime(time);
            Locale[] locales = this.getStorer().getLocales();
            for (int i = 0; i <= locales.length - 1; ++i) {
                Locale locale = locales[i];
                StringBuffer buffer = new StringBuffer();
                String recordTransactionActivity = ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "RECORDTRANSACTIONACTIVITY", locale);
                buffer.append(recordTransactionActivity);
                info.setDescription(buffer.toString(), locale);
                buffer = new StringBuffer();
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "PROCESSDEFINITION", locale));
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "NAME", locale));
                buffer.append('=');
                buffer.append('\"');
                buffer.append(processDef.getName(locale));
                buffer.append('\"');
                buffer.append(';');
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "ACTIVITYDEF", locale));
                buffer.append(ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "NAME", locale));
                buffer.append('=');
                buffer.append('\"');
                buffer.append(toActivityDef.getName(locale));
                buffer.append('\"');
                buffer.append('.');
                String message = buffer.toString();
                info.setLongDescription(message, locale);
            }
            this.logQueue.put(info);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }

    public void addAnalysisData(String performer, String thread, String operation, String step, long createdTime, long consumeTime, String note) {
        if (!this.logConfig.enableAnalysisData) {
            return;
        }
        try {
            AnalysisDataInfo info = new AnalysisDataInfo();
            info.setPerformer(performer);
            info.setThread(thread);
            info.setOperation(operation);
            info.setStep(step);
            info.setCreatedTime(createdTime);
            info.setConsumeTime(consumeTime);
            info.setNote(note);
            this.logQueue.put(info);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }

    public void addStartLog(WFStartLogInfo info) {
        this.logQueue.put(info);
    }

    public void addExceptionLog(Throwable e) {
        try {
            if (e == null) {
                String message = "\"e\" is null!";
                throw new IllegalArgumentException(message);
            }
            StringBuffer buffer = new StringBuffer();
            StackTraceElement[] stackTrace = e.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                buffer.append(stackTrace[i].toString() + "\n");
            }
            String message = buffer.toString();
            this.addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.TRANSQUEUEERROR, "", message);
        }
        catch (Throwable ex) {
            logger.error((Object)ex.getMessage(), e);
        }
    }

    public LogStorer logStorer() {
        return this.logStorer;
    }

    private LogStorer getStorer() {
        return this.logStorer;
    }

    public boolean checkLogLevel(LogTypeEnum logType) {
        if (logType.equals((Object)LogTypeEnum.ERROR)) {
            return false;
        }
        int cnfgrtnLgLvlVl = this.logConfig.logLevel.getValue();
        return logType.getValue() < cnfgrtnLgLvlVl;
    }
}

