/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.runmonitor;

import com.kingdee.bos.Context;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.workflow.engine.core.runmonitor.IWfGatherLog;
import com.kingdee.bos.workflow.engine.core.runmonitor.WfGatherLog;
import com.kingdee.bos.workflow.engine.core.runmonitor.WfGatherLogHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class WfGatherLogWorker {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.engine.core.runmonitor.WfGatherLogWorker");
    private static File zipFile = null;
    private String localIP = null;
    private String localServerName = null;
    private FileOutputStream fos = null;
    private ZipOutputStream zos = null;

    public WfGatherLogWorker() {
        String path = System.getProperty("EAS_INSTANCE_HOME");
        String profilesPath = new File(path).getParent();
        String zipfilePath = profilesPath + "/wfLog.zip";
        zipFile = new File(zipfilePath);
        zipFile.delete();
        if (!zipFile.exists()) {
            try {
                zipFile.createNewFile();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public byte[] downloadWfZip(Context ctx) {
        try {
            WfGatherLogHelper.ctx = ctx;
            this.byteToZip2();
            byte[] byArray = this.getWfLogZip();
            return byArray;
        }
        finally {
            if (zipFile != null && zipFile.exists()) {
                zipFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void byteToZip2() {
        List<String> logNames = WfGatherLogHelper.getLogName();
        try {
            this.fos = new FileOutputStream(zipFile);
            this.zos = new ZipOutputStream(this.fos);
            List<ServerInfo> serverList = this.getRemoteServerList();
            for (String logName : logNames) {
                this.gatherWFLog(new ServerInfo("local", this.localIP, this.localServerName), logName);
                for (int i = 0; i < serverList.size(); ++i) {
                    this.gatherWFLog(serverList.get(i), logName);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (this.zos != null) {
                    this.zos.close();
                }
                if (this.fos != null) {
                    this.fos.close();
                }
            }
            catch (IOException e1) {
                logger.error((Object)e1);
            }
        }
    }

    private void gatherWFLog(ServerInfo serverInfo, String logName) {
        Map<String, byte[]> m = null;
        if ("local".equals(serverInfo.getUrl())) {
            WfGatherLog LogGather = new WfGatherLog();
            m = LogGather.getWfLogDataByLogName(logName);
            this.innerZip(m, serverInfo.getIP(), serverInfo.getServerName());
        } else {
            IWfGatherLog remoteGather = (IWfGatherLog)RPCEngineFactory.getEngine((String)serverInfo.getUrl()).createObject("com.kingdee.bos.workflow.engine.core.runmonitor.WfGatherLog", IWfGatherLog.class);
            if (remoteGather != null) {
                m = remoteGather.getWfLogDataByLogName(logName);
                this.innerZip(m, serverInfo.getIP(), serverInfo.getServerName());
            }
        }
    }

    private void innerZip(Map<String, byte[]> dataMap, String IP, String serverName) {
        for (Map.Entry<String, byte[]> entry : dataMap.entrySet()) {
            String fileName = entry.getKey();
            byte[] data = entry.getValue();
            fileName = IP + "/" + serverName + "/" + fileName;
            this.writeByteToZip(data, fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeByteToZip(byte[] data, String fileName) {
        try {
            ZipEntry zipEntry = new ZipEntry(fileName);
            this.zos.putNextEntry(zipEntry);
            this.zos.write(data);
            this.zos.flush();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                this.zos.closeEntry();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getWfLogZip() {
        FileInputStream fis = null;
        ByteArrayOutputStream byteos = null;
        try {
            fis = new FileInputStream(zipFile);
            byteos = new ByteArrayOutputStream();
            int ch = 0;
            while ((ch = fis.read()) != -1) {
                byteos.write(ch);
            }
            byteos.flush();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                fis.close();
                byteos.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return byteos.toByteArray();
    }

    private List<ServerInfo> getRemoteServerList() {
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            this.localIP = "local";
            this.localServerName = "localServer";
            return new ArrayList<ServerInfo>(0);
        }
        IRPCServer[] ss = sv.getServers();
        ArrayList<ServerInfo> ls = new ArrayList<ServerInfo>();
        for (int i = 0; i < ss.length; ++i) {
            IRPCServer s = ss[i];
            if (s.connectionFailed()) continue;
            String url = s.getUrl();
            String serverName = s.getName();
            String IP = url.split("//")[1].split(":")[0];
            if (url == null || url.length() <= 0) continue;
            if (this.isLocal(url)) {
                this.localIP = IP;
                this.localServerName = serverName;
                continue;
            }
            ServerInfo serverInfo = new ServerInfo(url, IP, serverName);
            ls.add(serverInfo);
        }
        return ls;
    }

    private boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }

    class ServerInfo {
        private String url;
        private String IP;
        private String serverName;

        public ServerInfo(String url, String IP, String serverName) {
            this.url = url;
            this.IP = IP;
            this.serverName = serverName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getIP() {
            return this.IP;
        }

        public String getServerName() {
            return this.serverName;
        }
    }
}

