/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.thread.JobDispatcher;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;

public class FlowAbort
extends WfJobHandler {
    private static final long serialVersionUID = -3149519947280565253L;
    private String procInstId;
    private String actInstId;

    public static void enqueue(Context ctx, String procInstId, String actInstId) throws AlreadyInProcessQueueException {
        String jobId = Mutex.getMutex(ctx, procInstId);
        String title = "~" + procInstId + ":abort";
        JobDispatcher.dispatch(jobId, ctx, title, new FlowAbort(procInstId, actInstId, ctx.getCaller().toString()), true, WfPriority.HIGHEST);
    }

    private FlowAbort(String procInstId, String actInstId, String userId) {
        super(userId);
        this.procInstId = procInstId;
        this.actInstId = actInstId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Context ctx) throws Exception {
        WfEngine engine = WfEngine.getEngine(ctx);
        WfProcess process = engine.getProcessInst(this.procInstId);
        FlowContext runtime = process.getProcessContext().loadFlowContext();
        try {
            if (process.isClosed() || runtime.isClosed()) {
                return;
            }
            Execution e = runtime.getExecution(this.actInstId);
            if (e != null) {
                e.terminate();
                runtime.resume();
            } else {
                runtime.terminate();
            }
        }
        catch (Exception error) {
            this.saveLog(error, ctx, this.procInstId);
        }
        finally {
            super.commitMgrAndRuntimeTx(process, runtime);
        }
    }

    @Override
    protected boolean requiresTran() {
        return false;
    }

    @Override
    protected String getProcInstId() {
        return this.procInstId;
    }
}

