/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.bos.workflow.engine.core.thread.FlowInitiator;
import com.kingdee.bos.workflow.engine.core.thread.JobDispatcher;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.cbos.process.vm.runtime.FlowContext;

public class FlowResume
extends WfJobHandler {
    private static final long serialVersionUID = -3149519947280565253L;
    private String procInstId;

    private FlowResume(String procInstId, String userId) {
        super(userId);
        this.procInstId = procInstId;
    }

    public static void enqueue(Context ctx, String procInstId, String actInstId) throws AlreadyInProcessQueueException {
        String jobId = Mutex.getMutex(ctx, procInstId);
        String title = "~" + procInstId + ":resume";
        JobDispatcher.dispatch(jobId, ctx, title, new FlowResume(procInstId, ctx.getCaller().toString()), false, WfPriority.LOWEST);
    }

    @Override
    public void run(Context ctx) throws Exception {
        WfEngine engine = WfEngine.getEngine(ctx);
        WfProcess process = engine.getProcessInst(this.procInstId);
        FlowContext runtime = process.getProcessContext().loadFlowContext();
        if (!runtime.isClosed()) {
            this.resume(ctx, process, runtime);
        }
    }

    @Override
    protected boolean requiresTran() {
        return false;
    }

    @Override
    protected String getProcInstId() {
        return this.procInstId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume(Context ctx, WfProcess process, FlowContext runtime) throws Exception {
        try {
            runtime.resume();
            FlowInitiator.tryOmitFirstActivitiy(runtime);
            String signal = Util.getLastSignal(runtime);
            if (signal != null) {
                runtime.signal(signal);
            }
            Util.setLastSignal(runtime, null);
        }
        catch (Exception error) {
            this.saveLog(error, ctx, this.procInstId);
        }
        finally {
            super.commitMgrAndRuntimeTx(process, runtime);
        }
    }
}

