/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.thread.JobDispatcher;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.cbos.process.vm.runtime.FlowContext;

public class FlowSuspend
extends WfJobHandler {
    private static final long serialVersionUID = -3149519947280565253L;
    private String procInstId;

    public static void enqueue(Context ctx, String procInstId, String actInstId) throws AlreadyInProcessQueueException {
        String jobId = Mutex.getMutex(ctx, procInstId);
        String title = "~" + procInstId + ":suspend";
        JobDispatcher.dispatch(jobId, ctx, title, new FlowSuspend(procInstId, actInstId, ctx.getCaller().toString()), true, WfPriority.HIGHEST);
    }

    private FlowSuspend(String procInstId, String actInstId, String userId) {
        super(userId);
        this.procInstId = procInstId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Context ctx) throws Exception {
        WfEngine engine = WfEngine.getEngine(ctx);
        WfProcess process = engine.getProcessInst(this.procInstId);
        FlowContext runtime = process.getProcessContext().loadFlowContext();
        if (runtime.isClosed()) {
            return;
        }
        try {
            runtime.suspend();
        }
        catch (Exception error) {
            this.saveLog(error, ctx, this.procInstId);
        }
        finally {
            super.commitMgrAndRuntimeTx(process, runtime);
        }
    }

    @Override
    protected String getProcInstId() {
        return this.procInstId;
    }

    @Override
    protected boolean requiresTran() {
        return false;
    }
}

