/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.event;

import com.kingdee.bos.workflow.define.EventPolicyDef;
import com.kingdee.bos.workflow.event.WfEvent;
import com.kingdee.bos.workflow.event.WfEventListener;
import com.kingdee.bos.workflow.event.WfSendNotificationAction;
import java.util.HashMap;
import java.util.Map;

public class WfEventPolicy
implements WfEventListener {
    private String eventType;
    private int actionType;
    private Map parameters = new HashMap();
    private String processDefId;
    int processDefVersion;
    private String actDefId;
    private String id;

    public WfEventPolicy(String processDefId, int processDefVersion, EventPolicyDef policyDef) {
        this.id = processDefId + "_" + processDefVersion + "WFEP";
        this.eventType = policyDef.getEventType();
        this.actionType = policyDef.getEventAction();
        this.processDefId = processDefId;
        this.processDefVersion = processDefVersion;
        this.parameters.put("participants", policyDef.getParticipants());
    }

    public WfEventPolicy(String eventType, String processDefId, int processDefVersion, int actionType) {
        this.id = processDefId + "_" + processDefVersion + "WFEP";
        this.eventType = eventType;
        this.actionType = actionType;
        this.processDefId = processDefId;
        this.processDefVersion = processDefVersion;
    }

    public WfEventPolicy(String processDefId, int processDefVersion, String actDefId, EventPolicyDef policyDef) {
        this.id = processDefId + "_" + processDefVersion + "WFEP";
        this.eventType = policyDef.getEventType();
        this.actionType = policyDef.getEventAction();
        this.processDefId = processDefId;
        this.processDefVersion = processDefVersion;
        this.actDefId = actDefId;
        this.parameters.put("participants", policyDef.getParticipants());
    }

    public WfEventPolicy(String processDefId, int processDefVersion, String actDefId, String eventType, int actionType) {
        this.id = processDefId + "_" + processDefVersion + "WFEP";
        this.eventType = eventType;
        this.actionType = actionType;
        this.processDefId = processDefId;
        this.processDefVersion = processDefVersion;
        this.actDefId = actDefId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public int getActionType() {
        return this.actionType;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public void putParameters(Map para) {
        if (para != null) {
            this.parameters.putAll(para);
        }
    }

    private void action(WfEvent event) {
        WfSendNotificationAction action = new WfSendNotificationAction();
        if (action != null) {
            action.action(event, this.parameters);
        }
    }

    private boolean isEventForMe(WfEvent event) {
        if (!this.eventType.equals(event.getEventType().getName())) {
            return false;
        }
        if (!(this.processDefId == null || this.processDefId.equals(event.getProcessDefId()) && this.processDefVersion == event.getProcessDefVersion())) {
            return false;
        }
        return this.actDefId == null || this.actDefId.equals(event.getActDefId());
    }

    @Override
    public void onEvent(WfEvent event) {
        if (this.isEventForMe(event)) {
            this.action(event);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

