/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.procdiagram.service;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.extscheme.procdiagram.bean.DiaActivityState;
import com.kingdee.bos.workflow.extscheme.procdiagram.bean.DiaActivityType;
import com.kingdee.bos.workflow.extscheme.procdiagram.bean.DiagramActivity;
import com.kingdee.bos.workflow.extscheme.procdiagram.cal.CalProcDiagram;
import com.kingdee.bos.workflow.extscheme.procdiagram.util.ProcDiagramUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProcDiagramService {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.extscheme.procdiagram.service.ProcDiagramService");
    public static final String PROCESSCTX = "PROCESSCTX";
    private Context ctx;

    public ProcDiagramService(Context ctx) {
        this.ctx = ctx;
    }

    public String calProcDiagram(String actinstId, String procDefId, String procinstId) throws BOSException {
        String toJsonString = "";
        try {
            WfEngine engine = WfEngine.getEngine(this.ctx);
            Map dataMap = engine.getProcessInst(procinstId).getProcessContext().cloneData();
            dataMap.put("_BILL_ID_", engine.getBizObjIdByProcessInstanceId(procinstId));
            CalProcDiagram tCalProcDiagram = new CalProcDiagram(engine, actinstId, procDefId, procinstId, this.ctx, dataMap);
            List<DiagramActivity> diaActList = tCalProcDiagram.calProcDiagram();
            if (diaActList != null) {
                Object[] tDiagramActivitys = new Object[diaActList.size()];
                for (int index = 0; index < diaActList.size(); ++index) {
                    tDiagramActivitys[index] = diaActList.get(index).toMap(this.ctx);
                }
                toJsonString = JSON.toJSONString((Object)tDiagramActivitys);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u8ba1\u7b97\u6d41\u7a0b\u56fe\u51fa\u9519", (Throwable)e);
            throw new BOSException("\u4f30\u7b97\u6d41\u7a0b\u56fe\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u6d41\u7a0b\u56fe", (Throwable)e);
        }
        return toJsonString;
    }

    public Map<String, String> calProcDiagram(String actinstId, String procDefId, String procinstId, IObjectValue model, Map<String, Object> predictMap) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            WfEngine engine = WfEngine.getEngine(this.ctx);
            Map dataMap = null;
            if (StringUtils.isEmpty((String)procinstId)) {
                dataMap = ProcDiagramUtil.getProcessPropMap(engine.getProcessMgr(procDefId).getProcessDef(), engine, model);
            } else {
                dataMap = engine.getProcessInst(procinstId).getProcessContext().cloneData();
                dataMap.put("_BILL_ID_", engine.getBizObjIdByProcessInstanceId(procinstId));
            }
            CalProcDiagram tCalProcDiagram = new CalProcDiagram(engine, actinstId, procDefId, procinstId, this.ctx, dataMap);
            tCalProcDiagram.setPredictMap(predictMap);
            List<DiagramActivity> diaActList = tCalProcDiagram.calProcDiagram();
            for (DiagramActivity diaAct : diaActList) {
                DiaActivityType actType = diaAct.getDiaActivityType();
                if (actType != DiaActivityType.APPROVENODE && actType != DiaActivityType.MANPOWERNODE && actType != DiaActivityType.SUBFLOWNODE && actType != DiaActivityType.MANUALDECISIONNODE) continue;
                String diaActId = diaAct.getActDefId();
                map.put(diaActId, diaActId);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u8ba1\u7b97\u6d41\u7a0b\u56fe\u51fa\u9519", (Throwable)e);
            map = null;
        }
        return map;
    }

    public Map<String, Object> calProcessProgress(String procDefId, String procinstId) throws BOSException {
        try {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            WfEngine engine = WfEngine.getEngine(this.ctx);
            Map dataMap = engine.getProcessInst(procinstId).getProcessContext().cloneData();
            dataMap.put("_BILL_ID_", engine.getBizObjIdByProcessInstanceId(procinstId));
            CalProcDiagram tCalProcDiagram = new CalProcDiagram(engine, null, procDefId, procinstId, this.ctx, dataMap);
            List<DiagramActivity> diaActList = tCalProcDiagram.calProcDiagram();
            if (diaActList != null && diaActList.size() > 0) {
                int completedCount = 0;
                int spendCount = 0;
                for (int index = 0; index < diaActList.size(); ++index) {
                    DiagramActivity diagramActivity = diaActList.get(index);
                    DiaActivityState state = diagramActivity.getActState();
                    DiaActivityType diaActivityType = diagramActivity.getDiaActivityType();
                    if (diaActivityType == DiaActivityType.STARTNODE || diaActivityType == DiaActivityType.ENDNODENODE || diaActivityType == DiaActivityType.ROUTERNODE) continue;
                    if (state == DiaActivityState.CLOSE || state == DiaActivityState.CLOSEJUMP || state == DiaActivityState.CLOSEBACK || state == DiaActivityState.CLOSENOEXECUTION) {
                        ++completedCount;
                    }
                    ++spendCount;
                }
                if (spendCount == 0) {
                    ret.put("progress", 0);
                } else {
                    ret.put("progress", completedCount * 100 / spendCount);
                    ret.put("detail", completedCount + "/" + spendCount);
                }
            } else {
                ret.put("progress", -1);
            }
            return ret;
        }
        catch (Exception e) {
            throw new BOSException(" \u4f30\u7b97\u6d41\u7a0b\u8fdb\u5ea6\u51fa\u9519  procinstId:" + procinstId, (Throwable)e);
        }
    }
}

