/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.participant;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.sql.shell.trace.ConnectionLogger;
import com.kingdee.bos.sql.shell.trace.LogItem;
import com.kingdee.bos.sql.shell.trace.LoggerDest;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ParticipantCacheCleanByTable
implements LoggerDest {
    protected static final Logger logger = Logger.getLogger(ParticipantCacheCleanByTable.class);
    private static HashSet tableSet = new HashSet();
    private static ParticipantCacheCleanByTable instance = null;
    private static volatile long cleanTime = System.currentTimeMillis();

    private ParticipantCacheCleanByTable() {
        if (ConnectionLogger.isValid()) {
            logger.info((Object)"WorkFlow ParticipantCacheCleanByTable Status: OK");
        }
    }

    public static ParticipantCacheCleanByTable getInstance() {
        if (instance == null) {
            instance = new ParticipantCacheCleanByTable();
        }
        return instance;
    }

    public static void clear() {
        if (instance != null) {
            ConnectionLogger.removeLoggerDest((LoggerDest)instance);
        }
        logger.info((Object)"WorkFlow ParticipantCacheCleanByTable Status: shutdown");
    }

    public void log(LogItem logitem) {
        block16: {
            if (logitem == null) {
                return;
            }
            if (logitem.method != null && "KDConnection.prepareStatement".equals(logitem.method)) {
                return;
            }
            try {
                String sql = logitem.dialect_sql;
                if (StringUtils.isEmpty((String)sql)) {
                    return;
                }
                String tablename = null;
                StringTokenizer token = new StringTokenizer(sql);
                if (sql.startsWith("INSERT")) {
                    token.nextToken();
                    token.nextToken();
                    tablename = token.nextToken().toUpperCase();
                } else if (sql.startsWith("UPDATE")) {
                    token.nextToken();
                    tablename = token.nextToken().toUpperCase();
                } else if (sql.startsWith("DELETE")) {
                    token.nextToken();
                    token.nextToken();
                    tablename = token.nextToken().toUpperCase();
                } else if (sql.startsWith("TRUNCATE")) {
                    token.nextToken();
                    token.nextToken();
                    tablename = token.nextToken().toUpperCase();
                } else {
                    return;
                }
                if (!tableSet.contains(tablename.toUpperCase())) break block16;
                cleanTime = System.currentTimeMillis();
                Context ctx = ContextUtils.getContextFromSessionNoException();
                if (ctx != null) {
                    Context fakeContext = new Context((IObjectPK)new ObjectUuidPK(), ctx.getSolution(), ctx.getAIS(), ctx.getLocale());
                    try {
                        IEnactmentService services = EnactmentServiceFactory.createEnactService((Context)fakeContext);
                        services.cleanParticipantCache();
                        logger.debug((Object)("WorkFlow ParticipantCacheCleanByTable : [" + fakeContext.getAIS() + "|" + fakeContext.getSolution() + "]Automatically clean participant cache success!"));
                    }
                    catch (Exception e) {
                        logger.warn((Object)("WorkFlow ParticipantCacheCleanByTable : [" + fakeContext.getAIS() + "|" + fakeContext.getSolution() + "]Automatically clean participant cache error! cause: " + e.getMessage()));
                    }
                    ctx = null;
                    fakeContext = null;
                    break block16;
                }
                logger.warn((Object)"WorkFlow ParticipantCacheCleanByTable : get context from Session error! can not Automatically clean participant cache!");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        tableSet.add("T_PM_USER");
        tableSet.add("T_BD_PERSON");
        tableSet.add("T_ORG_POSITION");
        tableSet.add("T_ORG_JOB");
        tableSet.add("T_ORG_POSITIONMEMBER");
    }
}

