/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.dao.xml.impl.MetadataCleaner;
import com.kingdee.bos.dao.xml.impl.MetadataClearListener;
import com.kingdee.bos.service.CannotCreateServiceManagerException;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.WfBizEventListener;
import com.kingdee.bos.workflow.biz.WfMetadataClearListener;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.participant.ParticipantCacheCleanByTable;
import com.kingdee.bos.workflow.util.DCServiceHelper;
import com.kingdee.util.objbuddy.BuddyObjectFactory;
import com.kingdee.util.objbuddy.IBuddyObject;
import java.lang.reflect.Method;
import java.util.Date;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class WfServerListener
implements ServletContextListener {
    private static Logger logger = Logger.getLogger(WfServerListener.class);
    private final IBuddyObject buddy = BuddyObjectFactory.getInstance((Object)this);

    public void contextInitialized(ServletContextEvent event) {
        try {
            this.buddy.initialize();
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
        }
        this.initWorkflowSystem();
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            ParticipantCacheCleanByTable.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            WfEngine.stopAll();
        }
        catch (WfException e) {
            logger.warn((Object)"BOS workflow service stop error", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"BOS workflow service stoped");
        }
        this.buddy.terminate();
    }

    private void initWorkflowSystem() {
        try {
            WfBizEventListener listener = new WfBizEventListener();
            ServiceManagerFactory.getServiceManager().registerService((IServiceAdapter)listener);
            ServiceManagerFactory.getServiceManager().enableService(listener.getName());
            logger.error((Object)"WfBizEventListener was registered and enabled! OK");
            WfMetadataClearListener listener2 = new WfMetadataClearListener();
            MetadataCleaner.registerListener((MetadataClearListener)listener2);
            WfEngineInitiator init = new WfEngineInitiator();
            Job job = new Job(null, (IJobHandler)init, null, false);
            job.setScheduledTime(new Date(System.currentTimeMillis() + 180000L));
            JobManager.instance().add(job);
        }
        catch (CannotCreateServiceManagerException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static class WfEngineInitiator
    implements IJobHandler {
        private static final long serialVersionUID = -8889065050273789290L;

        private WfEngineInitiator() {
        }

        public Object execute(Job job) throws Exception {
            String[][] dcInfos = DCServiceHelper.getDCInfos();
            int size = dcInfos.length;
            for (int i = 0; i < size; ++i) {
                String dataCenterName = dcInfos[i][0];
                String solutionName = dcInfos[i][1];
                try {
                    logger.info((Object)("BOS workflow service starting. AIS:" + dataCenterName + ". Solution:" + solutionName));
                    WfEngine engine = WfEngine.getEngine(dataCenterName, solutionName);
                    logger.info((Object)("BOS workflow service start successed! Server:" + engine.getServerKey() + ". AIS:" + dataCenterName + ". Solution:" + solutionName));
                    continue;
                }
                catch (WfException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            try {
                Class<?> clazz = Class.forName("com.kingdee.bos.search.lucene.LuceneBoot");
                Object[] param = new Class[]{};
                Method method = clazz.getMethod("boot", (Class<?>[])param);
                method.invoke(clazz, param);
            }
            catch (Exception e) {
                logger.error((Object)"lucene\u670d\u52a1\u521d\u59cb\u5931\u8d25", (Throwable)e);
            }
            return null;
        }
    }
}

