/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.metas.ActInstCollection;
import com.kingdee.bos.workflow.metas.ActInstHstCollection;
import com.kingdee.bos.workflow.metas.ActInstHstInfo;
import com.kingdee.bos.workflow.metas.ActInstInfo;
import com.kingdee.bos.workflow.metas.DataTypeEnum;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.store.AbstractBaseStorer;
import com.kingdee.bos.workflow.store.StoreManager;
import com.kingdee.bos.workflow.store.util.StoreUtil;
import com.kingdee.bos.workflow.store.util.StoreUtils;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.ConvertUtils;
import com.kingdee.util.SerializableByteArrayInputStream;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ActivityStorer
extends AbstractBaseStorer {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.store.ActivityStorer");

    ActivityStorer(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActInstCollection getActInstInfoCollection(String oql) throws SQLException, DataAccessException {
        Connection cn = null;
        try {
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.ACTIVITYINSTBOT, cn);
            IObjectCollection oc = ormdao.getCollection(oql);
            ActInstCollection aic = (ActInstCollection)oc;
            if (aic != null && aic.size() > 0) {
                ActInstCollection actInstCollection = aic;
                return actInstCollection;
            }
            ActInstCollection actInstCollection = null;
            return actInstCollection;
        }
        finally {
            this.cleanup(cn);
        }
    }

    private ActivityInstInfo getActivityInstInfo(String oql) throws SQLException, DataAccessException {
        ActInstCollection aic = this.getActInstInfoCollection(oql);
        if (aic != null && aic.size() > 0) {
            ActInstInfo aii = aic.get(0);
            ActivityInstInfo aiiex = new ActivityInstInfo(aii);
            return aiiex;
        }
        return null;
    }

    public static ActInstInfo buildNewActInstInfo(Context ctx, WfProcess procInst, ActivityDef actDef, String[] fromActList, String[] preActList, boolean isRedo, int sequence, String groupName, String performerList, String parentActInstId) {
        Locale[] localArray = ApplicationUtil.getContextLocales((Context)ctx);
        ProcessDef procDef = procInst.getDefinition();
        ActInstInfo actInstInfo = new ActInstInfo();
        actInstInfo.setParentActInstId(parentActInstId);
        for (int i = 0; i <= localArray.length - 1; ++i) {
            Locale lcl = localArray[i];
            actInstInfo.setActDefName(actDef.getName(lcl), lcl);
            actInstInfo.setProcDefName(procDef.getName(lcl), lcl);
        }
        BOSUuid aiiid = BOSUuid.create((BOSObjectType)WfBOSObjectTypeUtil.ACTIVITYINSTBOT);
        actInstInfo.setActInstID(aiiid);
        actInstInfo.setState(WfState.NOT_STARTED);
        actInstInfo.setInited(0);
        actInstInfo.setProcInstID(BOSUuid.read((String)procInst.getId()));
        actInstInfo.setActDefID(BOSUuid.read((String)actDef.getID()));
        actInstInfo.setProcDefID(BOSUuid.read((String)procDef.getID()));
        actInstInfo.setProcDefHash(procDef.getDocHash());
        actInstInfo.setLastStateTime(new Timestamp(System.currentTimeMillis()));
        actInstInfo.setCreatedTime(new Timestamp(System.currentTimeMillis()));
        if (procDef.getProcessHeader().getLimit() != null) {
            actInstInfo.setTimeUnit(procDef.getProcessHeader().getLimit().getDurationUnit().getValue());
            actInstInfo.setLimit(procDef.getProcessHeader().getLimit().getDuration());
        }
        actInstInfo.setSequence(sequence);
        actInstInfo.setAssignOption(0);
        actInstInfo.setAcceptOption(0);
        if (fromActList != null && fromActList.length > 0) {
            String fail = StringUtils.arrayToString((Object[])fromActList, (String)",");
            actInstInfo.setFromActInstList(fail);
        }
        if (preActList != null && preActList.length > 0) {
            String pail = StringUtils.arrayToString((Object[])preActList, (String)",");
            actInstInfo.setPreActInstList(pail);
        }
        actInstInfo.setIsRedo(ConvertUtils.toInt((boolean)isRedo));
        actInstInfo.setTransed(0);
        actInstInfo.setProcdefType(procDef.getType().getName());
        actInstInfo.setGroupName(groupName);
        actInstInfo.setPerformerList(performerList != null ? performerList : null);
        return actInstInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActInstHstCollection getActInstHstInfoCollection(String oql) throws SQLException, DataAccessException {
        Connection cn = null;
        try {
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.ACTIVITYINSTHSTBOT, cn);
            IObjectCollection oc = ormdao.getCollection(oql);
            ActInstHstCollection aic = (ActInstHstCollection)oc;
            if (aic != null && aic.size() > 0) {
                ActInstHstCollection actInstHstCollection = aic;
                return actInstHstCollection;
            }
            ActInstHstCollection actInstHstCollection = null;
            return actInstHstCollection;
        }
        finally {
            this.cleanup(cn);
        }
    }

    private ActivityInstInfo[] getActivityInstInfoArray_Hst(String oql) throws SQLException, DataAccessException {
        ActInstHstCollection aic = this.getActInstHstInfoCollection(oql);
        if (aic != null && aic.size() > 0) {
            return StoreUtils.toActivityInstInfoArray((Object[])aic.toArray());
        }
        return new ActivityInstInfo[0];
    }

    private ActivityInstInfo getActivityInstInfo_Hst(String oql) throws SQLException, DataAccessException {
        ActInstHstCollection aic = this.getActInstHstInfoCollection(oql);
        if (aic != null && aic.size() > 0) {
            ActInstHstInfo aii_hst = aic.get(0);
            ActInstInfo aii = new ActInstInfo(aii_hst.getValues());
            ActivityInstInfo aiiex = new ActivityInstInfo(aii);
            return aiiex;
        }
        return null;
    }

    private ActivityInstInfo getInstance(String activityInstId, String[] selectors, DataTypeEnum dataType) throws SQLException, DataAccessException {
        if (activityInstId == null || activityInstId.length() == 0) {
            throw new IllegalArgumentException();
        }
        String selectFields = "";
        if (selectors != null && selectors.length > 0) {
            selectFields = "select " + StringUtils.arrayToString((Object[])selectors, (String)",");
        }
        String cndtn = "(actinstID = '" + activityInstId + "')";
        String oql = selectFields + " WHERE " + cndtn;
        if (DataTypeEnum.RUNTIME.equals((Object)dataType)) {
            return this.getActivityInstInfo(oql);
        }
        if (DataTypeEnum.HISTORY.equals((Object)dataType)) {
            return this.getActivityInstInfo_Hst(oql);
        }
        throw new IllegalArgumentException();
    }

    public ActivityInstInfo[] getActivityInstInfoArray(String oql) throws SQLException, DataAccessException {
        ActInstCollection aic = this.getActInstInfoCollection(oql);
        if (aic != null && aic.size() > 0) {
            return StoreUtils.toActivityInstInfoArray((Object[])aic.toArray());
        }
        return new ActivityInstInfo[0];
    }

    public ActivityInstInfo getInstance(String activityInstId) throws SQLException, DataAccessException {
        if (activityInstId == null || activityInstId.length() == 0) {
            throw new IllegalArgumentException();
        }
        ActivityInstInfo result = this.getInstance(activityInstId, null, DataTypeEnum.RUNTIME);
        if (result == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ActivityStorer getActInstance null.ActId:" + activityInstId));
            }
            result = this.getInstance(activityInstId, null, DataTypeEnum.HISTORY);
        }
        return result;
    }

    public ActivityInstInfo getInstance(String activityInstId, String[] selectors) throws SQLException, DataAccessException {
        if (activityInstId == null || activityInstId.length() == 0) {
            throw new IllegalArgumentException();
        }
        return this.getInstance(activityInstId, selectors, DataTypeEnum.RUNTIME);
    }

    public ActivityInstInfo[] getInstance(String actDefID, String procInstID, boolean queryHistory) throws SQLException, DataAccessException {
        String cndtn = "";
        if (actDefID != null && actDefID.length() > 0) {
            if (cndtn.length() != 0) {
                cndtn = cndtn + " and ";
            }
            cndtn = cndtn + "(actDefID = '" + actDefID + "')";
        }
        if (procInstID != null && procInstID.length() > 0) {
            if (cndtn.length() != 0) {
                cndtn = cndtn + " and ";
            }
            cndtn = cndtn + "(procInstID = '" + procInstID + "')";
        }
        String oql = "";
        if (cndtn.length() > 0) {
            oql = "WHERE " + cndtn + "order by createdTime";
        }
        ActivityInstInfo[] result = this.getActivityInstInfoArray(oql);
        if (queryHistory && result.length == 0) {
            result = this.getActivityInstInfoArray_Hst(oql);
        }
        return result;
    }

    public ActivityInstInfo getInstance(String activityInstId, boolean queryHistory) throws SQLException, DataAccessException {
        if (activityInstId == null || activityInstId.length() == 0) {
            throw new IllegalArgumentException();
        }
        ActivityInstInfo resultRuntime = this.getInstance(activityInstId);
        if (queryHistory && resultRuntime == null) {
            ActivityInstInfo resultHistory = this.getInstance(activityInstId, null, DataTypeEnum.HISTORY);
            return resultHistory;
        }
        return resultRuntime;
    }

    public ActivityInstInfo[] getInstanceListByProcInstId(String procInstId, DataTypeEnum dataType) throws SQLException, DataAccessException {
        if (procInstId == null || procInstId.length() == 0) {
            throw new IllegalArgumentException();
        }
        String cndtn = "(procinstID = '" + procInstId + "')";
        String oql = "WHERE " + cndtn + "order by createdTime";
        if (DataTypeEnum.RUNTIME.equals((Object)dataType)) {
            return this.getActivityInstInfoArray(oql);
        }
        if (DataTypeEnum.HISTORY.equals((Object)dataType)) {
            return this.getActivityInstInfoArray_Hst(oql);
        }
        throw new IllegalArgumentException();
    }

    public ActivityInstInfo[] getInstanceListByProcInstId(String procInstId) throws SQLException, DataAccessException {
        if (procInstId == null || procInstId.length() == 0) {
            throw new IllegalArgumentException();
        }
        return this.getInstanceListByProcInstId(procInstId, DataTypeEnum.RUNTIME);
    }

    public ActivityInstInfo[] getInstanceListByProcInstId(String procInstId, boolean queryHistory) throws SQLException, DataAccessException {
        if (procInstId == null || procInstId.length() == 0) {
            throw new IllegalArgumentException();
        }
        ActivityInstInfo[] resultRuntime = this.getInstanceListByProcInstId(procInstId);
        if (queryHistory && (resultRuntime == null || resultRuntime.length == 0)) {
            ActivityInstInfo[] resultHistory = this.getInstanceListByProcInstId(procInstId, DataTypeEnum.HISTORY);
            return resultHistory;
        }
        return resultRuntime;
    }

    public void setActInstState(String actInstId, String state) throws SQLException, DataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            String sql = state.startsWith("close") ? "UPDATE T_WFR_ACTINST SET FSTATE = ?, FCOMLETETIME = ? WHERE (FACTINSTID = ?)" : "UPDATE T_WFR_ACTINST SET FSTATE = ? WHERE (FACTINSTID = ?)";
            int paramIndex = 1;
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(paramIndex++, state);
            if (state.startsWith("close")) {
                stmt.setTimestamp(paramIndex++, new Timestamp(System.currentTimeMillis()));
            }
            stmt.setString(paramIndex++, actInstId);
            int updateCount = stmt.executeUpdate();
            if (updateCount != 1) {
                throw new SQLException("not such activityInst, actInst id '" + actInstId + "'");
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                StoreManager.cleanup(stmt, conn);
                throw throwable;
            }
        }
        StoreManager.cleanup(stmt, conn);
        this.notifyDataChangeByActId(actInstId, "setActInstState", new Class[]{String.class, String.class}, new Object[]{actInstId, state});
    }

    public void setActInstInited(String actInstId, boolean value) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            String sql = "UPDATE T_WFR_ACTINST SET FINITED = ? WHERE (FACTINSTID = ?)";
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setInt(1, value ? 1 : 0);
            stmt.setString(2, actInstId);
            int updateCount = stmt.executeUpdate();
            if (updateCount != 1) {
                throw new SQLException("not such activityInst, actInst id '" + actInstId + "'");
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                StoreManager.cleanup(stmt, conn);
                throw throwable;
            }
        }
        StoreManager.cleanup(stmt, conn);
        this.notifyDataChangeByActId(actInstId, "setActInstInited", new Class[]{String.class, Boolean.TYPE}, new Object[]{actInstId, value});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActInstTransInfo(String actInstId, String[] toActInstList, String[] postActInstList) throws SQLException, DataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            String sql = "UPDATE T_WFR_ACTINST SET FTOACTINSTLIST = ?, FPOSTACTINSTLIST = ? WHERE (FACTINSTID = ?)";
            if (log.isDebugEnabled()) {
                log.debug((Object)sql);
            }
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, toActInstList == null ? "" : StringUtils.arrayToString((Object[])toActInstList, (String)","));
            stmt.setString(2, postActInstList == null ? "" : StringUtils.arrayToString((Object[])postActInstList, (String)","));
            stmt.setString(3, actInstId);
            int updateCount = stmt.executeUpdate();
            if (updateCount != 1) {
                throw new SQLException("not such activityInst, actInst id '" + actInstId + "'");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("update toactlist.toActLists:" + StringUtils.arrayToString((Object[])toActInstList, (String)",") + " actInstid:" + actInstId));
            }
        }
        catch (Throwable throwable) {
            StoreManager.cleanup(stmt, conn);
            throw throwable;
        }
        StoreManager.cleanup(stmt, conn);
        this.notifyDataChangeByActId(actInstId, "setActInstTransInfo", new Class[]{String.class, String[].class, String[].class}, new Object[]{actInstId, toActInstList, postActInstList});
    }

    public void setActInstSubProcInstId(String actInstId, String subProcInstId) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            String sql = "UPDATE T_WFR_ACTINST SET FSUBPROCINSTID = ? WHERE (FACTINSTID = ?)";
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, subProcInstId);
            stmt.setString(2, actInstId);
            int updateCount = stmt.executeUpdate();
            if (updateCount != 1) {
                throw new SQLException("not such activityInst, actInst id '" + actInstId + "'");
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                StoreManager.cleanup(stmt, conn);
                throw throwable;
            }
        }
        StoreManager.cleanup(stmt, conn);
    }

    public void setActInstPerformerList(String actInstId, String performerInfoList) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            String sql = "UPDATE T_WFR_ACTINST SET FPERFORMERLIST = ? WHERE (FACTINSTID = ?)";
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, performerInfoList);
            stmt.setString(2, actInstId);
            int updateCount = stmt.executeUpdate();
            if (updateCount != 1) {
                throw new SQLException("not such activityInst, actInst id '" + actInstId + "'");
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                StoreManager.cleanup(stmt, conn);
                throw throwable;
            }
        }
        StoreManager.cleanup(stmt, conn);
        this.notifyDataChangeByActId(actInstId, "setActInstPerformerList", new Class[]{String.class, String.class}, new Object[]{actInstId, performerInfoList});
    }

    public void addNewBatch(List actInstInfos) throws WfException {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("INSERT INTO T_WFR_ACTINST (FACTINSTID, ").append(" FSTATE, FINITED, FPROCINSTID, FACTDEFID,").append(" FACTDEFNAME_L1, FACTDEFNAME_L2, FACTDEFNAME_L3, ").append(" FPROCDEFID, FPROCDEFNAME_L1, FPROCDEFNAME_L2, FPROCDEFNAME_L3, ").append(" FPROCDEFHASH, FCOMLETETIME, FLASTSTATETIME, ").append(" FCREATEDTIME, FTIMEUNIT, FLIMIT,  FWORKINGTIME, FWAITTINGTIME, FDURATION, ").append(" FEXTATTR, FSEQUENCE, FASSIGNOPTION,  FACCEPTOPTION, ").append(" FFROMACTINSTLIST, FPREACTINSTLIST, FISREDO, FTOACTINSTLIST, ").append(" FPOSTACTINSTLIST, FTRANSED, FSUBPROCINSTID, FPERFORMERLIST, ").append(" FPROCDEFTYPE, FGROUPNAME, FPRIORITY, FPARENTACTINSTID, FDEADLINETIME) VALUES ").append("(?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?,?)");
        Connection cn = null;
        PreparedStatement ps = null;
        try {
            cn = this.getConnection();
            ps = cn.prepareStatement(stringBuffer.toString());
            Locale l1 = new Locale("l1");
            Locale l2 = new Locale("l2");
            Locale l3 = new Locale("l3");
            int size = actInstInfos.size();
            for (int i = 0; i < size; ++i) {
                ActInstInfo actInstInfo = (ActInstInfo)actInstInfos.get(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ActivityStorer addNewBatch(" + (i + 1) + "/" + size + "): id:" + actInstInfo.getActInstID().toString()));
                }
                ps.setString(1, actInstInfo.getActInstID().toString());
                ps.setString(2, actInstInfo.getState().getValue());
                ps.setInt(3, actInstInfo.getInited());
                ps.setString(4, actInstInfo.getProcInstID().toString());
                ps.setString(5, actInstInfo.getActDefID().toString());
                if (StringUtils.isEmpty((String)actInstInfo.getActDefName(l1))) {
                    ps.setNull(6, 12);
                } else {
                    ps.setString(6, actInstInfo.getActDefName(l1));
                }
                if (StringUtils.isEmpty((String)actInstInfo.getActDefName(l2))) {
                    ps.setNull(7, 12);
                } else {
                    ps.setString(7, actInstInfo.getActDefName(l2));
                }
                if (StringUtils.isEmpty((String)actInstInfo.getActDefName(l3))) {
                    ps.setNull(8, 12);
                } else {
                    ps.setString(8, actInstInfo.getActDefName(l3));
                }
                ps.setString(9, actInstInfo.getProcDefID().toString());
                if (StringUtils.isEmpty((String)actInstInfo.getProcDefName(l1))) {
                    ps.setNull(10, 12);
                } else {
                    ps.setString(10, actInstInfo.getProcDefName(l1));
                }
                if (StringUtils.isEmpty((String)actInstInfo.getProcDefName(l2))) {
                    ps.setNull(11, 12);
                } else {
                    ps.setString(11, actInstInfo.getProcDefName(l2));
                }
                if (StringUtils.isEmpty((String)actInstInfo.getProcDefName(l3))) {
                    ps.setNull(12, 12);
                } else {
                    ps.setString(12, actInstInfo.getProcDefName(l3));
                }
                ps.setString(13, actInstInfo.getProcDefHash());
                if (actInstInfo.getComleteTime() == null) {
                    ps.setNull(14, 93);
                } else {
                    ps.setTimestamp(14, actInstInfo.getComleteTime());
                }
                ps.setTimestamp(15, actInstInfo.getLastStateTime());
                ps.setTimestamp(16, actInstInfo.getCreatedTime());
                ps.setInt(17, actInstInfo.getTimeUnit());
                ps.setInt(18, actInstInfo.getLimit());
                ps.setInt(19, actInstInfo.getWorkingTime());
                ps.setInt(20, actInstInfo.getWaitingTime());
                ps.setInt(21, actInstInfo.getDuration());
                if (actInstInfo.getExtattr() == null) {
                    ps.setBytes(22, null);
                } else {
                    ps.setBinaryStream(22, (InputStream)new SerializableByteArrayInputStream(actInstInfo.getExtattr()), actInstInfo.getExtattr().length);
                }
                ps.setInt(23, actInstInfo.getSequence());
                ps.setInt(24, actInstInfo.getAssignOption());
                ps.setInt(25, actInstInfo.getAcceptOption());
                ps.setString(26, actInstInfo.getFromActInstList());
                ps.setString(27, actInstInfo.getPreActInstList());
                ps.setInt(28, actInstInfo.getIsRedo());
                ps.setString(29, actInstInfo.getToActInstList());
                ps.setString(30, actInstInfo.getPostActInstList());
                ps.setInt(31, actInstInfo.getTransed());
                if (StringUtils.isEmpty((String)actInstInfo.getSubProcInstID())) {
                    ps.setNull(32, 12);
                } else {
                    ps.setString(32, actInstInfo.getSubProcInstID());
                }
                ps.setString(33, actInstInfo.getPerformerList());
                if (StringUtils.isEmpty((String)actInstInfo.getProcdefType())) {
                    ps.setNull(34, 12);
                } else {
                    ps.setString(34, actInstInfo.getProcdefType());
                }
                if (StringUtils.isEmpty((String)actInstInfo.getGroupName())) {
                    ps.setNull(35, 12);
                } else {
                    ps.setString(35, actInstInfo.getGroupName());
                }
                ps.setInt(36, actInstInfo.getPriority());
                if (StringUtils.isEmpty((String)actInstInfo.getParentActInstId())) {
                    ps.setNull(37, 12);
                } else {
                    ps.setString(37, actInstInfo.getParentActInstId());
                }
                Timestamp deadlineTime = actInstInfo.getDeadlineTime();
                if (deadlineTime == null) {
                    ps.setNull(38, 93);
                } else {
                    ps.setTimestamp(38, deadlineTime);
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
        this.notifyBatchDataChange(actInstInfos, "addNewBatch");
    }

    private void notifyBatchDataChange(List actInfos, String methodName) {
        if (this.isEnableListen()) {
            ProcessDefInfo def = StoreUtil.getProcessDefInfo(actInfos, this.getContext());
            this.setDataChanged(StoreUtil.generateTransDataByProcessDefInfo(this, this.getContext(), methodName, new Class[]{List.class}, new Object[]{actInfos}, def));
        }
    }

    private void notifyDataChangeByActId(String actInstId, String methodName, Class[] types, Object[] params) {
        if (this.isEnableListen()) {
            ProcessDef def = StoreUtil.getProcessDefByActInstID(actInstId, this.getContext());
            this.setDataChanged(StoreUtil.generateTransDataByProcessDef(this, this.getContext(), methodName, types, params, def));
        }
    }
}

