/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.google.common.collect.Lists;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.store.StoreManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;

public class OperateDataUtils {
    private static final Logger logger = Logger.getLogger(OperateDataUtils.class);
    protected StoreManager storeManager;
    private static final AtomicBoolean running = new AtomicBoolean(false);

    public OperateDataUtils(StoreManager sm) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fixLatestAssign(Context ctx, String firstTime) {
        if (running.get()) {
            logger.error((Object)" is running!");
            return;
        }
        try {
            running.set(true);
            Date curDate = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            Date firstDate = null;
            if (StringUtils.isNotBlank((CharSequence)firstTime)) {
                firstDate = dateFormat.parse(firstTime);
            } else {
                Timestamp firstCreatedtime = null;
                String sql0 = "select top 1 fcreatedtime from T_WFR_ASSIGNDETAIL order by fcreatedtime";
                IRowSet rs0 = DbUtil.executeQuery((Context)ctx, (String)sql0);
                while (rs0.next()) {
                    firstCreatedtime = rs0.getTimestamp("fcreatedtime");
                }
                if (firstCreatedtime != null) {
                    firstDate = firstCreatedtime;
                }
            }
            while (!curDate.before(firstDate)) {
                Date lastMonthDate = DateUtils.addMonths((Date)curDate, (int)-1);
                String curDateStr = dateFormat.format(curDate);
                String lastMonthDateStr = dateFormat.format(lastMonthDate);
                String bt = "{ts'" + lastMonthDateStr + "'}";
                String et = "{ts'" + curDateStr + "'}";
                logger.error((Object)("\u5f00\u59cb\u8c03\u7528deal() , firstDate = " + dateFormat.format(firstDate) + " bt = " + lastMonthDateStr + " , et = " + curDateStr));
                OperateDataUtils.deal(ctx, bt, et);
                curDate = lastMonthDate;
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u591a\u6761\u5df2\u529e\u53ea\u663e\u793a\u6700\u65b0\u4e00\u6761\u8bb0\u5f55\u5904\u7406\u5386\u53f2\u6570\u636e\u51fa\u73b0\u5f02\u5e38, err : ", (Throwable)e);
        }
        finally {
            running.set(false);
        }
    }

    public static void deal(Context ctx, String bt, String et) {
        try {
            String sql = "SELECT distinct fprocinstid FROM  T_WFR_ASSIGNDETAIL where fcreatedtime > " + bt + " and fcreatedtime <= " + et;
            HashSet<String> proinstIds = new HashSet<String>();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                proinstIds.add(rs.getString("fprocinstid"));
            }
            if (proinstIds.size() < 1) {
                return;
            }
            ArrayList list = Lists.newArrayList(proinstIds);
            proinstIds.clear();
            List procList = Lists.partition((List)list, (int)200);
            for (List procSubList : procList) {
                HashMap rsMap = new HashMap();
                String sql1 = "SELECT fassignid assignid, fcreatedtime createdtime, fpersonuserid personuserid, fprocinstid procinstid  FROM  T_WFR_ASSIGNDETAIL where fprocinstid in (";
                Object[] params1 = new Object[procSubList.size()];
                for (int i = 0; i < procSubList.size(); ++i) {
                    sql1 = sql1 + "?,";
                    params1[i] = procSubList.get(i);
                }
                sql1 = sql1 + ")";
                IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.replace(",)", ")"), (Object[])params1);
                while (rs1.next()) {
                    HashMap<String, Object> assignMap = new HashMap<String, Object>();
                    String procinstid = rs1.getString("procinstid");
                    String personuserid = rs1.getString("personuserid");
                    String assignid = rs1.getString("assignid");
                    assignMap.put("procinstid", procinstid);
                    assignMap.put("personuserid", personuserid);
                    assignMap.put("createdtime", rs1.getTimestamp("createdtime"));
                    assignMap.put("assignid", assignid);
                    if (!rsMap.containsKey(procinstid)) {
                        ArrayList rsList = new ArrayList();
                        rsMap.put(procinstid, rsList);
                    }
                    ((List)rsMap.get(procinstid)).add(assignMap);
                }
                logger.error((Object)("\u5df2\u529e\u4efb\u52a1\u8bb0\u5f55\u5904\u7406\u6d41\u7a0b\u5b9e\u4f8b\u603b\u6570 \uff1a " + rsMap.keySet().size()));
                ArrayList<String> assigns = new ArrayList<String>();
                for (String procinstId : rsMap.keySet()) {
                    List assignDetails = (List)rsMap.get(procinstId);
                    HashMap userAssignDetails = new HashMap();
                    for (Map assignDetail : assignDetails) {
                        String personuserid = (String)assignDetail.get("personuserid");
                        if (!userAssignDetails.containsKey(personuserid)) {
                            userAssignDetails.put(personuserid, new ArrayList());
                        }
                        ((List)userAssignDetails.get(personuserid)).add(assignDetail);
                    }
                    for (String personuserid : userAssignDetails.keySet()) {
                        List details = (List)userAssignDetails.get(personuserid);
                        if (details.size() < 2) continue;
                        Collections.sort(details, new Comparator<Map<String, Object>>(){

                            @Override
                            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                                return ((Date)o2.get("createdtime")).compareTo((Date)o1.get("createdtime"));
                            }
                        });
                        for (int i = 1; i < details.size(); ++i) {
                            String assignid = (String)((Map)details.get(i)).get("assignid");
                            assigns.add(assignid);
                        }
                    }
                }
                logger.error((Object)("\u5df2\u529e\u4efb\u52a1\u8bb0\u5f55\u5f85\u5904\u7406\u4efb\u52a1\u603b\u6570 \uff1a " + assigns.size()));
                if (assigns.size() <= 0) continue;
                List partition = Lists.partition(assigns, (int)100);
                for (List subList : partition) {
                    String upSql = "update T_WFR_ASSIGNDETAIL set flatestAssign = 0 where fassignid in (";
                    Object[] params = new Object[subList.size()];
                    for (int i = 0; i < subList.size(); ++i) {
                        String assign = (String)subList.get(i);
                        params[i] = assign;
                        upSql = upSql + "?,";
                    }
                    upSql = upSql + ")";
                    DbUtil.execute((Context)ctx, (String)upSql.replace(",)", ")"), (Object[])params);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"deal() -- \u591a\u6761\u5df2\u529e\u53ea\u663e\u793a\u6700\u65b0\u4e00\u6761\u8bb0\u5f55\u5904\u7406\u5386\u53f2\u6570\u636e\u51fa\u73b0\u5f02\u5e38, err : ", (Throwable)e);
        }
    }

    public static boolean initRunnigFlag() {
        return running.getAndSet(false);
    }
}

