/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.transaction;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.cache.IWfCacheManager;
import java.util.HashSet;
import java.util.Set;

public class TxProcessMgr {
    private final Set txProcessIDs;
    private final Context context;

    public TxProcessMgr(Context context) {
        this.context = context;
        this.txProcessIDs = new HashSet();
    }

    public void addTxProcessID(String processId) {
        this.txProcessIDs.add(processId);
    }

    public Set getTxProcessIDs() {
        return this.txProcessIDs;
    }

    public void notfiyCacheChange() throws WfException {
        WfEngine engine = WfEngine.getEngine(this.context);
        IWfCacheManager cacheManager = engine.getCacheManager();
        for (String procInstId : this.txProcessIDs) {
            cacheManager.notifyProcessInstChange(procInstId);
        }
    }

    public void removeFromCache() throws WfException {
        WfEngine engine = WfEngine.getEngine(this.context);
        IWfCacheManager cacheManager = engine.getCacheManager();
        for (String processID : this.txProcessIDs) {
            cacheManager.removeProcessInst(processID);
        }
    }
}

