/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.wfdesigner.service.IDCService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.log4j.Logger;

public class DCServiceHelper {
    private static final Logger logger = Logger.getLogger(DCServiceHelper.class);
    private static final String DCSERVICE_CLASS_NAME = "com.kingdee.eas.framework.app.workflow.DCService";
    private static final String DCINFO_CLASS_NAME = "com.kingdee.eas.base.common.DCInfo";

    private static IDCService getDCService() throws WfException {
        IDCService service = null;
        try {
            service = (IDCService)DCServiceHelper.newInstanceWithDefConstructor(DCSERVICE_CLASS_NAME);
        }
        catch (Exception e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
        return service;
    }

    private static Class getClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    private static Object newInstanceWithDefConstructor(String className) throws Exception {
        Class clazz = DCServiceHelper.getClass(className);
        return clazz.newInstance();
    }

    public static String[][] getDCInfos() throws WfException {
        String[][] dcInfos = null;
        try {
            IDCService service = DCServiceHelper.getDCService();
            List dcs = service.getDataCenters();
            if (dcs != null) {
                int size = dcs.size();
                dcInfos = new String[size][2];
                Class classDCInfo = DCServiceHelper.getClass(DCINFO_CLASS_NAME);
                Method methodGetAIS = classDCInfo.getMethod("getNumber", null);
                Method methodGetSLN = classDCInfo.getMethod("getSolutionName", null);
                for (int i = 0; i < size; ++i) {
                    Object obj = dcs.get(i);
                    dcInfos[i][0] = (String)methodGetAIS.invoke(obj, null);
                    dcInfos[i][1] = (String)methodGetSLN.invoke(obj, null);
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            logger.error((Object)t.getMessage(), t);
            throw new WfException(t.getMessage(), t);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException(e.getMessage(), (Throwable)e);
        }
        return dcInfos;
    }
}

