/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.service.CannotCreateServiceManagerException;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.service.permission.metadata.BizPropertyCollection;
import com.kingdee.bos.service.permission.metadata.BizRefCollection;
import com.kingdee.bos.service.permission.metadata.BizRefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PermissionUtil {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.util.PermissionUtil");

    public static PermissionItemCollection getPermissionItemCollection(Context ctx, String packageName, String functionName, String operationName) throws BOSException {
        PermissionItemCollection permissionItemCol;
        String bizProp;
        MetaDataInfo metaInfo = new MetaDataInfo();
        try {
            FacadeInfo bo;
            FunctionObjectInfo function = MetaDataLoader.getFunction((Context)ctx, (IMetaDataPK)new MetaDataPK(packageName, functionName));
            OperationInfo operation = PermissionUtil.getOperation(function, operationName);
            PermissionInfo perm = MetaDataLoader.getPermission((Context)ctx);
            if (operation.getUiActionRef() != null) {
                String permissionItemName = PermissionUtil.getActionPermissionName(ctx, function, operation);
                for (int i = 0; i < perm.getPermissionItems().size(); ++i) {
                    if (!perm.getPermissionItems().get(i).getName().equals(permissionItemName)) continue;
                    PermissionItemCollection permissionItemCol2 = new PermissionItemCollection();
                    permissionItemCol2.add(perm.getPermissionItems().get(i));
                    return permissionItemCol2;
                }
            }
            if (operation.getFacadeObjectRef() != null) {
                bo = operation.getFacadeObjectRef();
            } else if (operation.getEntityObjectRef() != null) {
                bo = operation.getEntityObjectRef();
            } else {
                throw new BOSException("Unknow function error");
            }
            metaInfo.setName(bo.getName());
            metaInfo.setPackage(bo.getPackage());
            metaInfo.setMetaDataType(bo.getBOSType().toString());
            MethodInfo method = operation.getMethodRef();
            bizProp = method.getInnerID();
        }
        catch (BOSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException("checkPermission error. " + e.getMessage(), (Throwable)e);
        }
        try {
            permissionItemCol = PermissionUtil.findPermItem(ctx, metaInfo, bizProp);
        }
        catch (BOSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException("checkPermission error. " + e.getMessage(), (Throwable)e);
        }
        return permissionItemCol;
    }

    private static OperationInfo getOperation(FunctionObjectInfo function, String operationName) throws BOSException {
        if (function == null) {
            throw new IllegalArgumentException("function is null!");
        }
        OperationCollection operCol = function.getOperation();
        OperationInfo oper = null;
        int length = operCol.size();
        for (int i = 0; i < length; ++i) {
            if (!StringUtils.equalsIgnoreCase((String)operCol.get(i).getName(), (String)operationName)) continue;
            oper = operCol.get(i);
            break;
        }
        if (oper == null) {
            throw new DataAccessException("Cannot found status: " + operationName);
        }
        return oper;
    }

    private static String getActionPermissionName(Context ctx, FunctionObjectInfo function, OperationInfo operation) throws BOSException {
        String actionName;
        UIObjectInfo uiOI = operation.getUiActionRef().getUIObjectRef();
        ActionInfo action = PermissionUtil.getAction(uiOI, actionName = operation.getUiActionRef().getActionRefName());
        if (action == null) {
            log.error((Object)"Get UI action error!");
            return null;
        }
        String actoinName = action.getClass().getName();
        if (actoinName.indexOf("$") >= 0) {
            actoinName = actoinName.substring(actoinName.indexOf("$") + 1);
        }
        MetaDataPK actionPK = new MetaDataPK(action.getClassName());
        List list = PermissionUtil.getPermItemsByAction(ctx, new MetaDataPK(uiOI.getPackage(), uiOI.getName()), actionPK);
        if (list != null && list.size() > 0) {
            return (String)list.get(0);
        }
        return null;
    }

    private static List getPermItemsByAction(Context ctx, MetaDataPK uiMetaPK, MetaDataPK actionPK) throws BOSException {
        ArrayList<String> permItems = new ArrayList<String>();
        if (actionPK == null) {
            return permItems;
        }
        IServiceManager manager = null;
        IServiceBinder binder = null;
        try {
            manager = ServiceManagerFactory.getServiceManager();
        }
        catch (CannotCreateServiceManagerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = null;
        bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, (IMetaDataPK)uiMetaPK, (IMetaDataPK)actionPK);
        if (bind == null || bind.length <= 0) {
            return permItems;
        }
        int len = bind.length;
        for (int i = 0; i < len; ++i) {
            if (bind[i].getType() != 0) continue;
            permItems.add(bind[i].getName());
        }
        return permItems;
    }

    public static PermissionItemInfo findPermission(Context ctx, String itemName) throws BOSException {
        if (itemName == null) {
            throw new IllegalArgumentException("itemName null");
        }
        PermissionInfo perm = PermissionUtil.getPermission(ctx);
        PermissionItemCollection permItemCol = perm.getPermissionItems();
        for (int i = 0; i < permItemCol.size(); ++i) {
            if (!itemName.equalsIgnoreCase(permItemCol.get(i).getName())) continue;
            return permItemCol.get(i);
        }
        return null;
    }

    private static PermissionInfo getPermission(Context ctx) throws BOSException {
        PermissionInfo perm = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getPermission();
        return perm;
    }

    private static PermissionItemCollection findPermItem(Context ctx, MetaDataInfo metaInfo, String methodInnerID) throws BOSException {
        PermissionInfo perm = PermissionUtil.getPermission(ctx);
        PermissionItemCollection permItemCol = perm.getPermissionItems();
        PermissionItemCollection retCol = new PermissionItemCollection();
        for (int i = permItemCol.size() - 1; i >= 0; --i) {
            PermissionItemInfo permItem = permItemCol.get(i);
            BizRefCollection bizRefCol = permItem.getBizRefs();
            for (int j = bizRefCol.size() - 1; j >= 0; --j) {
                BizRefInfo bizRef = bizRefCol.get(j);
                MetaDataInfo metaRef = bizRef.getBizMetadataInfo();
                if (!metaRef.equals((Object)metaInfo)) continue;
                BizPropertyCollection bizPropCol = bizRef.getBizPropertys();
                for (int k = bizPropCol.size() - 1; k >= 0; --k) {
                    String innerID = bizPropCol.get(k).getProperty();
                    if (!innerID.equalsIgnoreCase(methodInnerID)) continue;
                    retCol.add(permItem);
                }
            }
        }
        return retCol;
    }

    private static ActionInfo getAction(UIObjectInfo uiInfo, String actionName) {
        if (uiInfo == null) {
            return null;
        }
        ActionCollection actions = uiInfo.getActions();
        ActionInfo rtnAction = null;
        if (actions != null) {
            for (int i = 0; i < actions.size(); ++i) {
                if (!actionName.equalsIgnoreCase(actions.get(i).getName())) continue;
                rtnAction = actions.get(i);
                break;
            }
            if (rtnAction == null) {
                return PermissionUtil.getAction(uiInfo.getParent(), actionName);
            }
        }
        return rtnAction;
    }

    public static Person[] usersToPersons(Context ctx, String[] userIds) throws WfException {
        WfEngine engine = WfEngine.getEngine(ctx);
        IParticipantProvider participantProvider = engine.getPariticipantProvider();
        HashMap<String, Person> map = new HashMap<String, Person>();
        for (int i = 0; i < userIds.length; ++i) {
            String userId = userIds[i];
            Person person = participantProvider.getPersonByUserId(ctx, userId);
            if (person.getEmployeeId() == null || person.getUserId() == null || map.containsKey(person.getEmployeeId())) continue;
            map.put(person.getEmployeeId(), person);
        }
        Person[] rtnValue = new Person[map.size()];
        int j = 0;
        for (Map.Entry entry : map.entrySet()) {
            rtnValue[j] = (Person)entry.getValue();
            ++j;
        }
        return rtnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context simulateLogin(Context ctx) throws BOSException {
        if (ctx == null || ctx.getCaller() == null) {
            log.error((Object)"SimulateLogin error. ctx is null.");
        }
        long time = System.currentTimeMillis();
        try {
            Class<?> contextUtilsClass = Class.forName("com.kingdee.eas.base.permission.ContextUtils");
            Method method = contextUtilsClass.getMethod("loadUserContext", Context.class);
            WfEventListenerStateManager.getInstance().disableEventListener();
            method.invoke(contextUtilsClass, ctx);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"WfEngine simulateLogin error.", (Throwable)e);
        }
        catch (SecurityException e) {
            log.error((Object)"WfEngine simulateLogin error.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"WfEngine simulateLogin error.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"WfEngine simulateLogin error.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"WfEngine simulateLogin error.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"WfEngine simulateLogin error.", (Throwable)e);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
        if (log.isDebugEnabled() && System.currentTimeMillis() - time > 1000L) {
            log.info((Object)("simulateLogin cost:" + (System.currentTimeMillis() - time) + "user:" + ctx.getUserName()));
        }
        return ctx;
    }
}

