/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.ProcessInstEventEnum;
import com.kingdee.exception.ExceptionInfo;
import com.kingdee.exception.ExceptionUtil;
import com.kingdee.exception.FriendlyBOSException;
import com.kingdee.exception.IExceptionInfoSupport;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.omg.CORBA.ORB;

public class WorkflowUtils {
    private static final Logger logger = Logger.getLogger(WorkflowUtils.class);

    public static Object invoke(String className, Object obj, String methodName, Class[] parameterTypes, Object[] args) throws Exception {
        if (StringUtils.isEmpty((String)className)) {
            String message = "\"className\" is null!";
            throw new IllegalArgumentException(message);
        }
        if (StringUtils.isEmpty((String)methodName)) {
            String message = "\"method\" is null!";
            throw new IllegalArgumentException(message);
        }
        Class<?> classInstance = Class.forName(className);
        Method method = classInstance.getMethod(methodName, parameterTypes);
        return method.invoke(obj, args);
    }

    public static TransactionManager getApusicTM() {
        try {
            InitialContext nctx = new InitialContext();
            ORB orb = (ORB)nctx.getEnvironment().get("java.naming.corba.orb");
            TransactionManager tm = (TransactionManager)orb.resolve_initial_references("TransactionManager");
            return tm;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Context getContext(WfActivity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("\"activity\" is null!");
        }
        WfEngine engine = activity.getWfEngine();
        return engine.context();
    }

    public static WfLogger getWfLogger(WfActivity activity) {
        try {
            if (activity == null) {
                throw new IllegalArgumentException("\"activity\" is null!");
            }
            return activity.getWfEngine().getWfLogger();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isFirstManpowerActivityInst(WfActivity activity) throws WfException {
        WfProcess processInst = activity.container();
        ActivityDef activityDef = activity.getDefinition();
        if (!(activityDef instanceof ManpowerActivityDef)) {
            return false;
        }
        return processInst.getDefinition().getStartupActivities().containsKey((Object)activityDef.getID());
    }

    public static String getProcessInsatId(Context ctx, String assignmentId) {
        try {
            WfEngine engine = WfEngine.getEngine(ctx);
            if (engine == null) {
                return "";
            }
            WfAssignment assignment = engine.getAssignment(assignmentId);
            if (assignment == null) {
                return "";
            }
            return assignment.getMeta().getProcInstId();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getAncestorProcInstID(Context ctx, String procInstId) throws WfException {
        WfEngine wfEngine = WfEngine.getEngine(ctx);
        String parentProcInstID = wfEngine.getProcessInst(procInstId).getProcessMeta().getParentProcInstId();
        if (StringUtils.isEmpty((String)parentProcInstID)) {
            return procInstId;
        }
        return WorkflowUtils.getAncestorProcInstID(ctx, parentProcInstID);
    }

    public static void logProcessException(String procInstId, WfEngine engine, FriendlyBOSException exception) {
        try {
            ExceptionInfo exceptionInfo = ExceptionUtil.getExceptionInfo((IExceptionInfoSupport)exception);
            if (exceptionInfo == null) {
                engine.getWfLogger().addWfProcessInstLog(LogTypeEnum.ERROR, ProcessInstEventEnum.COMMON, procInstId, StringUtils.stackToString((Exception)exception));
                return;
            }
            String exceptionName = "";
            Object[] reasons = exceptionInfo.getReasons();
            if (reasons != null) {
                exceptionName = StringUtils.arrayToString((Object[])reasons, (String)";");
            }
            String reasonMsg = ExceptionUtil.getShortMsg((IExceptionInfoSupport)exception);
            String responseMsg = "";
            Object[] responses = exceptionInfo.getResponses();
            if (responses != null) {
                responseMsg = StringUtils.arrayToString((Object[])responses, (String)";");
            }
            String stackMsg = StringUtils.stackToString((Exception)exception);
            engine.getWfLogger().logProcInstException(procInstId, exceptionName, reasonMsg, responseMsg, stackMsg);
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
        }
    }

    public static void logProcessException(String procInstId, WfEngine engine, WfException exception) {
        WorkflowUtils.logProcessException(procInstId, engine, exception, ProcessInstEventEnum.COMMON);
    }

    public static void logProcessException(String procInstId, WfEngine engine, WfException exception, ProcessInstEventEnum event) {
        try {
            if (event == null) {
                event = ProcessInstEventEnum.COMMON;
            }
            String exceptionName = "";
            String reasonMsg = "";
            String responseMsg = "";
            if (event == ProcessInstEventEnum.TOOLARGTYPENOTMATCH) {
                exceptionName = event.getAlias(engine.getLocale());
                reasonMsg = "\u81ea\u52a8\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff0c\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\u3002";
                responseMsg = "\u8bf7\u53c2\u7167\u793e\u533a\u5e2e\u52a9\u5e16\u89e3\u51b3\u3002\u68c0\u67e5\u53c2\u6570\u7c7b\u578b\uff0c\u5982\u65e0\u6cd5\u89e3\u51b3\u8bf7\u63d0\u5355\u5e76\u5907\u6ce8\u6e05\u695a\uff0c\u5230\u5de5\u4f5c\u6d41\u6a21\u5757\u8fdb\u884c\u5904\u7406\u3002";
            } else if (event == ProcessInstEventEnum.TOOLARGISEMPTY) {
                exceptionName = event.getAlias(engine.getLocale());
                reasonMsg = "\u81ea\u52a8\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff0c\u53c2\u6570\u4e3a\u7a7a\u3002";
                responseMsg = "\u8bf7\u53c2\u7167\u793e\u533a\u5e2e\u52a9\u5e16\u89e3\u51b3\u3002\u68c0\u67e5\u81ea\u52a8\u8282\u70b9\u5165\u53e3\u53c2\u6570\u914d\u7f6e\uff0c\u901a\u8fc7\u6d41\u7a0b\u5c5e\u6027\u68c0\u67e5\u53d8\u91cf\u7684\u503c\u3002";
            } else if (event == ProcessInstEventEnum.TOOLBIZFUNCTIONERROR) {
                exceptionName = event.getAlias(engine.getLocale());
                reasonMsg = "\u975e\u5de5\u4f5c\u6d41\u62a5\u9519\uff0c\u81ea\u52a8\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff0c\u4e1a\u52a1\u65b9\u6cd5\u8c03\u7528\u51fa\u9519\u3002";
                responseMsg = "\u8bf7\u53c2\u7167\u793e\u533a\u5e2e\u52a9\u5e16\u89e3\u51b3\u3002\u81ea\u52a8\u6d3b\u52a8\u3010\u8bbe\u7f6e\u5ba1\u6838\u6807\u5fd7\u3011\u6267\u884c\u65f6\u51fa\u73b0\u5f02\u5e38:\u81ea\u52a8\u4efb\u52a1  " + ExceptionUtil.getShortMsg((IExceptionInfoSupport)exception);
            } else if (event == ProcessInstEventEnum.EVALPOSTSCRIPTERROR) {
                exceptionName = event.getAlias(engine.getLocale());
                reasonMsg = "\u6267\u884c\u811a\u672c\u51fa\u9519\uff0c\u811a\u672c\u8282\u70b9\u4e3a\u3010" + exception.getArgs().get(0) + "\u3011";
                responseMsg = "\u8bf7\u53c2\u7167\u793e\u533a\u5e2e\u52a9\u5e16\u89e3\u51b3\u3002\u68c0\u67e5\u811a\u672c\u914d\u7f6e\u3002";
            } else if (event == ProcessInstEventEnum.BOTPEXECUTE) {
                reasonMsg = exceptionName = event.getAlias(engine.getLocale());
                responseMsg = "\u6267\u884cBOTP\u6d3b\u52a8\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5BOTP\u6d3b\u52a8\u3002";
            } else if (event == ProcessInstEventEnum.PARTICIPANTERROR) {
                exceptionName = event.getAlias(engine.getLocale());
                reasonMsg = "\u3010" + exception.getArgs().get(0) + "\u3011\u8282\u70b9\u627e\u4e0d\u5230\u53c2\u4e0e\u4eba\u3002";
                responseMsg = "\u8bf7\u53c2\u7167\u793e\u533a\u5e2e\u52a9\u5e16\u89e3\u51b3\u3002\u68c0\u67e5\u8282\u70b9\u914d\u7f6e\u3002";
            } else if (event == ProcessInstEventEnum.ASYNCTASK) {
                exceptionName = event.getAlias(engine.getLocale());
                reasonMsg = "\u5f02\u6b65\u4efb\u52a1\u6267\u884c\u51fa\u9519\u3002";
                responseMsg = "1\u3001\u53ef\u901a\u8fc7\u5f02\u5e38\u5806\u6808\u5206\u6790\u539f\u56e0\uff1b2\u3001\u53ef\u4f7f\u7528Administrator\u5230Web\u7aef\u5de5\u4f5c\u6d41\u76d1\u63a7->\u5916\u90e8\u670d\u52a1\u76d1\u63a7\uff0c\u67e5\u770b\u8be5\u4efb\u52a1\u8be6\u60c5\uff0c\u6216\u91cd\u65b0\u6fc0\u6d3b\u4efb\u52a1\uff1b";
            } else if (WorkflowUtils.isApproveRuleException(exception)) {
                exceptionName = "\u6ee1\u8db3\u5ba1\u6279\u89c4\u5219\u6761\u4ef6\uff0c\u6d41\u7a0b\u6302\u8d77";
                reasonMsg = "\u6ee1\u8db3\u5ba1\u6279\u89c4\u5219\u6761\u4ef6\uff0c\u6d41\u7a0b\u6302\u8d77";
                responseMsg = "\u67e5\u770b\u5ba1\u6279\u89c4\u5219\u914d\u7f6e";
            } else if (exception.getCause() != null && exception.getCause().getMessage() != null & exception.getCause().getMessage().contains("\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u8f6c\u79fb")) {
                event = ProcessInstEventEnum.TRANSITIONNOTFIND;
                reasonMsg = exceptionName = event.getAlias(engine.getLocale());
                responseMsg = "\u8bf7\u68c0\u67e5\u5404\u5206\u652f\u8bbe\u7f6e\u7684\u6761\u4ef6\u548c\u5b9e\u9645\u53c2\u6570\u3002";
            } else {
                ExceptionInfo exceptionInfo = ExceptionUtil.getExceptionInfo((IExceptionInfoSupport)exception);
                if (exceptionInfo == null) {
                    engine.getWfLogger().addWfProcessInstLog(LogTypeEnum.ERROR, event, procInstId, StringUtils.stackToString((Exception)((Object)exception)));
                    return;
                }
                Object[] reasons = exceptionInfo.getReasons();
                if (reasons != null) {
                    exceptionName = StringUtils.arrayToString((Object[])reasons, (String)";");
                }
                reasonMsg = ExceptionUtil.getShortMsg((IExceptionInfoSupport)exception);
                responseMsg = "";
                Object[] responses = exceptionInfo.getResponses();
                if (responses != null) {
                    responseMsg = StringUtils.arrayToString((Object[])responses, (String)";");
                }
            }
            String stackMsg = StringUtils.stackToString((Exception)((Object)exception));
            engine.getWfLogger().logProcInstException(procInstId, exceptionName, reasonMsg, responseMsg, stackMsg, event);
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
        }
    }

    private static boolean isApproveRuleException(WfException exception) {
        try {
            for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
                Throwable tempException;
                if (!(cause instanceof UndeclaredThrowableException) || !((tempException = ((UndeclaredThrowableException)cause).getUndeclaredThrowable()) instanceof InvocationTargetException) || (tempException = ((InvocationTargetException)tempException).getTargetException()) == null || (tempException = tempException.getCause()) == null) continue;
                return tempException.getMessage().contains("\u5ba1\u6279\u89c4\u5219\u6302\u8d77");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static void addWfProcessInstWarn(WfEngine engine, LogTypeEnum logType, ProcessInstEventEnum event, String processInstID, String extendedDescription) {
        engine.getWfLogger().addWfProcessInstWarn(logType, event, processInstID, extendedDescription);
    }
}

