/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.wfdesigner.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModule;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.workflow.wfdesigner.service.ILoginAgent;
import com.kingdee.bos.workflow.wfdesigner.service.LoginAgentException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LoginAgent
extends ORMObject
implements ILoginAgent {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.wfdesigner.service.LoginAgent");

    public LoginAgent() {
        super.registerInterface(ILoginAgent.class, (Object)this);
    }

    public LoginAgent(Context ctx) {
        super.registerInterface(ILoginAgent.class, (Object)this);
    }

    public String loginIn(String url, String slnName, String dcName, String userName, String passWord, Locale locale) throws LoginAgentException {
        ORMRPCServiceLocator.setCurrentServiceURL((String)url);
        LoginModule login = null;
        login = new LoginModule();
        LoginContext ctx = new LoginContext(userName, passWord, slnName, dcName, locale);
        try {
            return login.login(ctx);
        }
        catch (BOSLoginException bos) {
            String trace = this.getErrDetailString(bos);
            logger.error((Object)"Error", (Throwable)bos);
            if (bos.getCause() != null && "com.kingdee.eas.base.permission.BasePMException".equals(bos.getCause().getClass().getName())) {
                throw new LoginAgentException(bos.getCause().getMessage(), trace);
            }
            if (bos.getCause() != null) {
                throw new LoginAgentException(bos.getCause().getMessage(), trace);
            }
            throw new LoginAgentException("Login Error" + bos.getMessage(), trace);
        }
    }

    private String getErrDetailString(Throwable t) {
        ByteArrayOutputStream baOut = new ByteArrayOutputStream(1024);
        PrintStream ps = new PrintStream(baOut);
        t.printStackTrace(ps);
        ps.close();
        return new String(baOut.toByteArray());
    }
}

