/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.wfdesigner.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.mdo.BriefViewTreeUtil;
import com.kingdee.bos.workflow.mdo.ISimpleBriefViewTreeNodeObject;
import com.kingdee.bos.workflow.mdo.impl.SimpleBriefViewTreeNodeObject;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.bos.workflow.wfdesigner.service.ISubSystemHelper;
import com.kingdee.bos.workflow.wfdesigner.service.ISubSystemProvider;
import org.apache.log4j.Logger;

public class SubSystemHelper
extends AbstractBOSObject
implements ISubSystemHelper {
    private static Logger logger = Logger.getLogger(SubSystemHelper.class);
    private ISubSystemProvider _provider = this.loadSubSystemProvider();

    public SubSystemHelper(Context ctx) {
        super.registerInterface(ISubSystemHelper.class, (Object)this);
    }

    public SubSystemHelper() {
        super.registerInterface(ISubSystemHelper.class, (Object)this);
    }

    public BOSObjectType getType() {
        return null;
    }

    private ISubSystemProvider loadSubSystemProvider() {
        String subSystemProviderClassName = EngineConfig.getInstance().getSubSystemProvider();
        if (subSystemProviderClassName != null) {
            try {
                Class<?> subSystemProviderClass = Class.forName(subSystemProviderClassName);
                ISubSystemProvider mySubSystemProvider = (ISubSystemProvider)subSystemProviderClass.newInstance();
                return mySubSystemProvider;
            }
            catch (IllegalAccessException ex1) {
                logger.error((Object)"SubSystemProvider init error", (Throwable)ex1);
                return null;
            }
            catch (InstantiationException ex1) {
                logger.error((Object)"SubSystemProvider init error", (Throwable)ex1);
                return null;
            }
            catch (ClassNotFoundException ex1) {
                logger.error((Object)"SubSystemProvider init error", (Throwable)ex1);
                return null;
            }
        }
        return null;
    }

    public IBriefViewTreeNode getSubSystemByName(String mdbViewName, BOSObjectType[] types) {
        return this._provider.getSubSystemByName(this.getContext(), mdbViewName, types);
    }

    public ISimpleBriefViewTreeNodeObject getSubSystemByName2(String mdbViewName, BOSObjectType[] types) {
        IBriefViewTreeNode bft = this._provider.getSubSystemByName(this.getContext(), mdbViewName, types);
        SimpleBriefViewTreeNodeObject rtn = BriefViewTreeUtil.convertToSimpleBriefViewTreeNode2((IBriefViewTreeNode)bft);
        return rtn;
    }
}

