/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.microflow.adapter;

import com.kingdee.bos.Context;
import com.kingdee.bos.microflow.adapter.KScriptBindings;
import com.kingdee.bos.microflow.adapter.MessageUtil;
import com.kingdee.bos.microflow.adapter.MicroflowUtil;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.MessageSender;
import com.kingdee.bos.service.message.agent.Sender;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.model.VariableScope;
import com.kingdee.cbos.process.vm.plugin.Application;
import com.kingdee.cbos.process.vm.runtime.Execution;
import java.util.HashSet;
import java.util.Locale;

public class MessageApp
implements Application {
    private String title;
    private String body;
    private String userIds;
    private ParticipantCollection pc;

    public MessageApp(String title, String body, ParticipantCollection pc) {
        this.title = title;
        this.body = body;
        this.pc = pc;
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution<? extends Node> e) throws Exception {
        Context ctx = MicroflowUtil.getContext(e);
        String userIds = this.getUserIds(ctx);
        if (userIds.length() == 0) {
            return;
        }
        KScriptBindings bindings = new KScriptBindings(e);
        String title = MessageUtil.parse(this.title, bindings);
        String body = MessageUtil.parse(this.body, bindings);
        Message msg = this.createMessage(ctx);
        msg.setStringHeader("receiver", userIds);
        msg.setLocaleStringHeader("title", title, ctx.getLocale());
        msg.setLocaleStringHeader("body", body, ctx.getLocale());
        Sender sender = MessageSender.getInstance();
        sender.sendMessage(msg);
    }

    synchronized String getUserIds(Context ctx) throws WfException {
        if (this.userIds == null) {
            HashSet<String> users = new HashSet<String>();
            WfEngine engine = WfEngine.getEngine((Context)ctx);
            for (int i = 0; i < this.pc.size(); ++i) {
                ParticipantDef p = this.pc.get(i);
                if (p.getParticipantType() == ParticipantType.HUMAN) {
                    Person[] persons;
                    for (Person u : persons = engine.getPariticipantProvider().getPersonByEmployeeId(ctx, p.getParticipantValue())) {
                        users.add(u.getUserId());
                    }
                    continue;
                }
                throw new RuntimeException("\u5fae\u6d41\u7a0b\u53ea\u652f\u6301\u804c\u5458\u7c7b\u6d88\u606f\u63a5\u6536\u4eba\uff01");
            }
            StringBuilder sb = new StringBuilder(users.size() * 30);
            for (String uid : users) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(uid);
            }
            this.userIds = sb.toString();
        }
        return this.userIds;
    }

    private Message createMessage(Context ctx) {
        Message message = MessageFactory.newMessage();
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 50);
        message.setIntHeader("priority", 20);
        message.setIntHeader("sourceStatus", 0);
        message.setStringHeader("sender", "MicroFlow");
        message.setLocaleStringHeader("sender", "MicroFlow", new Locale("l1"));
        message.setLocaleStringHeader("sender", "\u5fae\u6d41\u7a0b", new Locale("l2"));
        message.setLocaleStringHeader("sender", "\u5fae\u6d41\u7a0b", new Locale("l3"));
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setBooleanHeader("isSendEmail", false);
        message.setBooleanHeader("isSendMobile", false);
        message.setBooleanHeader("isSendCommon", true);
        return message;
    }
}

