/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.microflow.types;

import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.util.BOSUuid;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class Util {
    static Object convert(DataType type, String s, BizEnumInfo enumInfo) {
        if (s == null || s.length() == 0) {
            return null;
        }
        if (DataType.STRING.equals((Object)type)) {
            return s;
        }
        if (DataType.BOOLEAN.equals((Object)type)) {
            return Boolean.parseBoolean(s);
        }
        if (DataType.BOSUUID.equals((Object)type)) {
            return BOSUuid.read((String)s);
        }
        if (DataType.BYTE.equals((Object)type)) {
            return Byte.parseByte(s);
        }
        if (DataType.BYTEARRAY.equals((Object)type)) {
            throw new UnsupportedOperationException("BYTEARRAY");
        }
        if (DataType.DATE.equals((Object)type)) {
            return Date.valueOf(s);
        }
        if (DataType.DECIMAL.equals((Object)type)) {
            return new BigDecimal(s);
        }
        if (DataType.DOUBLE.equals((Object)type)) {
            return Double.parseDouble(s);
        }
        if (DataType.FLOAT.equals((Object)type)) {
            return Float.valueOf(Float.parseFloat(s));
        }
        if (DataType.INTEGER.equals((Object)type)) {
            return Integer.parseInt(s);
        }
        if (DataType.LONG.equals((Object)type)) {
            return Long.parseLong(s);
        }
        if (DataType.SHORT.equals((Object)type)) {
            return Short.parseShort(s);
        }
        if (DataType.TIME.equals((Object)type)) {
            return Time.valueOf(s);
        }
        if (DataType.TIMESTAMP.equals((Object)type)) {
            return Timestamp.valueOf(s.replace('T', ' '));
        }
        if (DataType.CHAR.equals((Object)type)) {
            return Character.valueOf(s.charAt(0));
        }
        if (DataType.ENUM.equals((Object)type)) {
            return null;
        }
        if (DataType.OBJECTPK.equals((Object)type)) {
            return new ObjectStringPK(s);
        }
        throw new UnsupportedOperationException();
    }
}

