/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.adapter;

import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import com.kingdee.cbos.process.vm.runtime.ProfileLogger;
import org.apache.log4j.Logger;

public class WfProfileLogger
implements ProfileLogger {
    private static Logger logger = Logger.getLogger(WfProfileLogger.class);

    public void logBegin(FlowContext ctx) {
        StringBuilder messages = new StringBuilder();
        messages.append("---begin---");
        ctx.setTransientProperty("$profile$", (Object)messages);
    }

    public void logEnd(FlowContext ctx, String message) {
        StringBuilder messages = (StringBuilder)ctx.getTransientProperty("$profile$");
        messages.append("\r\n---end---\r\n").append(message);
        WfProcess process = Util.getWfProcess((FlowContext)ctx);
        if (process != null) {
            WfEngine engine = process.getWfEngine();
            String tmp = "00000" + ctx.getCounter();
            engine.getProfileLoader().insert(process.getId(), tmp.substring(tmp.length() - 5), messages.toString());
        } else {
            logger.info((Object)messages);
        }
    }

    public void logExecute(Execution<?> e, String message, boolean success) {
        StringBuilder messages = (StringBuilder)e.getContext().getTransientProperty("$profile$");
        messages.append("\r\n").append(message);
        if (!success) {
            messages.append(" failed!");
        }
    }
}

