/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.ws;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.microflow.MicroFlowEngine;
import com.kingdee.bos.microflow.adapter.MicroflowUtil;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.ProcessStartParam;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.engine.ws.Util;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.cbos.process.vm.model.Variable;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import com.kingdee.cbos.process.vm.utils.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProcessInvoke {
    public static String invokeMicroFlow(String dataCenter, String procCode, Document input) throws Exception {
        Context ctx = Ctx.newShadowContext((String)dataCenter);
        MicroFlowEngine engine = MicroFlowEngine.getEngine(ctx);
        Flow flow = engine.getFlow(procCode);
        Object[] params = ProcessInvoke.getInputParams(input, flow);
        FlowContext runtime = flow.newInstance();
        MicroflowUtil.setContext(runtime, ctx);
        runtime.execute(params);
        Map<String, Object> returns = ProcessInvoke.getReturns(flow, runtime);
        String serviceURL = Util.getServiceURL(dataCenter, procCode);
        Document doc = ProcessInvoke.map2xml(ctx, serviceURL, returns);
        return XmlUtil.toString((Document)doc);
    }

    private static Map<String, Object> getReturns(Flow flow, FlowContext runtime) {
        HashMap<String, Object> returns = new HashMap<String, Object>();
        List output = runtime.getOutput();
        List vars = flow.getOutputVariables();
        for (int i = 0; i < vars.size(); ++i) {
            returns.put(((Variable)vars.get(i)).getName(), output.get(i));
        }
        return returns;
    }

    private static Object[] getInputParams(Document input, Flow flow) {
        List vars = flow.getInputVariables();
        Object[] params = new Object[vars.size()];
        HashMap<String, Object> data = new HashMap<String, Object>();
        ProcessInvoke.getInput(data, input);
        for (int i = 0; i < vars.size(); ++i) {
            Variable v = (Variable)vars.get(i);
            params[i] = data.get(v.getName());
        }
        return params;
    }

    public static String invoke(String dataCenter, String procCode, Document input) throws Exception {
        Context ctx = Ctx.getDefaultContext((String)dataCenter);
        HashMap<String, Object> data = new HashMap<String, Object>();
        String op = ProcessInvoke.getInput(data, input);
        String serviceURL = Util.getServiceURL(dataCenter, procCode);
        if ("start".equals(op)) {
            String defId = Util.findProcDefId(procCode, ctx);
            if (defId != null) {
                return ProcessInvoke.startProcess(ctx, defId, data, serviceURL);
            }
        } else {
            if ("pull".equals(op)) {
                return ProcessInvoke.getOutput(ctx, data, serviceURL);
            }
            if ("state".equals(op)) {
                return ProcessInvoke.getState(ctx, data, serviceURL);
            }
        }
        return null;
    }

    private static String getOutput(Context ctx, HashMap<String, Object> data, String serviceURL) throws BOSException, WfException {
        String procInstId = (String)data.get("procInstId");
        HashMap<String, Object> output = ProcessInvoke.retrieveOutput(ctx, procInstId);
        Document doc = ProcessInvoke.map2xml(ctx, serviceURL, output);
        return XmlUtil.toString((Document)doc);
    }

    private static Document map2xml(Context ctx, String serviceURL, Map<String, Object> output) {
        String xml = "<S:Envelope xmlns:S='http://schemas.xmlsoap.org/soap/envelope/'><S:Body><ns2:pullResponse xmlns:ns2='" + serviceURL + "'><output></output></ns2:pullResponse></S:Body></S:Envelope>";
        Document doc = XmlUtil.parse((String)xml);
        Element body = XmlUtil.getChild((Element)doc.getDocumentElement(), (String)"Body");
        Element response = XmlUtil.getChild((Element)body, (String)"pullResponse");
        Element parent = XmlUtil.getChild((Element)response, (String)"output");
        for (Map.Entry<String, Object> entry : output.entrySet()) {
            Element element = doc.createElement(entry.getKey());
            parent.appendChild(element);
            Util.serialize(ctx, entry.getValue(), element);
        }
        return doc;
    }

    private static HashMap<String, Object> retrieveOutput(Context ctx, String procInstId) throws BOSException, WfException {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessInstInfo info = svc.getProcessInstInfo(procInstId);
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        output.put("_state_", info.getState());
        String hashCode = info.getProcDefHashValue();
        FormalParameterCollection params = Util.getParameters(ctx, hashCode);
        Map processContext = svc.getProcessContext(procInstId);
        for (int i = 0; i < params.size(); ++i) {
            FormalParameterDef param = params.get(i);
            if (!param.getMode().equals((Object)FormalParameterMode.OUT)) continue;
            String key = param.getName();
            Object value = processContext.get(key);
            output.put(key, value);
        }
        return output;
    }

    private static String startProcess(Context ctx, String defId, HashMap<String, Object> data, String serviceURL) throws BOSException, WfException {
        ProcessStartParam[] startParams = new ProcessStartParam[1];
        ProcessStartParam p = startParams[0] = new ProcessStartParam();
        p.setInitiatorID(ctx.getCaller().toString());
        p.setProcessDefID(defId);
        p.setProcessStartContext(data);
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        String procInstId = svc.createAndStartProcesses(startParams)[0];
        return "<S:Envelope xmlns:S='http://schemas.xmlsoap.org/soap/envelope/'><S:Body><ns2:startResponse xmlns:ns2='" + serviceURL + "'><procInstId>" + procInstId + "</procInstId></ns2:startResponse></S:Body></S:Envelope>";
    }

    private static String getState(Context ctx, HashMap<String, Object> data, String serviceURL) throws BOSException, WfException {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        String procInstId = (String)data.get("procInstId");
        String state = svc.getProcessInstInfo(procInstId).getState();
        return "<S:Envelope xmlns:S='http://schemas.xmlsoap.org/soap/envelope/'><S:Body><ns2:stateResponse xmlns:ns2='" + serviceURL + "'><state>" + state + "</state></ns2:stateResponse></S:Body></S:Envelope>";
    }

    private static String getInput(HashMap<String, Object> data, Document doc) {
        Element body = XmlUtil.getChild((Element)doc.getDocumentElement(), (String)"Body");
        Element operation = XmlUtil.getChild((Element)body, (String)"start");
        if (operation != null) {
            return ProcessInvoke.getInput4Execute(data, operation);
        }
        operation = XmlUtil.getChild((Element)body, (String)"pull");
        if (operation != null) {
            return ProcessInvoke.getInput4Pull(data, operation);
        }
        operation = XmlUtil.getChild((Element)body, (String)"state");
        if (operation != null) {
            return ProcessInvoke.getInput4State(data, operation);
        }
        return null;
    }

    private static String getInput4Pull(HashMap<String, Object> data, Element operation) {
        Element proc = XmlUtil.getChild((Element)operation, (String)"procInstId");
        if (proc == null) {
            return null;
        }
        data.put("procInstId", proc.getTextContent());
        return "pull";
    }

    private static String getInput4State(HashMap<String, Object> data, Element operation) {
        Element proc = XmlUtil.getChild((Element)operation, (String)"procInstId");
        if (proc == null) {
            return null;
        }
        data.put("procInstId", proc.getTextContent());
        return "state";
    }

    private static String getInput4Execute(HashMap<String, Object> data, Element start) {
        Element input = XmlUtil.getChild((Element)start, (String)"input");
        NodeList params = (input != null ? input : start).getChildNodes();
        ProcessInvoke.parseItems(data, params);
        return "start";
    }

    private static void parseItems(HashMap<String, Object> data, NodeList params) {
        for (int i = 0; i < params.getLength(); ++i) {
            Object value;
            Node el = params.item(i);
            if (!(el instanceof Element)) continue;
            NodeList items = el.getChildNodes();
            if (items.getLength() == 1 || items.getLength() == 0) {
                value = el.getTextContent();
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                ProcessInvoke.parseItems(map, items);
                value = map;
            }
            String key = el.getNodeName();
            Object original = data.put(key, value);
            if (original == null) continue;
            if (original instanceof List) {
                ((List)original).add(value);
                continue;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(original);
            list.add(value);
            data.put(key, list);
        }
    }
}

