/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.ws;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.ITaskServiceActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.engine.ws.ProcessXsd;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Util {
    private static final String NAME_SPACE = "http://localhost:6888/easweb/wf";

    public static String findHashCode(String procCode, Context ctx) throws BOSException {
        String sql = "select top 1 fmd5hash from t_wfr_procdef where fproccode=?  order by finnerversion desc";
        ArrayList list = SQL.executeQuery((Context)ctx, (String)sql, (int[])new int[]{12}, (Object[])new String[]{procCode});
        String procDefHash = null;
        if (list.size() == 1) {
            procDefHash = (String)((Map)list.get(0)).get("fmd5hash");
        }
        return procDefHash;
    }

    static String findProcDefId(String procCode, Context ctx) throws BOSException {
        String sql = "select top 1 fprocdefid from t_wfr_procdef where fproccode=?  order by finnerversion desc";
        ArrayList list = SQL.executeQuery((Context)ctx, (String)sql, (int[])new int[]{12}, (Object[])new String[]{procCode});
        String defId = null;
        if (list.size() == 1) {
            defId = (String)((Map)list.get(0)).get("fprocdefid");
        }
        return defId;
    }

    public static String getServiceURL(String dataCenter, String procCode) {
        return "http://localhost:6888/easweb/wf/" + dataCenter + "/" + procCode;
    }

    static FormalParameterCollection getParameters(Context ctx, String procDefHash) throws WfException {
        ProcessDef def = Util.getProcessDef(ctx, procDefHash);
        FormalParameterCollection parameters = def.getFormalParameters();
        return parameters;
    }

    static ProcessDef getProcessDef(Context ctx, String procDefHash) throws WfException {
        WfEngine engine = WfEngine.getEngine((Context)ctx);
        ProcessDef def = engine.getProcessDef(procDefHash);
        return def;
    }

    static boolean hasOutParameters(ActivityDef act) {
        FormalParameterCollection params = Util.getFormalParameters(act);
        if (params == null) {
            return false;
        }
        for (int i = 0; i < params.size(); ++i) {
            FormalParameterDef p = params.get(i);
            if (!FormalParameterMode.OUT.equals((Object)p.getMode()) || ProcessXsd.getType(p.getDataType()) == null) continue;
            return true;
        }
        return false;
    }

    static FormalParameterCollection getFormalParameters(ActivityDef act) {
        ApplicationDef app = null;
        if (act instanceof ManpowerActivityDef) {
            app = ((ManpowerActivityDef)act).getRelatedApplication();
        } else if (act instanceof EventActivityDef) {
            app = ((EventActivityDef)act).getRelatedApplication();
        } else if (act instanceof ITaskServiceActivityDef) {
            app = ((ITaskServiceActivityDef)act).getRelatedApplication();
        }
        if (app == null) {
            return null;
        }
        return app.getFormalParameters();
    }

    static void serialize(Context ctx, Object value, Element element) {
        if (value instanceof Date) {
            element.setTextContent(value.toString());
        } else if (value instanceof Time) {
            element.setTextContent(value.toString());
        } else if (value instanceof Timestamp) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss");
            element.setTextContent(sdf.format((java.util.Date)value));
        } else if (value instanceof java.util.Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            element.setTextContent(sdf.format((java.util.Date)value));
        } else if (value instanceof IObjectValue) {
            IObjectValue biz = (IObjectValue)value;
            Util.serialize(ctx, element, biz);
        } else if (value != null) {
            element.setTextContent(value.toString());
        }
    }

    private static void serialize(Context ctx, Element element, IObjectValue biz) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(biz.getBOSType());
        PropertyCollection c = entity.getPropertiesRuntime();
        Document doc = element.getOwnerDocument();
        for (int i = 0; i < c.size(); ++i) {
            PropertyInfo p = c.get(i);
            String key = p.getName();
            Element child = doc.createElement(key);
            element.appendChild(child);
            Object value = biz.get(key);
            if (value == null) continue;
            if (p instanceof OwnPropertyInfo) {
                Util.serialize(ctx, value, child);
                continue;
            }
            if (!(p instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo lp = (LinkPropertyInfo)p;
            RelationshipInfo rInfo = lp.getRelationship();
            if (rInfo.getType().equals((Object)RelationshipType.ASSOCIATION)) {
                IObjectValue ref = (IObjectValue)value;
                Object id = ref.get("id");
                Util.serialize(ctx, id, child);
                continue;
            }
            if (!rInfo.getType().equals((Object)RelationshipType.COMPOSITION) || rInfo.getSupplierObject().equals((Object)entity)) continue;
            IObjectCollection vc = (IObjectCollection)value;
            for (int j = 0; j < vc.size(); ++j) {
                IObjectValue v = vc.getObject(j);
                Util.serialize(ctx, child, v);
            }
        }
    }
}

