/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashSet;
import java.util.Set;

public class AccountBankFilterParam
extends CoreBaseInfo {
    public FilterInfo getFilter() throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        if (this.getBankIdArray() != null) {
            HashSet<String> idSet = new HashSet<String>();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterBank = new FilterInfo();
            filterBank.getFilterItems().add(new FilterItemInfo("id", (Object)this.getIdSet(this.getBankIdArray()), CompareType.INCLUDE));
            evi.setFilter(filterBank);
            BankCollection selectBanks = BankFactory.getRemoteInstance().getBankCollection(evi);
            int n = selectBanks.size();
            for (int i = 0; i < n; ++i) {
                BankInfo bank = selectBanks.get(i);
                idSet.add(bank.getId().toString());
                if (bank.isIsLeaf()) continue;
                BankCollection childBanks = BankFactory.getRemoteInstance().getAllChildBank(bank.getId().toString());
                int m = childBanks.size();
                for (int j = 0; j < m; ++j) {
                    idSet.add(childBanks.get(j).getId().toString());
                }
            }
            filterItems.add(new FilterItemInfo("bank.id", idSet, CompareType.INCLUDE));
        }
        if (!this.getIncludeClosed().booleanValue()) {
            filterItems.add(new FilterItemInfo("isClosed", (Object)new Boolean(false)));
        }
        if (!this.getIncledeUsed().booleanValue()) {
            filterItems.add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
        }
        FilterInfo filterCompany = new FilterInfo();
        if (this.getCompanyIdArray() != null && this.getCompanyIdArray().length > 0) {
            String sql = " select bd.fid from t_bd_accountbanks bd  left outer join T_BD_AcctBankTrusterEntries AS en on en.FAcctBankID=bd.fid  where " + StringUtil.buildIn((String)"bd.fcompanyid", (Object[])this.getCompanyIdArray()) + " or " + StringUtil.buildIn((String)"en.ftrustCompanyID", (Object[])this.getCompanyIdArray());
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        }
        if (filterCompany.getFilterItems().size() > 0) {
            filter.mergeFilter(filterCompany, "and");
        }
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        return null;
    }

    private Set getIdSet(String[] ids) {
        if (ids == null || ids != null && ids.length <= 0) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i]);
        }
        return idSet;
    }

    public void setCompanyIdArray(String[] companyIdArray) {
        this.put("companyIdArray", companyIdArray);
    }

    public String[] getCompanyIdArray() {
        return (String[])this.get("companyIdArray");
    }

    public void setBankIdArray(String[] bankIdArray) {
        this.put("bankIdArray", bankIdArray);
    }

    public String[] getBankIdArray() {
        return (String[])this.get("bankIdArray");
    }

    public Boolean getIncludeClosed() {
        return (Boolean)this.get("IncludeClosed");
    }

    public void setIncludeClosed(Boolean includeClosed) {
        this.put("IncludeClosed", includeClosed);
    }

    public void setIncledeUsed(Boolean incledeUsed) {
        this.put("incledeUsed", incledeUsed);
    }

    public Boolean getIncledeUsed() {
        return (Boolean)this.get("incledeUsed");
    }
}

