/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyException;
import com.kingdee.eas.basedata.assistant.DenominationCollection;
import com.kingdee.eas.basedata.assistant.DenominationInfo;
import java.math.BigDecimal;
import java.util.Hashtable;

public class DenominationUtils {
    public static void checkDenomination(DenominationInfo model) throws CurrencyException {
        if (model.getCurrency() == null) {
            throw new CurrencyException(CurrencyException.DENOMINATION_CURRENCY_IS_NULL);
        }
        if (model.getValue() == null || model.getValue().trim().equals("")) {
            throw new CurrencyException(CurrencyException.DENOMINATION_VALUE_IS_NULL);
        }
        if (model.getCoefficient() == null) {
            throw new CurrencyException(CurrencyException.DENOMINATION_COEFFICIENT_IS_NULL);
        }
        if (model.getCoefficient().compareTo(new BigDecimal("0.000")) <= 0) {
            throw new CurrencyException(CurrencyException.DENOMINATION_COEFFICIENT_MUST_GREATER_THAN_ZERO);
        }
        if (model.isIsStandardUnit() && model.getCoefficient().compareTo(new BigDecimal("1.000")) != 0) {
            throw new CurrencyException(CurrencyException.STD_DENOMINATION_COEFICIENT_MUST_EQUALS_ONE);
        }
    }

    public static void checkValueDuplicate(DenominationCollection vos) throws CurrencyException {
        if (vos != null) {
            Hashtable<String, String> table = new Hashtable<String, String>();
            for (int i = 0; i < vos.size(); ++i) {
                if (table.get(vos.get(i).getValue()) != null) {
                    table = null;
                    throw new CurrencyException(CurrencyException.DENOMINATION_VALUE_DUPLICATED, new Object[]{vos.get(i).getValue()});
                }
                table.put(vos.get(i).getValue(), vos.get(i).getValue());
            }
            Object var1_1 = null;
        }
    }

    public static void checkCoefficientDuplicate(DenominationCollection vos) throws CurrencyException {
        if (vos != null) {
            Hashtable<BigDecimal, BigDecimal> table = new Hashtable<BigDecimal, BigDecimal>();
            for (int i = 0; i < vos.size(); ++i) {
                if (table.get(vos.get(i).getCoefficient()) != null) {
                    table = null;
                    throw new CurrencyException(CurrencyException.DENOMINATION_COEFFICIENT_NOT_UNIQUE, new Object[]{vos.get(i).getCoefficient()});
                }
                table.put(vos.get(i).getCoefficient(), vos.get(i).getCoefficient());
            }
            Object var1_1 = null;
        }
    }

    public static void checkStandardDenoMustOnlyUnique(DenominationCollection vos) throws CurrencyException {
        if (vos != null && vos.size() > 0) {
            int count = 0;
            for (int i = 0; i < vos.size(); ++i) {
                if (!vos.get(i).isIsStandardUnit()) continue;
                ++count;
            }
            if (count == 0) {
                throw new CurrencyException(CurrencyException.STD_DENOMINATION_NOT_EXIST);
            }
            if (count > 1) {
                throw new CurrencyException(CurrencyException.STD_DENOMINATION_NOT_UNIQUE);
            }
        }
    }

    public static boolean isIDEquals(BOSUuid id1, BOSUuid id2) {
        return id1 == null && id2 == null || id1 != null && id2 != null && id1.toString().equals(id2.toString());
    }
}

