/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AbstractPayConditionInfo;
import com.kingdee.eas.basedata.assistant.PayConditionEntryCollection;
import com.kingdee.eas.basedata.assistant.PayConditionEntryInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeEnum;
import java.io.Serializable;
import java.math.BigDecimal;

public class PayConditionInfo
extends AbstractPayConditionInfo
implements Serializable {
    public static final int DEFAULT_PRECESION = 2;
    public static final int VERIFY_OK = 0;
    public static final int MUL_PREPAY_RATE = 1;
    public static final int RATE_NOT_EQUAL = 2;
    public static final int DATE_IS_NULL = 3;
    public static final int NO_PREPAY_ENTRY = 5;
    public static final int SUM_RATE_NOT_100 = 4;
    public static final int MIN_START_DEFER_DAYS = 0;
    public static final int MAX_START_DEFER_DAYS = 1000;
    public static final int MIN_CREDIT_DAYS = 0;
    public static final int MAX_CREDIT_DAYS = 1000;
    public static final int MIN_MONTH = 0;
    public static final int DEFAULT_MONTH = 1;
    public static final int MAX_MONTH = 100;
    public static final int MIN_DAY = 1;
    public static final int MAX_DAY = 31;
    private int verifyFailedSeq = -1;
    private static final int HALF_UP = 4;

    public PayConditionInfo() {
    }

    protected PayConditionInfo(String pkField) {
        super(pkField);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IObjectValue) {
            return super.equalsPK((IObjectValue)obj);
        }
        return false;
    }

    public int bizVerify() {
        PayConditionEntryCollection entries = this.getEntries();
        BigDecimal sumRate = new BigDecimal(0);
        int prepayEntryCount = 0;
        BigDecimal prepayRate = this.getPrepayRate();
        if (prepayRate == null) {
            prepayRate = new BigDecimal(0);
        }
        prepayRate = prepayRate.setScale(2, 4);
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            PayConditionEntryInfo entry = entries.get(i);
            BigDecimal rate = entry.getRate();
            if (rate == null) {
                rate = new BigDecimal(0);
                entry.setRate(rate);
            }
            rate = rate.setScale(2, 4);
            sumRate = sumRate.add(rate);
            if (entry.isIsPrepay()) {
                if (++prepayEntryCount > 1) {
                    return 1;
                }
                if (prepayRate.compareTo(rate) != 0) {
                    return 2;
                }
                entry.setSettlementType(SettlementTypeEnum.CREDIT);
                entry.setStartDeferDays(0);
                entry.setCreditDays(0);
                continue;
            }
            if (entry.getStartDeferDays() < 0 || entry.getStartDeferDays() > 1000) {
                entry.setStartDeferDays(0);
            }
            if (SettlementTypeEnum.MONTH.equals((Object)entry.getSettlementType())) {
                if (entry.getMonths() < 0 || entry.getMonths() > 100) {
                    entry.setMonths(1);
                }
                if (entry.getDay() >= 1 && entry.getDay() <= 31) continue;
                entry.setDay(1);
                continue;
            }
            if (!SettlementTypeEnum.DATE.equals((Object)entry.getSettlementType()) || entry.getFicedDate() != null) continue;
            this.verifyFailedSeq = i;
            return 3;
        }
        if (prepayEntryCount <= 0 && prepayRate.compareTo(new BigDecimal(0)) > 0) {
            return 5;
        }
        if (sumRate.compareTo(new BigDecimal(100)) != 0) {
            return 4;
        }
        return 0;
    }

    public int getVerifyFailedSeq() {
        return this.verifyFailedSeq;
    }

    public static FilterInfo getCompanyFilter(String companyID) {
        if (companyID == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("createOrg.id", (Object)companyID, CompareType.EQUALS));
        StringBuffer sb = new StringBuffer();
        sb.append(" select FPayConditionID from T_BD_PayConditionReference ");
        sb.append("where (FAssignCompanyID = '");
        sb.append(companyID);
        sb.append("') ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        filter.setMaskString("#0 OR #1");
        return filter;
    }

    public static FilterInfo getNotNullCompanyFilter(String companyID) {
        if (companyID == null) {
            return PayConditionInfo.getCompanyFilter("");
        }
        return PayConditionInfo.getCompanyFilter(companyID);
    }
}

