/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.IPeriodRelation;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodRelationCollection;
import com.kingdee.eas.basedata.assistant.PeriodRelationFactory;
import com.kingdee.eas.basedata.assistant.PeriodRelationInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Date;
import org.apache.log4j.Logger;

public class PeriodUtils {
    static final Logger log = Logger.getLogger(PeriodUtils.class);

    public static boolean PeriodCompare(PeriodInfo sourceperiodInfo, PeriodInfo targetperiodInfo) {
        if (sourceperiodInfo.getPeriodYear() > targetperiodInfo.getPeriodYear()) {
            return true;
        }
        if (sourceperiodInfo.getPeriodYear() == targetperiodInfo.getPeriodYear()) {
            return sourceperiodInfo.getPeriodNumber() >= targetperiodInfo.getPeriodNumber();
        }
        return false;
    }

    public static int PeriodCompare(String sourceperiodInfoId, String targetperiodInfoId) throws BOSException, EASBizException {
        if (sourceperiodInfoId == null || targetperiodInfoId == null) {
            throw new PeriodException(PeriodException.PKNOTNULL);
        }
        PeriodInfo sourceperiodInfo = null;
        PeriodInfo targetperiodInfo = null;
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        sourceperiodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(sourceperiodInfoId));
        targetperiodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(targetperiodInfoId));
        if (sourceperiodInfo.getPeriodYear() > targetperiodInfo.getPeriodYear()) {
            return 1;
        }
        if (sourceperiodInfo.getPeriodYear() == targetperiodInfo.getPeriodYear()) {
            if (sourceperiodInfo.getPeriodNumber() > targetperiodInfo.getPeriodNumber()) {
                return 1;
            }
            if (sourceperiodInfo.getPeriodNumber() == targetperiodInfo.getPeriodNumber()) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public static boolean PeriodCompare(IObjectPK sourceperiodInfoPK, IObjectPK targetperiodInfoPK) throws BOSException, EASBizException {
        if (sourceperiodInfoPK == null || targetperiodInfoPK == null) {
            throw new PeriodException(PeriodException.PKNOTNULL);
        }
        PeriodInfo sourceperiodInfo = null;
        PeriodInfo targetperiodInfo = null;
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        sourceperiodInfo = iPeriod.getPeriodInfo(sourceperiodInfoPK);
        targetperiodInfo = iPeriod.getPeriodInfo(targetperiodInfoPK);
        if (sourceperiodInfo.getPeriodYear() > targetperiodInfo.getPeriodYear()) {
            return true;
        }
        if (sourceperiodInfo.getPeriodYear() == targetperiodInfo.getPeriodYear()) {
            return sourceperiodInfo.getPeriodNumber() >= targetperiodInfo.getPeriodNumber();
        }
        return false;
    }

    public static int getPeriodCount(PeriodInfo periodInfo) throws BOSException, EASBizException {
        return PeriodUtils.getPeriodCount(periodInfo, true);
    }

    public static int getPeriodCount(PeriodInfo periodInfo, boolean hasNotAdj) throws BOSException, EASBizException {
        return PeriodUtils.getPeriodCount(null, periodInfo, hasNotAdj);
    }

    public static int getPeriodCount(Context ctx, PeriodInfo periodInfo, boolean hasNotAdj) throws BOSException, EASBizException {
        int count = 0;
        if (periodInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        if (hasNotAdj) {
            filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)new Integer(1), CompareType.NOTEQUALS));
        }
        evi.setFilter(filter);
        PeriodCollection periodc = new PeriodCollection();
        periodc = iPeriod.getPeriodCollection(evi);
        count = periodc.size();
        return count;
    }

    public static int getPeriodCount(IObjectPK periodInfoPK) throws BOSException, EASBizException {
        return PeriodUtils.getPeriodCount(periodInfoPK, true);
    }

    public static int getPeriodCount(IObjectPK periodInfoPK, boolean hasNotAdj) throws BOSException, EASBizException {
        return PeriodUtils.getPeriodCount(null, periodInfoPK, hasNotAdj);
    }

    public static int getPeriodCount(Context ctx, IObjectPK periodInfoPK, boolean hasNotAdj) throws BOSException, EASBizException {
        int count = 0;
        PeriodInfo periodInfo = null;
        if (periodInfoPK == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        periodInfo = iPeriod.getPeriodInfo(periodInfoPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        if (hasNotAdj) {
            filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)new Integer(1), CompareType.NOTEQUALS));
        }
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        SorterItemCollection sorterc = new SorterItemCollection();
        sorterc.add(new SorterItemInfo("periodNumber"));
        IObjectPK[] pks = iPeriod.getPKList(filter, sorterc);
        count = pks.length;
        return count;
    }

    public static int getPeriodQuarterCount(PeriodInfo periodInfo) throws BOSException, EASBizException {
        int periodQuarterCount = 0;
        if (periodInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)new Integer(1), CompareType.NOTEQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = new PeriodCollection();
        periodc = iPeriod.getPeriodCollection(evi);
        for (int i = 0; i < periodc.size(); ++i) {
            if (periodc.get(i).getPeriodQuarter() <= periodQuarterCount) continue;
            periodQuarterCount = periodc.get(i).getPeriodQuarter();
        }
        return periodQuarterCount;
    }

    public static int getPeriodQuarterCount(IObjectPK periodInfoPK) throws BOSException, EASBizException {
        PeriodInfo periodInfo = null;
        int periodQuarterCount = 0;
        if (periodInfoPK == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        periodInfo = iPeriod.getPeriodInfo(periodInfoPK);
        if (periodInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)new Integer(1), CompareType.NOTEQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = new PeriodCollection();
        periodc = iPeriod.getPeriodCollection(evi);
        for (int i = 0; i < periodc.size(); ++i) {
            if (periodc.get(i).getPeriodQuarter() <= periodQuarterCount) continue;
            periodQuarterCount = periodc.get(i).getPeriodQuarter();
        }
        return periodQuarterCount;
    }

    public static PeriodInfo getPrePeriodInfo(PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (periodInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo prePeriodInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodInfo.getId()));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(periodInfo.getEndDate()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() - 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = new PeriodCollection();
        periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodc.size() == 0) {
            EntityViewInfo evi1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear() - 1), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1");
            evi1.setFilter(filter1);
            evi1.getSorter().add(new SorterItemInfo("periodNumber"));
            periodc = iPeriod.getPeriodCollection(evi1);
        }
        if (periodc.size() > 0) {
            prePeriodInfo = periodc.get(periodc.size() - 1);
        }
        if (prePeriodInfo.getId() == null) {
            prePeriodInfo = null;
        }
        return prePeriodInfo;
    }

    public static PeriodInfo getPreAdjPeriodInfo(Context ctx, PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (periodInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo prePeriodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        if (periodInfo.getPeriodType() == null) {
            periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodInfo.getId()));
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear() - 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.TRUE, CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = new PeriodCollection();
        periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodc.size() == 0) {
            EntityViewInfo evi1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear() - 1), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1");
            evi1.setFilter(filter1);
            evi1.getSorter().add(new SorterItemInfo("periodNumber"));
            periodc = iPeriod.getPeriodCollection(evi1);
        }
        if (periodc.size() > 0) {
            prePeriodInfo = periodc.get(periodc.size() - 1);
        }
        if (prePeriodInfo.getId() == null) {
            prePeriodInfo = null;
        }
        return prePeriodInfo;
    }

    public static PeriodInfo getAdjPeriodInfo(Context ctx, PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (periodInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo prePeriodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        if (periodInfo.getPeriodType() == null) {
            periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodInfo.getId()));
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear() - 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.TRUE, CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = new PeriodCollection();
        periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() == 0) {
            EntityViewInfo evi1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.TRUE, CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.LESS));
            filter1.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1 and #2");
            evi1.setFilter(filter1);
            evi1.getSorter().add(new SorterItemInfo("periodYear"));
            evi1.getSorter().add(new SorterItemInfo("periodNumber"));
            periodc = iPeriod.getPeriodCollection(evi1);
        }
        if (periodc.size() > 0) {
            prePeriodInfo = periodc.get(periodc.size() - 1);
        }
        if (prePeriodInfo.getId() == null) {
            prePeriodInfo = null;
        }
        return prePeriodInfo;
    }

    public static PeriodInfo getPrePeriodInfo(IObjectPK periodInfoPK) throws BOSException, EASBizException {
        PeriodInfo periodInfo = null;
        if (periodInfoPK == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo prePeriodInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        periodInfo = iPeriod.getPeriodInfo(periodInfoPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(periodInfo.getEndDate()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() - 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = new PeriodCollection();
        periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodc.size() == 0) {
            EntityViewInfo evi1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear() - 1), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1");
            evi1.setFilter(filter1);
            evi1.getSorter().add(new SorterItemInfo("periodNumber"));
            periodc = iPeriod.getPeriodCollection(evi1);
        }
        if (periodc.size() > 0) {
            prePeriodInfo = periodc.get(periodc.size() - 1);
        }
        if (prePeriodInfo.getId() == null) {
            prePeriodInfo = null;
        }
        return prePeriodInfo;
    }

    public static PeriodInfo getPrePeriodInfo(Context ctx, PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (periodInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo prePeriodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodInfo.getId()));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(periodInfo.getEndDate()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() - 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = new PeriodCollection();
        periodc = iPeriod.getPeriodCollection(evi);
        log.debug((Object)("fi_gl.filter is :" + filter));
        log.info((Object)("fi_gl.filter is :" + filter));
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodc.size() == 0) {
            EntityViewInfo evi1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear() - 1), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1");
            evi1.setFilter(filter1);
            evi1.getSorter().add(new SorterItemInfo("periodNumber"));
            periodc = iPeriod.getPeriodCollection(evi1);
        }
        if (periodc.size() > 0) {
            prePeriodInfo = periodc.get(periodc.size() - 1);
        }
        if (prePeriodInfo.getId() == null) {
            log.info((Object)("fi_gl.filter period 0." + periodInfo));
            prePeriodInfo = null;
        }
        return prePeriodInfo;
    }

    public static PeriodInfo getPrePeriodInfo(Context ctx, IObjectPK periodInfoPK) throws BOSException, EASBizException {
        PeriodInfo periodInfo = null;
        if (periodInfoPK == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo prePeriodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        periodInfo = iPeriod.getPeriodInfo(periodInfoPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(periodInfo.getEndDate()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() - 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = new PeriodCollection();
        periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodc.size() == 0) {
            EntityViewInfo evi1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear() - 1), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1");
            evi1.setFilter(filter1);
            evi1.getSorter().add(new SorterItemInfo("periodNumber"));
            periodc = iPeriod.getPeriodCollection(evi1);
        }
        if (periodc.size() > 0) {
            prePeriodInfo = periodc.get(periodc.size() - 1);
        }
        if (prePeriodInfo.getId() == null) {
            prePeriodInfo = null;
        }
        return prePeriodInfo;
    }

    public static PeriodInfo getNextPeriodInfo(PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (periodInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo nextPeriodInfo = null;
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodInfo.getId()));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(periodInfo.getEndDate()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() + 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = new PeriodCollection();
        periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodc.size() == 0) {
            EntityViewInfo evi1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear() + 1), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("Periodnumber", (Object)new Integer(1), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1 and #2");
            evi1.setFilter(filter1);
            evi1.getSorter().add(new SorterItemInfo("periodNumber"));
            periodc = iPeriod.getPeriodCollection(evi1);
        }
        if (periodc.size() > 0) {
            nextPeriodInfo = periodc.get(0);
        }
        return nextPeriodInfo;
    }

    public static PeriodInfo getNextPeriodInfo(IObjectPK periodInfoPK) throws BOSException, EASBizException {
        PeriodInfo periodInfo = null;
        if (periodInfoPK == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo nextPeriodInfo = null;
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        periodInfo = iPeriod.getPeriodInfo(periodInfoPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(periodInfo.getEndDate()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() + 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = new PeriodCollection();
        periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodc.size() == 0) {
            EntityViewInfo evi1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear() + 1), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("Periodnumber", (Object)new Integer(1), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1 and #2");
            evi1.setFilter(filter1);
            evi1.getSorter().add(new SorterItemInfo("periodNumber"));
            periodc = iPeriod.getPeriodCollection(evi1);
        }
        if (periodc.size() > 0) {
            nextPeriodInfo = periodc.get(0);
        }
        return nextPeriodInfo;
    }

    public static PeriodInfo getNextPeriodInfo(Context ctx, PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (periodInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo nextPeriodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodInfo.getId()));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(periodInfo.getEndDate()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() + 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = new PeriodCollection();
        periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodc.size() == 0) {
            EntityViewInfo evi1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear() + 1), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("Periodnumber", (Object)new Integer(1), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1 and #2");
            evi1.setFilter(filter1);
            evi1.getSorter().add(new SorterItemInfo("periodNumber"));
            periodc = iPeriod.getPeriodCollection(evi1);
        }
        if (periodc.size() > 0) {
            nextPeriodInfo = periodc.get(0);
        }
        return nextPeriodInfo;
    }

    public static PeriodInfo getNextPeriodInfo(Context ctx, IObjectPK periodInfoPK) throws BOSException, EASBizException {
        PeriodInfo periodInfo = null;
        if (periodInfoPK == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo nextPeriodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        periodInfo = iPeriod.getPeriodInfo(periodInfoPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(periodInfo.getEndDate()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() + 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = new PeriodCollection();
        periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodc.size() == 0) {
            EntityViewInfo evi1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear() + 1), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("Periodnumber", (Object)new Integer(1), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1 and #2");
            evi1.setFilter(filter1);
            evi1.getSorter().add(new SorterItemInfo("periodNumber"));
            periodc = iPeriod.getPeriodCollection(evi1);
        }
        if (periodc.size() > 0) {
            nextPeriodInfo = periodc.get(0);
        }
        return nextPeriodInfo;
    }

    public static boolean isLastPeriodInfo(PeriodInfo periodInfo) throws BOSException {
        boolean isLastPeriod = false;
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() + 1), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() == 0) {
            isLastPeriod = true;
        }
        return isLastPeriod;
    }

    public static boolean isLastPeriodInfo(IObjectPK periodInfoPK) throws BOSException, EASBizException {
        PeriodInfo periodInfo = null;
        boolean isLastPeriod = false;
        if (periodInfoPK == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        periodInfo = iPeriod.getPeriodInfo(periodInfoPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() + 1), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() == 0) {
            isLastPeriod = true;
        }
        return isLastPeriod;
    }

    public static boolean isLastPeriodInfoWithOutAdj(IObjectPK periodInfoPK) throws BOSException, EASBizException {
        PeriodInfo periodInfo = null;
        boolean isLastPeriod = false;
        if (periodInfoPK == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        periodInfo = iPeriod.getPeriodInfo(periodInfoPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() + 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.FALSE, CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() == 0) {
            isLastPeriod = true;
        }
        return isLastPeriod;
    }

    public static boolean isAdjOfNext(IObjectPK periodInfoPK) throws BOSException, EASBizException {
        PeriodInfo periodInfo = null;
        boolean isLastPeriod = false;
        if (periodInfoPK == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        periodInfo = iPeriod.getPeriodInfo(periodInfoPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() + 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.TRUE, CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            isLastPeriod = true;
        }
        return isLastPeriod;
    }

    public static boolean isExitAdjOfLastYear(int periodYear, int periodNumber, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        boolean isLastPeriod = false;
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear - 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.TRUE, CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            isLastPeriod = true;
        }
        return isLastPeriod;
    }

    public static boolean isExitAdjOfLastYear(int periodYear, int periodNumber, ProfitCenterOrgUnitInfo profitCenterInfo) throws BOSException, EASBizException {
        boolean isLastPeriod = false;
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear - 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)profitCenterInfo.getPcaccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.TRUE, CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            isLastPeriod = true;
        }
        return isLastPeriod;
    }

    public static PeriodInfo getPeriodInfo(Date date, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo periodInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }

    public static PeriodInfo getPeriodInfo(Date date, ProfitCenterOrgUnitInfo profitCenterInfo) throws BOSException, EASBizException {
        if (profitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null || profitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitCenterOrgUnit = ProfitCenterOrgUnitFactory.getRemoteInstance();
            profitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterInfo.getId()));
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        PeriodInfo periodInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)profitCenterInfo.getPcaccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }

    public static PeriodInfo getPeriodInfo(Date date, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = null;
        if (companyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyInfoPK);
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo periodInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, Date date, CompanyOrgUnitInfo companyInfo, SystemEnum system) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = null;
            iCompanyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo periodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            if (periodc.size() > 1 && SystemStatusCtrolUtils.isIsAdjustPeriod(ctx, system, companyInfo, periodc.get(1))) {
                return periodc.get(1);
            }
            return periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, Date date, ProfitCenterOrgUnitInfo profitCenterInfo, SystemEnum system) throws BOSException, EASBizException {
        if (profitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null || profitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitCenterOrgUnit = null;
            iProfitCenterOrgUnit = ctx != null ? ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx) : ProfitCenterOrgUnitFactory.getRemoteInstance();
            profitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterInfo.getId()));
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        PeriodInfo periodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)profitCenterInfo.getPcaccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            if (periodc.size() > 1 && SystemStatusCtrolUtils.isIsAdjustPeriod(ctx, system, profitCenterInfo, periodc.get(1))) {
                return periodc.get(1);
            }
            return periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, Date date, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = null;
            iCompanyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo periodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, Date date, ProfitCenterOrgUnitInfo profitCenterInfo) throws BOSException, EASBizException {
        if (profitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null || profitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitCenterOrgUnit = null;
            iProfitCenterOrgUnit = ctx != null ? ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx) : ProfitCenterOrgUnitFactory.getRemoteInstance();
            profitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterInfo.getId()));
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        PeriodInfo periodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)profitCenterInfo.getPcaccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, Date date, boolean isAdjustPeriod, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = null;
            iCompanyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo periodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (isAdjustPeriod) {
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(date)));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(date)));
            filter.getFilterItems().add(new FilterItemInfo("isadjustperiod", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2");
        }
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, Date date, boolean isAdjustPeriod, ProfitCenterOrgUnitInfo profitCenterInfo) throws BOSException, EASBizException {
        if (profitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null || profitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitCenterOrgUnit = null;
            iProfitCenterOrgUnit = ctx != null ? ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx) : ProfitCenterOrgUnitFactory.getRemoteInstance();
            profitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterInfo.getId()));
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        PeriodInfo periodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (isAdjustPeriod) {
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(date)));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(date)));
            filter.getFilterItems().add(new FilterItemInfo("isadjustperiod", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)profitCenterInfo.getPcaccountPeriodType().getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)profitCenterInfo.getPcaccountPeriodType().getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2");
        }
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, Date date, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = null;
        if (companyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = null;
        iCompanyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyInfoPK);
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo periodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(date), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }

    public static PeriodCollection getPeriodCollection(Date dateFrom, Date dateTo, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        if (dateFrom == null || dateTo == null) {
            return null;
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("((#0 and #1) or (#2 and #3)) and #4 ");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() == 0) {
            PeriodInfo PeriodFrom = PeriodUtils.getPeriodInfo(null, dateFrom, companyInfo);
            PeriodInfo PeriodTo = PeriodUtils.getPeriodInfo(null, dateTo, companyInfo);
            if (PeriodFrom != null && PeriodTo != null) {
                if (PeriodFrom.equals(PeriodTo)) {
                    periodc.add(PeriodTo);
                }
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.client.PeriodResource.voucherDateCheck"));
                SysUtil.abort();
            }
        }
        return periodc;
    }

    public static PeriodCollection getPeriodCollection(Date dateFrom, Date dateTo, ProfitCenterOrgUnitInfo profitCenterInfo) throws BOSException, EASBizException {
        if (profitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null || profitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitCenterOrgUnit = ProfitCenterOrgUnitFactory.getRemoteInstance();
            profitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterInfo.getId()));
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        if (dateFrom == null || dateTo == null) {
            return null;
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)profitCenterInfo.getPcaccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("((#0 and #1) or (#2 and #3)) and #4 ");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() == 0) {
            PeriodInfo PeriodFrom = PeriodUtils.getPeriodInfo(null, dateFrom, profitCenterInfo);
            PeriodInfo PeriodTo = PeriodUtils.getPeriodInfo(null, dateTo, profitCenterInfo);
            if (PeriodFrom != null && PeriodTo != null) {
                if (PeriodFrom.equals(PeriodTo)) {
                    periodc.add(PeriodTo);
                }
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.client.PeriodResource.voucherDateCheck"));
                SysUtil.abort();
            }
        }
        return periodc;
    }

    public static PeriodCollection getPeriodCollection(Date dateFrom, Date dateTo, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        PeriodInfo PeriodTo;
        PeriodInfo PeriodFrom;
        CompanyOrgUnitInfo companyInfo = null;
        if (companyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyInfoPK);
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        if (dateFrom == null || dateTo == null) {
            return null;
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("((#0 and #1) or (#2 and #3)) and #4 ");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() == 0 && (PeriodFrom = PeriodUtils.getPeriodInfo(null, dateFrom, companyInfo)).equals(PeriodTo = PeriodUtils.getPeriodInfo(null, dateTo, companyInfo))) {
            periodc.add(PeriodTo);
        }
        return periodc;
    }

    public static PeriodInfo getPeriodInfo(int periodYear, int periodNumber, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    public static PeriodInfo getPeriodInfo(int periodYear, int periodNumber, ProfitCenterOrgUnitInfo profitCenterInfo) throws BOSException, EASBizException {
        if (profitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null || profitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitCenterOrgUnit = ProfitCenterOrgUnitFactory.getRemoteInstance();
            profitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterInfo.getId()));
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)profitCenterInfo.getPcaccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    public static PeriodInfo getPeriodInfo(int periodYear, int periodNumber, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = null;
        if (companyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyInfoPK);
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, int periodYear, int periodNumber, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = null;
            iCompanyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, int periodYear, int periodNumber, ProfitCenterOrgUnitInfo profitCenterInfo) throws BOSException, EASBizException {
        if (profitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null || profitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitCenterOrgUnit = null;
            iProfitCenterOrgUnit = ctx != null ? ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx) : ProfitCenterOrgUnitFactory.getRemoteInstance();
            profitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterInfo.getId()));
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)profitCenterInfo.getPcaccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, int periodYear, int periodNumber, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = null;
        if (companyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = null;
        iCompanyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyInfoPK);
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    public static PeriodInfo getPeriodInfo(CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    public static PeriodInfo getPeriodInfo(ProfitCenterOrgUnitInfo profitCenterInfo) throws BOSException, EASBizException {
        if (profitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null || profitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitCenterOrgUnit = ProfitCenterOrgUnitFactory.getRemoteInstance();
            profitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterInfo.getId()));
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)profitCenterInfo.getPcaccountPeriodType().getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    public static PeriodInfo getPeriodInfo(IObjectPK companyInfoPK) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = null;
        if (companyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyInfoPK);
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    public static PeriodCollection getPeriodc(PeriodInfo periodFrom, PeriodInfo periodTo, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (periodFrom == null || periodTo == null) {
            return null;
        }
        if (periodFrom.getId() == null || periodTo.getId() == null) {
            return null;
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        IPeriod iperiod = PeriodFactory.getRemoteInstance();
        PeriodCollection periodc = null;
        periodFrom = iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodFrom.getId()));
        periodTo = iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodTo.getId()));
        periodc = PeriodUtils.getPeriodCollection(periodFrom.getBeginDate(), (Date)periodTo.getEndDate(), companyInfo);
        return periodc;
    }

    public static PeriodCollection getPeriodc(PeriodInfo periodFrom, PeriodInfo periodTo, ProfitCenterOrgUnitInfo profitCenterInfo) throws BOSException, EASBizException {
        if (profitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (periodFrom == null || periodTo == null) {
            return null;
        }
        if (periodFrom.getId() == null || periodTo.getId() == null) {
            return null;
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null || profitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitCenterOrgUnit = ProfitCenterOrgUnitFactory.getRemoteInstance();
            profitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterInfo.getId()));
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        IPeriod iperiod = PeriodFactory.getRemoteInstance();
        PeriodCollection periodc = null;
        periodFrom = iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodFrom.getId()));
        periodTo = iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodTo.getId()));
        periodc = PeriodUtils.getPeriodCollection(periodFrom.getBeginDate(), (Date)periodTo.getEndDate(), profitCenterInfo);
        return periodc;
    }

    public static PeriodCollection getPeriodc(IObjectPK periodFromPK, IObjectPK periodToPK, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        PeriodInfo periodFrom = null;
        PeriodInfo periodTo = null;
        CompanyOrgUnitInfo companyInfo = null;
        if (companyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (periodFromPK == null || periodToPK == null) {
            return null;
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyInfoPK);
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        IPeriod iperiod = PeriodFactory.getRemoteInstance();
        PeriodCollection periodc = null;
        periodFrom = iperiod.getPeriodInfo(periodFromPK);
        periodTo = iperiod.getPeriodInfo(periodToPK);
        periodc = PeriodUtils.getPeriodCollection(periodFrom.getBeginDate(), (Date)periodTo.getEndDate(), companyInfo);
        return periodc;
    }

    public static PeriodCollection getPeriodc(int periodYear, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        return periodc;
    }

    public static PeriodCollection getPeriodc(int periodYear, ProfitCenterOrgUnitInfo profitCenterInfo) throws BOSException, EASBizException {
        if (profitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null || profitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitCenterOrgUnit = ProfitCenterOrgUnitFactory.getRemoteInstance();
            profitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterInfo.getId()));
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)profitCenterInfo.getPcaccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        return periodc;
    }

    public static PeriodCollection getPeriodc(int periodYear, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = null;
        if (companyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyInfoPK);
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        return periodc;
    }

    public static PeriodCollection getPeriodc(int periodYear, int periodQuarter, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodQuarter", (Object)new Integer(periodQuarter), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        return periodc;
    }

    public static PeriodCollection getPeriodc(int periodYear, int periodQuarter, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = null;
        if (companyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyInfoPK);
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodQuarter", (Object)new Integer(periodQuarter), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        return periodc;
    }

    public static PeriodCollection getPeriodc(Context ctx, int periodYear, int periodQuarter, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = null;
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        IPeriod iPeriod = null;
        try {
            iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodQuarter", (Object)new Integer(periodQuarter), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        return periodc;
    }

    public static PeriodCollection getPeriodc(Context ctx, int periodYear, int periodQuarter, ProfitCenterOrgUnitInfo profitCenterInfo) throws BOSException, EASBizException {
        if (profitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        IProfitCenterOrgUnit iProfitCenterOrgUnit = null;
        if (profitCenterInfo.getPcaccountPeriodType() == null || profitCenterInfo.getPcaccountPeriodType().getId() == null) {
            iProfitCenterOrgUnit = ctx == null ? ProfitCenterOrgUnitFactory.getRemoteInstance() : ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            profitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterInfo.getId()));
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        IPeriod iPeriod = null;
        try {
            iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodQuarter", (Object)new Integer(periodQuarter), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)profitCenterInfo.getPcaccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        return periodc;
    }

    public static PeriodCollection getPeriodc(Context ctx, int periodYear, int periodQuarter, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = null;
        if (companyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = null;
        iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyInfoPK);
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        IPeriod iPeriod = null;
        try {
            iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodQuarter", (Object)new Integer(periodQuarter), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        return periodc;
    }

    public static int getMaxPeriodNumber(Context ctx, int periodYear, String companyInfoId) throws BOSException, EASBizException {
        if (companyInfoId == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = null;
        iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfoId));
        IPeriod iPeriod = null;
        try {
            iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("PeriodYear"));
        evi.getSorter().add(new SorterItemInfo("PeriodQuarter"));
        evi.getSorter().add(new SorterItemInfo("PeriodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        int MaxPeriodNumber = 0;
        if (periodc.size() > 0) {
            MaxPeriodNumber = periodc.get(periodc.size() - 1).getPeriodNumber();
        }
        return MaxPeriodNumber;
    }

    public static int getMaxPeriodNumber(Context ctx, int periodYear, ProfitCenterOrgUnitInfo profitInfo) throws BOSException, EASBizException {
        if (profitInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        IPeriod iPeriod = null;
        try {
            iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)profitInfo.getPcaccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("PeriodYear"));
        evi.getSorter().add(new SorterItemInfo("PeriodQuarter"));
        evi.getSorter().add(new SorterItemInfo("PeriodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        int MaxPeriodNumber = 0;
        if (periodc.size() > 0) {
            MaxPeriodNumber = periodc.get(periodc.size() - 1).getPeriodNumber();
        }
        return MaxPeriodNumber;
    }

    public static int getMaxOrMinPeriodYear(Context ctx, String companyInfoId, boolean maxOrMin) throws BOSException, EASBizException {
        if (companyInfoId == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = null;
        iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfoId));
        IPeriod iPeriod = null;
        try {
            iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("PeriodYear"));
        evi.getSorter().add(new SorterItemInfo("PeriodQuarter"));
        evi.getSorter().add(new SorterItemInfo("PeriodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        int MaxPeriodNumber = 0;
        if (periodc.size() > 0) {
            MaxPeriodNumber = maxOrMin ? periodc.get(periodc.size() - 1).getPeriodYear() : periodc.get(0).getPeriodYear();
        }
        return MaxPeriodNumber;
    }

    public static int getMaxPeriodNumber(Context ctx, int periodYear, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        if (companyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = null;
        iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyInfoPK);
        IPeriod iPeriod = null;
        try {
            iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("PeriodYear"));
        evi.getSorter().add(new SorterItemInfo("PeriodQuarter"));
        evi.getSorter().add(new SorterItemInfo("PeriodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        int MaxPeriodNumber = 0;
        if (periodc.size() > 0) {
            MaxPeriodNumber = periodc.get(periodc.size() - 1).getPeriodNumber();
        }
        return MaxPeriodNumber;
    }

    public static int getMinPeriodNumber(Context ctx, int periodYear, String companyInfoId) throws BOSException, EASBizException {
        if (companyInfoId == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = null;
        iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfoId));
        IPeriod iPeriod = null;
        try {
            iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("PeriodYear"));
        evi.getSorter().add(new SorterItemInfo("PeriodQuarter"));
        evi.getSorter().add(new SorterItemInfo("PeriodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        int MinPeriodNumber = 0;
        if (periodc.size() > 0) {
            MinPeriodNumber = periodc.get(0).getPeriodNumber();
        }
        return MinPeriodNumber;
    }

    public static int getMinPeriodNumber(Context ctx, int periodYear, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        if (companyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = null;
        iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyInfoPK);
        IPeriod iPeriod = null;
        try {
            iPeriod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("PeriodYear"));
        evi.getSorter().add(new SorterItemInfo("PeriodQuarter"));
        evi.getSorter().add(new SorterItemInfo("PeriodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        int MinPeriodNumber = 0;
        if (periodc.size() > 0) {
            MinPeriodNumber = periodc.get(0).getPeriodNumber();
        }
        return MinPeriodNumber;
    }

    public static PeriodInfo getPeriod(PeriodInfo sourcePeriodInfo, CompanyOrgUnitInfo TargetcompanyInfo) throws BOSException, EASBizException {
        if (sourcePeriodInfo == null || TargetcompanyInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        if (TargetcompanyInfo.getAccountPeriodType() == null || TargetcompanyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            TargetcompanyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(TargetcompanyInfo.getId()));
        }
        if (TargetcompanyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo targetPeriodInfo = null;
        if (sourcePeriodInfo.getPeriodType().getId().toString().equals(TargetcompanyInfo.getAccountPeriodType().getId().toString())) {
            targetPeriodInfo = sourcePeriodInfo;
            return targetPeriodInfo;
        }
        IPeriodRelation iPeriodRelation = PeriodRelationFactory.getRemoteInstance();
        PeriodRelationCollection periodRelc = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourcePeriodId", (Object)sourcePeriodInfo.getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        periodRelc = iPeriodRelation.getPeriodRelationCollection(evi);
        if (periodRelc.size() > 0) {
            PeriodRelationInfo PeriodRel = null;
            PeriodInfo periodInfo = null;
            IPeriod iPeriod = PeriodFactory.getRemoteInstance();
            for (int i = 0; i < periodRelc.size(); ++i) {
                PeriodRel = periodRelc.get(i);
                periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(PeriodRel.getTargetPeriodId().getId()));
                if (!TargetcompanyInfo.getAccountPeriodType().getId().toString().equals(periodInfo.getPeriodType().getId().toString())) continue;
                targetPeriodInfo = periodInfo;
            }
        }
        return targetPeriodInfo;
    }

    public static PeriodInfo getPeriod(PeriodInfo sourcePeriodInfo, ProfitCenterOrgUnitInfo TargetprofitCenterInfo) throws BOSException, EASBizException {
        if (sourcePeriodInfo == null || TargetprofitCenterInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        if (TargetprofitCenterInfo.getPcaccountPeriodType() == null || TargetprofitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitCenterOrgUnit = ProfitCenterOrgUnitFactory.getRemoteInstance();
            TargetprofitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(TargetprofitCenterInfo.getId()));
        }
        if (TargetprofitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        PeriodInfo targetPeriodInfo = null;
        if (sourcePeriodInfo.getPeriodType().getId().toString().equals(TargetprofitCenterInfo.getPcaccountPeriodType().getId().toString())) {
            targetPeriodInfo = sourcePeriodInfo;
            return targetPeriodInfo;
        }
        IPeriodRelation iPeriodRelation = PeriodRelationFactory.getRemoteInstance();
        PeriodRelationCollection periodRelc = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourcePeriodId", (Object)sourcePeriodInfo.getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        periodRelc = iPeriodRelation.getPeriodRelationCollection(evi);
        if (periodRelc.size() > 0) {
            PeriodRelationInfo PeriodRel = null;
            PeriodInfo periodInfo = null;
            IPeriod iPeriod = PeriodFactory.getRemoteInstance();
            for (int i = 0; i < periodRelc.size(); ++i) {
                PeriodRel = periodRelc.get(i);
                periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(PeriodRel.getTargetPeriodId().getId()));
                if (!TargetprofitCenterInfo.getPcaccountPeriodType().getId().toString().equals(periodInfo.getPeriodType().getId().toString())) continue;
                targetPeriodInfo = periodInfo;
            }
        }
        return targetPeriodInfo;
    }

    public static PeriodInfo getPeriod(IObjectPK sourcePeriodInfoPK, IObjectPK TargetcompanyInfoPK) throws BOSException, EASBizException {
        PeriodInfo sourcePeriodInfo = null;
        CompanyOrgUnitInfo TargetcompanyInfo = null;
        if (sourcePeriodInfoPK == null || TargetcompanyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        TargetcompanyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(TargetcompanyInfoPK);
        if (TargetcompanyInfo.getAccountPeriodType() == null) {
            return null;
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        sourcePeriodInfo = iPeriod.getPeriodInfo(sourcePeriodInfoPK);
        PeriodInfo targetPeriodInfo = null;
        if (sourcePeriodInfo.getPeriodType().getId().toString().equals(TargetcompanyInfo.getAccountPeriodType().getId().toString())) {
            targetPeriodInfo = sourcePeriodInfo;
            return targetPeriodInfo;
        }
        IPeriodRelation iPeriodRelation = PeriodRelationFactory.getRemoteInstance();
        PeriodRelationCollection periodRelc = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourcePeriodId", (Object)sourcePeriodInfo.getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        periodRelc = iPeriodRelation.getPeriodRelationCollection(evi);
        if (periodRelc.size() > 0) {
            PeriodRelationInfo PeriodRel = null;
            PeriodInfo periodInfo = null;
            for (int i = 0; i < periodRelc.size(); ++i) {
                PeriodRel = periodRelc.get(i);
                periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(PeriodRel.getTargetPeriodId().getId()));
                if (!TargetcompanyInfo.getAccountPeriodType().getId().toString().equals(periodInfo.getPeriodType().getId().toString())) continue;
                targetPeriodInfo = periodInfo;
            }
        }
        return targetPeriodInfo;
    }

    public static PeriodInfo getPeriod(Context ctx, PeriodInfo sourcePeriodInfo, CompanyOrgUnitInfo TargetcompanyInfo) throws BOSException, EASBizException {
        if (sourcePeriodInfo == null || TargetcompanyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (TargetcompanyInfo.getAccountPeriodType() == null || TargetcompanyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = null;
            iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            TargetcompanyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(TargetcompanyInfo.getId()));
        }
        if (TargetcompanyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo targetPeriodInfo = null;
        if (sourcePeriodInfo.getId().toString().equals(TargetcompanyInfo.getAccountPeriodType().getId().toString())) {
            targetPeriodInfo = sourcePeriodInfo;
            return targetPeriodInfo;
        }
        IPeriodRelation iPeriodRelation = null;
        iPeriodRelation = ctx == null ? PeriodRelationFactory.getRemoteInstance() : PeriodRelationFactory.getLocalInstance(ctx);
        PeriodRelationCollection periodRelc = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourcePeriodId", (Object)sourcePeriodInfo.getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        periodRelc = iPeriodRelation.getPeriodRelationCollection(evi);
        if (periodRelc.size() > 0) {
            PeriodRelationInfo PeriodRel = null;
            PeriodInfo periodInfo = null;
            IPeriod iPeriod = null;
            iPeriod = ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance(ctx);
            for (int i = 0; i < periodRelc.size(); ++i) {
                PeriodRel = periodRelc.get(i);
                periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(PeriodRel.getTargetPeriodId().getId()));
                if (!TargetcompanyInfo.getAccountPeriodType().getId().toString().equals(periodInfo.getPeriodType().getId().toString())) continue;
                targetPeriodInfo = periodInfo;
            }
        }
        return targetPeriodInfo;
    }

    public static PeriodInfo getPeriod(Context ctx, PeriodInfo sourcePeriodInfo, ProfitCenterOrgUnitInfo TargetprofitCenterInfo) throws BOSException, EASBizException {
        if (sourcePeriodInfo == null || TargetprofitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (TargetprofitCenterInfo.getPcaccountPeriodType() == null || TargetprofitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitOrgUnit = null;
            iProfitOrgUnit = ctx == null ? ProfitCenterOrgUnitFactory.getRemoteInstance() : ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            TargetprofitCenterInfo = iProfitOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(TargetprofitCenterInfo.getId()));
        }
        if (TargetprofitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        PeriodInfo targetPeriodInfo = null;
        if (sourcePeriodInfo.getId().toString().equals(TargetprofitCenterInfo.getPcaccountPeriodType().getId().toString())) {
            targetPeriodInfo = sourcePeriodInfo;
            return targetPeriodInfo;
        }
        IPeriodRelation iPeriodRelation = null;
        iPeriodRelation = ctx == null ? PeriodRelationFactory.getRemoteInstance() : PeriodRelationFactory.getLocalInstance(ctx);
        PeriodRelationCollection periodRelc = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourcePeriodId", (Object)sourcePeriodInfo.getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        periodRelc = iPeriodRelation.getPeriodRelationCollection(evi);
        if (periodRelc.size() > 0) {
            PeriodRelationInfo PeriodRel = null;
            PeriodInfo periodInfo = null;
            IPeriod iPeriod = null;
            iPeriod = ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance(ctx);
            for (int i = 0; i < periodRelc.size(); ++i) {
                PeriodRel = periodRelc.get(i);
                periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(PeriodRel.getTargetPeriodId().getId()));
                if (!TargetprofitCenterInfo.getPcaccountPeriodType().getId().toString().equals(periodInfo.getPeriodType().getId().toString())) continue;
                targetPeriodInfo = periodInfo;
            }
        }
        return targetPeriodInfo;
    }

    public static PeriodInfo getPeriod(Context ctx, IObjectPK sourcePeriodInfoPK, IObjectPK TargetcompanyInfoPK) throws BOSException, EASBizException {
        PeriodInfo sourcePeriodInfo = null;
        CompanyOrgUnitInfo TargetcompanyInfo = null;
        if (sourcePeriodInfoPK == null || TargetcompanyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = null;
        IPeriod iPeriod = null;
        if (ctx == null) {
            iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            iPeriod = PeriodFactory.getRemoteInstance();
        } else {
            iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            iPeriod = PeriodFactory.getLocalInstance(ctx);
        }
        sourcePeriodInfo = iPeriod.getPeriodInfo(sourcePeriodInfoPK);
        TargetcompanyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(TargetcompanyInfoPK);
        if (TargetcompanyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo targetPeriodInfo = null;
        if (sourcePeriodInfo.getId().toString().equals(TargetcompanyInfo.getAccountPeriodType().getId().toString())) {
            targetPeriodInfo = sourcePeriodInfo;
            return targetPeriodInfo;
        }
        IPeriodRelation iPeriodRelation = null;
        iPeriodRelation = ctx == null ? PeriodRelationFactory.getRemoteInstance() : PeriodRelationFactory.getLocalInstance(ctx);
        PeriodRelationCollection periodRelc = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourcePeriodId", (Object)sourcePeriodInfo.getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        periodRelc = iPeriodRelation.getPeriodRelationCollection(evi);
        if (periodRelc.size() > 0) {
            PeriodRelationInfo PeriodRel = null;
            PeriodInfo periodInfo = null;
            for (int i = 0; i < periodRelc.size(); ++i) {
                PeriodRel = periodRelc.get(i);
                periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(PeriodRel.getTargetPeriodId().getId()));
                if (!TargetcompanyInfo.getAccountPeriodType().getId().toString().equals(periodInfo.getPeriodType().getId().toString())) continue;
                targetPeriodInfo = periodInfo;
            }
        }
        return targetPeriodInfo;
    }

    public static PeriodCollection getSourcePeriods(Context ctx, PeriodInfo targetPeriodInfo, CompanyOrgUnitInfo sourcecompanyInfo) throws BOSException, EASBizException {
        if (targetPeriodInfo == null || sourcecompanyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (sourcecompanyInfo.getAccountPeriodType() == null || sourcecompanyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = null;
            iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            sourcecompanyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(sourcecompanyInfo.getId()));
        }
        if (sourcecompanyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodCollection sourcePeriodCollection = null;
        sourcePeriodCollection = new PeriodCollection();
        if (targetPeriodInfo.getId().toString().equals(sourcecompanyInfo.getAccountPeriodType().getId().toString())) {
            sourcePeriodCollection.add(targetPeriodInfo);
            return sourcePeriodCollection;
        }
        IPeriodRelation iPeriodRelation = null;
        iPeriodRelation = ctx == null ? PeriodRelationFactory.getRemoteInstance() : PeriodRelationFactory.getLocalInstance(ctx);
        PeriodRelationCollection periodRelc = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("targetPeriodId", (Object)targetPeriodInfo.getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        periodRelc = iPeriodRelation.getPeriodRelationCollection(evi);
        if (periodRelc.size() > 0) {
            PeriodRelationInfo PeriodRel = null;
            PeriodInfo periodInfo = null;
            IPeriod iPeriod = null;
            iPeriod = ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance(ctx);
            for (int i = 0; i < periodRelc.size(); ++i) {
                PeriodRel = periodRelc.get(i);
                periodInfo = new PeriodInfo();
                periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(PeriodRel.getTargetPeriodId().getId()));
                if (!sourcecompanyInfo.getAccountPeriodType().getId().toString().equals(periodInfo.getPeriodType().getId().toString())) continue;
                sourcePeriodCollection.add(periodInfo);
            }
        }
        return sourcePeriodCollection;
    }

    public static PeriodCollection getSourcePeriods(Context ctx, PeriodInfo targetPeriodInfo, ProfitCenterOrgUnitInfo sourceProfitCenterInfo) throws BOSException, EASBizException {
        if (targetPeriodInfo == null || sourceProfitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (sourceProfitCenterInfo.getPcaccountPeriodType() == null || sourceProfitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitCenterOrgUnit = null;
            iProfitCenterOrgUnit = ctx == null ? ProfitCenterOrgUnitFactory.getRemoteInstance() : ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            sourceProfitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(sourceProfitCenterInfo.getId()));
        }
        if (sourceProfitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        PeriodCollection sourcePeriodCollection = null;
        sourcePeriodCollection = new PeriodCollection();
        if (targetPeriodInfo.getId().toString().equals(sourceProfitCenterInfo.getPcaccountPeriodType().getId().toString())) {
            sourcePeriodCollection.add(targetPeriodInfo);
            return sourcePeriodCollection;
        }
        IPeriodRelation iPeriodRelation = null;
        iPeriodRelation = ctx == null ? PeriodRelationFactory.getRemoteInstance() : PeriodRelationFactory.getLocalInstance(ctx);
        PeriodRelationCollection periodRelc = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("targetPeriodId", (Object)targetPeriodInfo.getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        periodRelc = iPeriodRelation.getPeriodRelationCollection(evi);
        if (periodRelc.size() > 0) {
            PeriodRelationInfo PeriodRel = null;
            PeriodInfo periodInfo = null;
            IPeriod iPeriod = null;
            iPeriod = ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance(ctx);
            for (int i = 0; i < periodRelc.size(); ++i) {
                PeriodRel = periodRelc.get(i);
                periodInfo = new PeriodInfo();
                periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(PeriodRel.getTargetPeriodId().getId()));
                if (!sourceProfitCenterInfo.getPcaccountPeriodType().getId().toString().equals(periodInfo.getPeriodType().getId().toString())) continue;
                sourcePeriodCollection.add(periodInfo);
            }
        }
        return sourcePeriodCollection;
    }

    public static PeriodCollection getSourcePeriods(Context ctx, IObjectPK targetPeriodInfoPK, IObjectPK sourcecompanyInfoPK) throws BOSException, EASBizException {
        PeriodInfo targetPeriodInfo = null;
        CompanyOrgUnitInfo sourcecompanyInfo = null;
        if (targetPeriodInfoPK == null || sourcecompanyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = null;
        IPeriod iPeriod = null;
        if (ctx == null) {
            iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            iPeriod = PeriodFactory.getRemoteInstance();
        } else {
            iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            iPeriod = PeriodFactory.getLocalInstance(ctx);
        }
        sourcecompanyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(sourcecompanyInfoPK);
        targetPeriodInfo = iPeriod.getPeriodInfo(targetPeriodInfoPK);
        if (sourcecompanyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodCollection sourcePeriodCollection = null;
        sourcePeriodCollection = new PeriodCollection();
        if (targetPeriodInfo.getId().toString().equals(sourcecompanyInfo.getAccountPeriodType().getId().toString())) {
            sourcePeriodCollection.add(targetPeriodInfo);
            return sourcePeriodCollection;
        }
        IPeriodRelation iPeriodRelation = null;
        iPeriodRelation = ctx == null ? PeriodRelationFactory.getRemoteInstance() : PeriodRelationFactory.getLocalInstance(ctx);
        PeriodRelationCollection periodRelc = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("targetPeriodId", (Object)targetPeriodInfo.getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        periodRelc = iPeriodRelation.getPeriodRelationCollection(evi);
        if (periodRelc.size() > 0) {
            PeriodRelationInfo PeriodRel = null;
            PeriodInfo periodInfo = null;
            for (int i = 0; i < periodRelc.size(); ++i) {
                PeriodRel = periodRelc.get(i);
                periodInfo = new PeriodInfo();
                periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(PeriodRel.getTargetPeriodId().getId()));
                if (!sourcecompanyInfo.getAccountPeriodType().getId().toString().equals(periodInfo.getPeriodType().getId().toString())) continue;
                sourcePeriodCollection.add(periodInfo);
            }
        }
        return sourcePeriodCollection;
    }

    public static PeriodCollection getPeriodc(Context ctx, PeriodInfo periodFrom, PeriodInfo periodTo, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = null;
            iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        IPeriod iperiod = null;
        try {
            iperiod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        PeriodCollection periodc = null;
        periodFrom = iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodFrom.getId()));
        periodTo = iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodTo.getId()));
        periodc = PeriodUtils.getPeriodCollection(ctx, periodFrom.getBeginDate(), (Date)periodTo.getEndDate(), companyInfo);
        return periodc;
    }

    public static PeriodCollection getPeriodc(Context ctx, PeriodInfo periodFrom, PeriodInfo periodTo, ProfitCenterOrgUnitInfo profitCenterInfo) throws BOSException, EASBizException {
        if (profitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null || profitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitCenterOrgUnit = null;
            iProfitCenterOrgUnit = ctx == null ? ProfitCenterOrgUnitFactory.getRemoteInstance() : ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            profitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterInfo.getId()));
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        IPeriod iperiod = null;
        try {
            iperiod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        PeriodCollection periodc = null;
        periodFrom = iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodFrom.getId()));
        periodTo = iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodTo.getId()));
        periodc = PeriodUtils.getPeriodCollection(ctx, periodFrom.getBeginDate(), (Date)periodTo.getEndDate(), profitCenterInfo);
        return periodc;
    }

    public static PeriodCollection getPeriodc(Context ctx, IObjectPK periodFromPK, IObjectPK periodToPK, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        PeriodInfo periodFrom = null;
        PeriodInfo periodTo = null;
        CompanyOrgUnitInfo companyInfo = null;
        if (companyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        IPeriod iPeriod = null;
        ICompanyOrgUnit iCompanyOrgUnit = null;
        if (ctx == null) {
            iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            iPeriod = PeriodFactory.getRemoteInstance();
        } else {
            iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            iPeriod = PeriodFactory.getLocalInstance(ctx);
        }
        periodFrom = iPeriod.getPeriodInfo(periodFromPK);
        periodTo = iPeriod.getPeriodInfo(periodToPK);
        companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyInfoPK);
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodCollection periodc = null;
        periodFrom = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodFrom.getId()));
        periodTo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodTo.getId()));
        periodc = PeriodUtils.getPeriodCollection(ctx, periodFrom.getBeginDate(), (Date)periodTo.getEndDate(), companyInfoPK);
        return periodc;
    }

    public static PeriodCollection getPeriodCollection(Context ctx, Date dateFrom, Date dateTo, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo beginInfo;
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = null;
            iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        if (dateFrom == null || dateTo == null) {
            return null;
        }
        IPeriod iperiod = null;
        try {
            iperiod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("((#0 and #1) or (#2 and #3)) and #4 ");
        evi.setFilter(filter);
        PeriodCollection periodc = iperiod.getPeriodCollection(evi);
        if (periodc.size() == 0 && (beginInfo = PeriodUtils.getPeriodInfo(ctx, dateFrom, companyInfo)) != null) {
            periodc.add(beginInfo);
        }
        return periodc;
    }

    public static PeriodCollection getPeriodCollection(Context ctx, Date dateFrom, Date dateTo, ProfitCenterOrgUnitInfo profitCenterInfo) throws BOSException, EASBizException {
        PeriodInfo beginInfo;
        if (profitCenterInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null || profitCenterInfo.getPcaccountPeriodType().getId() == null) {
            IProfitCenterOrgUnit iProfitCenterOrgUnit = null;
            iProfitCenterOrgUnit = ctx == null ? ProfitCenterOrgUnitFactory.getRemoteInstance() : ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            profitCenterInfo = iProfitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterInfo.getId()));
        }
        if (profitCenterInfo.getPcaccountPeriodType() == null) {
            return null;
        }
        if (dateFrom == null || dateTo == null) {
            return null;
        }
        IPeriod iperiod = null;
        try {
            iperiod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)profitCenterInfo.getPcaccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("((#0 and #1) or (#2 and #3)) and #4 ");
        evi.setFilter(filter);
        PeriodCollection periodc = iperiod.getPeriodCollection(evi);
        if (periodc.size() == 0 && (beginInfo = PeriodUtils.getPeriodInfo(ctx, dateFrom, profitCenterInfo)) != null) {
            periodc.add(beginInfo);
        }
        return periodc;
    }

    public static PeriodCollection getPeriodCollection(Context ctx, Date dateFrom, Date dateTo, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        PeriodInfo beginInfo;
        CompanyOrgUnitInfo companyInfo = null;
        if (companyInfoPK == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = null;
        iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyInfoPK);
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        if (dateFrom == null || dateTo == null) {
            return null;
        }
        IPeriod iperiod = null;
        try {
            iperiod = ctx != null ? PeriodFactory.getLocalInstance(ctx) : PeriodFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate(dateTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("((#0 and #1) or (#2 and #3)) and #4 ");
        evi.setFilter(filter);
        PeriodCollection periodc = iperiod.getPeriodCollection(evi);
        if (periodc.size() == 0 && (beginInfo = PeriodUtils.getPeriodInfo(ctx, dateFrom, companyInfo)) != null) {
            periodc.add(beginInfo);
        }
        return periodc;
    }
}

