/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.RowSet;

public class SystemStatusCtrolUtils {
    public static PeriodInfo getStartPeriod(Context ctx, SystemEnum SystemName, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance(ctx);
        return ictrol.getStartPeriod(new Integer(SystemName.getValue()), company.getId().toString());
    }

    public static PeriodInfo getStartPeriod(Context ctx, SystemEnum SystemName, IObjectPK companyPK) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance(ctx);
        return ictrol.getStartPeriod(new Integer(SystemName.getValue()), companyPK.toString());
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, SystemEnum SystemName, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance(ctx);
        return ictrol.getCacheCurrentPeriod(new Integer(SystemName.getValue()), company.getId().toString());
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, SystemEnum SystemName, ProfitCenterOrgUnitInfo profitCenter) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance(ctx);
        return ictrol.getProfitCurrentPeriod(new Integer(SystemName.getValue()), profitCenter.getId().toString());
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, SystemEnum SystemName, IObjectPK companyPK) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance(ctx);
        return ictrol.getCacheCurrentPeriod(new Integer(SystemName.getValue()), companyPK.toString());
    }

    public static boolean isRelAccount(Context ctx, SystemEnum SystemName, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance(ctx);
        return ictrol.isRelatedAccount(company.getId().toString(), SystemName);
    }

    public static boolean isStart(Context ctx, SystemEnum SystemName, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance(ctx);
        return ictrol.isStart(new Integer(SystemName.getValue()), company.getId().toString());
    }

    public static boolean isStart(Context ctx, SystemEnum SystemName, IObjectPK companyPK) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance(ctx);
        return ictrol.isStart(new Integer(SystemName.getValue()), companyPK.toString());
    }

    public static boolean isClose(Context ctx, SystemEnum SystemName, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance(ctx);
        return ictrol.isClose(new Integer(SystemName.getValue()), company.getId().toString());
    }

    public static boolean isIsAdjustPeriod(Context ctx, SystemEnum SystemName, CompanyOrgUnitInfo company, PeriodInfo periodInfo) throws BOSException, EASBizException {
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(ctx, SystemName, company);
        return periodInfo.isIsAdjustPeriod() && (periodInfo.getPeriodYear() < currentPeriod.getPeriodYear() || periodInfo.getPeriodYear() == currentPeriod.getPeriodYear() && periodInfo.getPeriodNumber() == currentPeriod.getPeriodNumber());
    }

    public static boolean isIsAdjustPeriod(Context ctx, SystemEnum SystemName, ProfitCenterOrgUnitInfo profitCenter, PeriodInfo periodInfo) throws BOSException, EASBizException {
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(ctx, SystemName, profitCenter);
        return periodInfo.isIsAdjustPeriod() && (periodInfo.getPeriodYear() < currentPeriod.getPeriodYear() || periodInfo.getPeriodYear() == currentPeriod.getPeriodYear() && periodInfo.getPeriodNumber() == currentPeriod.getPeriodNumber());
    }

    public static boolean isClose(Context ctx, SystemEnum SystemName, IObjectPK companyPK) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance(ctx);
        return ictrol.isClose(new Integer(SystemName.getValue()), companyPK.toString());
    }

    public static boolean chekcRelGL1(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        boolean check = false;
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance(ctx);
        PeriodInfo glCurrPeriod = ictrol.getCacheCurrentPeriod(SystemEnum.GENERALLEDGER.getValue(), company.getId().toString());
        if (glCurrPeriod == null) {
            throw new PeriodException(PeriodException.GL_NOTSTART);
        }
        List systemEnumList = SystemEnum.getEnumList();
        PeriodInfo orherCurrPeriod = null;
        int size = systemEnumList.size();
        for (int i = 0; i < size; ++i) {
            if (((SystemEnum)systemEnumList.get(i)).getValue() == SystemEnum.GENERALLEDGER.getValue() || !ictrol.isRelatedAccount(company.getId().toString(), (SystemEnum)systemEnumList.get(i)) || (orherCurrPeriod = ictrol.getCacheCurrentPeriod(((SystemEnum)systemEnumList.get(i)).getValue(), company.getId().toString())) == null || (check = PeriodUtils.PeriodCompare(orherCurrPeriod, glCurrPeriod))) continue;
            return check;
        }
        return check;
    }

    public static ArrayList chekcRelGL1(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        ArrayList<String> checkList = new ArrayList<String>();
        boolean check = false;
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance(ctx);
        PeriodInfo glCurrPeriod = ictrol.getCacheCurrentPeriod(SystemEnum.GENERALLEDGER.getValue(), companyPK.toString());
        if (glCurrPeriod == null) {
            throw new PeriodException(PeriodException.GL_NOTSTART);
        }
        List systemEnumList = SystemEnum.getEnumList();
        PeriodInfo orherCurrPeriod = null;
        int size = systemEnumList.size();
        for (int i = 0; i < size; ++i) {
            if (((SystemEnum)systemEnumList.get(i)).getValue() == SystemEnum.GENERALLEDGER.getValue() || !ictrol.isRelatedAccount(companyPK.toString(), (SystemEnum)systemEnumList.get(i)) || (orherCurrPeriod = ictrol.getCacheCurrentPeriod(((SystemEnum)systemEnumList.get(i)).getValue(), companyPK.toString())) == null) continue;
            check = PeriodUtils.PeriodCompare(orherCurrPeriod, glCurrPeriod);
            checkList.add(((SystemEnum)systemEnumList.get(i)).getAlias());
        }
        return checkList;
    }

    protected static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public static boolean hasStartPeriod1(Context ctx, BOSUuid companyID) throws BOSException {
        RowSet rs;
        PreparedStatement ps;
        Connection con;
        boolean returnEnd;
        block6: {
            String fCompanyID = null;
            returnEnd = false;
            StringBuffer sql = new StringBuffer();
            con = SystemStatusCtrolUtils.getConnection(ctx);
            ps = null;
            rs = null;
            sql.append("select FStartPeriodID from T_BD_SystemStatusCtrol where FCompanyID = ? and FStartPeriodID is not null");
            if (companyID != null) {
                fCompanyID = companyID.toString();
            }
            try {
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, fCompanyID);
                rs = (RowSet)ps.executeQuery();
                if (rs.next()) {
                    returnEnd = true;
                    rs.close();
                    break block6;
                }
                returnEnd = false;
            }
            catch (SQLException e) {
                try {
                    throw new SQLAccessException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return returnEnd;
    }

    public boolean isRelatedAccount(Context ctx, String companyID, SystemEnum systemName) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance(ctx);
        return ictrol.isRelatedAccount(companyID, systemName);
    }

    public boolean isRelatedAccount4Client(String companyID, SystemEnum systemName) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getRemoteInstance();
        return ictrol.isRelatedAccount(companyID, systemName);
    }

    public boolean isEqualsCurPeriodAndRelPeriod(Context ctx, String companyID, SystemEnum systemName) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance(ctx);
        return ictrol.isEqualsCurPeriodAndRelPeriod(companyID, systemName);
    }

    public boolean isEqualsCurPeriodAndRelPeriod4Client(String companyID, SystemEnum systemName) throws BOSException, EASBizException {
        ISystemStatusCtrol iSysStatusCtr = SystemStatusCtrolFactory.getRemoteInstance();
        return iSysStatusCtr.isEqualsCurPeriodAndRelPeriod(companyID, systemName);
    }
}

