/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ebservice.AccountToSync;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.message.common.util.UuidException;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fi.gl.BalanceCheckProcessFactory;
import com.kingdee.eas.base.core.fm.AccountCurrencyVerifyUtil;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankException;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankGroupFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AcctBankTrusterEntriesCollection;
import com.kingdee.eas.basedata.assistant.AcctBankTrusterEntriesInfo;
import com.kingdee.eas.basedata.assistant.BankException;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesFactory;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.app.AbstractAccountBankControllerBean;
import com.kingdee.eas.basedata.assistant.app.builder.AccountBankProcessorBuiler;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.app.AssistUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.BizBalanceException;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutingHelper;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.condition.InterfaceItem;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.fi.cas.subacct.SubAcctCurrencyBalance;
import com.kingdee.eas.fm.be.IScheduleJob;
import com.kingdee.eas.fm.be.ScheduleJobCollection;
import com.kingdee.eas.fm.be.ScheduleJobFactory;
import com.kingdee.eas.fm.be.ScheduleJobInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class AccountBankControllerBean
extends AbstractAccountBankControllerBean {
    private String resourcePath = "com.kingdee.eas.basedata.assistant.AccountBankResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.AccountBankControllerBean");

    @Override
    public void _writeOff(Context ctx, IObjectPK pk, Date closeDate) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("isByCurrency"));
        selector.add(new SelectorItemInfo("isClosed"));
        selector.add(new SelectorItemInfo("company.name"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("company.number"));
        selector.add(new SelectorItemInfo("currency.id"));
        selector.add(new SelectorItemInfo("currency.name"));
        selector.add(new SelectorItemInfo("currency.number"));
        selector.add(new SelectorItemInfo("account.id"));
        selector.add(new SelectorItemInfo("account.number"));
        selector.add(new SelectorItemInfo("account.name"));
        AccountBankInfo model = this.getAccountBankInfo(ctx, pk, selector);
        BOSUuid accBankUuid = model.getId();
        if (model.isIsClosed()) {
            throw new AccountBankException(AccountBankException.MSG_INFO_ACCBANKHASCANCEL, new Object[]{model.getCompany().getName(), model.getNumber()});
        }
        BizCheckResult bizCheckResult = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)accBankUuid);
        if (bizCheckResult.isFound()) {
            throw new BizBalanceException(BizBalanceException.BIZ_HASBALANCE);
        }
        String currencyid = null;
        String accountId = null;
        if (model.isIsByCurrency()) {
            currencyid = model.getCurrency().getId().toString();
        }
        if (model.getAccount() != null) {
            accountId = model.getAccount().getId().toString();
        }
        String companyid = model.getCompany().getId().toString();
        BigDecimal balance = BigDecimal.ZERO;
        if (model.isIsByCurrency()) {
            currencyid = model.getCurrency().getId().toString();
            balance = this.getBalance(ctx, model.getId().toString(), currencyid, new Date(), model);
            if (balance.compareTo(BigDecimal.ZERO) != 0) {
                throw new AccountBankException(AccountBankException.MSG_JOURNALNOTZERO, new Object[]{model.getCompany().getName(), model.getNumber()});
            }
        } else {
            CurrencyCollection curColl = CurrencyFactory.getLocalInstance(ctx).getCurrencyCollection();
            for (int i = 0; i < curColl.size(); ++i) {
                currencyid = curColl.get(i).getId().toString();
                balance = this.getBalance(ctx, model.getId().toString(), currencyid, new Date(), model);
                if (balance.compareTo(BigDecimal.ZERO) == 0) continue;
                throw new AccountBankException(AccountBankException.MSG_JOURNALNOTZERO, new Object[]{model.getCompany().getName(), model.getNumber()});
            }
        }
        if (!model.isIsByCurrency()) {
            currencyid = null;
        }
        if ((bizCheckResult = this.isAcctHasAcctBankAssis(ctx, accountId) ? BalanceCheckProcessFactory.getBalanceCheckProcess().checkHasBalanceByAccount(ctx, accountId, model.getId().toString(), currencyid, companyid) : BalanceCheckProcessFactory.getBalanceCheckProcess().checkHasBalanceByAccount(ctx, accountId, currencyid, companyid)).isFound()) {
            throw new AccountBankException(AccountBankException.MSG_ACCOUNTNOTZERO, new Object[]{model.getCompany().getName(), model.getNumber()});
        }
        if (this.isUserBankAcntRelation(ctx, model)) {
            throw new AccountBankException(AccountBankException.MSG_ACCOUNTBANKEXCEPTION, new Object[]{model.getCompany().getName(), model.getNumber()});
        }
        model.setIsClosed(true);
        model.setIsDefaultPayment(false);
        model.setCloseDate(closeDate);
        SelectorItemCollection updateSelector = new SelectorItemCollection();
        updateSelector.add(new SelectorItemInfo("isClosed"));
        updateSelector.add(new SelectorItemInfo("isDefaultPayment"));
        updateSelector.add(new SelectorItemInfo("closeDate"));
        this.updatePartial(ctx, (CoreBaseInfo)model, updateSelector);
        this.disableScheduleJob(ctx, model);
        this.reverseDestoryAccountApply(ctx, 2, accBankUuid.toString());
    }

    private void disableScheduleJob(Context ctx, AccountBankInfo accountBankInfo) throws BOSException, EASBizException, UuidException {
        ScheduleJobInfo scheduleJobInfo;
        IScheduleJob iScheduleJob = ScheduleJobFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)accountBankInfo.getId(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("isEffected");
        sic.add("endDate");
        view.setSelector(sic);
        ScheduleJobCollection coll = iScheduleJob.getScheduleJobCollection(view);
        if (coll != null && coll.size() > 0 && (scheduleJobInfo = coll.get(0)).isIsEffected()) {
            scheduleJobInfo.setIsEffected(false);
            scheduleJobInfo.setEndDate((Date)DateUtil.getSQLBegin((Date)new Date()));
            iScheduleJob.updatePartial((CoreBaseInfo)scheduleJobInfo, sic);
        }
    }

    public boolean isAcctHasAcctBankAssis(Context ctx, String acctViewId) throws EASBizException, BOSException, UuidException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT T_BD_AsstActType.FRealtionDataObject AS tName, A.FID FROM T_BD_AccountView A INNER JOIN T_BD_AsstAccount ON A.FCAA = T_BD_AsstAccount.FID INNER JOIN T_BD_AsstActGroupDetail ON T_BD_AsstAccount.FID = T_BD_AsstActGroupDetail.FAsstAccountID INNER JOIN T_BD_AsstActType ON T_BD_AsstActGroupDetail.FAsstActTypeID = T_BD_AsstActType.FID  WHERE (T_BD_AsstActType.FRealtionDataObject = 'T_BD_AccountBanks') and A.fid='" + acctViewId + "'");
        IRowSet rs = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString()).executeSQL();
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private boolean isUserBankAcntRelation(Context ctx, AccountBankInfo model) throws BOSException, EASBizException {
        String sql = "select Fid from T_BE_BankAcntRelation where FFirstAcnt = '" + model.getId().toString() + "' or FSecondOverAcnt = '" + model.getId().toString() + "'";
        IRowSet rowSet = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql).executeSQL();
        if (!EmptyUtil.isEmpty((Object)rowSet) && rowSet.size() > 0) {
            return true;
        }
        sql = "select Fid from T_BE_BankAcntRelationEntry where FBankAcntID = '" + model.getId().toString() + "'";
        rowSet = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql).executeSQL();
        return !EmptyUtil.isEmpty((Object)rowSet) && rowSet.size() > 0;
    }

    private void reverseDestoryAccountApply(Context ctx, int accountResult, String accountBankId) throws BOSException, EASBizException {
        String sql = "Update T_BD_DestroyAccountApply set FAccountResult =? where FAccountBankID=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{String.valueOf(accountResult), accountBankId});
    }

    @Override
    public void _unWriteOff(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("account.*"));
        AccountBankInfo model = this.getAccountBankInfo(ctx, pk, selector);
        if (!model.isIsClosed()) {
            throw new AccountBankException(AccountBankException.INFO_ACCBANKHASNOTCANCEL);
        }
        model.setIsClosed(false);
        model.setCloseDate(null);
        this._update(ctx, pk, (IObjectValue)model);
        this.reverseDestoryAccountApply(ctx, 1, model.getId().toString());
    }

    public IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String accApplyBillId;
        AccountBankInfo info = null;
        info = (AccountBankInfo)model;
        info.setCU(info.getCompany().getCU());
        if (EmptyUtil.isEmpty((String)info.getNumber()) && this.isAutoNumber((AccountBankInfo)model, ctx)) {
            this.setNewNumber(ctx, (AccountBankInfo)model);
        }
        super._checkNumberBlank(ctx, (IObjectValue)info);
        this._checkNumberDup(ctx, (IObjectValue)info);
        this.checkBankAccountNumberBlank(ctx, (IObjectValue)info);
        this.checkAccountBlank(ctx, (IObjectValue)info);
        this.checkBankAccountView(ctx, info);
        this.checkBankAccountNumber(ctx, info);
        this.checkBankBlank(ctx, (IObjectValue)info);
        this.checkAboutParentAcc(ctx, model);
        this.checkMonoCombine(ctx, model, null);
        this.checkSubAccount(ctx, model);
        if (((AccountBankInfo)model).isIsDefaultReck()) {
            this.cancelDefault(ctx, info);
        }
        if (((AccountBankInfo)model).isIsDefaultPayment()) {
            this.cancelDefaultPayment(ctx, info);
        }
        this.updateReleMotherAcct(ctx, info);
        if (info.getAccount() != null) {
            info.setIsBank(info.getAccount().isIsBank());
            info.setIsCash(info.getAccount().isIsCash());
        }
        if ((accApplyBillId = info.getApplyBillId()) != null && !"".equals(accApplyBillId.trim())) {
            HashMap<String, String> idMap = new HashMap<String, String>();
            idMap.put(accApplyBillId, info.getId().toString());
            BOTPUtil.saveBOTRelation((Context)ctx, idMap);
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    private void updateReleMotherAcct(Context ctx, AccountBankInfo info) {
        info.setReleMotherAcct(info.getSubAccount());
    }

    private void checkAboutParentAcc(Context ctx, IObjectValue model) throws AccountBankException {
        AccountBankInfo info = (AccountBankInfo)model;
        if (info.isIsMotherAccount() && info.getAccount() != null && !info.getAccount().isIsBank()) {
            throw new AccountBankException(AccountBankException.PARENT_NOTBANK);
        }
        if (!info.isIsMotherAccount() && info.isNotOutPay()) {
            throw new AccountBankException(AccountBankException.OUTPAY_PARENT);
        }
    }

    private void checkMonoCombine(Context ctx, IObjectValue model, IObjectPK pk) throws BOSException, AccountBankException {
        AccountBankInfo info = (AccountBankInfo)model;
        if (info == null) {
            return;
        }
        String bankId = null;
        if (pk != null) {
            bankId = pk.toString();
        }
        if (info.isIsMotherAccount()) {
            BankInfo bankifo = info.getBank();
            if (bankifo == null) {
                return;
            }
            String longNum = bankifo.getLongNumber();
            if (EmptyUtil.isEmpty((String)longNum)) {
                return;
            }
        }
    }

    private void checkSubAccount(Context ctx, IObjectValue model) throws AccountBankException {
        AccountBankInfo info = (AccountBankInfo)model;
        if (info == null) {
            return;
        }
    }

    private void checkBankAccountNumber(Context ctx, AccountBankInfo model) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (model.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getId().toString().trim(), CompareType.NOTEQUALS));
        }
        if (model.getShareType().getValue() != 0) {
            filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)model.getBankAccountNumber().trim(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)model.getCompany().getId().toString(), CompareType.EQUALS));
            if (model.getId() != null) {
                filter.setMaskString("#0 and #1 and #2");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)model.getBankAccountNumber().trim(), CompareType.EQUALS));
            if (model.getId() != null) {
                filter.setMaskString("#0 and #1");
            }
        }
        evi.setFilter(filter);
        if (this.exists(ctx, filter)) {
            throw new AccountBankException(AccountBankException.INFO_HASSAMEACCBANK);
        }
    }

    private void checkBankAccountView(Context ctx, AccountBankInfo model) throws EASBizException, BOSException, EASBizException {
        AccountBankInfo info = model;
        AccountViewInfo account = null;
        account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getAccount().getId().toString())));
        if (account.getAccountingcurrency().getValue() != 2 && !info.isIsByCurrency()) {
            throw new AccountBankException(AccountBankException.ISBYCURRENCY_IS_NULL);
        }
        if (info.getCurrency() != null && !AccountCurrencyVerifyUtil.isAccountCurrency((Context)ctx, (String)info.getAccount().getId().toString(), (String)info.getCurrency().getId().toString())) {
            throw new AccountBankException(AccountBankException.ACCOUNT_NOT_INCLUDE_CURRENCY);
        }
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IAccountBank iAccountBank = AccountBankFactory.getLocalInstance(ctx);
        AccountBankInfo oldInfo = iAccountBank.getAccountBankInfo(pk, this.getSelectors());
        AccountBankInfo newModel = (AccountBankInfo)model;
        BOSUuid updateAccBankUuid = oldInfo.getId();
        this._checkNumberDup(ctx, (IObjectValue)newModel);
        this.checkBankAccountNumberBlank(ctx, (IObjectValue)newModel);
        this.checkAccountBlank(ctx, (IObjectValue)newModel);
        this.checkBankAccountNumber(ctx, newModel);
        this.checkBankAccountView(ctx, newModel);
        this.checkBankBlank(ctx, (IObjectValue)newModel);
        if (((AccountBankInfo)model).isIsDefaultReck() && !oldInfo.isIsDefaultReck()) {
            this.cancelDefault(ctx, newModel);
        }
        if (((AccountBankInfo)model).isIsDefaultPayment()) {
            this.cancelDefaultPayment(ctx, newModel);
        }
        this.checkHasReference(ctx, oldInfo, newModel);
        boolean changeFlag = false;
        BizCheckResult bizCheckResult = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)updateAccBankUuid);
        if (bizCheckResult.isFound() && oldInfo.getAccount().getCurrencyID().equals(newModel.getAccount().getCurrencyID()) && !oldInfo.getAccount().equals((Object)newModel.getAccount())) {
            changeFlag = true;
        }
        if (changeFlag) {
            throw new BizBalanceException(BizBalanceException.BIZ_HASBALANCE);
        }
        this.checkAboutParentAcc(ctx, model);
        this.checkMonoCombine(ctx, model, pk);
        this.checkSubAccount(ctx, model);
        this.updateReleMotherAcct(ctx, newModel);
        super._update(ctx, pk, (IObjectValue)newModel);
        if (!EqualsUtil.equals((String)oldInfo.getNumber(), (String)newModel.getNumber()) || !EqualsUtil.equals((String)oldInfo.getName(), (String)newModel.getName())) {
            AssistUtil.updateAssist((Context)ctx, (String)pk.toString(), (BOSObjectType)new AccountBankInfo().getBOSType());
        }
    }

    private Throwable checkReference(Context ctx, BOSUuid id) {
        Exception e = null;
        try {
            this._isReferenced(ctx, (IObjectPK)new ObjectUuidPK(id));
            BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)id);
        }
        catch (Exception er) {
            e = er;
        }
        return e;
    }

    private void checkHasReference(Context ctx, AccountBankInfo oldVO, AccountBankInfo updateVO) throws EASBizException {
        Throwable e = this.checkReference(ctx, oldVO.getId());
        if (e != null) {
            if (!oldVO.getCompany().getId().toString().equals(updateVO.getCompany().getId().toString())) {
                throw new AccountBankException(AccountBankException.REF_NOT_UPDATE_COMPANY, e);
            }
            if (!oldVO.getOpenDate().toString().equals(updateVO.getOpenDate().toString())) {
                logger.error((Object)("origin bank id: " + oldVO.getId().toString() + ",name :" + oldVO.getName() + ",open date: " + oldVO.getOpenDate().toString()));
                logger.error((Object)("update bank id: " + updateVO.getId().toString() + ",name :" + updateVO.getName() + ",open date: " + updateVO.getOpenDate().toString()));
                throw new AccountBankException(AccountBankException.REF_NOT_UPDATE_OPENDATE, e);
            }
        }
    }

    public void checkIsAccountDup(Context ctx, AccountBankInfo model) throws BOSException, EASBizException {
        for (int i = 0; i < model.getAccount().size(); ++i) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)model.getAccount().getId().toString().trim(), CompareType.EQUALS));
            evi.setFilter(filter);
            IAccountBank iAcc = AccountBankFactory.getLocalInstance(ctx);
            AccountBankCollection accCon = iAcc.getAccountBankCollection(evi);
            for (int j = 0; j < accCon.size(); ++j) {
                EntityViewInfo evi2 = new EntityViewInfo();
                FilterInfo filter2 = new FilterInfo();
                if (model.getId() != null) {
                    filter2.getFilterItems().add(new FilterItemInfo("id", (Object)model.getId().toString().trim(), CompareType.NOTEQUALS));
                    filter2.setMaskString("#0 and #1 and #2");
                } else {
                    filter2.setMaskString("#0 and #1");
                }
                filter2.getFilterItems().add(new FilterItemInfo("company.id", (Object)model.getCompany().getId().toString().trim(), CompareType.EQUALS));
                filter2.getFilterItems().add(new FilterItemInfo("id", (Object)accCon.get(j).getAccount().getId().toString().trim(), CompareType.EQUALS));
                evi2.setFilter(filter2);
                IAccountBank iAccBank = AccountBankFactory.getLocalInstance(ctx);
                CoreBaseCollection collection = iAccBank.getCollection(evi2);
                if (collection == null || collection.size() <= 0) continue;
                throw new AccountBankException(AccountBankException.INFO_ACCVIEWHASUSED);
            }
        }
    }

    protected AccountBankInfo _getAccountBankByCurAcc(Context ctx, BOSUuid AccountViewID, BOSUuid CurrencyID, BOSUuid CompanyID) throws BOSException, AccountBankException, EASBizException {
        RowSet rs = null;
        Connection conn = null;
        int i = 0;
        String strID = "";
        AccountBankInfo info = null;
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("SELECT t0.FID AS ID");
        sqlBuff.append(" FROM T_BD_AccountBanks t0 INNER JOIN");
        sqlBuff.append(" T_ORG_Company t1 ON t0.FCompanyID = t1.FID LEFT OUTER JOIN");
        sqlBuff.append(" T_ORG_BaseUnit t2 ON t2.FID = t1.FID INNER JOIN ");
        sqlBuff.append(" T_BD_AccBankDtlGrp T3 ON T3.FAccountBankID = t0.FID INNER JOIN");
        sqlBuff.append(" T_BD_Currency T4 ON T3.FCurrencyID = T4.FID INNER JOIN");
        sqlBuff.append(" T_BD_AccountView T5 ON T3.FAccountID = T5.FID ");
        sqlBuff.append(" WHERE (t1.FID ='");
        sqlBuff.append(CompanyID.toString().toString());
        sqlBuff.append("') AND");
        sqlBuff.append(" (T4.FID ='");
        sqlBuff.append(CurrencyID.toString().toString());
        sqlBuff.append("')  AND");
        sqlBuff.append(" (T5.FID ='");
        sqlBuff.append(AccountViewID.toString().toString());
        sqlBuff.append("')");
        try {
            conn = this.getConnection(ctx);
            rs = SQLUtils.getJdbcRowSet((Connection)conn, (String)sqlBuff.toString());
            while (rs.next()) {
                ++i;
                strID = rs.getString("ID");
            }
            if (i > 1) {
                throw new AccountBankException(AccountBankException.ACCOUNT_IS_NULL);
            }
            if (i == 1) {
                info = this.getAccountBankInfo(ctx, (IObjectPK)new ObjectUuidPK(strID));
            }
        }
        catch (SQLException e) {
            throw new AccountBankException(AccountBankException.ACCOUNT_IS_NULL);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return info;
    }

    private void checkBankBlank(Context ctx, IObjectValue model) throws AccountBankException {
        AccountBankInfo info = (AccountBankInfo)model;
        if (info.getBank() == null || info.getBank().getId().toString().equals("")) {
            throw new AccountBankException(AccountBankException.INFO_VALIDBANK);
        }
    }

    private void checkAccountBlank(Context ctx, IObjectValue model) throws AccountBankException {
        AccountBankInfo info = (AccountBankInfo)model;
        if (info.getAccount() == null || info.getAccount().getId().toString().equals("")) {
            throw new AccountBankException(AccountBankException.ACCOUNT_IS_NULL);
        }
    }

    private void checkBankAccountNumberBlank(Context ctx, IObjectValue model) throws AccountBankException {
        AccountBankInfo info = (AccountBankInfo)model;
        if ("".equals(info.getBankAccountNumber())) {
            throw new AccountBankException(AccountBankException.INFO_BANKACCOUNT_INVALID);
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.baseCurrency"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.number"));
        sic.add(new SelectorItemInfo("bank.longNumber"));
        sic.add(new SelectorItemInfo("bank.address"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("subAccount.id"));
        sic.add(new SelectorItemInfo("subAccount.number"));
        sic.add(new SelectorItemInfo("subAccount.name"));
        sic.add(new SelectorItemInfo("subAccount.bank.id"));
        sic.add(new SelectorItemInfo("subAccount.bank.number"));
        sic.add(new SelectorItemInfo("subAccount.bank.longNumber"));
        sic.add(new SelectorItemInfo("subAccount.relationalUnit.id"));
        sic.add(new SelectorItemInfo("currency.isoCode"));
        sic.add(new SelectorItemInfo("openArea.number"));
        sic.add(new SelectorItemInfo("openArea.name"));
        sic.add(new SelectorItemInfo("openArea.deptID"));
        sic.add(new SelectorItemInfo("openArea.province"));
        sic.add(new SelectorItemInfo("openArea.unionCode"));
        sic.add(new SelectorItemInfo("country.name"));
        return sic;
    }

    @Override
    protected AccountBankInfo _getAccountBankByAcc(Context ctx, BOSUuid AccountViewID, BOSUuid CompanyID) throws BOSException, AccountBankException, EASBizException {
        return null;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AccountBankInfo info = (AccountBankInfo)super._getValue(ctx, pk);
        return info.getLogInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._isReferenced(ctx, pk);
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        Statement stat = null;
        String sqlBankBalanceAdjust = "SELECT  faudittime FROM T_CAS_BankBalanceAdjust where fbankaccountid=? and faudittime is not null";
        BizReference ref = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sqlBankBalanceAdjust);
            ps.setString(1, pk.toString());
            stat = conn.createStatement();
            rs = ps.executeQuery();
            if (rs.next()) {
                ref = new BizReference();
                ref.setRefEntityAlias_L1("T_CAS_BankBalanceAdjust");
                ref.setRefEntityAlias_L2("\u4f59\u989d\u8c03\u8282\u8868");
                ref.setRefEntityAlias_L3("\u9918\u984d\u8abf\u7bc0\u8868");
                throw new ObjectReferedException((Object)ref);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        this.deleteRefIntObject(ctx, pk);
        AccountBankInfo accountBankInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("applyBillId"));
        accountBankInfo = AccountBankFactory.getLocalInstance(ctx).getAccountBankInfo(pk, sic);
        this._disposeAccApply(ctx, accountBankInfo.getApplyBillId(), false);
        String srcBosType = "7DC111B3";
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        iBOTRelation.removeRelationByDestObjId(accountBankInfo.getId().toString(), srcBosType);
        accountBankInfo = this.getAccountBankInfo(ctx, pk);
        if (this.isAutoNumber(accountBankInfo, ctx)) {
            this.rolbackNumber(accountBankInfo, ctx);
        }
        this.checkSharedAcct(ctx, pk);
        if (!EmptyUtil.isEmpty((String)accountBankInfo.getBankInterFace())) {
            Object[] accts = new Object[]{accountBankInfo};
            InterfaceItem item = new InterfaceItem("BankFacade", "A2F61E6C", "deleteAcctFromBank", "facade", new Class[]{Object[].class}, null);
            item.doInvoke(ctx, new Object[]{accts});
        }
        super._delete(ctx, pk);
    }

    private void checkSharedAcct(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        AccountBankInfo accountBankInfo = AccountBankFactory.getLocalInstance(ctx).getAccountBankInfo(pk);
        if (accountBankInfo.getShareType().getValue() == 2) {
            String msg = ResourceBase.getString((String)this.resourcePath, (String)"usedAcctDelete", (Locale)ctx.getLocale());
            throw new AccountBankException(AccountBankException.COMMON, new Object[]{msg});
        }
        if (accountBankInfo.getShareType().getValue() == 1) {
            String msg = ResourceBase.getString((String)this.resourcePath, (String)"sharedAcctDelete", (Locale)ctx.getLocale());
            throw new AccountBankException(AccountBankException.COMMON, new Object[]{msg});
        }
    }

    private void deleteRefIntObject(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> sourceTypes = new HashSet<Integer>();
        sourceTypes.add(2);
        sourceTypes.add(5);
        filter.getFilterItems().add(new FilterItemInfo("sourceType", sourceTypes, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("sourceId", (Object)pk.toString()));
        ((ICoreBase)BusinessProcessUtil.getLocBizInteface((Context)ctx, (BOSObjectType)BOSObjectType.create((String)"C5AD9BF9"))).delete(filter);
    }

    @Override
    protected boolean _getIsUsed(Context ctx, String id) throws BOSException, EASBizException {
        return BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)BOSUuid.read((String)id)).isFound();
    }

    protected void _updateAccountRef(Context ctx, String acctRefContrastId) throws BOSException {
        SQLUtil sb = new SQLUtil();
        sb.appendSql("update t_bd_accountbanks set (faccountid )=  (select  fnewacctid from T_BD_AcctRefContrastentry where  foldacctid=faccountid and  FACCTREFCONTRASTID=?)");
        sb.addParam((Object)acctRefContrastId);
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sb.getTestSql());
    }

    @Override
    protected boolean _checkIsMonoAcc(Context ctx, String topNum, String companyID, String mainID) throws BOSException {
        if (EmptyUtil.isEmpty((String)topNum) || EmptyUtil.isEmpty((String)companyID)) {
            return false;
        }
        String sql = "SELECT T_BD_ACCOUNTBANKS.FID FROM T_BD_ACCOUNTBANKS,T_BD_BANK WHERE T_BD_ACCOUNTBANKS.FCOMPANYID = '" + companyID + "' AND T_BD_BANK.FLONGNUMBER LIKE '" + topNum + "%' AND T_BD_ACCOUNTBANKS.FBANK = T_BD_BANK.FID  AND FISMOTHERACCOUNT = 1 ";
        IRowSet set = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
        if (set != null && set.size() > 0) {
            try {
                set.next();
                return !EmptyUtil.isEmpty((String)mainID) && set.size() == 1 && !EmptyUtil.isEmpty((String)set.getString(1)) && mainID.equals(set.getString(1));
            }
            catch (SQLException e) {
                e.printStackTrace();
                SysUtil.abort((Throwable)e);
                return false;
            }
        }
        return true;
    }

    private BigDecimal getBalance(Context ctx, String accountBankId, String currencyId, Date queryDate, AccountBankInfo subAccountInfo) throws EASBizException, BOSException {
        if (queryDate == null) {
            queryDate = new Date();
        }
        BigDecimal balance = Constants.ZERO;
        CompanyOrgUnitInfo company = null;
        if (subAccountInfo == null || subAccountInfo.getCompany() == null) {
            return balance;
        }
        company = subAccountInfo.getCompany();
        PeriodInfo period = null;
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(ctx, SystemEnum.CASHMANAGEMENT, company);
        if (startPeriod == null) {
            return balance;
        }
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(ctx, SystemEnum.CASHMANAGEMENT, company);
        period = queryDate.before(startPeriod.getBeginDate()) ? startPeriod : (queryDate.after(currentPeriod.getBeginDate()) ? currentPeriod : PeriodUtils.getPeriodInfo(ctx, queryDate, company));
        StringBuffer innerSql = new StringBuffer();
        innerSql.append(this.getPeriodStartSql(accountBankId, currencyId, period, queryDate));
        innerSql.append(" union all ");
        innerSql.append(this.getRangeSql(accountBankId, currencyId, period, queryDate));
        StringBuffer sql = new StringBuffer();
        sql.append("select isnull(sum(SubResult),0) Result from (");
        sql.append(innerSql);
        sql.append(") tt ");
        IRowSet set = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (set.next()) {
                balance = set.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return balance;
    }

    private String getPeriodStartSql(String accountBankId, String currencyId, PeriodInfo period, Date queryDate) {
        StringBuffer sql = new StringBuffer();
        sql.append("select  FMonthStartAmt SubResult  from T_CAS_JournalBalance where ");
        sql.append("FIsInit =0   ");
        sql.append(" and FType= 2");
        sql.append(" and FAccountBankId='").append(accountBankId).append("'");
        sql.append(" AND FCurrencyId = '").append(currencyId).append("'");
        sql.append(" AND FPeriodId = '").append(period.getId().toString()).append("'");
        return sql.toString();
    }

    private String getRangeSql(String accountBankId, String currencyId, PeriodInfo period, Date queryDate) {
        StringBuffer sql = new StringBuffer();
        sql.append("select   sum(FDebitAmount - FCreditAmount)  SubResult  from t_cas_Journal where ");
        sql.append("  FType = 2");
        sql.append(" and FAccountBankId='").append(accountBankId).append("'");
        sql.append(" AND FCurrencyId = '").append(currencyId).append("'");
        sql.append(" and FCreateDate <= {").append(TypeConversionUtils.objToDate((Object)queryDate)).append("} ");
        sql.append(" AND FCreateDate >= {").append(TypeConversionUtils.objToDate((Object)period.getBeginDate())).append(" } ");
        return sql.toString();
    }

    @Override
    protected List _getInstantBalance(Context ctx, List subAcctCurrencyList, Date queryDate) throws BOSException, EASBizException {
        String[] ids = new String[subAcctCurrencyList.size()];
        for (int i = 0; i < ids.length; ++i) {
            SubAcctCurrencyBalance destObj = null;
            destObj = (SubAcctCurrencyBalance)subAcctCurrencyList.get(i);
            ids[i] = destObj.getSubAcctId();
        }
        AccountBankCollection coll = this.getBankCollbyIds(ctx, ids);
        HashMap<String, AccountBankInfo> acctMap = new HashMap<String, AccountBankInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            if (acctMap.containsKey(coll.get(i).getId().toString())) continue;
            acctMap.put(coll.get(i).getId().toString(), coll.get(i));
        }
        for (int j = 0; j < subAcctCurrencyList.size(); ++j) {
            BigDecimal balance = null;
            SubAcctCurrencyBalance destObj = null;
            destObj = (SubAcctCurrencyBalance)subAcctCurrencyList.get(j);
            AccountBankInfo subAccountInfo = (AccountBankInfo)acctMap.get(destObj.getSubAcctId());
            balance = this.getBalance(ctx, destObj.getSubAcctId(), destObj.getCurrencyId(), queryDate, subAccountInfo);
            destObj.setBalance(balance);
        }
        return subAcctCurrencyList;
    }

    private void addScheduleJob(Context ctx, AccountBankInfo accountBankInfo, boolean isSyncAdd) throws EASBizException, BOSException {
        int paramValue;
        if (isSyncAdd && accountBankInfo.getBankInterFaceID() == null) {
            return;
        }
        ObjectUuidPK orgUnitID = new ObjectUuidPK(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
        String param003 = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)orgUnitID, "BD003");
        if (!EmptyUtil.isEmpty((String)param003) && (paramValue = Integer.valueOf(param003).intValue()) > 0) {
            InterfaceItem item = new InterfaceItem("ScheduleJob", "F44AEBF0", "addJobByAccountBank", "entity", new Class[]{AccountBankInfo.class, Integer.TYPE}, null);
            item.doInvoke(ctx, new Object[]{accountBankInfo, paramValue});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        AccountBankInfo accountBankInfo = (AccountBankInfo)model;
        if (accountBankInfo.getBankAccountNumber().equals(accountBankInfo.getOldBankAccountNumber())) {
            accountBankInfo.setOldBankAccountNumber(null);
        }
        boolean isSyncAdd = false;
        boolean isSyncDel = false;
        IObjectPK[] pks = null;
        if (accountBankInfo.getId() != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountBankInfo.getId().toString(), CompareType.EQUALS));
            pks = this._getPKList(ctx, filter, null);
        }
        if (!EmptyUtil.isEmpty((Object)accountBankInfo.getId()) && pks != null && pks.length > 0) {
            AccountBankInfo oldInfo = (AccountBankInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(accountBankInfo.getId()));
            if (oldInfo.isIsClosed()) {
                throw new AccountBankException(AccountBankException.ACCTBANKEDITERROR);
            }
            if (EmptyUtil.isEmpty((String)oldInfo.getBankInterFaceID())) {
                accountBankInfo.setOldBankAccountNumber(null);
                if (!EmptyUtil.isEmpty((String)accountBankInfo.getBankInterFaceID())) {
                    isSyncAdd = true;
                }
            } else if (EmptyUtil.isEmpty((String)accountBankInfo.getBankInterFaceID())) {
                isSyncDel = true;
            } else {
                isSyncAdd = true;
            }
        } else if (accountBankInfo.isIsSetBankInterface()) {
            isSyncAdd = true;
        }
        IObjectPK innerAccountPK = super._submit(ctx, (IObjectValue)accountBankInfo);
        this.saveIntObjectInfo(ctx, accountBankInfo);
        this._disposeAccApply(ctx, accountBankInfo.getApplyBillId(), true);
        if (accountBankInfo.getShareType().getValue() != 2) {
            try {
                Object[] accts = new Object[]{model};
                if (isSyncAdd) {
                    InterfaceItem item = new InterfaceItem("BankFacade", "A2F61E6C", "synAccountToBank", "facade", new Class[]{Object[].class}, null);
                    Object[] acct = (Object[])item.doInvoke(ctx, new Object[]{accts});
                    AccountToSync sync = (AccountToSync)acct[0];
                    this.updateBankAcctSyncStatus(ctx, sync);
                    if (sync.getSyncStatus().equalsIgnoreCase("FAIL")) {
                        throw new BankException(BankException.SYNCBANKACCTERR, new Object[]{sync.getSyncStatusMsg()});
                    }
                } else if (isSyncDel) {
                    InterfaceItem item = new InterfaceItem("BankFacade", "A2F61E6C", "deleteAcctFromBank", "facade", new Class[]{Object[].class}, null);
                    item.doInvoke(ctx, new Object[]{accts});
                }
            }
            catch (Exception e) {
                throw new BankException(BankException.SYNCBANKACCTERR, new Object[]{e.getMessage()});
            }
        }
        this.syncSharedAcct(ctx, accountBankInfo);
        this.addScheduleJob(ctx, accountBankInfo, isSyncAdd);
        return innerAccountPK;
    }

    private void syncSharedAcct(Context ctx, AccountBankInfo accountBankInfo) throws EASBizException, BOSException {
        if (!EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo.getShareAcct()) && accountBankInfo.getShareType().getValue() == 1) {
            SharedAcctFactory.getLocalInstance(ctx).syncSharedAcct(accountBankInfo.getShareAcct());
            this.updateShareAcct(ctx, accountBankInfo.getShareAcct(), accountBankInfo);
        } else if (!EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo.getShareAcct()) && accountBankInfo.getShareType().getValue() == 2) {
            this.updateShareAcct(ctx, accountBankInfo.getShareAcct(), accountBankInfo);
        }
    }

    private void updateShareAcct(Context ctx, SharedAcctInfo shareAcct, AccountBankInfo accountBankInfo) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("shareType"));
        selector.add(new SelectorItemInfo("entries.*"));
        shareAcct = SharedAcctFactory.getLocalInstance(ctx).getSharedAcctInfo((IObjectPK)new ObjectUuidPK(shareAcct.getId().toString()), selector);
        if (accountBankInfo.getShareType().getValue() == 1) {
            shareAcct.setSharedBankAccountNumber(accountBankInfo.getBankAccountNumber());
            shareAcct.setBankAccount(accountBankInfo);
            shareAcct.setSharedOpenDate(accountBankInfo.getOpenDate());
            shareAcct.setSharedBankInterFace(accountBankInfo.getBankInterFace());
            shareAcct.setShareAcctName(accountBankInfo.getAcctName());
            shareAcct.setCurrency(accountBankInfo.getCurrency());
            shareAcct.setName(accountBankInfo.getName());
        } else {
            SharedAcctEntriesCollection coll = shareAcct.getEntries();
            for (int i = 0; i < coll.size(); ++i) {
                SharedAcctEntriesInfo info = coll.get(i);
                if (!info.getAccountBank().getId().toString().equals(accountBankInfo.getId().toString())) continue;
                info.setAccountView(accountBankInfo.getAccount());
                break;
            }
        }
        SharedAcctFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(shareAcct.getId().toString()), shareAcct);
    }

    private boolean exists(Context ctx, BOSUuid id) {
        return false;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountBankInfo info = (AccountBankInfo)model;
        return super._save(ctx, model);
    }

    private void saveIntObjectInfo(Context ctx, AccountBankInfo accountBankInfo) throws EASBizException, BOSException {
        CoreBaseInfo intObjectInfo = (CoreBaseInfo)accountBankInfo.get("intObjectInfo");
        if (intObjectInfo != null) {
            intObjectInfo.setString("sourceId", accountBankInfo.getId().toString());
            if (EmptyUtil.isEmpty((String)intObjectInfo.getString("number"))) {
                intObjectInfo.setString("number", accountBankInfo.getNumber());
            }
            ((ICoreBase)BusinessProcessUtil.getLocBizInteface((Context)ctx, (BOSObjectType)BOSObjectType.create((String)"C5AD9BF9"))).submit(intObjectInfo);
        }
    }

    protected void cancelDefault(Context ctx, AccountBankInfo info) throws EASBizException, BOSException {
        AccountBankInfo oldVO = this.getDefault(ctx, info);
        if (oldVO != null) {
            oldVO.setIsDefaultReck(false);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(oldVO.getId()), (CoreBaseInfo)oldVO);
        }
    }

    @Override
    protected IObjectValue _getDefault(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountBankInfo info = (AccountBankInfo)model;
        if (info.getBank() == null || info.getCompany() == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefaultReck", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isReckoning", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bank", (Object)info.getBank().getId(), CompareType.EQUALS));
        IObjectPK[] pks = this._getPKList(ctx, filter, null);
        if (pks == null || pks.length == 0) {
            return null;
        }
        if (pks.length > 1) {
            this.setRollbackOnly();
            throw new AccountBankException(AccountBankException.DEFAULT_ACCOUNTRECK_NOT_UNIQUE);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.*"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.number"));
        return this.getAccountBankInfo(ctx, pks[0], sic);
    }

    @Override
    protected void _saveTrusters(Context ctx, IObjectValue acctBankInfo) throws BOSException, EASBizException {
        if (!(acctBankInfo instanceof AccountBankInfo)) {
            return;
        }
        AccountBankInfo info = (AccountBankInfo)acctBankInfo;
        this.checkTrusterValid(ctx, info);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
    }

    private void checkTrusterValid(Context ctx, AccountBankInfo acctBankInfo) throws BOSException, EASBizException {
        if (!acctBankInfo.isTruested()) {
            return;
        }
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        AcctBankTrusterEntriesCollection entries = acctBankInfo.getTrusterEntries();
        for (int i = 0; i < entries.size(); ++i) {
            AcctBankTrusterEntriesInfo acctBankTrustEntry = entries.get(i);
            if (acctBankTrustEntry.getTrustCompany().getId().equals((Object)acctBankInfo.getCompany().getId())) {
                throw new AccountBankException(AccountBankException.TRUSTCOMPANYVALID);
            }
            for (int j = i + 1; j < entries.size(); ++j) {
                AcctBankTrusterEntriesInfo acctBankTrustEntry2 = entries.get(j);
                if (!acctBankTrustEntry.getTrustCompany().getId().equals((Object)acctBankTrustEntry2.getTrustCompany().getId())) continue;
                throw new AccountBankException(AccountBankException.TRUSTCOMPANYSAME);
            }
        }
    }

    @Override
    protected IObjectValue _getAcctBankGroup(Context ctx, String acctBankID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT G.FID FROM T_BD_AccountBankGroup G ").append("INNER JOIN T_BD_AcctBankGroupEntries E ON E.FParentsID = G.FID ").append("WHERE E.FAcctBankID='" + acctBankID + "'");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("strategy.*");
        sic.add("entries.acctBank.*");
        sic.add("entries.*");
        view.setSelector(sic);
        CoreBaseCollection coll = AccountBankGroupFactory.getLocalInstance(ctx).getCollection(view);
        return coll.get(0);
    }

    @Override
    protected IObjectValue _applyToBank(Context ctx, String accApplyID) throws BOSException {
        if (accApplyID == null || "".equals(accApplyID.trim())) {
            return null;
        }
        try {
            BatchActionResults batchResults = BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)this.getBOSType(), (Object[])new Object[]{accApplyID}, (BatchActionEnum)AccountBankProcessorBuiler.ACT_APPLYTOBANK, AccountBankProcessorBuiler.class, null);
            return (IObjectValue)batchResults.getResponse().get((Object)"accBankInfo");
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _disposeAccApply(Context ctx, String accApplyID, boolean isCreateToBank) throws BOSException, EASBizException {
        if (accApplyID == null || "".equals(accApplyID.trim()) || new Boolean(isCreateToBank) == null) {
            return;
        }
        ApplicationContext applicationContext = new ApplicationContext();
        applicationContext.putData("isCreateToBank", (Object)new Boolean(isCreateToBank));
        applicationContext.putData("id", (Object)accApplyID);
        BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)this.getBOSType(), (Object[])new Object[]{accApplyID}, (BatchActionEnum)AccountBankProcessorBuiler.ACT_DISPOSE, AccountBankProcessorBuiler.class, (ApplicationContext)applicationContext);
    }

    private boolean isAutoNumber(AccountBankInfo accountBankInfo, Context ctx) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCompanyID = "";
        strCompanyID = EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo.getCompany()) ? iCodingRuleManager.getCurrentAppOUID((IObjectValue)accountBankInfo) : accountBankInfo.getCompany().getId().toString();
        return this.getBindingProperty() != null && this.getBindingProperty().trim().length() > 0 ? iCodingRuleManager.isExist((IObjectValue)accountBankInfo, strCompanyID, this.getBindingProperty()) : iCodingRuleManager.isExist((IObjectValue)accountBankInfo, strCompanyID);
    }

    private String getBindingProperty() {
        return null;
    }

    private boolean isAddView(AccountBankInfo accountBankInfo, Context ctx) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)accountBankInfo);
        if (this.getBindingProperty() != null && this.getBindingProperty().trim().length() > 0) {
            return iCodingRuleManager.isAddView((IObjectValue)accountBankInfo, strCompanyID, this.getBindingProperty());
        }
        return iCodingRuleManager.isAddView((IObjectValue)accountBankInfo, strCompanyID);
    }

    protected void setNewNumber(Context ctx, AccountBankInfo model) throws BOSException, EASBizException {
        if (this.isAddNew(ctx, model)) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String strCompanyID = "";
            strCompanyID = EmptyUtil.isEmpty((CoreBaseInfo)model.getCompany()) ? iCodingRuleManager.getCurrentAppOUID((IObjectValue)model) : model.getCompany().getId().toString();
            if (EmptyUtil.isEmpty((String)model.getNumber())) {
                this.getNewNumber(ctx, model, strCompanyID, "");
            }
        }
    }

    protected boolean isAddNew(Context ctx, AccountBankInfo model) throws EASBizException, BOSException {
        boolean ret = false;
        ret = model.getId() == null || model.getId().toString().trim().length() == 0 || !this._exists(ctx, (IObjectPK)new ObjectUuidPK(model.getId()));
        return ret;
    }

    protected boolean isRuleAutoNumber(Context ctx, AccountBankInfo model, String strCompanyID) throws EASBizException, BOSException {
        String strBindProp;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (strCompanyID == null || strCompanyID.trim().length() == 0) {
            strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)model);
        }
        return (strBindProp = this.getBindingProperty(ctx)) != null && strBindProp.trim().length() > 0 ? iCodingRuleManager.isExist((IObjectValue)model, strCompanyID, strBindProp) && !iCodingRuleManager.isAddView((IObjectValue)model, strCompanyID, strBindProp) : iCodingRuleManager.isExist((IObjectValue)model, strCompanyID) && (!iCodingRuleManager.isAddView((IObjectValue)model, strCompanyID) || EmptyUtil.isEmpty((String)model.getNumber()));
    }

    protected String getBindingProperty(Context ctx) throws BOSException {
        return null;
    }

    protected AccountBankInfo getNewNumber(Context ctx, AccountBankInfo model, String strCompanyID, String customString) throws BOSException, EASBizException {
        String strBindProp;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (strCompanyID == null || strCompanyID.trim().length() == 0) {
            strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)model);
        }
        String number = "";
        boolean isNumberNoSet = false;
        if (model.getNumber() == null || model.getNumber().length() == 0) {
            isNumberNoSet = true;
        }
        if ((strBindProp = this.getBindingProperty(ctx)) != null && strBindProp.trim().length() > 0) {
            number = iCodingRuleManager.getNumber((IObjectValue)model, strCompanyID, strBindProp, customString);
            model.setNumber(number);
        } else {
            number = iCodingRuleManager.getNumber((IObjectValue)model, strCompanyID, customString);
            model.setNumber(number);
        }
        ObjectUuidPK pk = new ObjectUuidPK(model.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, model)) {
            String newNumber = "";
            newNumber = strBindProp != null && strBindProp.trim().length() > 0 ? iCodingRuleManager.getNumber((IObjectValue)model, strCompanyID, strBindProp, customString) : iCodingRuleManager.getNumber((IObjectValue)model, strCompanyID, customString);
            if (newNumber.equals(model.getNumber())) {
                String dupNum = this._getPropertyAlias(ctx, model, "number") + model.getNumber();
                throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{dupNum});
            }
            model.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, model)) {
                return this.getNewNumber(ctx, model, strCompanyID, customString);
            }
        }
        return model;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, AccountBankInfo model) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)model.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (model.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)model.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (model.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)model.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty(ctx) != null && this.getBindingProperty(ctx).trim().length() > 0 && model.get(this.getBindingProperty(ctx)) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(ctx), this.getBindingPropertyValue(model), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    protected Object getBindingPropertyValue(AccountBankInfo model) {
        return null;
    }

    private void rolbackNumber(AccountBankInfo accountBankInfo, Context ctx) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)accountBankInfo);
        String strBindProp = this.getBindingProperty();
        if (strBindProp != null && strBindProp.trim().length() > 0) {
            if (iCodingRuleManager.isExist((IObjectValue)accountBankInfo, strCompanyID, strBindProp) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)accountBankInfo, strCompanyID, strBindProp)) {
                iCodingRuleManager.recycleNumber((IObjectValue)accountBankInfo, strCompanyID, strBindProp, "", accountBankInfo.getNumber());
            }
        } else if (iCodingRuleManager.isExist((IObjectValue)accountBankInfo, strCompanyID) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)accountBankInfo, strCompanyID)) {
            iCodingRuleManager.recycleNumber((IObjectValue)accountBankInfo, strCompanyID, accountBankInfo.getNumber());
        }
        if (iCodingRuleManager.getRuleStatus((IObjectValue)accountBankInfo, strCompanyID).isAddNoBreak()) {
            iCodingRuleManager.recycleNumber((IObjectValue)accountBankInfo, strCompanyID, accountBankInfo.getNumber());
        }
    }

    private boolean isModify(AccountBankInfo accountBankInfo, Context ctx) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCompanyID = "";
        strCompanyID = EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo.getCompany()) ? iCodingRuleManager.getCurrentAppOUID((IObjectValue)accountBankInfo) : accountBankInfo.getCompany().getId().toString();
        if (this.getBindingProperty() != null && this.getBindingProperty().trim().length() > 0) {
            return iCodingRuleManager.isModifiable((IObjectValue)accountBankInfo, strCompanyID, this.getBindingProperty());
        }
        return iCodingRuleManager.isModifiable((IObjectValue)accountBankInfo, strCompanyID);
    }

    protected void setNumberFromCodingRule(Context ctx, DataBaseInfo caller, String orgId) throws BOSException, EASBizException {
    }

    @Override
    protected String _synAccountToBank(Context ctx) throws BOSException, EASBizException {
        StringBuffer result = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setSelector(this.getSelectors());
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        view.setFilter(filter);
        AccountBankCollection colls = AccountBankFactory.getLocalInstance(ctx).getAccountBankCollection(view);
        Object[] accts = colls.toArray();
        InterfaceItem item = new InterfaceItem("BankFacade", "A2F61E6C", "synAccountToBank", "facade", new Class[]{Object[].class}, null);
        Object[] acct = (Object[])item.doInvoke(ctx, new Object[]{accts});
        for (int i = 0; i < acct.length; ++i) {
            AccountToSync sync = (AccountToSync)acct[i];
            this.updateBankAcctSyncStatus(ctx, sync);
            if (sync.getSyncStatus().equalsIgnoreCase("FAIL")) {
                result.append(sync.getAccName() + "[" + sync.getAccNo() + "]: " + (EmptyUtil.isEmpty((String)sync.getReserveds()[0]) ? sync.getSyncStatusMsg() : sync.getReserveds()[0]) + System.getProperty("line.separator"));
                continue;
            }
            String syncStr = ResourceBase.getString((String)this.resourcePath, (String)"SyncSuccess", (Locale)ctx.getLocale(), (Object[])new Object[]{sync.getAccName(), sync.getAccNo()});
            result.append(syncStr);
        }
        return result.toString();
    }

    private void updateBankAcctSyncStatus(Context ctx, AccountToSync sync) throws BOSException {
        String Status2 = sync.getSyncStatus();
        String StatusMsg = sync.getSyncStatusMsg();
        StatusMsg = StatusMsg.replaceAll("'", "").length() > 80 ? StatusMsg.replaceAll("'", "").substring(0, 79) : StatusMsg.replaceAll("'", "");
        String bankAcct = sync.getAccNo();
        String bankId = sync.getBankServiceLoginId();
        if (EmptyUtil.isEmpty((String)sync.getBankServiceLoginId()) || sync.getBankServiceLoginId().equals("null")) {
            bankId = "";
        }
        String bankDesc = sync.getReserveds()[1];
        String sSQL = "Update T_BD_AccountBanks set FSyncStatus = '" + Status2 + "', FSyncStatusMsg = '" + StatusMsg + "', FBankInterFace = '" + bankDesc + "', FBankInterFaceID = '" + bankId + "' where FBankAccountNumber = '" + bankAcct + "'";
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sSQL);
    }

    @Override
    protected IObjectCollection _getAccountTreeByids(Context ctx, String[] accountIds) throws BOSException, EASBizException {
        AccountBankInfo info;
        int i;
        AccountBankCollection allBankColl = this.getAllEntryBanAcntkColl(ctx);
        AccountBankCollection resultColl = this.getBankCollbyIds(ctx, accountIds);
        HashMap<String, AccountBankInfo> treeIdMap = new HashMap<String, AccountBankInfo>();
        for (int i2 = 0; i2 < resultColl.size(); ++i2) {
            AccountBankInfo info2 = (AccountBankInfo)resultColl.getObject(i2);
            treeIdMap.put(info2.getId().toString(), info2);
        }
        HashMap<String, AccountBankInfo> allBankMap = new HashMap<String, AccountBankInfo>();
        for (i = 0; i < allBankColl.size(); ++i) {
            info = (AccountBankInfo)allBankColl.getObject(i);
            allBankMap.put(info.getId().toString(), info);
        }
        for (i = 0; i < allBankColl.size(); ++i) {
            info = (AccountBankInfo)allBankColl.getObject(i);
            if (treeIdMap.containsKey(info.getId().toString()) || !this.isSubBank(info, treeIdMap, allBankMap)) continue;
            treeIdMap.put(info.getId().toString(), info);
            resultColl.addObject(allBankColl.getObject(i));
        }
        return resultColl;
    }

    private boolean isSubBank(AccountBankInfo info, Map treeIdMap, Map allBankMap) {
        if (treeIdMap.containsKey(info.getId().toString())) {
            return true;
        }
        if (!(EmptyUtil.isEmpty((CoreBaseInfo)info.getSubAccount()) || EmptyUtil.isEmpty((Object)info.getSubAccount().getId()) || EmptyUtil.isEmpty((String)info.getSubAccount().getId().toString()))) {
            AccountBankInfo tmp = (AccountBankInfo)allBankMap.get(info.getSubAccount().getId().toString());
            if (tmp == null) {
                return false;
            }
            return this.isSubBank(tmp, treeIdMap, allBankMap);
        }
        return false;
    }

    private AccountBankCollection getBankCollbyIds(Context ctx, String[] accountIds) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = this.getEntryBankAcntSelector();
        evi.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        if (accountIds != null && accountIds.length > 0) {
            Set idSets = this.getIdSets(accountIds);
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSets, CompareType.INCLUDE));
        }
        evi.setFilter(filterInfo);
        return this.getAccountBankCollection(ctx, evi);
    }

    private Set getIdSets(String[] accountIds) {
        HashSet<String> set = new HashSet<String>();
        if (accountIds == null || accountIds.length <= 0) {
            return set;
        }
        for (int i = 0; i < accountIds.length; ++i) {
            set.add(accountIds[i]);
        }
        return set;
    }

    private AccountBankCollection getAllEntryBanAcntkColl(Context ctx) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = this.getEntryBankAcntSelector();
        evi.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isMotherAccount", (Object)Boolean.TRUE, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("subAccount", null, CompareType.NOTEQUALS));
        filterInfo.setMaskString("(#0 OR #1)");
        evi.setFilter(filterInfo);
        return this.getAccountBankCollection(ctx, evi);
    }

    private SelectorItemCollection getEntryBankAcntSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("ID"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("openDate"));
        sic.add(new SelectorItemInfo("closeDate"));
        sic.add(new SelectorItemInfo("isClosed"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("property.id"));
        sic.add(new SelectorItemInfo("property.name"));
        sic.add(new SelectorItemInfo("isMotherAccount"));
        sic.add(new SelectorItemInfo("isSetBankInterface"));
        sic.add(new SelectorItemInfo("bankInterFace"));
        sic.add(new SelectorItemInfo("ctrlStrategy.id"));
        sic.add(new SelectorItemInfo("ctrlStrategy.name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("subAccount.id"));
        sic.add(new SelectorItemInfo("subAccount.name"));
        sic.add(new SelectorItemInfo("subAccount.number"));
        return sic;
    }

    @Override
    protected boolean _isCloseCycle(Context ctx, IObjectValue acctBank) throws BOSException, EASBizException {
        AccountBankInfo bank = (AccountBankInfo)acctBank;
        if ((bank = super.getAccountBankInfo(ctx, (IObjectPK)new ObjectUuidPK(bank.getSubAccount().getId().toString()))).isIsClosed()) {
            throw new BankException(BankException.HADCOLSE);
        }
        AccountBankCollection allBankColl = this.getAllEntryBanAcntkColl(ctx);
        HashMap<String, AccountBankInfo> allBankMap = new HashMap<String, AccountBankInfo>();
        for (int i = 0; i < allBankColl.size(); ++i) {
            AccountBankInfo info = (AccountBankInfo)allBankColl.getObject(i);
            allBankMap.put(info.getId().toString(), info);
        }
        return this.checkIsCloseCycle((AccountBankInfo)acctBank, (AccountBankInfo)acctBank, allBankMap);
    }

    private boolean checkIsCloseCycle(AccountBankInfo checkAcct, AccountBankInfo curAcct, Map allBankMap) {
        if (EmptyUtil.isEmpty((CoreBaseInfo)curAcct.getSubAccount())) {
            return false;
        }
        if (checkAcct.getId().toString().equals(curAcct.getSubAccount().getId().toString())) {
            return true;
        }
        AccountBankInfo montherAcct = (AccountBankInfo)allBankMap.get(curAcct.getSubAccount().getId().toString());
        return this.checkIsCloseCycle(checkAcct, montherAcct, allBankMap);
    }

    @Override
    protected boolean _hasSubAccount(Context ctx, IObjectValue accountBank) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("ID"));
        evi.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("subAccount", (Object)((AccountBankInfo)accountBank).getId().toString(), CompareType.EQUALS));
        evi.setFilter(filterInfo);
        AccountBankCollection coll = this.getAccountBankCollection(ctx, evi);
        return coll.size() > 0;
    }

    private Map resetPrmotDisplay(Context ctx, AccountBankInfo info, IObjectPK pk) throws BOSException, EASBizException {
        HashMap<String, Boolean> displayMap = new HashMap<String, Boolean>();
        boolean bankDisplay = false;
        boolean accountDisplay = false;
        if (this.isReference(ctx, pk)) {
            boolean isCreateVoucher = this.isCreateVoucherBusiness(ctx, info);
            if (!isCreateVoucher && !info.getBank().isInGroup()) {
                bankDisplay = true;
            }
        } else {
            bankDisplay = true;
            accountDisplay = true;
        }
        displayMap.put("bank", new Boolean(bankDisplay));
        displayMap.put("accountView", new Boolean(accountDisplay));
        return displayMap;
    }

    private boolean isCreateVoucherBusiness(Context ctx, AccountBankInfo info) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from T_BD_AccountBanks AB \n");
        sql.append("inner join T_BD_AccountView AV on AB.FAccountID = AV.FID \n");
        sql.append("inner join T_BD_AsstActGroupDetail AAGD on AV.FCAA = AAGD.FAsstAccountID \n");
        sql.append("inner join T_BD_AsstActType AAT on AAGD.FAsstActTypeID = AAT.FID \n");
        sql.append("where AAT.FRealtionDataObject = 'T_BD_Bank' and AB.FID = '").append(info.getId().toString()).append("'");
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private boolean isReference(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Select top 1 FID From  T_CAS_PaymentBill ");
        sql.append("where FPayerAccountBankID= '").append(pk.toString()).append("'");
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql = new StringBuffer();
        sql.append("Select top 1 FID From  T_CAS_ReceivingBill ");
        sql.append("where FPayeeAccountBankID= '").append(pk.toString()).append("'");
        rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql = new StringBuffer();
        sql.append("Select top 1 FID From  T_FS_SettlementBill ");
        sql.append("where FPayeeBankAcctID= '").append(pk.toString()).append("'");
        sql.append(" union all Select top 1 FID From  T_FS_SettlementBill ").append("where FPayerBankAcctID = '").append(pk.toString()).append("'");
        rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql = new StringBuffer();
        sql.append("Select top 1 FID From  T_FS_TransDownBill ");
        sql.append("where FMotherAcctBankID= '").append(pk.toString()).append("'");
        rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql = new StringBuffer();
        sql.append("Select top 1 FID From  T_FS_TransUpBill ");
        sql.append("where FMotherAcctBankID= '").append(pk.toString()).append("'");
        rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        BizReference ref = ReferenceDAO.getReference((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        return ref != null;
    }

    @Override
    protected Map _modifyDisplay(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bank.inGroup"));
        sic.add(new SelectorItemInfo("bank.id"));
        AccountBankInfo info = (AccountBankInfo)super._getValue(ctx, pk, sic);
        return this.resetPrmotDisplay(ctx, info, pk);
    }

    @Override
    protected String _AddNoBreakCodingRule(Context ctx, AccountBankInfo accountBankInfo, String companyId) throws BOSException, EASBizException {
        this.setNewNumber(ctx, accountBankInfo);
        return accountBankInfo.getNumber();
    }

    @Override
    protected void _delShareNormalAcct(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        SharedAcctEntriesInfo entry = (SharedAcctEntriesInfo)info;
        if (!EmptyUtil.isEmpty((Object)entry.getId())) {
            ObjectUuidPK pk = new ObjectUuidPK(entry.getId().toString());
            boolean isExists = SharedAcctEntriesFactory.getLocalInstance(ctx).exists((IObjectPK)pk);
            if (!isExists) {
                try {
                    ObjectUuidPK apk = new ObjectUuidPK(entry.getAccountBank().getId().toString());
                    AccountBankFactory.getLocalInstance(ctx).delete((IObjectPK)apk);
                }
                catch (Exception e) {
                    logger.info((Object)"\u5220\u9664\u5171\u4eab\u8d26\u6237\u5931\u8d25\uff0c\u65e0\u6cd5\u5220\u9664\u4f7f\u7528\u6743\u7684\u8d26\u6237");
                }
            }
        }
    }

    protected void cancelDefaultPayment(Context ctx, AccountBankInfo info) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.*"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefaultPayment", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId()));
        if (info.isIsByCurrency() && info.getCurrency() != null) {
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId()));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", null));
            filter.setMaskString("#0 and #1 and (#2 or #3)");
        }
        view.setFilter(filter);
        view.setSelector(sic);
        AccountBankCollection coll = this.getAccountBankCollection(ctx, view);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                AccountBankInfo acctInfo = coll.get(i);
                acctInfo.setIsDefaultPayment(false);
                this.update(ctx, (IObjectPK)new ObjectUuidPK(acctInfo.getId()), (CoreBaseInfo)acctInfo);
            }
        }
    }

    @Override
    protected IObjectValue _getDefaultPayment(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountBankInfo info = (AccountBankInfo)model;
        if (info.getBank() == null || info.getCompany() == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefaultPayment", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId(), CompareType.EQUALS));
        IObjectPK[] pks = this._getPKList(ctx, filter, null);
        if (pks == null || pks.length == 0) {
            return null;
        }
        if (pks.length > 1) {
            this.setRollbackOnly();
            throw new AccountBankException(AccountBankException.DEFAULT_ACCOUNTPAYMENT_NOT_UNIQUE_045);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.*"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.number"));
        return this.getAccountBankInfo(ctx, pks[0], sic);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filterCU;
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        AccountBankInfo ab = (AccountBankInfo)model;
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ab.getCompany().getId()));
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (FilterUtility.hasFilterItem((FilterInfo)(filterCU = this.getFilterForDefaultCU(ctx, model)))) {
            filter.mergeFilter(filterCU, "AND");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + " : " + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        DataBaseInfo info = (DataBaseInfo)model;
        if (info == null) {
            return null;
        }
        if (info.getCU() == null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)super.getCU(ctx, (ObjectBaseInfo)info).getId().toString(), CompareType.EQUALS));
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        return filter;
    }
}

