/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.core.datatask.AbstractDataImport;
import com.kingdee.eas.basedata.assistant.AccountBankException;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountType;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.app.AccountBankDataImportVerify;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AccountBankDataImport
extends AbstractDataImport {
    private AccountBankDataImportVerify verify;
    private static Logger logger = Logger.getLogger((String)AccountBankDataImport.class.getName());

    protected ICoreBase _getController(Context ctx) throws BOSException, EASBizException {
        return AccountBankFactory.getLocalInstance(ctx);
    }

    public AccountBankDataImportVerify getVerify() {
        if (this.verify == null) {
            this.verify = new AccountBankDataImportVerify();
        }
        return this.verify;
    }

    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            throw new AccountBankException(AccountBankException.IMPORTMODEERROR);
        }
        AccountBankInfo accountBankInfo = new AccountBankInfo();
        this.prepareImport(ctx, (IObjectValue)accountBankInfo, hsData);
        accountBankInfo.setIsClosed(false);
        String currencyId = accountBankInfo.getCurrency() != null ? accountBankInfo.getCurrency().getId().toString() : null;
        Object data = null;
        data = this.getData(hsData, "company");
        if (data != null && data.toString().length() > 0) {
            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo companyInfo = iCompany.getCompanyOrgUnitInfo("select cu where number='" + data.toString() + "'");
            if (companyInfo.getCU().getId().toString() != null) {
                accountBankInfo.setCU(companyInfo.getCU());
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"7_AccountBankDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "account");
        if (data != null && data.toString().trim().length() > 0) {
            try {
                Class<?> utilCls = Class.forName("com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil2");
                Object util = utilCls.newInstance();
                Class[] paramType = new Class[]{Context.class, String.class, String.class, String.class, String.class};
                Method staticFunc1 = utilCls.getMethod("getAccountByNumber", paramType);
                Object[] paramValue = new Object[]{ctx, ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"8_AccountBankDataImport", (Locale)ctx.getLocale()), accountBankInfo.getCompany().getId().toString(), currencyId, data.toString()};
                Object retValue = staticFunc1.invoke(util, paramValue);
                if (retValue instanceof AccountViewInfo) {
                    accountBankInfo.setAccount((AccountViewInfo)retValue);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if ((data = this.getData(hsData, "accountType")) != null) {
            if (ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"9_AccountBankDataImport", (Locale)ctx.getLocale()).equals(data)) {
                accountBankInfo.setAccountType(AccountType.PAYINOUT);
            } else if (ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"10_AccountBankDataImport", (Locale)ctx.getLocale()).equals(data)) {
                accountBankInfo.setAccountType(AccountType.PAYIN);
            } else if (ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"11_AccountBankDataImport", (Locale)ctx.getLocale()).equals(data)) {
                accountBankInfo.setAccountType(AccountType.PAYOUT);
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"12_AccountBankDataImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.getData(hsData, "isByCurrency");
        if (ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"13_AccountBankDataImport", (Locale)ctx.getLocale()).equals(data)) {
            accountBankInfo.setIsByCurrency(true);
        } else if (ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"14_AccountBankDataImport", (Locale)ctx.getLocale()).equals(data)) {
            accountBankInfo.setIsByCurrency(false);
            accountBankInfo.setCurrency(null);
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"15_AccountBankDataImport", (Locale)ctx.getLocale()));
        }
        accountBankInfo.setIsMotherAccount(false);
        accountBankInfo.setIsSetBankInterface(false);
        this.getVerify().verifyHead(ctx, (CoreBaseInfo)accountBankInfo);
        return accountBankInfo;
    }

    protected void _submit(CoreBaseInfo info, Context ctx) throws BOSException, EASBizException {
        IAccountBank j = (IAccountBank)this._getController(ctx);
        j.save(info);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = super.getExportFilterForQuery(ctx);
        Object obj = this.getContextParameter().get("filter");
        if (obj != null && obj instanceof FilterInfo) {
            FilterInfo filter1 = (FilterInfo)obj;
            try {
                filter.mergeFilter(filter1, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.AccountBankQuery";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            Date openDate;
            String property;
            String currency;
            Boolean isByCurrency;
            String innerAcct;
            String account;
            String bank;
            String company;
            String name;
            String bankAccountNumber;
            String number = this.getString(rs, "number");
            if (number != null) {
                result.put("number", number);
            }
            if ((bankAccountNumber = this.getString(rs, "bankAccountNumber")) != null) {
                result.put("bankAccountNumber", bankAccountNumber);
            }
            if ((name = this.getString(rs, "name")) != null) {
                result.put("name", name);
            }
            if ((company = this.getString(rs, "company.number")) != null) {
                result.put("company", company);
            }
            if ((bank = this.getString(rs, "bank.number")) != null) {
                result.put("bank", bank);
            }
            if ((account = this.getString(rs, "account.number")) != null) {
                result.put("account", account);
            }
            if ((innerAcct = this.getString(rs, "innerAcct.number")) != null) {
                result.put("InnerAcct", innerAcct);
            }
            if ((isByCurrency = Boolean.valueOf(rs.getBoolean("isByCurrency"))) != null) {
                result.put("isByCurrency", isByCurrency != false ? ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"13_AccountBankDataImport", (Locale)ctx.getLocale()) : ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"14_AccountBankDataImport", (Locale)ctx.getLocale()));
            }
            if ((currency = this.getString(rs, "currency.number")) != null) {
                result.put("currency", currency);
            }
            if ((property = this.getString(rs, "property.number")) != null) {
                result.put("property", property);
            }
            if ((openDate = rs.getDate("openDate")) != null) {
                result.put("openDate", DateTimeUtils.format((java.util.Date)openDate, (String)"yyyy-MM-dd"));
            }
            int accountType = rs.getInt("accountType");
            String type = null;
            if (0 == accountType) {
                type = ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"10_AccountBankDataImport", (Locale)ctx.getLocale());
            } else if (1 == accountType) {
                type = ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"11_AccountBankDataImport", (Locale)ctx.getLocale());
            } else if (2 == accountType) {
                type = ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"9_AccountBankDataImport", (Locale)ctx.getLocale());
            }
            result.put("accountType", type);
            String description = this.getString(rs, "description");
            if (description != null) {
                result.put("description", description);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }
}

