/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.core.util.VerifyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankException;
import com.kingdee.eas.basedata.assistant.AccountBankGroupInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AcctBankGroupEntriesCollection;
import com.kingdee.eas.basedata.assistant.AcctBankGroupEntriesFactory;
import com.kingdee.eas.basedata.assistant.AcctBankGroupEntriesInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractAccountBankGroupControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class AccountBankGroupControllerBean
extends AbstractAccountBankGroupControllerBean {
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountBankGroupInfo info = (AccountBankGroupInfo)model;
        this.checkAcctBankGroupValid(ctx, info);
        info.setBizDate(new Date());
        return super._submit(ctx, model);
    }

    private void checkAcctBankGroupValid(Context ctx, AccountBankGroupInfo info) throws BOSException, EASBizException, AccountBankException {
        this.checkEntriesAcctBankDup(info);
        AcctBankGroupEntriesCollection coll = this.checkAcctBankBelongOtherGrouped(ctx, info);
        if (coll.size() > 0) {
            StringBuffer acctNums = new StringBuffer();
            for (int i = 0; i < coll.size(); ++i) {
                AcctBankGroupEntriesInfo entry = coll.get(i);
                acctNums.append(entry.getAcctBank().getBankAccountNumber() + " ");
            }
            throw new AccountBankException(AccountBankException.ACCTBANKHASGROUPED, new Object[]{acctNums});
        }
    }

    private AcctBankGroupEntriesCollection checkAcctBankBelongOtherGrouped(Context ctx, AccountBankGroupInfo info) throws EASBizException, BOSException {
        AcctBankGroupEntriesCollection entries = info.getEntries();
        HashSet<String> acctBankIdSet = new HashSet<String>();
        for (int i = 0; i < entries.size(); ++i) {
            AcctBankGroupEntriesInfo entry1 = entries.get(i);
            AccountBankInfo acctBank1 = entry1.getAcctBank();
            acctBankIdSet.add(acctBank1.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("acctBank.id");
        view.getSelector().add("acctBank.bankAccountNumber");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("parents.id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("acctBank.id", acctBankIdSet, CompareType.INCLUDE));
        AcctBankGroupEntriesCollection coll = AcctBankGroupEntriesFactory.getLocalInstance(ctx).getAcctBankGroupEntriesCollection(view);
        return coll;
    }

    private void checkEntriesAcctBankDup(AccountBankGroupInfo info) throws BOSException, EASBizException {
        AcctBankGroupEntriesCollection entries = info.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            AcctBankGroupEntriesInfo entry1 = entries.get(i);
            AccountBankInfo acctBank1 = entry1.getAcctBank();
            for (int j = i + 1; j < entries.size(); ++j) {
                AcctBankGroupEntriesInfo entry2 = entries.get(j);
                AccountBankInfo acctBank2 = entry2.getAcctBank();
                if (!acctBank1.getId().equals((Object)acctBank2.getId())) continue;
                throw new AccountBankException(AccountBankException.ACCTBANKCANTSAME);
            }
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AccountBankGroupInfo info = (AccountBankGroupInfo)model;
        this.checkAcctBankGroupValid(ctx, info);
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountBankGroupInfo info = (AccountBankGroupInfo)model;
        VerifyUtil.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this._checkNumberDup(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)model, (boolean)false);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._isReferenced(ctx, pk);
        super._delete(ctx, pk);
    }

    @Override
    protected Set _getCompanyIds(Context ctx, String companyNum) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)companyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(120);
        sql.append("select fid from t_org_company where (");
        if (companyNum.indexOf(";") > 0) {
            String[] nums = companyNum.split(";");
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sql.append(" or ");
                }
                sql.append(" (FNumber = '").append(nums[i].trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%') ");
            }
        } else {
            sql.append(" FNumber = '").append(companyNum.trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%'");
        }
        sql.append(" ) and FIsOnlyUnion =0 ");
        sql.append(" order by FLongNumber asc");
        Object conn = null;
        Object state = null;
        Object rs = null;
        HashSet<String> idSet = new HashSet<String>();
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
        try {
            while (rs1.next()) {
                idSet.add(rs1.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return idSet;
    }
}

