/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.assistant.AddressClassCollection;
import com.kingdee.eas.basedata.assistant.AddressClassFactory;
import com.kingdee.eas.basedata.assistant.AddressClassInfo;
import com.kingdee.eas.basedata.assistant.IAddressClass;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class AddressClassDataTransmission
extends AbstractDataTransmission {
    private static final String RESOURCE_FILE_NAME = "com.kingdee.eas.tools.datatask.DatataskResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AddressClassFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String parentNum;
        String name_l3;
        String name_l2;
        String name_l1;
        AddressClassInfo info = new AddressClassInfo();
        String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (number == null) throw new TaskExternalException("number  not found!");
        info.setNumber(number);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            try {
                IAddressClass iAddressClass = (IAddressClass)this.getController(ctx);
                AddressClassCollection AddressClassCollection2 = iAddressClass.getAddressClassCollection();
                if (AddressClassCollection2 != null) {
                    for (int i = 0; i < AddressClassCollection2.size(); ++i) {
                        if (!AddressClassCollection2.get(i).getNumber().equalsIgnoreCase(number)) continue;
                        info.setId(AddressClassCollection2.get(i).getId());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TaskExternalException("BOSException: getAddressClassCollection", (Throwable)e);
            }
        }
        if ((name_l1 = (String)((DataToken)hsData.get((Object)"Fname_L1")).data) != null && name_l1.trim().length() != 0) {
            info.setName(name_l1, new Locale("L1"));
        }
        if ((name_l2 = (String)((DataToken)hsData.get((Object)"Fname_L2")).data) != null && name_l2.trim().length() != 0) {
            info.setName(name_l2, new Locale("L2"));
        }
        if ((name_l3 = (String)((DataToken)hsData.get((Object)"Fname_L3")).data) != null && name_l3.trim().length() != 0) {
            info.setName(name_l3, new Locale("L3"));
        }
        if ((parentNum = (String)((DataToken)hsData.get((Object)"FParent")).data) == null || parentNum.trim().length() == 0) return info;
        AddressClassInfo addressClassInfo = null;
        try {
            addressClassInfo = (AddressClassInfo)AddressClassFactory.getLocalInstance(ctx).getValue("select id where number = '" + parentNum + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            StringBuffer message = new StringBuffer();
            message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"addressNumber", (Locale)currentLocale));
            message.append(parentNum);
            message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"addressImport", (Locale)currentLocale));
            throw new TaskExternalException(message.toString());
        }
        info.setParent(addressClassInfo);
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iAddressClass = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iAddressClass.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iAddressClass.addnew(coreBaseInfo);
            } else {
                iAddressClass.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FNumber", rs.getString("number"));
            Locale currentLocale = ctx.getLocale();
            if (rs.getString("name") != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("Fname_L1", rs.getString("name"));
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("Fname_L2", rs.getString("name"));
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("Fname_L3", rs.getString("name"));
                }
            }
            if (rs.getString("parent.number") != null) {
                result.put("FParent", rs.getString("parent.number"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"accessError", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.AddressClassQuery";
    }
}

